/*************************************************************************
 *
 *  $RCSfile: pluginacceptthread.cxx,v $
 *
 *  $Revision: 1.6 $
 *
 *  last change: $Author: sb $ $Date: 2001/05/28 08:19:35 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _UCB_MAIN_PLUGINACCEPTTHREAD_HXX_
#include "pluginacceptthread.hxx"
#endif

#ifndef _COM_SUN_STAR_BRIDGE_XBRIDGEFACTORY_HPP_
#include <com/sun/star/bridge/XBridgeFactory.hpp>
#endif
#ifndef _COM_SUN_STAR_CONNECTION_XACCEPTOR_HPP_
#include <com/sun/star/connection/XAcceptor.hpp>
#endif
#ifndef _COM_SUN_STAR_LANG_XCOMPONENT_HPP_
#include <com/sun/star/lang/XComponent.hpp>
#endif
#ifndef _COM_SUN_STAR_LANG_XMULTISERVICEFACTORY_HPP_
#include <com/sun/star/lang/XMultiServiceFactory.hpp>
#endif
#ifndef _RTL_USTRBUF_HXX_
#include <rtl/ustrbuf.hxx>
#endif
#ifndef _VOS_REF_HXX_ 
#include <vos/ref.hxx>
#endif
#ifndef _VOS_TIMER_HXX_ 
#include <vos/timer.hxx>
#endif

namespace unnamed_ucb_main_pluginacceptthread {}
using namespace unnamed_ucb_main_pluginacceptthread;
	// unnamed namespaces don't work well yet...

using ucb_main::Machine;
using ucb_main::MachineControl;
using ucb_main::PluginAcceptThread;
using namespace com::sun::star;

//============================================================================
//
//  Timer
//
//============================================================================

namespace unnamed_ucb_main_pluginacceptthread {

class Timer: public vos::OTimer
{
public:
	inline Timer(vos::ORef< PluginAcceptThread > const & rTheThread);

	inline void stopShooting();

private:
	vos::OMutex m_aMutex;
	vos::ORef< PluginAcceptThread > m_xThread;
	bool m_bStopped;

	virtual void SAL_CALL onShot();
};

//@@@ Logically, there is no need for this 100 millisecond timer (it used to
// be a 2 minute timer, which indeed was needed).  But if the timer is removed
// altogether, a bug in the acceptor might cause a crash (when stopAccepting()
// is called before going into accept()).  Therefore, it seems safest to keep
// a---much shorter---timer.
inline Timer::Timer(vos::ORef< PluginAcceptThread > const & rTheThread):
	OTimer(100),
	m_xThread(rTheThread),
	m_bStopped(false)
{
	VOS_ENSURE(m_xThread.isValid(),
			   "ucb/pluginaccepthtread:Timer::TimeoutHandler(): Null thread");
}

inline void Timer::stopShooting()
{
	{
		vos::OGuard aGuard(m_aMutex);
		m_bStopped = true;
	}
	stop();
}

}

//============================================================================
void Timer::onShot()
{
	vos::OGuard aGuard(m_aMutex);
	if (!m_bStopped)
		m_xThread->timedOut();
}

//============================================================================
//
//  PluginAcceptThread
//
//============================================================================

PluginAcceptThread::PluginAcceptThread( 
	uno::Reference< lang::XMultiServiceFactory > const & rServiceFactory,
	uno::Reference< bridge::XBridgeFactory > const & rBridgeFactory,
	uno::Reference< bridge::XInstanceProvider > const & rInstanceProvider,
	rtl::OUString const & rConnection,
	rtl::OUString const & rProtocol,
	MachineControl * pControl):
	AcceptThread(rServiceFactory, rBridgeFactory, rInstanceProvider,
				 rConnection, rProtocol),
	Machine(pControl),
	m_eState(STATE_INIT)
{
	idle(true);
}

//============================================================================
// virtual
uno::Any SAL_CALL PluginAcceptThread::queryInterface(uno::Type const & rType)
	throw (uno::RuntimeException)
{
	uno::Any aRet(cppu::queryInterface(rType,
									   static_cast< lang::XEventListener * >(
										   this)));
	return aRet.hasValue() ? aRet : OWeakObject::queryInterface(rType);
}

//============================================================================
// virtual
void SAL_CALL PluginAcceptThread::acquire() throw ()
{
	OWeakObject::acquire();
}

//============================================================================
// virtual
void SAL_CALL PluginAcceptThread::release() throw ()
{
	OWeakObject::release();
}

//============================================================================
// virtual
void SAL_CALL PluginAcceptThread::run()
{
	//@@@ Since after calling vos::OTimer::stop() the vos::OTimer::onShot()
	// can still run for an arbitrarily long time, in each iteration we need
	// a new timer with a private 'stopped' flag (there's no point in time
	// where we could safely reset a global 'stopped' flag):
	for (vos::ORef< Timer > xTimer;; xTimer = new Timer(this))
	{
		uno::Reference< connection::XAcceptor > xTheAcceptor;
		for (;;)
		{
			vos::OClearableGuard aGuard(m_aMutex);
			if (m_eState == STATE_INIT_TRY_STOP)
			{
				aGuard.clear();
				m_aDoStop.wait();
				m_aDoStop.reset();
				if (m_eState == STATE_STOPPED)
					break;
			}
			else
			{
				m_eState = STATE_RUNNING;
				if (!m_xAcceptor.is())
				{
					try
					{
						m_xAcceptor
							= uno::Reference< connection::XAcceptor >(
								  getServiceFactory()->
								      createInstance(
										  rtl::OUString::createFromAscii(
										 "com.sun.star.connection.Acceptor")),
								  uno::UNO_QUERY);
					}
					catch (uno::Exception const &) {}
					if (!m_xAcceptor.is())
					{
						VOS_ENSURE(false,
								   "ucb_main::PluginAcceptThread::run():"
								       " No service");
						stopped();
						return;
					}
				}
				xTheAcceptor = m_xAcceptor;
				break;
			}
		}

		if (xTimer.isValid())
			xTimer->start();

		uno::Reference< connection::XConnection > xConnection;
		try
		{
			xConnection = xTheAcceptor->accept(getConnection());
		}
		catch (connection::AlreadyAcceptingException const &)
		{
			VOS_ENSURE(false,
					   "ucb_main::PluginAcceptThread::run():"
					       " AlreadyAcceptingException");
		}
		catch (connection::ConnectionSetupException const &)
		{
			VOS_ENSURE(false,
					   "ucb_main::PluginAcceptThread::run():"
					       " ConnectionSetupException");
		}
		catch (lang::IllegalArgumentException const &)
		{
			VOS_ENSURE(false,
					   "ucb_main::PluginAcceptThread::run():"
					       " IllegalArgumentException");
		}
		catch (uno::RuntimeException const &)
		{
			VOS_ENSURE(false,
					   "ucb_main::PluginAcceptThread::run():"
					       " RuntimeException");
		}
        m_xAcceptor = 0;
        m_xAcceptor2 = xTheAcceptor;
        xTheAcceptor = 0;

		if (xTimer.isValid())
			xTimer->stopShooting();

		if (xConnection.is())
			busy();

		if (m_eState == STATE_TRY_STOP)
		{
			canStop(!xConnection.is());
			m_aDoStop.wait();
			m_aDoStop.reset();
			if (m_eState == STATE_STOPPED)
				break;
		}

		uno::Reference< lang::XComponent > xComponent;
		try
		{
			xComponent
				= uno::Reference< lang::XComponent >(
					  getBridgeFactory()->
					      createBridge(getConnection(),
									   getProtocol(),
									   xConnection,
									   getInstanceProvider()),
					  uno::UNO_QUERY);
		}
		catch (bridge::BridgeExistsException const &)
		{
			VOS_ENSURE(false,
					   "ucb_main::PluginAcceptThread::run():"
					       " BridgeExistsException");
			break;
		}
		catch (lang::IllegalArgumentException const &)
		{
			VOS_ENSURE(false,
					   "ucb_main::PluginAcceptThread::run():"
					       " IllegalArgumentException");
			break;
		}
		catch (uno::RuntimeException const &)
		{
			VOS_ENSURE(false,
					   "ucb_main::PluginAcceptThread::run():"
					       " RuntimeException");
			break;
		}

		bool bListening = false;
		if (xComponent.is())
			try
			{
				xComponent->addEventListener(this);
				bListening = true;
			}
			catch (uno::RuntimeException const &) {}
		VOS_ENSURE(bListening,
				   "ucb_main::PluginAcceptThread::run(): Can't listen\n");
		if (bListening)
		{
            // If there are other processes that want to connect via this
            // pipe, accept those connections, but create a bridge with a null
            // instance provider, as a signal to the other processes that the
            // pipe is already in use:
            for (sal_Int32 i = 0;; ++i)
            {
                uno::Reference< connection::XAcceptor >
                    xTheAcceptor2(m_xAcceptor2);
                if (!xTheAcceptor2.is())
                    break;
                rtl::OUStringBuffer aName(getConnection());
                aName.append(static_cast< sal_Unicode >('_'));
                aName.append(rtl::OUString::valueOf(i));
                try
                {
                    uno::Reference< connection::XConnection >
                        xConnection2(xTheAcceptor2->accept(getConnection()));
                    if (xConnection2.is())
                        getBridgeFactory()->
                            createBridge(aName.makeStringAndClear(),
                                         getProtocol(),
                                         xConnection2,
                                         0);
                }
                catch (connection::AlreadyAcceptingException &)
                {
                    VOS_ENSURE(
                        false,
                       "com::sun::star::connection::AlreadyAcceptingException"
                            " caught");
                }
                catch (connection::ConnectionSetupException &)
                {
                    VOS_ENSURE(
                        false,
                        "com::sun::star::connection::ConnectionSetupException"
                            " caught");
                }
                catch (bridge::BridgeExistsException &)
                {
                    VOS_ENSURE(false,
                               "com::sun::star::bridge::BridgeExistsException"
                                   " caught");
                }
                catch (lang::IllegalArgumentException &)
                {
                    VOS_ENSURE(
                        false,
                        "com::sun::star::lang::IllegalArgumentException"
                            " caught");
                }
                catch (uno::RuntimeException &)
                {
                    VOS_ENSURE(false,
                               "com::sun::star::uno::RuntimeException"
                                   " caught");
                }
            }

			m_aDisposed.wait();
			m_aDisposed.reset();
		}
        else
            m_xAcceptor2 = 0;

		eventOccured();
	}

	stopped();
}

//============================================================================
// virtual
void PluginAcceptThread::tryStop()
{
	vos::OGuard aGuard(m_aMutex);
	switch (m_eState)
	{
		case STATE_INIT:
			m_eState = STATE_INIT_TRY_STOP;
			canStop(true);
			break;

		case STATE_RUNNING:
        {
            uno::Reference< connection::XAcceptor > xTheAcceptor(m_xAcceptor);
			if (xTheAcceptor.is())
			{
				m_eState = STATE_TRY_STOP;
				m_xAcceptor = 0;
				xTheAcceptor->stopAccepting();
			}
            break;
        }

		default:
			VOS_ENSURE(false,
					   "ucb_main::PluginAcceptThread::tryStop(): Bad state");
			break;
	}
}

//============================================================================
// virtual
void PluginAcceptThread::doStop(bool bStop)
{
	vos::OGuard aGuard(m_aMutex);
	switch (m_eState)
	{
		case STATE_INIT_TRY_STOP:
			m_eState = bStop ? STATE_STOPPED : STATE_INIT;
			m_aDoStop.set();
			break;

		case STATE_TRY_STOP:
			m_eState = bStop ? STATE_STOPPED : STATE_RUNNING;
			m_aDoStop.set();
			break;

		default:
			VOS_ENSURE(false,
					   "ucb_main::PluginAcceptThread::doStop(): Bad state");
			break;
	}
}

//============================================================================
// virtual
void SAL_CALL PluginAcceptThread::disposing(lang::EventObject const & rSource)
	throw (uno::RuntimeException)
{
    uno::Reference< connection::XAcceptor > xTheAcceptor2(m_xAcceptor2);
    if (xTheAcceptor2.is())
    {
        m_xAcceptor2 = 0;
        xTheAcceptor2->stopAccepting();
    }
	m_aDisposed.set();
}

//============================================================================
void PluginAcceptThread::timedOut()
{
	idle(false);
}
