/*************************************************************************
 *
 *  $RCSfile: rapproxyprovider.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: sb $ $Date: 2001/06/06 11:06:55 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef INCLUDED_UCB_RAPPROXYPROVIDER_HXX
#include "rapproxyprovider.hxx"
#endif

#ifndef _COM_SUN_STAR_LANG_XMULTISERVICEFACTORY_HPP_
#include <com/sun/star/lang/XMultiServiceFactory.hpp>
#endif
#ifndef _COM_SUN_STAR_UCB_XREMOTECONTENTPROVIDERACTIVATOR_HPP_
#include <com/sun/star/ucb/XRemoteContentProviderActivator.hpp>
#endif
#ifndef _COM_SUN_STAR_UNO_XINTERFACE_HPP_
#include <com/sun/star/uno/XInterface.hpp>
#endif
#ifndef _OSL_DIAGNOSE_H_
#include <osl/diagnose.h>
#endif
#ifndef _RTL_USTRING_HXX_
#include <rtl/ustring.hxx>
#endif
#ifndef _UCBHELPER_CONTENTIDENTIFIER_HXX
#include <ucbhelper/contentidentifier.hxx>
#endif

using namespace com::sun;
using ucprmt::ProxyProvider;

ProxyProvider::ProxyProvider(
	star::uno::Reference< star::lang::XMultiServiceFactory > const &
		rServiceFactory):
	m_xServiceFactory(rServiceFactory)
{}

star::uno::Reference< star::ucb::XContentProvider >
ProxyProvider::getTarget(rtl::OUString const & rUrl)
	throw (star::uno::RuntimeException)
{
	star::uno::Reference< star::ucb::XRemoteContentProviderActivator >
		xActivator;
	if (m_xServiceFactory.is())
		try
		{
			xActivator
				= star::uno::Reference<
				          star::ucb::XRemoteContentProviderActivator >(
					  m_xServiceFactory->
					      createInstance(
							  rtl::OUString(
								  RTL_CONSTASCII_USTRINGPARAM(
						  "com.sun.star.ucb.RemoteContentProviderAcceptor"))),
					  star::uno::UNO_QUERY);
		}
		catch (star::uno::Exception const &) {}
	OSL_ENSURE(xActivator.is(), "null RemoteContentProviderAcceptor");
	if (xActivator.is())
	{
		star::uno::Reference< star::ucb::XContentProviderManager >
			xManager(xActivator->activateRemoteContentProviders());
		if (xManager.is())
		{
			star::uno::Reference< star::ucb::XContentProvider >
				xProvider(xManager->queryContentProvider(rUrl));
			if (xProvider
				    != star::uno::Reference< star::ucb::XContentProvider >(
						   this))
				return xProvider;
		}
	}
	return 0;
}

ProxyProvider::~ProxyProvider() throw ()
{}

rtl::OUString SAL_CALL ProxyProvider::getImplementationName() throw ()
{
	return rtl::OUString::createFromAscii(getImplementationName_static());
}

sal_Bool SAL_CALL
ProxyProvider::supportsService(rtl::OUString const & rServiceName)
	throw (star::uno::RuntimeException)
{
	star::uno::Sequence< rtl::OUString >
		aNames(getSupportedServiceNames_static());
	sal_Int32 nCount = aNames.getLength();
	for (sal_Int32 i = 0; i < nCount; ++i)
		if (rServiceName == aNames[i])
			return true;
	return false;
}

star::uno::Sequence< rtl::OUString > SAL_CALL
ProxyProvider::getSupportedServiceNames()
	throw (star::uno::RuntimeException)
{
	return getSupportedServiceNames_static();
}

star::uno::Reference< star::ucb::XContent > SAL_CALL
ProxyProvider::queryContent(
	star::uno::Reference< star::ucb::XContentIdentifier > const & rIdentifier)
	throw (star::ucb::IllegalIdentifierException, star::uno::RuntimeException)
{
	star::uno::Reference< star::ucb::XContentProvider >
		xTarget(getTarget(rIdentifier.is() ?
						      rIdentifier->getContentIdentifier() :
						      rtl::OUString()));
	return xTarget.is() ? xTarget->queryContent(rIdentifier) :
		                  star::uno::Reference< star::ucb::XContent >();
}

sal_Int32 SAL_CALL
ProxyProvider::compareContentIds(
	star::uno::Reference< star::ucb::XContentIdentifier > const & rId1,
	star::uno::Reference< star::ucb::XContentIdentifier > const & rId2)
	throw (star::uno::RuntimeException)
{
	rtl::OUString aUrl1;
	if (rId1.is())
		aUrl1 = rId1->getContentIdentifier();
	star::uno::Reference< star::ucb::XContentProvider >
		xTarget(getTarget(aUrl1));
	return xTarget.is() ?
		       xTarget->compareContentIds(rId1, rId2) :
		       aUrl1.compareTo(rId2.is() ? rId2->getContentIdentifier() :
							               rtl::OUString());
}

star::uno::Reference< star::ucb::XContentIdentifier > SAL_CALL
ProxyProvider::createContentIdentifier(rtl::OUString const & rContentId)
	throw (star::uno::RuntimeException)
{
	star::uno::Reference< star::ucb::XContentIdentifierFactory >
		xTarget(getTarget(rContentId), star::uno::UNO_QUERY);
	return xTarget.is() ?
		       xTarget->createContentIdentifier(rContentId) :
		       star::uno::Reference< star::ucb::XContentIdentifier >(
				   new ucb::ContentIdentifier(rContentId));
}

sal_Char const * ProxyProvider::getImplementationName_static()
{
	return "com.sun.star.comp.ucb.ucp.remote.ProxyProvider";
}

star::uno::Sequence< rtl::OUString >
ProxyProvider::getSupportedServiceNames_static()
{
	star::uno::Sequence< rtl::OUString > aNames(1);
	aNames[0] = rtl::OUString(
		            RTL_CONSTASCII_USTRINGPARAM(
						"com.sun.star.ucb.RemoteProxyContentProvider"));
	return aNames;
}

star::uno::Reference< star::uno::XInterface > SAL_CALL
ProxyProvider::createInstance(
	star::uno::Reference< star::lang::XMultiServiceFactory > const &
		rServiceFactory)
{
	return *new ProxyProvider(rServiceFactory);
}
