/*************************************************************************
 *
 *  $RCSfile: VCLApplication.m,v $
 *
 *  $Revision: 1.31 $
 *
 *  last change: $Author: pluby $ $Date: 2001/03/19 16:31:41 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *		 - GNU Lesser General Public License Version 2.1
 *		 - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#import <VCLApplication.h>
#import <VCLWindow.h>
#import <VCLEvent.h>
#import <keycodes.hxx>
#import <saldata.hxx>
#include <premac.h>
#import <Carbon/Carbon.h>
#include <postmac.h>

#define _SV_VCLAPPLICATION_M

// --------------------
// - Static functions -
// --------------------

static BOOL SalHandleMouseEvent( NSEvent *pEvent )
{
	VCLWindow *pFrame = [pEvent window];
	NSEventType nEventType = [pEvent type];
	struct SalMouseEvent aMouseEvt;
	NSPoint aPoint = [pEvent locationInWindow];
	NSRect aFrameRect = [(VCLWindow *)pFrame frame];
	NSRect aContentRect = [[(VCLWindow *)pFrame contentView] frame];
	NSRect aResizeRect;
	unsigned int nModifiers = [pEvent modifierFlags];
	USHORT nEvent = 0;

	// Test if the point is in the window's contentView. If not, we don't
	// handle it here.
	if ( ! NSPointInRect( aPoint, aContentRect ) )
	{
		return FALSE;
	}

	// Test if the point is in the window's resize box. If so, allow the
	// default event handler to handle it.
	if ( [pFrame styleMask] & NSResizableWindowMask )
	{
		aResizeRect.origin.x = aFrameRect.size.width - kThemeMetricResizeControlHeight;
		aResizeRect.origin.y = 0;
		aResizeRect.size.width = kThemeMetricResizeControlHeight;
		aResizeRect.size.height = kThemeMetricResizeControlHeight;
		if ( NSPointInRect( aPoint, aResizeRect ) )
			return FALSE;
	}

	// Convert mouse coordinates from window's coordinate space that
	// contentView's coordinate space since we will be drawing in the
	// contentView.
	aPoint.x -= aContentRect.origin.x;
	aPoint.y -= aContentRect.origin.y;

	// Initialize SalMouseEvent structure
	aMouseEvt.mnTime = (ULONG)([pEvent timestamp] * 1000);
	aMouseEvt.mnCode = 0;
	aMouseEvt.mnX = (long)(aPoint.x);
	// Need to adjust the Y coordinate since 0 is at the bottom of the window
	// in aPoint
	aMouseEvt.mnY = (long)(aContentRect.size.height - (aPoint.y));
	aMouseEvt.mnButton = 0;

	// Get the modifiers for the event
	if ( nModifiers & NSShiftKeyMask )
		aMouseEvt.mnCode |= KEY_SHIFT;
	if ( nModifiers & NSCommandKeyMask )
		aMouseEvt.mnCode |= KEY_MOD1;
	if ( nModifiers & NSAlternateKeyMask )
		aMouseEvt.mnCode |= KEY_MOD2;

	// Determine with button has been pressed
	switch ( nEventType )
	{
		case NSLeftMouseDown:
		case NSLeftMouseUp:
		case NSLeftMouseDragged:
			// If the Alt key is pressed, treat event as a right button
			// event and ignore the Alt key. We need this since many Apple
			// machines have only a one-button mouse. We can't use the Command
			// key because that is reserved for drag-copy operations.
			if ( aMouseEvt.mnCode & KEY_MOD2 )
			{
				aMouseEvt.mnCode |= MOUSE_RIGHT;
				aMouseEvt.mnCode &= ~KEY_MOD2 ;
			}
			else
				aMouseEvt.mnCode |= MOUSE_LEFT;
			break;
		case NSRightMouseDown:
		case NSRightMouseUp:
		case NSRightMouseDragged:
			aMouseEvt.mnCode |= MOUSE_RIGHT;
			break;
		default:
			break;
	}

	// Get the button for this event
	if ( aMouseEvt.mnCode & MOUSE_LEFT )
		aMouseEvt.mnButton = MOUSE_LEFT;
	if ( aMouseEvt.mnCode & MOUSE_RIGHT )
		aMouseEvt.mnButton = MOUSE_RIGHT;

	// Pass the event to this window's callback function
	switch ( nEventType )
	{
		case NSLeftMouseDown:
		case NSRightMouseDown:
			nEvent = SALEVENT_MOUSEBUTTONDOWN;
			break;
		case NSLeftMouseUp:
		case NSRightMouseUp:
			nEvent = SALEVENT_MOUSEBUTTONUP;
			break;
		case NSMouseMoved:
		case NSMouseEntered:
		case NSLeftMouseDragged:
		case NSRightMouseDragged:
			nEvent = SALEVENT_MOUSEMOVE;
			break;
		case NSMouseExited:
			nEvent = SALEVENT_MOUSELEAVE;
			break;
		default:
			return FALSE;
			break;
	}
	pFrame->mpSalFrameData->mpProc( pFrame->mpSalFrameData->mpInst,
		pFrame->mpSalFrame, nEvent, &aMouseEvt );

	return FALSE;
}

static BOOL SalHandleKeyEvent( NSEvent *pEvent )
{
	VCLWindow *pFrame = [pEvent window];
	NSEventType nEventType = [pEvent type];
	NSString *pKey = nil;
	struct SalKeyEvent aKeyEvt;
	unsigned int nModifiers = [pEvent modifierFlags];
	USHORT nEvent = 0;

	// Initialize SalKeyEvent structure
	aKeyEvt.mnTime = (ULONG)[pEvent timestamp];
	aKeyEvt.mnCode = 0;
	aKeyEvt.mnCharCode = 0;
	aKeyEvt.mnRepeat = 0;
	
	// Get the modifiers for the event
	if ( nModifiers & NSShiftKeyMask )
		aKeyEvt.mnCode |= KEY_SHIFT;
	if ( nModifiers & NSCommandKeyMask )
		aKeyEvt.mnCode |= KEY_MOD1;
	if ( nModifiers & NSAlternateKeyMask )
		aKeyEvt.mnCode |= KEY_MOD2;

	if ( nEventType == NSKeyDown || nEventType == NSKeyUp )
	{
		// Get the Unicode character for the event
		pKey = [pEvent characters];
		if ( [pKey length] )
			aKeyEvt.mnCharCode = (USHORT)[pKey characterAtIndex: 0];
		else
			return TRUE;
	
		// Add alphanumeric and special characters to modifiers
		if ( ( aKeyEvt.mnCharCode >= '0' ) && ( aKeyEvt.mnCharCode <= '9' ) )
			aKeyEvt.mnCode |= KEYGROUP_NUM + aKeyEvt.mnCharCode - '0';
		else if ( ( aKeyEvt.mnCharCode >= 'A' ) && ( aKeyEvt.mnCharCode <= 'Z' ) )
			aKeyEvt.mnCode |= KEYGROUP_ALPHA + aKeyEvt.mnCharCode - 'A';
		else if ( ( aKeyEvt.mnCharCode >= 'a' ) && ( aKeyEvt.mnCharCode <= 'z' ) )
			aKeyEvt.mnCode |= KEYGROUP_ALPHA + aKeyEvt.mnCharCode - 'a';
		else if ( aKeyEvt.mnCharCode == 0x0D )  // RETURN
			aKeyEvt.mnCode |= KEY_RETURN;
		else if ( aKeyEvt.mnCharCode == 0x1B )  // ESCAPE
			aKeyEvt.mnCode |= KEY_ESCAPE;
		else if ( aKeyEvt.mnCharCode == 0x09 )  // TAB
			aKeyEvt.mnCode |= KEY_TAB;
		else if ( aKeyEvt.mnCharCode == 0x20 )  // SPACE
			aKeyEvt.mnCode |= KEY_SPACE;
	}
	// Check if this is a system key equivalent (e.g. Command-Q)
	if ( nModifiers == NSCommandKeyMask )
	{
		// Only handle event if it is a Key Down event, not a Key Up event
		if (nEventType == NSKeyDown )
		{
			if (aKeyEvt.mnCharCode == 'q')
			{
				[NSApp terminate: NSApp];
				return TRUE;
			}
			if (aKeyEvt.mnCharCode == 'h')
			{
				[NSApp hide: NSApp];
				return TRUE;
			}
		}
	}
	
	// Pass the event to this window's callback function
	switch ( nEventType )
	{
		case NSKeyDown:
			nEvent = SALEVENT_KEYINPUT;
			break;
		case NSKeyUp:
			nEvent = SALEVENT_KEYUP;
			break;
		case NSFlagsChanged:
			nEvent = SALEVENT_KEYMODCHANGE;
			break;
		default:
			return FALSE;
			break;
	}
	pFrame->mpSalFrameData->mpProc( pFrame->mpSalFrameData->mpInst,
		pFrame->mpSalFrame, nEvent, &aKeyEvt );

	return TRUE;
}

static BOOL SalHandlePeriodicEvent( NSEvent *pEvent )
{
	NSArray *pWindows = nil;
	VCLWindow *pFrame = nil;
	unsigned int nFrame = 0;
	struct SalData *pSalData = NULL;

	pSalData = SalGetSalData();

	// Call the timer callback to paint
	if ( pSalData->mpTimerProc )
	{
		pSalData->mpTimerProc();

		// Force update of all windows so that the window border is painted
		pWindows = [NSApp windows];
		for ( nFrame = 0; nFrame < [pWindows count]; nFrame++ )
		{
			pFrame = (VCLWindow *)[pWindows objectAtIndex: nFrame];
			if ( [pFrame isVisible] )
				[pFrame display];
		}
	}

	return TRUE;
}

// ------------------
// - VCLApplication -
// ------------------

@implementation VCLApplication

- (MacOSBOOL)applicationShouldTerminate: (NSApplication *)sender
{
	VCLWindow *pFrame = [NSApp keyWindow];

	// Pass the event to this window's callback function.
	if ( pFrame && pFrame->mpSalFrameData->mpProc )
	{
		pFrame->mpSalFrameData->mpProc( pFrame->mpSalFrameData->mpInst,
			pFrame->mpSalFrame, SALEVENT_SHUTDOWN, NULL );
	}
 
	// Always return FALSE as the event handler above should have taken
	// care of starting the termination process
	return FALSE;
}

- (void)sendEvent: (NSEvent *)anEvent
{
	VCLWindow *pFrame = [anEvent window];
	BOOL bHandled = FALSE;

	// Check if this is an event that we should handle. If so, translate and
	// pass the event to the platform independent event handlers.
	switch ( [anEvent type] )
	{
		case NSLeftMouseDown:
		case NSLeftMouseUp:
		case NSRightMouseDown:
		case NSRightMouseUp:
		case NSMouseMoved:
		case NSLeftMouseDragged:
		case NSRightMouseDragged:
		case NSMouseEntered:
		case NSMouseExited:
			if ( [pFrame isVisible] && SalHandleMouseEvent( anEvent ) )
				bHandled = TRUE;
			break;
		case NSCursorUpdate:
			break;
		case NSKeyDown:
		case NSKeyUp:
		case NSFlagsChanged:
			if ( [pFrame isVisible] && SalHandleKeyEvent( anEvent ) )
				bHandled = TRUE;
			break;
		case NSApplicationDefined:
			// Pass the event to this window's callback function.
			if ( pFrame && pFrame->mpSalFrameData->mpProc )
				pFrame->mpSalFrameData->mpProc( pFrame->mpSalFrameData->mpInst,
					pFrame->mpSalFrame, SALEVENT_USEREVENT,
					(void *)[anEvent data1] );
			bHandled = TRUE;
			break;
		case NSScrollWheel:
			break;
		case NSPeriodic:
			bHandled = SalHandlePeriodicEvent( anEvent );
			break;
		case NSAppKitDefined:
		case NSSystemDefined:
			break;
		default:
			break;
	}

	// If the event has not been handled, pass it to [NSApplication sendEvent:]
	if ( !bHandled )
		[super sendEvent: anEvent];
}

@end

// -----------------------
// - C wrapper functions -
// -----------------------

void VCLApplication_SharedApplication()
{
	[VCLApplication sharedApplication];
	[NSApp setDelegate: NSApp];

	// We need to invoke the following code since we don't use [NSApp run]
	[NSApp finishLaunching];
}

void VCLApplication_Run( BOOL bWait )
{
	NSEvent *pEvent;
	NSDate *pDate = [NSDate date];

	// Manually pull events from the event queue and dispatch them to
	// [NSApp sendEvent:]. Although this is the same thing that [NSApp run]
	// does, the VCL platform independent expects events to be pulled instead
	// of pushed from the system event queue.
	for ( ; ; )
	{
		pEvent = [NSApp nextEventMatchingMask: NSAnyEventMask untilDate: pDate
			inMode: NSDefaultRunLoopMode dequeue: YES];

		if ( pEvent )
		{
			[NSApp sendEvent: pEvent];

			// Invoke update on all of the windows. This is done in [NSApp run]
			// hence it is included here.
			[NSApp updateWindows];
		}
		else
			break;
	}
}
