/*************************************************************************
 *
 *  $RCSfile: salobj.hxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/19 10:23:06 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _SV_SALOBJ_HXX
#define _SV_SALOBJ_HXX

#ifndef _SV_SV_H
#include <sv.h>
#endif
#ifndef _SV_SALGTYPE_HXX
#include <salgtype.hxx>
#endif
#ifndef _SV_SALWTYPE_HXX
#include <salwtype.hxx>
#endif
#ifndef _SV_SALOBJ_H
#include <salobj.h>
#endif

struct SystemEnvData;

// -------------------
// - SalObject-Types -
// -------------------

#define SAL_OBJECT_CLIP_INCLUDERECTS			((USHORT)0x0001)
#define SAL_OBJECT_CLIP_EXCLUDERECTS			((USHORT)0x0002)
#define SAL_OBJECT_CLIP_ABSOLUTE				((USHORT)0x0004)

// -------------
// - SalObject -
// -------------

class SalObject
{
public: 					// public for Sal Implementation
							SalObject();
							~SalObject();

public: 					// public for Sal Implementation
	SalObjectData			maObjectData;

#ifdef _INCL_SAL_SALOBJ_IMP
#include <salobj.imp>
#endif

public:
	void					ResetClipRegion();
	USHORT					GetClipRegionType();
	void					BeginSetClipRegion( ULONG nRects );
	void					UnionClipRegion( long nX, long nY, long nWidth, long nHeight );
	void					EndSetClipRegion();

	void					SetPosSize( long nX, long nY, long nWidth, long nHeight );
	void					Show( BOOL bVisible );
	void					Enable( BOOL nEnable );
	void					GrabFocus();

	void					SetBackground();
	void					SetBackground( SalColor nSalColor );

	const SystemEnvData*	GetSystemData() const;

	// Callbacks (indepen in \vcl\source\window\winproc.cxx)
	// for default message handling return 0
	void					SetCallback( void* pInst, SALOBJECTPROC pProc );
};

#endif // _SV_SALOBJ_HXX
