/*************************************************************************
 *
 *  $RCSfile: salxutil.cxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 17:05:42 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#ifndef _SV_SALXUTIL_HXX
#include <salxutil.hxx>
#endif

#ifndef _SV_SALDATA_HXX
#include <saldata.hxx>
#endif

#ifndef _SV_SALDISP_HXX
#include <saldisp.hxx>
#endif

XWindowProperty::XWindowProperty( Display *pDisplay, XLIB_Window aWindow,
									   Atom aProp )
{
	mnProperty = aProp;
	mpDisplay  = pDisplay;
	maWindow   = aWindow;
	mpData     = 0;

	XGetWindowProperty( mpDisplay, maWindow, mnProperty, 0, 2048, False,
						AnyPropertyType, &mnType, &mnFormat, &mnItems,
						&mnBytes, &mpData );
}

XWindowProperty::~XWindowProperty()
{
	if( mpData )
		XFree( mpData );
}

void XWindowProperty::WriteBack()
{
	if( mpData )
		XChangeProperty( mpDisplay, maWindow, mnProperty, mnType, mnFormat,
						 PropModeReplace, mpData, mnItems );
}

WindowPropertyStorage::WindowPropertyStorage( Display *pDisplay, XLIB_Window aWindow )
{
	pSaveAtoms = XListProperties( pDisplay, aWindow, &nSaveAtoms );
	ppProperties = new XWindowProperty*[ nSaveAtoms ];
	for( int i = 0; i < nSaveAtoms; i++ )
		ppProperties[i] =
			new XWindowProperty( pDisplay, aWindow, pSaveAtoms[i] );
}

WindowPropertyStorage::~WindowPropertyStorage()
{
	for( int i = 0; i < nSaveAtoms; i++ )
	{
		ppProperties[i]->WriteBack();
		delete ppProperties[i];
	}
	delete ppProperties;
}

static Atom nStateAtom = 0;
static Atom nChangeStateAtom = 0;

WMState GetWindowState( Display *pDisplay, XLIB_Window aWindow )
{
	WMState aState;
	int nType=0, nFormat=0;
	unsigned long nItems=0, nBytesAfter=0;
	unsigned char *pBuffer=NULL;

	if( ! nStateAtom )
		nStateAtom = XInternAtom( pDisplay, "WM_STATE", True );

	GetSalData()->GetDisplay( pDisplay )->GetXLib()->SetIgnoreXErrors( TRUE );
	XGetWindowProperty( pDisplay, aWindow, nStateAtom, 0, 64, False,
						nStateAtom, (Atom*)&nType, &nFormat, &nItems,
						&nBytesAfter, &pBuffer );
	GetSalData()->GetDisplay( pDisplay )->GetXLib()->SetIgnoreXErrors( FALSE );

	if( pBuffer )
	{
		switch( *((int*)pBuffer) )
		{
			case 0: aState.meState = Withdrawn; break;
			case 1: aState.meState = Normal; break;
			case 3: aState.meState = Iconic; break;
			default: aState.meState = Unknown; break;
		}
		aState.mnStateValue = *((int*)pBuffer);
		aState.maIconWindow = *((XLIB_Window*)(pBuffer+sizeof(int)));
		XFree( pBuffer );
	}
	else
	{
		aState.meState = NoState;
		aState.maIconWindow = None;
	}
	return aState;
}

void SetWindowState( Display *pDisplay, XLIB_Window aWindow, WMState& rState )
{
	int nType, nFormat;
	unsigned long nItems, nBytesAfter;
	unsigned char pBuffer[ sizeof(int) + sizeof(XLIB_Window) ];

	if( ! nChangeStateAtom )
		nChangeStateAtom = XInternAtom( pDisplay, "WM_CHANGE_STATE", True );

	XEvent aSendEvent;
	aSendEvent.type = ClientMessage;
	aSendEvent.xclient.display		= pDisplay;
	aSendEvent.xclient.window		= aWindow;
	aSendEvent.xclient.message_type	= nChangeStateAtom;
	aSendEvent.xclient.format		= 32;
	switch( rState.meState )
	{
		case Withdrawn:	aSendEvent.xclient.data.l[0] = 0; break;
		case Normal:	aSendEvent.xclient.data.l[0] = 1; break;
		case Iconic:	aSendEvent.xclient.data.l[0] = 3; break;
		default:		aSendEvent.xclient.data.l[0] = 0; break;
	}
	GetSalData()->GetDisplay( pDisplay )->GetXLib()->SetIgnoreXErrors( TRUE );
	XSendEvent( pDisplay, DefaultRootWindow( pDisplay ),
				False,
				SubstructureRedirectMask |
				SubstructureNotifyMask,
				&aSendEvent );
	GetSalData()->GetDisplay( pDisplay )->GetXLib()->SetIgnoreXErrors( FALSE );
}

ByteString GetStringFromTextProperty( Display *pDisplay, XLIB_Window aWindow,
								  Atom aProperty )
{
	char **ppStringList = 0;
	int nStringCount;
	ByteString aRetString;
	XTextProperty aTextProperty;

	aTextProperty.value = 0;
	GetSalData()->GetDisplay( pDisplay )->GetXLib()->SetIgnoreXErrors( TRUE );
	if( XGetTextProperty( pDisplay, aWindow, &aTextProperty, aProperty ) )
	{
		if( aTextProperty.value && XTextPropertyToStringList( &aTextProperty,
															  &ppStringList,
															  &nStringCount ) &&
			ppStringList )
		{
			aRetString = ByteString( ppStringList[0] );
			for( int i = 1; i < nStringCount; i++ )
			{
				aRetString += '.';
				aRetString += ppStringList[i];
			}
		}
	}
	if( ppStringList )
		XFreeStringList( ppStringList );
	if( aTextProperty.value )
		XFree( aTextProperty.value );
	GetSalData()->GetDisplay( pDisplay )->GetXLib()->SetIgnoreXErrors( FALSE );
	return aRetString;
}


BOOL CheckProperty( Display* pDisplay, XLIB_Window aWindow, Atom nAtom )
{
	Atom *pAtoms;
	int nAtoms;
	BOOL bHasProperty = FALSE;

	GetSalData()->GetDisplay( pDisplay )->GetXLib()->SetIgnoreXErrors( TRUE );
	pAtoms = XListProperties( pDisplay, aWindow, &nAtoms );
	GetSalData()->GetDisplay( pDisplay )->GetXLib()->SetIgnoreXErrors( FALSE );
	if( pAtoms )
	{
		for( int i=0; i < nAtoms; i++ )
		{
			if( pAtoms[i] == nAtom )
			{
				bHasProperty = TRUE;
				break;
			}
		}
		XFree( pAtoms );
	}
	return bHasProperty;
}

BOOL CheckProperty( Display* pDisplay, XLIB_Window aWindow,
					const char* pProperty )
{
	Atom nAtom = XInternAtom( pDisplay, pProperty, True );
	if( nAtom )
		return CheckProperty( pDisplay, aWindow, nAtom );
	return FALSE;
}
