/*************************************************************************
 *
 *  $RCSfile: bytarray.hxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 15:18:11 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/


#ifndef _VOS_BYTARRAY_HXX_
#define _VOS_BYTARRAY_HXX_


#ifndef _VOS_TYPES_HXX_
#	include <vos/types.hxx>
#endif
#ifndef _VOS_OBJECT_HXX_
#	include <vos/object.hxx>
#endif
#ifndef _VOS_STREAM_HXX_
#	include <vos/stream.hxx>
#endif

#ifdef _USE_NAMESPACE
namespace vos
{     
#endif

/** Array of bytes.
*/
class OByteArray : public NAMESPACE_VOS(OObject)
{
	VOS_DECLARE_CLASSINFO(VOS_NAMESPACE(OByteArray, vos));

public:

	///
    OByteArray();

	///
    OByteArray(void *pbuf, sal_uInt32 size, sal_Bool resize = sal_False);

	///
    OByteArray(const OByteArray& b);

	///
    ~OByteArray();

    // ------------------------- Access -----------------------------------

	///
    void SAL_CALL setAllBytesTo(sal_uInt8 b);

	/// Return the number of bytes in the byte array.
    virtual sal_uInt32 SAL_CALL getSize() const;	

	/// synonym for getSize
    sal_uInt32 SAL_CALL getLength () const;		

	///
    SAL_CALL operator sal_uInt8* () const;

	/// return the address of the byte array.
    void* SAL_CALL asPtr () const;			

    ///
    sal_uInt8 SAL_CALL operator[](sal_uInt32 index);

    // ------------------------- Comparison --------------------------------
    
    /** Check if this ByteArray's contents are identical to those of b
        using the memcmp function.
	*/
    virtual sal_Bool SAL_CALL operator== (const OByteArray& b) const;

    /** This and other comparison methods that take character pointer
		arguments assume that the size of the memory segment pointed to by
		the parameter is the same as the
		size of this ByteArray.
	*/
    virtual sal_Bool SAL_CALL operator== (const void* b) const;

	///
    virtual sal_Bool SAL_CALL operator!= (const OByteArray& b) const;
	///
    virtual sal_Bool SAL_CALL operator!= (const void* b) const;
    
	///
    virtual sal_Bool SAL_CALL operator>= (const OByteArray& b) const;
	///
    virtual sal_Bool SAL_CALL operator>= (const void* b) const;
    
	///
    virtual sal_Bool SAL_CALL operator<= (const OByteArray& b) const;
	///
    virtual sal_Bool SAL_CALL operator<= (const void* b) const;
    
	///
    virtual sal_Bool SAL_CALL operator> (const OByteArray& b) const;
	///
    virtual sal_Bool SAL_CALL operator> (const void* b) const;
    
	///
    virtual sal_Bool SAL_CALL operator< (const OByteArray& b) const;
	///
    virtual sal_Bool SAL_CALL operator< (const void* b) const;

	///
    virtual sal_Int16 SAL_CALL Compare (const OByteArray& obj) const;

    // ------------------ Sub-structure manipulation ------------------
    
    /** Return the sub-array beginning at the given index (using
		0-origin indexing) and of the given size. Note that the
		returned ByteArray uses (part of) the same memory as this object,
		so it is possible to assign to the returned sub-array to effect
		copying into parts of this object. For example, with a ByteArray {\tt
		anArray},  you can write
    
		      anArray(5, 4) = (ulong) 23;
    
		to put the value 23 as an unsigned long value  (usually
		4 bytes) in the cells 5 through 8.
    
    	Also, assignment to sub-arrays does not change the size of the
		array itself.
	*/
    OByteArray SAL_CALL operator() (sal_uInt32 index, sal_uInt32 size) const;

    /** Return the suffix beginning at the given index (using
		0-origin indexing). Note that the
		returned ByteArray uses (part of) the same memory as this
		ByteArray does.
	*/
    OByteArray SAL_CALL getSuffix(sal_uInt32 index) const;

    /** Obtain a sal_Int32 value from our array, beginning at the given
		position (i.e., treat the sizeof(sal_Int32) bytes beginning at the
		given position as a sal_Int32), and return it.
	*/
    sal_Int32 SAL_CALL getLongValueAt(sal_uInt32 index) const;
    
    /** Extract a sal_Int16 value from our array, beginning at the given
		position, and return it.
	*/
    sal_Int16 SAL_CALL getShortValueAt(sal_uInt32 index) const;

    /** Return the size of the longest common prefix with the
		parameter.
	*/
    sal_uInt32 SAL_CALL getCommonPrefixLength(const sal_uInt8* p);


    // ----------------- Assignment, copying, modification ----------------

    /// Assign another byte array to this one.
    virtual void SAL_CALL operator= (const OByteArray& b);

    /** Copy getSize() bytes from the given pointer position into this
		ByteArray.
	*/
    virtual void SAL_CALL operator= (const void* p);

    /** Copy the given sal_Int32 value into this ByteArray, beginning at position
		0. Do not copy more than getSize() bytes. This method, as well
		as the operator= on sal_Int16 and String, can be used in conjunction with
		the operator() to put values at arbitrary positions in the
		ByteArray.
	*/
    virtual OByteArray& SAL_CALL operator= (sal_Int32);

	///
    virtual OByteArray& SAL_CALL operator= (sal_Int16);

    /** Copy count bytes from pbuffer into our data segment,
		beginning at position in our data. But do not copy any
		more than getSize() - position bytes. Return the actual
		number of bytes copied.
	*/
    virtual sal_uInt32 SAL_CALL copyFrom(const void* pbuffer, sal_uInt32 count, sal_uInt32 position = 0) const;
    
    /** Copy count bytes of our data, beginning at position pos,
		into buffer. But do not copy any more than getSize() - 
		position bytes. Return the actual number of bytes copied.
	*/
    sal_uInt32 SAL_CALL copyTo(void* buffer, sal_uInt32 count, sal_uInt32 position = 0);

    /** Tell us to change our size, and return True if successful.  Since
    	the ByteArray manages someone else's space and therefore cannot
		change its size, this method always returns False. It is overridden
		by the derived class ByteString.
	*/
    virtual sal_Bool SAL_CALL changeSize(sal_uInt32 newSize);
    
	// -------------------- Storage and restoration --------------
    
    /** Overrides the method inherited from Object. The implementation reads
		a passive representation of a ByteArray from the parameter Stream.
	*/
    sal_Bool SAL_CALL readFrom(const OStream&);

    /** Overrides the method inherited from Object. The implementation writes
		a passive representation of a ByteArray to the parameter Stream.
	*/
    sal_Bool SAL_CALL writeTo(OStream&) const;

protected:
    sal_uInt32  m_Size;
    sal_uInt8*   m_pArray;
	sal_Bool m_bResize;
	sal_Bool m_bOwner;
};

inline sal_uInt32 OByteArray::getSize() const
{
    return (m_Size);
}

inline sal_uInt32 OByteArray::getLength() const
{
    return (m_Size);
}


inline OByteArray::operator sal_uInt8* () const
{
    return (m_pArray);
}


inline void* OByteArray::asPtr() const
{
    return (m_pArray);
}

#ifdef _USE_NAMESPACE
}     
#endif
    
#endif // _VOS_BYTARRAY_HXX_










