/*************************************************************************
 *
 *  $RCSfile: bytestrm.hxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 15:18:11 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/


#ifndef _VOS_BYTESTRM_HXX_
#define _VOS_BYTESTRM_HXX_

#ifndef _VOS_TYPES_HXX_
#	include <vos/types.hxx>
#endif
#ifndef _VOS_OBJECT_HXX_
#	include <vos/object.hxx>
#endif
#ifndef _VOS_STREAM_HXX_
#	include <vos/stream.hxx>
#endif
#ifndef _VOS_BYTARRAY_HXX_
#	include <vos/bytarray.hxx>
#endif

#ifdef _USE_NAMESPACE
namespace vos
{     
#endif

/** Wraps a byte-stream around a byte array.
*/
class OByteStream : public NAMESPACE_VOS(OStream)
{
public:

	/// Create a ByteStream that uses the given ByteArray.
    OByteStream(OByteArray& b);	

    // ----------------- Stream interface ------------------------

	///
    virtual sal_Int32 SAL_CALL write(const void* pbuffer, sal_uInt32 n);

	///
    virtual sal_Int32 SAL_CALL read(void* pbuffer, sal_uInt32 n) const;

	///
	virtual sal_Int32 SAL_CALL read(IPositionableStream::Offset offset, 
					     void* pbuffer, 
			             sal_uInt32 n) const;

	///
    virtual sal_Int32 SAL_CALL write(IPositionableStream::Offset offset, 
			              const void* pbuffer, 
			              sal_uInt32 n);

	///
    virtual sal_Bool SAL_CALL seekTo(IPositionableStream::Offset pos) const;

	///
    virtual sal_Bool SAL_CALL seekToEnd() const;

	///
    virtual sal_Bool SAL_CALL seekRelative(IPositionableStream::Offset change) const;
    
	///
    virtual sal_Bool SAL_CALL changeSize(sal_uInt32 new_size);

	///
    virtual sal_uInt32 SAL_CALL getSize() const;	

	///
    virtual sal_Bool SAL_CALL isEof() const;	

	///
    virtual IPositionableStream::Offset SAL_CALL getOffset() const;

protected:
    OByteArray& m_Buffer;
    sal_uInt32      m_Position;
};

#ifdef _USE_NAMESPACE
}     
#endif

#endif // _VOS_BYTESTRM_HXX_

