/*************************************************************************
 *
 *  $RCSfile: SinglePropertySetInfoCache.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: hr $ $Date: 2003/03/27 18:19:55 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _XMLOFF_SINGEPROPERTYSETINFOCACHE_HXX
#define _XMLOFF_SINGEPROPERTYSETINFOCACHE_HXX

#ifndef _COM_SUN_STAR_BEANS_XPROPERTYSET_HPP_
#include <com/sun/star/beans/XPropertySet.hpp>
#endif

#include <hash_map>

#ifndef _XMLOFF_PROPERTYSETINFOHASH_HXX
#include "PropertySetInfoHash.hxx"
#endif


typedef std::hash_map
<
	PropertySetInfoKey,
	sal_Bool,
	PropertySetInfoHash,
	PropertySetInfoHash
>
SinglePropertySetInfoMap_Impl;

class SinglePropertySetInfoCache : private SinglePropertySetInfoMap_Impl
{
	::rtl::OUString sName;

public:

	inline SinglePropertySetInfoCache( const ::rtl::OUString& rName );
	~SinglePropertySetInfoCache() {};

	sal_Bool hasProperty( 
			const ::com::sun::star::uno::Reference< 
				::com::sun::star::beans::XPropertySet >& rPropSet,
			::com::sun::star::uno::Reference< 
				::com::sun::star::beans::XPropertySetInfo >& rPropSetInfo );
	inline sal_Bool hasProperty( 
			const ::com::sun::star::uno::Reference< 
				::com::sun::star::beans::XPropertySet>& rPropSet );
};


inline SinglePropertySetInfoCache::SinglePropertySetInfoCache( 
		const ::rtl::OUString& rName ) :
	sName( rName )
{
}


inline sal_Bool SinglePropertySetInfoCache::hasProperty( 
		const ::com::sun::star::uno::Reference< 
			::com::sun::star::beans::XPropertySet>& rPropSet )
{
	::com::sun::star::uno::Reference< 
		::com::sun::star::beans::XPropertySetInfo > xInfo;
	return hasProperty( rPropSet, xInfo );
}

#endif
