/*************************************************************************
 *
 *  $RCSfile: QueryStatement.java,v $
 *
 *  $Revision: 1.1 $
 *
 *  last change: $Author: abi $ $Date: 2000/11/30 18:03:51 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

package com.sun.xmlsearch.xml.qe;

import java.io.*;

public final class QueryStatement implements Externalizable {
    private static final int DefaultNumberOfHits = 20;
  
    private String _terms;
    private String _scope;

    private int _nHits;
  
    public void readExternal(ObjectInput in)
	throws ClassNotFoundException, IOException {
	_terms   = (String) in.readObject();
	_scope   = (String) in.readObject();
	_nHits   = in.readInt();
    }
  
    public void writeExternal(ObjectOutput out) throws IOException {
	out.writeObject(_terms);
	out.writeObject(_scope);
	out.writeInt(_nHits);
    }

    public QueryStatement() { /* for Externalizable */ }

    public QueryStatement(String terms, String scope, int nHits) {
	_terms = terms;
	_scope = scope;
	_nHits = nHits;
    }

    public QueryStatement makeClone() {
	return new QueryStatement(_terms, _scope, _nHits);
    }

    public QueryStatement(String terms, String scope) {
	this(terms, scope, DefaultNumberOfHits);
    }

    public QueryStatement(String terms) {
	this(terms, null);
    }

    public QueryStatement(String terms, int nHits) {
	this(terms, null, nHits);
    }

    public void defaultSearchUnit(String tagName) {
	// !!! need to differenciate requested NONE from not requested
	if (_scope == null || _scope.length() == 0)
	    _scope = tagName;
    }

    public String getTerms() {
	return _terms;
    }
  
    public String getScope() {
	return _scope;
    }

    public int getRequestedNumberOfHits() {
	return _nHits;
    }

    public String toString() {
	return "search for |" + _terms + (_scope != null ? "| in " + _scope : "|");
    }
}
