/*************************************************************************
 *
 *  $RCSfile: ports.c,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 15:17:22 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/


#include "system.h"

#include <osl/diagnose.h>
#include <osl/thread.h>
#include <osl/ports.h>




/*********************************************************
  port functions implementation
**********************************************************/

/** 
	The getPortNames function copies all portnames in ppNamelist and set the number of portnames in nNumberOfEntries.
	Check the oslPortError for osl_Port_E_BufferToSmall.
*/
oslPortError SAL_CALL osl_getPortNames( sal_Char* pNameList, sal_uInt32 nSize, sal_uInt32 *nNumberOfEntries)
{
	return osl_Port_E_NotAvailable;
}


/** The openPort function opens a port for a connection.
	@param pPortName [in]
		The name of the port, like COM1 (win) or /dev/term/a (unx). This must be a null terminated string.
	@param nAccessMode [in]
		Specifies the type of access to the object. An application can obtain read access,
		write access, read-write access, or device query access. This parameter can be any
		combination of the OSL_PORT_AC_XXX constants.
	@param hPort [out]
		If the requested port is open, hPort is a valid Porthandle. Otherwise the handle is NULL.
	@return Error value.
*/

sal_uInt32	SAL_CALL osl_getPortTypeByName( const sal_Char * pName )
{
	return OSL_PORT_TYPE_UNKNOWN;
}
/** 
	The getPortTypeByName function returns the port type of the port with the name pName.
	The return value is one of the OSL_PORT_TYPE_XXX constants.

*/

oslPortError SAL_CALL osl_openPort( const sal_Char *pPortName, sal_uInt32 nAccessMode, oslPort *hPort )
{
	return osl_Port_E_NotAvailable;
}

/** 
	The closePort function closes an openPort and frees all resources.
*/
oslPortError SAL_CALL osl_closePort( oslPort hPort )
{
	return osl_Port_E_NotAvailable;
}


oslPortError SAL_CALL osl_getPortProperties( oslPort hPort, oslPortProperties *pPortProp )
{
	return osl_Port_E_NotAvailable;
}


/** The osl_getPortProperties function fills a buffer with information about the 
	communications properties for a specified communications device. 
	
	 @param hPortProp [out]
		Structure of a oslPortProperties filled with properties for a specified communications device.

*/
oslPortError SAL_CALL osl_setEventHandler( oslPort hPort, osl_Port_Callback aCallback, sal_uInt32 nUserData )
{
	return osl_Port_E_NotAvailable;
}

oslPortError SAL_CALL osl_removeEventHandler( oslPort hPort )
{
	return osl_Port_E_NotAvailable;
}



oslPortError SAL_CALL osl_clearPortBreak( oslPort hPort )
{
	return osl_Port_E_NotAvailable;
}

/** The osl_clearPortBreak function restores character transmission for a specified communications 
	device and places the transmission line in a nonbreak state. */

oslPortError SAL_CALL osl_setPortBreak( oslPort hPort )
{
	return osl_Port_E_NotAvailable;
}

/** The osl_setPortBreak function suspends character transmission for a specified communications 
	device and places the transmission line in a break state until the ClearCommBreak function is called. */


oslPortError SAL_CALL osl_getPortControlBlock( oslPort hPort, oslPortControlBlock *pPCB )
{
	return osl_Port_E_NotAvailable;
}



oslPortError SAL_CALL osl_setPortControlBlock( oslPort hPort, const oslPortControlBlock *pPCB )
{
	return osl_Port_E_NotAvailable;
}


oslPortError SAL_CALL osl_getAndClearPortError( oslPort hPort, sal_uInt32* pErrorValueMask, oslPortState *pPortState )
{
	return osl_Port_E_NotAvailable;
}

/** The getAndClearPortError function retrieves information about a communications error.
	The function is called when a communications error occurs, and it clears the device's error 
	flag to enable additional input and output (I/O) operations. 
	
	@param pErrorValueMask [out]
		Specifies the error that occurred. This parameter can be a combination of 
		the OSL_PORT_E_XXX constants.
*/
oslPortError SAL_CALL osl_purgePort( oslPort hPort, sal_uInt32 nFlags )
{
	return osl_Port_E_NotAvailable;
}

/** The purgePort function can discard all characters from the output or input 
	buffer of a specified communications resource. It can also terminate pending 
	read or write operations on the resource. 

	@param nFlags [in]
		Specifies the action to take. This parameter can be a combination of 
		the OSL_PORT_PURGE_XXX constants.
*/


oslPortError SAL_CALL osl_getPortEventMask( oslPort hPort, sal_uInt32 *nEventMask)
{
	return osl_Port_E_NotAvailable;
}

/** The osl_getPortEventMask function specifies a set of events to be monitored for a communications device. 
*/

oslPortError SAL_CALL osl_setPortEventMask( oslPort hPort, sal_uInt32 nEventMask )
{
	return osl_Port_E_NotAvailable;
}

/** The osl_getPortEventMask function specifies a set of events to be monitored for a communications device. 
*/


oslPortError SAL_CALL osl_transmitPortChar( oslPort hPort, sal_Char cChar )
{
	return osl_Port_E_NotAvailable;
}

/** The TransmitPortChar function transmits a specified character ahead of 
	any pending data in the output buffer of the specified communications device.
	This function is useful for sending an interrupt character (such as a ctrl+c) to a host system. 
 */

oslPortError SAL_CALL osl_setPortTimeout( oslPort hPort, const oslPortTimeouts* pPortTimeouts )
{
	return osl_Port_E_NotAvailable;
}
/**	The SetPortTimeout function set the time-out parameters for all read 
	and write operations on a specified communications device. 
*/

oslPortError SAL_CALL osl_getPortTimeout( oslPort hPort, oslPortTimeouts *pPortTimeouts )
{
	return osl_Port_E_NotAvailable;
}

/** The GetPortTimeout function returned the current time-out parameters for all read 
	and write operations on a specified communications device. 
*/


sal_uInt32 SAL_CALL osl_sendToPort( oslPort hPort, void* pBuffer, sal_uInt32 nNumberOfBytesToWrite )
{
	return 0;
}

/** The function sendToPort tries to send the contents of pBuffer synchronous to the port.
	The function will block until all bytes are transmitted, or if a timeout is set
	(with setPortTimeout) until the timeout has reached. If no timeout is set, the function
	may be block forever.

	@return The number of bytes written.
*/


sal_uInt32 SAL_CALL osl_receiveFromPort( oslPort hPort, void* pBuffer, sal_uInt32 nNumberOfBytesToRead )
{
	return 0;
}

/** The function receiveFromPort tries to fill the contents of pBuffer synchronous from the port.
	The function will block until nNumberOfBytesToRead bytes received, or if a timeout is set
	(with setPortTimeout) until the timeout has reached. If no timeout is set, the function
	may be block forever.

	@return The number of bytes received.
*/

