/*************************************************************************
 *
 *  $RCSfile: WinObjectBase.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: vg $ $Date: 2003/04/15 17:47:29 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _WINOBJECTBASE_HXX_
#define _WINOBJECTBASE_HXX_

//------------------------------------------------------------------------
// includes
//------------------------------------------------------------------------

#ifndef _KEYVALUEMAP_HXX_
#include "KeyValueMap.hxx"
#endif

#ifndef _SYNCOBJECTS_HXX_
#include <systools\win32\syncobjects.hxx>
#endif

//------------------------------------------------------------------------
// a useful define ( in my opinion )
//------------------------------------------------------------------------

#define DECLARE_INSTANCE(CLASSNAME, KEY) \
	CLASSNAME* pImpl = CLASSNAME##::GetInstanceFromKey( KEY )

//------------------------------------------------------------------------
// deklarations
//------------------------------------------------------------------------

/*
	the problem: if you wrapp win32 objects with a class and also have to
	support callbacks you need a way to reconnect to the belonging instance
	of the wrapper class; because callback functions have to be static they
	don't get a this pointer
	one way to solve the problem is to use a static map which saves the
	association between the HANDLE and an instance
	sample:
	class CWindow
	{
	public:
		....
	protected:
		// the window proc called by windows
		static LRESULT WndProc( HWND hWnd, UINT uMsg, ...);

	private:
		HWND m_hWnd;
	};

	...

	LRESULT CWindow::WndProc( HWND hWnd, ... )
	{
		// how to reconnect to the right instance?
	}
*/

template< class KEY, class VALUE, class LOCK >
class TWinObjectBase
{
public:
	typedef CKeyValueMap< KEY, VALUE > HandleInstanceMap_t;

	//-------------------------------------------------
	// ctor
	//-------------------------------------------------

	TWinObjectBase( )
	{
    #if OSL_DEBUG_LEVEL > 0
		m_nInstances = 0;
		++m_nInstances;
	#endif
	}

	//-------------------------------------------------
	// dtor
	//-------------------------------------------------

	virtual ~TWinObjectBase( )
	{
    #ifdef OSL_DEBUG_LEVEL > 0
		--m_nInstances;
	#endif
	}

	//-------------------------------------------------
	// Register
	//-------------------------------------------------

	static BOOL  Register( KEY aKey, VALUE aValue )
	{
		SyncObjLockGuard_t aGuard( &s_aLock );
		s_aKVMap.insert( aKey, aValue );
		return TRUE;
	}

	//-------------------------------------------------
	// Unregister
	//-------------------------------------------------

	static BOOL  Unregister( KEY aKey )
	{
		SyncObjLockGuard_t aGuard( &s_aLock );
		s_aKVMap.remove( aKey );
		return TRUE;
	}

	//-------------------------------------------------
	// GetInstanceFromKey
	//-------------------------------------------------

	static VALUE GetInstanceFromKey( KEY aKey )
	{
		SyncObjLockGuard_t aGuard( &s_aLock );
		return s_aKVMap.get( aKey );
	}

protected:
	static HandleInstanceMap_t s_aKVMap;
	static LOCK                s_aLock;

#ifdef OSL_DEBUG_LEVEL > 0
	size_t m_nInstances;
#endif

};

// static template member definition
template< class KEY, class VALUE, class LOCK > \
	TWinObjectBase< KEY, VALUE, LOCK >::HandleInstanceMap_t \
	TWinObjectBase< KEY, VALUE, LOCK >::s_aKVMap;

template< class KEY, class VALUE, class LOCK > \
	LOCK TWinObjectBase< KEY, VALUE, LOCK >::s_aLock;

#endif
