/*************************************************************************
 *
 *  $RCSfile: functab.cxx,v $
 *
 *  $Revision: 1.9 $
 *
 *  last change: $Author: dr $ $Date: 2001/11/23 13:04:17 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifdef PCH
#include "filt_pch.hxx"
#endif

#pragma hdrstop

#ifndef _TOOLS_DEBUG_HXX
#	include <tools/debug.hxx>
#endif
#ifndef _VOS_MUTEX_HXX_
#	include <vos/mutex.hxx>
#endif

#include "functab.h"

//------------------------------------------------------------------------


static SFuncData**					ppFT = NULL;
static UINT32						nUseCnt = 0;
static NAMESPACE_VOS( OMutex )		aInitSemaphore;


static const SFuncData FuncTab[] =
{
//  Opcode          | Index| FuncType| Volatile   | ParamCount | VarParamTypeCount | PType1,PType2 ...
	{ ocCount         ,	  0, nTypeVal, FALSE,		nVarParam,	1, nTypeRef },
	{ ocIf            ,	  1, nTypeVal, FALSE,		nVarParam,	2, nTypeVal, nTypeRef },
	{ ocIsNV          ,	  2, nTypeVal, FALSE,		1,			1, nTypeVal },
	{ ocIsError       ,	  3, nTypeVal, FALSE,		1,			1, nTypeVal },
	{ ocSum           ,	  4, nTypeVal, FALSE,		nVarParam,	1, nTypeRef },
	{ ocAverage       ,	  5, nTypeVal, FALSE,		nVarParam,	1, nTypeRef },
	{ ocMin           ,	  6, nTypeVal, FALSE,		nVarParam,	1, nTypeRef },
	{ ocMax           ,	  7, nTypeVal, FALSE,		nVarParam,	1, nTypeRef },
	{ ocRow           ,	  8, nTypeVal, FALSE,		nVarParam,	1, nTypeRef },
	{ ocColumn        ,	  9, nTypeVal, FALSE,		nVarParam,	1, nTypeRef },
	{ ocNoValue       ,	 10, nTypeVal, FALSE,		0,			1, 0 },
	{ ocNBW           ,	 11, nTypeVal, FALSE,		nVarParam,	2, nTypeVal, nTypeRef },
	{ ocStDev         ,	 12, nTypeVal, FALSE,		nVarParam,	1, nTypeRef },
	{ ocCurrency      ,	 13, nTypeVal, FALSE,		nVarParam,	1, nTypeVal },
	{ ocFixed         ,	 14, nTypeVal, FALSE,		nVarParam,	1, nTypeVal },
	{ ocSin           ,	 15, nTypeVal, FALSE,		1,			1, nTypeVal },
	{ ocCos           ,	 16, nTypeVal, FALSE,		1,			1, nTypeVal },
	{ ocTan           ,	 17, nTypeVal, FALSE,		1,			1, nTypeVal },
	{ ocArcTan        ,	 18, nTypeVal, FALSE,		1,			1, nTypeVal },
	{ ocPi            ,	 19, nTypeVal, FALSE,		0,			1, 0 },
	{ ocSqrt          ,	 20, nTypeVal, FALSE,		1,			1, nTypeVal },
	{ ocExp           ,	 21, nTypeVal, FALSE,		1,			1, nTypeVal },
	{ ocLn            ,	 22, nTypeVal, FALSE,		1,			1, nTypeVal },
	{ ocLog10         ,	 23, nTypeVal, FALSE,		1,			1, nTypeVal },
	{ ocAbs           ,	 24, nTypeVal, FALSE,		1,			1, nTypeVal },
	{ ocInt           ,	 25, nTypeVal, FALSE,		1,			1, nTypeVal },
	{ ocPlusMinus     ,	 26, nTypeVal, FALSE,		1,			1, nTypeVal },
	{ ocRound         ,	 27, nTypeVal, FALSE,		2,			1, nTypeVal, nTypeVal },
	{ ocLookup        ,	 28, nTypeVal, FALSE,		nVarParam,	2, nTypeVal, nTypeRef },
    { ocIndex         ,  29, nTypeRef, TRUE,        nVarParam,  4, nTypeRef, nTypeVal, nTypeVal, nTypeVal },
	{ ocRept          ,	 30, nTypeVal, FALSE,		2,			1, nTypeVal, nTypeVal },
	{ ocMid           ,	 31, nTypeVal, FALSE,		3,			1, nTypeVal, nTypeVal, nTypeVal },
	{ ocLen           ,	 32, nTypeVal, FALSE,		1,			1, nTypeVal },
	{ ocValue         ,	 33, nTypeVal, FALSE,		1,			1, nTypeVal },
	{ ocTrue          ,	 34, nTypeVal, FALSE,		0,			1, 0 },
	{ ocFalse         ,	 35, nTypeVal, FALSE,		0,			1, 0 },
	{ ocAnd           ,	 36, nTypeVal, FALSE,		nVarParam,	1, nTypeRef },
	{ ocOr            ,	 37, nTypeVal, FALSE,		nVarParam,	1, nTypeRef },
	{ ocNot           ,	 38, nTypeVal, FALSE,		1,			1, nTypeVal },
	{ ocMod           ,	 39, nTypeVal, FALSE,		2,			1, nTypeVal, nTypeVal },
	{ ocDBCount       ,	 40, nTypeVal, FALSE,		3,			1, nTypeRef, nTypeRef, nTypeRef },
	{ ocDBSum         ,	 41, nTypeVal, FALSE,		3,			1, nTypeRef, nTypeRef, nTypeRef },
	{ ocDBAverage     ,	 42, nTypeVal, FALSE,		3,			1, nTypeRef, nTypeRef, nTypeRef },
	{ ocDBMin         ,	 43, nTypeVal, FALSE,		3,			1, nTypeRef, nTypeRef, nTypeRef },
	{ ocDBMax         ,	 44, nTypeVal, FALSE,		3,			1, nTypeRef, nTypeRef, nTypeRef },
	{ ocDBStdDev      ,	 45, nTypeVal, FALSE,		3,			1, nTypeRef, nTypeRef, nTypeRef },
	{ ocVar           ,	 46, nTypeVal, FALSE,		nVarParam,	1, nTypeRef },
	{ ocDBVar         ,	 47, nTypeVal, FALSE,		3,			1, nTypeRef, nTypeRef, nTypeRef },
	{ ocText          ,	 48, nTypeVal, FALSE,		2,			1, nTypeVal, nTypeVal },
	{ ocRGP           ,	 49, nTypeVal, FALSE,		nVarParam,	1, nTypeRef },
	{ ocTrend         ,	 50, nTypeVal, FALSE,		nVarParam,	1, nTypeRef },
	{ ocRKP           ,	 51, nTypeVal, FALSE,		nVarParam,	1, nTypeRef },
	{ ocGrowth        ,	 52, nTypeVal, FALSE,		nVarParam,	1, nTypeRef },
	{ ocBW            ,	 56, nTypeVal, FALSE,		nVarParam,	1, nTypeVal },
	{ ocZW            ,	 57, nTypeVal, FALSE,		nVarParam,	1, nTypeVal },
	{ ocZZR           ,	 58, nTypeVal, FALSE,		nVarParam,	1, nTypeVal },
	{ ocRMZ           ,	 59, nTypeVal, FALSE,		nVarParam,	1, nTypeVal },
	{ ocZins          ,	 60, nTypeVal, FALSE,		nVarParam,	1, nTypeVal },
	{ ocMIRR          ,	 61, nTypeVal, FALSE,		3,			1, nTypeRef, nTypeVal, nTypeVal },
	{ ocIKV           ,	 62, nTypeVal, FALSE,		nVarParam,	2, nTypeRef, nTypeVal },
	{ ocRandom        ,	 63, nTypeVal, TRUE,		0,			1, 0 },
	{ ocMatch         ,	 64, nTypeVal, FALSE,		nVarParam,	2, nTypeVal, nTypeRef },
	{ ocGetDate       ,	 65, nTypeVal, FALSE,		3,			1, nTypeVal, nTypeVal, nTypeVal },
	{ ocGetTime       ,	 66, nTypeVal, FALSE,		3,			1, nTypeVal, nTypeVal, nTypeVal },
	{ ocGetDay        ,	 67, nTypeVal, FALSE,		1,			1, nTypeVal },
	{ ocGetMonth      ,	 68, nTypeVal, FALSE,		1,			1, nTypeVal },
	{ ocGetYear       ,	 69, nTypeVal, FALSE,		1,			1, nTypeVal },
	{ ocGetDayOfWeek  ,	 70, nTypeVal, FALSE,		nVarParam,	1, nTypeVal },
	{ ocGetHour       ,	 71, nTypeVal, FALSE,		1,			1, nTypeVal },
	{ ocGetMin        ,	 72, nTypeVal, FALSE,		1,			1, nTypeVal },
	{ ocGetSec        ,	 73, nTypeVal, FALSE,		1,			1, nTypeVal },
	{ ocGetActTime    ,	 74, nTypeVal, TRUE,		0,			1, 0 },
	{ ocAreas         ,	 75, nTypeVal, FALSE,		1,			1, nTypeRef },
	{ ocRows          ,	 76, nTypeVal, FALSE,		1,			1, nTypeRef },
	{ ocColumns       ,	 77, nTypeVal, FALSE,		1,			1, nTypeRef },
	{ ocOffset        ,	 78, nTypeRef, FALSE,		nVarParam,	2, nTypeRef, nTypeVal },
	{ ocSearch        ,	 82, nTypeVal, FALSE,		nVarParam,	1, nTypeVal },
	{ ocMatTrans      ,	 83, nTypeVal, FALSE,		1,			1, nTypeArr },
	{ ocType          ,	 86, nTypeVal, FALSE,		1,			1, nTypeVal },
	{ ocArcTan2       ,	 97, nTypeVal, FALSE,		2,			1, nTypeVal, nTypeVal },
	{ ocArcSin        ,	 98, nTypeVal, FALSE,		1,			1, nTypeVal },
	{ ocArcCos        ,	 99, nTypeVal, FALSE,		1,			1, nTypeVal },
	{ ocChose         , 100, nTypeVal, FALSE,		nVarParam,	2, nTypeVal, nTypeRef },
	{ ocHLookup       ,	101, nTypeVal, FALSE,		nVarParam,	4, nTypeVal, nTypeRef, nTypeRef, nTypeVal },
	{ ocVLookup       ,	102, nTypeVal, FALSE,		nVarParam,	4, nTypeVal, nTypeRef, nTypeRef, nTypeVal },
	{ ocIsRef         ,	105, nTypeVal, FALSE,		1,			1, nTypeRef },
	{ ocLog           ,	109, nTypeVal, FALSE,		nVarParam,	1, nTypeVal },
	{ ocChar          ,	111, nTypeVal, FALSE,		1,			1, nTypeVal },
	{ ocLower         ,	112, nTypeVal, FALSE,		1,			1, nTypeVal },
	{ ocUpper         ,	113, nTypeVal, FALSE,		1,			1, nTypeVal },
	{ ocPropper       ,	114, nTypeVal, FALSE,		1,			1, nTypeVal },
	{ ocLeft          ,	115, nTypeVal, FALSE,		nVarParam,	1, nTypeVal },
	{ ocRight         ,	116, nTypeVal, FALSE,		nVarParam,	1, nTypeVal },
	{ ocExact         ,	117, nTypeVal, FALSE,		2,			1, nTypeVal, nTypeVal },
	{ ocTrim          ,	118, nTypeVal, FALSE,		1,			1, nTypeVal },
	{ ocReplace       ,	119, nTypeVal, FALSE,		4,			1, nTypeVal, nTypeVal, nTypeVal, nTypeVal },
	{ ocSubstitute    ,	120, nTypeVal, FALSE,		nVarParam,	1, nTypeVal },
	{ ocCode          ,	121, nTypeVal, FALSE,		1,			1, nTypeVal },
	{ ocFind          ,	124, nTypeVal, FALSE,		nVarParam,	1, nTypeVal },
	{ ocCell          ,	125, nTypeVal, FALSE,		nVarParam,	2, nTypeVal, nTypeRef },
	{ ocIsErr         ,	126, nTypeVal, FALSE,		1,			1, nTypeVal },
	{ ocIsString      ,	127, nTypeVal, FALSE,		1,			1, nTypeVal },
	{ ocIsValue       ,	128, nTypeVal, FALSE,		1,			1, nTypeVal },
	{ ocIsEmpty       ,	129, nTypeVal, FALSE,		1,			1, nTypeVal },
	{ ocT             ,	130, nTypeVal, FALSE,		1,			1, nTypeRef },
	{ ocN             ,	131, nTypeVal, FALSE,		1,			1, nTypeRef },
	{ ocGetDateValue  ,	140, nTypeVal, FALSE,		1,			1, nTypeVal },
	{ ocGetTimeValue  ,	141, nTypeVal, FALSE,		1,			1, nTypeVal },
	{ ocLIA           ,	142, nTypeVal, FALSE,		3,			1, nTypeVal, nTypeVal, nTypeVal },
	{ ocDIA           ,	143, nTypeVal, FALSE,		4,			1, nTypeVal, nTypeVal, nTypeVal, nTypeVal },
	{ ocGDA           ,	144, nTypeVal, FALSE,		nVarParam,	1, nTypeVal },
	{ ocIndirect      ,	148, nTypeRef, TRUE,		nVarParam,	1, nTypeVal },
	{ ocClean         ,	162, nTypeVal, FALSE,		1,			1, nTypeVal },
	{ ocMatDet        ,	163, nTypeVal, FALSE,		1,			1, nTypeArr },
	{ ocMatInv        ,	164, nTypeVal, FALSE,		1,			1, nTypeArr },
	{ ocMatMult       ,	165, nTypeVal, FALSE,		2,			1, nTypeArr, nTypeArr },
	{ ocZinsZ         ,	167, nTypeVal, FALSE,		nVarParam,	1, nTypeVal },
	{ ocKapz          ,	168, nTypeVal, FALSE,		nVarParam,	1, nTypeVal },
	{ ocCount2        ,	169, nTypeVal, FALSE,		nVarParam,	1, nTypeRef },
	{ ocProduct       ,	183, nTypeVal, FALSE,		nVarParam,	1, nTypeRef },
	{ ocFact          ,	184, nTypeVal, FALSE,		1,			1, nTypeVal },
	{ ocDBProduct     ,	189, nTypeVal, FALSE,		3,			1, nTypeRef, nTypeRef, nTypeRef },
	{ ocIsNonString   ,	190, nTypeVal, FALSE,		1,			1, nTypeVal },
	{ ocStDevP        ,	193, nTypeVal, FALSE,		nVarParam,	1, nTypeRef },
	{ ocVarP          ,	194, nTypeVal, FALSE,		nVarParam,	1, nTypeRef },
	{ ocDBStdDevP     ,	195, nTypeVal, FALSE,		3,			1, nTypeRef, nTypeRef, nTypeRef },
	{ ocDBVarP        ,	196, nTypeVal, FALSE,		3,			1, nTypeRef, nTypeRef, nTypeRef },
	{ ocTrunc         ,	197, nTypeVal, FALSE,		nVarParam,	1, nTypeVal },
	{ ocIsLogical     ,	198, nTypeVal, FALSE,		1,			1, nTypeVal },
	{ ocDBCount2      ,	199, nTypeVal, FALSE,		3,			1, nTypeRef, nTypeRef, nTypeRef },
	{ ocRoundUp       ,	212, nTypeVal, FALSE,		2,			1, nTypeVal, nTypeVal },
	{ ocRoundDown     ,	213, nTypeVal, FALSE,		2,			1, nTypeVal, nTypeVal },
	{ ocRank          ,	216, nTypeVal, FALSE,		nVarParam,	3, nTypeVal, nTypeRef, nTypeVal },
	{ ocAdress        ,	219, nTypeVal, FALSE,		nVarParam,	5, nTypeVal, nTypeVal, nTypeVal, nTypeInsert, nTypeVal },
	{ ocGetDiffDate360,	220, nTypeVal, FALSE,		nVarParam,	1, nTypeVal },
	{ ocGetActDate    ,	221, nTypeVal, TRUE,		0,			1, 0 },
	{ ocVBD           ,	222, nTypeVal, FALSE,		nVarParam,	1, nTypeVal },
	{ ocMedian        ,	227, nTypeVal, FALSE,		nVarParam,	1, nTypeRef },
	{ ocSumProduct    ,	228, nTypeVal, FALSE,		nVarParam,	1, nTypeArr },
	{ ocSinHyp        ,	229, nTypeVal, FALSE,		1,			1, nTypeVal },
	{ ocCosHyp        ,	230, nTypeVal, FALSE,		1,			1, nTypeVal },
	{ ocTanHyp        ,	231, nTypeVal, FALSE,		1,			1, nTypeVal },
	{ ocArcSinHyp     ,	232, nTypeVal, FALSE,		1,			1, nTypeVal },
	{ ocArcCosHyp     ,	233, nTypeVal, FALSE,		1,			1, nTypeVal },
	{ ocArcTanHyp     ,	234, nTypeVal, FALSE,		1,			1, nTypeVal },
	{ ocDBGet         ,	235, nTypeVal, FALSE,		3,			1, nTypeRef, nTypeRef, nTypeRef },
	{ ocGDA2          ,	247, nTypeVal, FALSE,		nVarParam,	1, nTypeVal },
	{ ocFrequency     ,	252, nTypeVal, FALSE,		2,			1, nTypeRef, nTypeRef },
	{ ocErrorType     ,	261, nTypeVal, FALSE,		1,			1, nTypeVal },
	{ ocAveDev        ,	269, nTypeVal, FALSE,		nVarParam,	1, nTypeRef },
	{ ocBetaDist      ,	270, nTypeVal, FALSE,		nVarParam,	1, nTypeVal },
	{ ocGammaLn       ,	271, nTypeVal, FALSE,		1,			1, nTypeVal },
	{ ocBetaInv       ,	272, nTypeVal, FALSE,		nVarParam,	1, nTypeVal },
	{ ocBinomDist     ,	273, nTypeVal, FALSE,		4,			1, nTypeVal, nTypeVal, nTypeVal, nTypeVal },
	{ ocChiDist       ,	274, nTypeVal, FALSE,		2,			1, nTypeVal, nTypeVal },
	{ ocChiInv        ,	275, nTypeVal, FALSE,		2,			1, nTypeVal, nTypeVal },
	{ ocKombin        ,	276, nTypeVal, FALSE,		2,			1, nTypeVal, nTypeVal },
	{ ocConfidence    ,	277, nTypeVal, FALSE,		3,			1, nTypeVal, nTypeVal, nTypeVal },
	{ ocKritBinom     ,	278, nTypeVal, FALSE,		3,			1, nTypeVal, nTypeVal, nTypeVal },
	{ ocEven          ,	279, nTypeVal, FALSE,		1,			1, nTypeVal },
	{ ocExpDist       ,	280, nTypeVal, FALSE,		3,			1, nTypeVal, nTypeVal, nTypeVal },
	{ ocFDist         ,	281, nTypeVal, FALSE,		3,			1, nTypeVal, nTypeVal, nTypeVal },
	{ ocFInv          ,	282, nTypeVal, FALSE,		3,			1, nTypeVal, nTypeVal, nTypeVal },
	{ ocFisher        ,	283, nTypeVal, FALSE,		1,			1, nTypeVal },
	{ ocFisherInv     ,	284, nTypeVal, FALSE,		1,			1, nTypeVal },
	{ ocFloor         ,	285, nTypeVal, FALSE,		2,			1, nTypeVal, nTypeVal, nTypeIgnore },
	{ ocGammaDist     ,	286, nTypeVal, FALSE,		4,			1, nTypeVal, nTypeVal, nTypeVal, nTypeVal },
	{ ocGammaInv      ,	287, nTypeVal, FALSE,		3,			1, nTypeVal, nTypeVal, nTypeVal },
	{ ocCeil          ,	288, nTypeVal, FALSE,		2,			1, nTypeVal, nTypeVal, nTypeIgnore },
	{ ocHypGeomDist   ,	289, nTypeVal, FALSE,		4,			1, nTypeVal, nTypeVal, nTypeVal, nTypeVal },
	{ ocLogNormDist   ,	290, nTypeVal, FALSE,		3,			1, nTypeVal, nTypeVal, nTypeVal },
	{ ocLogInv        ,	291, nTypeVal, FALSE,		3,			1, nTypeVal, nTypeVal, nTypeVal },
	{ ocNegBinomVert  ,	292, nTypeVal, FALSE,		3,			1, nTypeVal, nTypeVal, nTypeVal },
	{ ocNormDist      ,	293, nTypeVal, FALSE,		4,			1, nTypeVal, nTypeVal, nTypeVal, nTypeVal },
	{ ocStdNormDist   ,	294, nTypeVal, FALSE,		1,			1, nTypeVal },
	{ ocNormInv       ,	295, nTypeVal, FALSE,		3,			1, nTypeVal, nTypeVal, nTypeVal },
	{ ocSNormInv      ,	296, nTypeVal, FALSE,		1,			1, nTypeVal },
	{ ocStandard      ,	297, nTypeVal, FALSE,		3,			1, nTypeVal, nTypeVal, nTypeVal },
	{ ocOdd           ,	298, nTypeVal, FALSE,		1,			1, nTypeVal },
	{ ocVariationen   ,	299, nTypeVal, FALSE,		2,			1, nTypeVal, nTypeVal },
	{ ocPoissonDist   ,	300, nTypeVal, FALSE,		3,			1, nTypeVal, nTypeVal, nTypeVal },
	{ ocTDist         ,	301, nTypeVal, FALSE,		3,			1, nTypeVal, nTypeVal, nTypeVal },
	{ ocWeibull       ,	302, nTypeVal, FALSE,		4,			1, nTypeVal, nTypeVal, nTypeVal, nTypeVal },
	{ ocSumXMY2       ,	303, nTypeVal, FALSE,		2,			1, nTypeArr, nTypeArr },
	{ ocSumX2MY2      ,	304, nTypeVal, FALSE,		2,			1, nTypeArr, nTypeArr },
	{ ocSumX2DY2      ,	305, nTypeVal, FALSE,		2,			1, nTypeArr, nTypeArr },
	{ ocChiTest       ,	306, nTypeVal, FALSE,		2,			1, nTypeArr, nTypeArr },
	{ ocCorrel        ,	307, nTypeVal, FALSE,		2,			1, nTypeArr, nTypeArr },
	{ ocCovar         ,	308, nTypeVal, FALSE,		2,			1, nTypeArr, nTypeArr },
	{ ocForecast      ,	309, nTypeVal, FALSE,		3,			1, nTypeVal, nTypeArr, nTypeArr },
	{ ocFTest         ,	310, nTypeVal, FALSE,		2,			1, nTypeArr, nTypeArr },
	{ ocIntercept     ,	311, nTypeVal, FALSE,		2,			1, nTypeArr, nTypeArr },
	{ ocPearson       ,	312, nTypeVal, FALSE,		2,			1, nTypeArr, nTypeArr },
	{ ocRSQ           ,	313, nTypeVal, FALSE,		2,			1, nTypeArr, nTypeArr },
	{ ocSTEYX         ,	314, nTypeVal, FALSE,		2,			1, nTypeArr, nTypeArr },
	{ ocSlope         ,	315, nTypeVal, FALSE,		2,			1, nTypeArr, nTypeArr },
	{ ocTTest         ,	316, nTypeVal, FALSE,		4,			1, nTypeArr, nTypeArr, nTypeVal, nTypeVal },
	{ ocProb          ,	317, nTypeVal, FALSE,		nVarParam,	3, nTypeArr, nTypeArr, nTypeVal },
	{ ocDevSq         ,	318, nTypeVal, FALSE,		nVarParam,	1, nTypeRef },
	{ ocGeoMean       ,	319, nTypeVal, FALSE,		nVarParam,	1, nTypeRef },
	{ ocHarMean       ,	320, nTypeVal, FALSE,		nVarParam,	1, nTypeRef },
	{ ocSumSQ         ,	321, nTypeVal, FALSE,		nVarParam,	1, nTypeRef },
	{ ocKurt          ,	322, nTypeVal, FALSE,		nVarParam,	1, nTypeRef },
	{ ocSchiefe       ,	323, nTypeVal, FALSE,		nVarParam,	1, nTypeRef },
	{ ocZTest         ,	324, nTypeVal, FALSE,		nVarParam,	2, nTypeRef, nTypeVal },
	{ ocLarge         ,	325, nTypeVal, FALSE,		2,			1, nTypeRef, nTypeVal },
	{ ocSmall         ,	326, nTypeVal, FALSE,		2,			1, nTypeRef, nTypeVal },
	{ ocQuartile      ,	327, nTypeVal, FALSE,		2,			1, nTypeRef, nTypeVal },
	{ ocPercentile    ,	328, nTypeVal, FALSE,		2,			1, nTypeRef, nTypeVal },
	{ ocPercentrank   ,	329, nTypeVal, FALSE,		nVarParam,	2, nTypeRef, nTypeVal },
	{ ocModalValue    ,	330, nTypeVal, FALSE,		nVarParam,	1, nTypeArr },
	{ ocTrimMean      ,	331, nTypeVal, FALSE,		2,			1, nTypeRef, nTypeVal },
	{ ocTInv          ,	332, nTypeVal, FALSE,		2,			1, nTypeVal, nTypeVal },
	{ ocConcat        ,	336, nTypeVal, FALSE,		nVarParam,	1, nTypeVal },
	{ ocPower         ,	337, nTypeVal, FALSE,		2,			1, nTypeVal, nTypeVal },
	{ ocRad           ,	342, nTypeVal, FALSE,		1,			1, nTypeVal },
	{ ocDeg           ,	343, nTypeVal, FALSE,		1,			1, nTypeVal },
	{ ocSubTotal      ,	344, nTypeVal, FALSE,		nVarParam,	2, nTypeVal, nTypeRef },
    { ocSumIf         , 345, nTypeVal, FALSE,       nVarParam,  3, nTypeRef, nTypeVal, nTypeRef },
    { ocCountIf       , 346, nTypeVal, FALSE,       2,          1, nTypeRef, nTypeVal },
	{ ocCountEmptyCells,347, nTypeVal, FALSE,		1,			1, nTypeRef },
	{ ocRoman         , 354, nTypeVal, FALSE,		nVarParam,	2, nTypeVal, nTypeVal },
	{ 0 },
	//! from here on only >= Biff8
	{ ocExternal      , 255, nTypeVal, FALSE,		nVarParam,	2, nTypeInsert, nTypeRef },
	{ ocISPMT	      , 350, nTypeVal, FALSE,		4,			1, nTypeVal, nTypeVal, nTypeVal, nTypeVal },
	{ ocAverageA      ,	361, nTypeVal, FALSE,		nVarParam,	1, nTypeRef },
	{ ocMaxA          ,	362, nTypeVal, FALSE,		nVarParam,	1, nTypeRef },
	{ ocMinA          ,	363, nTypeVal, FALSE,		nVarParam,	1, nTypeRef },
	{ ocStDevPA       ,	364, nTypeVal, FALSE,		nVarParam,	1, nTypeRef },
	{ ocVarPA         ,	365, nTypeVal, FALSE,		nVarParam,	1, nTypeRef },
	{ ocStDevA        ,	366, nTypeVal, FALSE,		nVarParam,	1, nTypeRef },
	{ ocVarA          ,	367, nTypeVal, FALSE,		nVarParam,	1, nTypeRef },
	{ 0 },
};


void InitFuncData( BOOL bBiff8 )
{
	aInitSemaphore.acquire();

	if( ppFT )
		nUseCnt++;
	else
	{
		nUseCnt = 1;

		ppFT = new SFuncData* [ ( UINT16 ) SC_OPCODE_END_2_PAR ];
		const SFuncData*	pFD;

		for( UINT16 nCnt = 0 ; nCnt < SC_OPCODE_END_2_PAR ; nCnt++ )
		{
			ppFT[ nCnt ] = NULL;
			for( pFD = FuncTab; pFD->nOp ; pFD++ )
			{
				if( pFD->nOp == nCnt )
				{
					DBG_ASSERT( pFD->nVarParamTypeCount &&
						pFD->nVarParamTypeCount <= nMaxParamCount,
						"InitFuncData: nVarParamTypeCount == 0 || nVarParamTypeCount > nMaxParamCount" );
					ppFT[ nCnt ] = new SFuncData;
					ppFT[ nCnt ]->Copy( *pFD );
					break;	// for
				}
			}
			if ( !ppFT[ nCnt ] && bBiff8 )
			{
				for( pFD++; pFD->nOp ; pFD++ )
				{
					if( pFD->nOp == nCnt )
					{
						DBG_ASSERT( pFD->nVarParamTypeCount &&
							pFD->nVarParamTypeCount <= nMaxParamCount,
							"InitFuncData: nVarParamTypeCount == 0 || nVarParamTypeCount > nMaxParamCount" );
						ppFT[ nCnt ] = new SFuncData;
						ppFT[ nCnt ]->Copy( *pFD );
						break;	// for
					}
				}

			}
		}
	}

	aInitSemaphore.release();
}


void DeInitFuncData()
{
	aInitSemaphore.acquire();

	DBG_ASSERT( ppFT, "-DeInitFuncData(): delete without new" );
	DBG_ASSERT( nUseCnt, "*DeInitFuncData(): use count without function!?" );

	nUseCnt--;

	if( !nUseCnt )
	{
		for( UINT16 nCnt = 0 ; nCnt < SC_OPCODE_END_2_PAR ; nCnt++ )
		{
			if( ppFT[ nCnt ] )
				delete ppFT[ nCnt ];
		}

		delete[] ppFT;
		ppFT = NULL;
	}

	aInitSemaphore.release();
}


const SFuncData* GetFuncData( OpCode eOp )
{
	DBG_ASSERT( ppFT, "-GetFuncData(): gleich gibt's Byte-Muell!" );

	if( eOp < SC_OPCODE_END_2_PAR )
		return ppFT[ ( UINT16 ) eOp ];
	else
		return NULL;
}

