/*************************************************************************
 *
 *  $RCSfile: slchghlp.cxx,v $
 *
 *  $Revision: 1.9 $
 *
 *  last change: $Author: cl $ $Date: 2002/05/21 13:56:13 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#pragma hdrstop

#include <vcl/msgbox.hxx>

#ifndef _URLOBJ_HXX
#include <tools/urlobj.hxx>
#endif
#include <svx/gallery.hxx>
#include <svtools/pathoptions.hxx>

#include "slidechg.hxx"
#include "slidechg.hrc"
#include "app.hrc"
#include "strings.hrc"
#include "res_bmp.hrc"
#include "sdattr.hxx"
#include "sdresid.hxx"
#include "sdview.hxx"
#include "drawdoc.hxx"
#include "filedlg.hxx"

using namespace ::com::sun::star;

// -----------------------------------------------------------------------

void SdSlideChangeWin::SetFadeEffect( presentation::FadeEffect eFE )
{
	USHORT nLB = 0;
	USHORT nVS = 0;

	// Sound fuer Favoriten (?)
	String aStr( aLbSound.GetSelectEntry() );
	USHORT nSoundId = GetIdBySound( aStr );

	switch( eFE )
	{
		// Kein Effekt
		case presentation::FadeEffect_NONE:						nLB = 0; nVS = 1; break;

		// Ueberblenden
		case presentation::FadeEffect_FADE_FROM_LEFT:			nLB = 1; nVS = 4; break;
		case presentation::FadeEffect_FADE_FROM_TOP:			nLB = 1; nVS = 2; break;
		case presentation::FadeEffect_FADE_FROM_RIGHT:			nLB = 1; nVS = 6; break;
		case presentation::FadeEffect_FADE_FROM_BOTTOM:			nLB = 1; nVS = 8; break;
		case presentation::FadeEffect_FADE_FROM_UPPERLEFT:		nLB = 1; nVS = 1; break;
		case presentation::FadeEffect_FADE_FROM_UPPERRIGHT:		nLB = 1; nVS = 3; break;
		case presentation::FadeEffect_FADE_FROM_LOWERLEFT:		nLB = 1; nVS = 7; break;
		case presentation::FadeEffect_FADE_FROM_LOWERRIGHT:		nLB = 1; nVS = 9; break;

		// Aufdecken
		case presentation::FadeEffect_MOVE_FROM_LEFT:
			if( nSoundId == 2 ) // Favorit
				{ nLB = 0; nVS = nSoundId; }
			else
				{ nLB = 2; nVS = 4; }
			break;
		case presentation::FadeEffect_MOVE_FROM_TOP:
			if( nSoundId == 5 ) // Favorit
				{ nLB = 0; nVS = nSoundId; }
			else
				{ nLB = 2; nVS = 2; }
			break;
		case presentation::FadeEffect_MOVE_FROM_RIGHT:			nLB = 2; nVS = 6; break;
		case presentation::FadeEffect_MOVE_FROM_BOTTOM:			nLB = 2; nVS = 8; break;
		case presentation::FadeEffect_MOVE_FROM_UPPERLEFT:		nLB = 2; nVS = 1; break;
		case presentation::FadeEffect_MOVE_FROM_UPPERRIGHT:		nLB = 2; nVS = 3; break;
		case presentation::FadeEffect_MOVE_FROM_LOWERRIGHT:		nLB = 2; nVS = 9; break;
		case presentation::FadeEffect_MOVE_FROM_LOWERLEFT:		nLB = 2; nVS = 7; break;

		// Move
		case presentation::FadeEffect_UNCOVER_TO_LEFT:			nLB = 3; nVS = 4; break;
		case presentation::FadeEffect_UNCOVER_TO_TOP:			nLB = 3; nVS = 2; break;
		case presentation::FadeEffect_UNCOVER_TO_RIGHT:		    nLB = 3; nVS = 6; break;
		case presentation::FadeEffect_UNCOVER_TO_BOTTOM:		nLB = 3; nVS = 8; break;
		case presentation::FadeEffect_UNCOVER_TO_UPPERLEFT:		nLB = 3; nVS = 1; break;
		case presentation::FadeEffect_UNCOVER_TO_UPPERRIGHT:	nLB = 3; nVS = 3; break;
		case presentation::FadeEffect_UNCOVER_TO_LOWERLEFT:		nLB = 3; nVS = 7; break;
		case presentation::FadeEffect_UNCOVER_TO_LOWERRIGHT:	nLB = 3; nVS = 9; break;

		// Blenden
		case presentation::FadeEffect_FADE_TO_CENTER:			nLB = 4; nVS = 1; break;
		case presentation::FadeEffect_FADE_FROM_CENTER:
			if( nSoundId == 8 ) // Favorit
				{ nLB = 0; nVS = nSoundId; }
			else
				{ nLB = 4; nVS = 2; }
			break;
		case presentation::FadeEffect_VERTICAL_STRIPES:			nLB = 4; nVS = 4; break;
		case presentation::FadeEffect_HORIZONTAL_STRIPES:		nLB = 4; nVS = 5; break;
		case presentation::FadeEffect_CLOCKWISE:
			if( nSoundId == 9 ) // Favorit
				{ nLB = 0; nVS = nSoundId; }
			else
				{ nLB = 4; nVS = 7; }
			break;
		case presentation::FadeEffect_COUNTERCLOCKWISE:     	nLB = 4; nVS = 8; break;

		// Oeffnen / Schliessen
		case presentation::FadeEffect_OPEN_VERTICAL:			nLB = 5; nVS = 1; break;
		case presentation::FadeEffect_OPEN_HORIZONTAL:			nLB = 5; nVS = 2; break;
		case presentation::FadeEffect_CLOSE_VERTICAL:			nLB = 5; nVS = 4; break;
		case presentation::FadeEffect_CLOSE_HORIZONTAL:			nLB = 5; nVS = 5; break;

		// Schlangenlinien
		case presentation::FadeEffect_WAVYLINE_FROM_LEFT:		nLB = 6; nVS = 4; break;
		case presentation::FadeEffect_WAVYLINE_FROM_RIGHT:		nLB = 6; nVS = 6; break;
		case presentation::FadeEffect_WAVYLINE_FROM_TOP:		nLB = 6; nVS = 2; break;
		case presentation::FadeEffect_WAVYLINE_FROM_BOTTOM:		nLB = 6; nVS = 8; break;

		// Spirale
		case presentation::FadeEffect_SPIRALIN_LEFT:			nLB = 7; nVS = 1; break;
		case presentation::FadeEffect_SPIRALIN_RIGHT:			nLB = 7; nVS = 3; break;
		case presentation::FadeEffect_SPIRALOUT_LEFT:			nLB = 7; nVS = 4; break;
		case presentation::FadeEffect_SPIRALOUT_RIGHT:			nLB = 7; nVS = 6; break;

		// Rollen
		case presentation::FadeEffect_ROLL_FROM_LEFT:
			if( nSoundId == 3 ) // Favorit
				{ nLB = 0; nVS = nSoundId; }
			else
				{ nLB = 8; nVS = 4; }
			break;
		case presentation::FadeEffect_ROLL_FROM_TOP:
			if( nSoundId == 6 ) // Favorit
				{ nLB = 0; nVS = nSoundId; }
			else
				{ nLB = 8; nVS = 2; }
			break;
		case presentation::FadeEffect_ROLL_FROM_RIGHT:			nLB = 8; nVS = 6; break;
		case presentation::FadeEffect_ROLL_FROM_BOTTOM:			nLB = 8; nVS = 8; break;

		// Stretchen
		case presentation::FadeEffect_STRETCH_FROM_LEFT:		nLB = 9; nVS = 4; break;
		case presentation::FadeEffect_STRETCH_FROM_TOP:
			if( nSoundId == 4 ) // Favorit
				{ nLB = 0; nVS = nSoundId; }
			else
				{ nLB = 9; nVS = 2; }
			break;
		case presentation::FadeEffect_STRETCH_FROM_RIGHT:		nLB = 9; nVS = 6; break;
		case presentation::FadeEffect_STRETCH_FROM_BOTTOM:		nLB = 9; nVS = 8; break;

		// Sonstige
		case presentation::FadeEffect_VERTICAL_LINES:			nLB = 10; nVS = 1; break;
		case presentation::FadeEffect_HORIZONTAL_LINES:			nLB = 10; nVS = 2; break;
		case presentation::FadeEffect_DISSOLVE:
			if( nSoundId == 7 ) // Favorit
				{ nLB = 0; nVS = nSoundId; }
			else
				{ nLB = 10; nVS = 3; }
			break;
		case presentation::FadeEffect_VERTICAL_CHECKERBOARD:	nLB = 10; nVS = 7; break;
		case presentation::FadeEffect_HORIZONTAL_CHECKERBOARD:	nLB = 10; nVS = 8; break;
		case presentation::FadeEffect_RANDOM:					nLB = 10; nVS = 9; break;

	}

	aLbEffect.SelectEntryPos( nLB );
	FillValueSet();
	aCtlEffect.SelectItem( nVS );
	if( aLbEffect.IsVisible() && !aCtlEffect.IsVisible() )
		aCtlEffect.Show();
}

// -----------------------------------------------------------------------

presentation::FadeEffect SdSlideChangeWin::GetFadeEffect()
{
	presentation::FadeEffect eFE = presentation::FadeEffect_NONE; // statt DontKnow

	USHORT nLB;
	USHORT nVS;

	nLB = aLbEffect.GetSelectEntryPos();
	nVS = aCtlEffect.GetSelectItemId();

	switch( nLB )
	{
		// Kein Effekt (Jetzt Favoriten)
		case 0:
		{
			if( nVS == 1 ) eFE = presentation::FadeEffect_NONE;
			else if( nVS == 2 ) eFE = presentation::FadeEffect_MOVE_FROM_LEFT;
			else if( nVS == 3 ) eFE = presentation::FadeEffect_ROLL_FROM_LEFT;
			else if( nVS == 4 ) eFE = presentation::FadeEffect_STRETCH_FROM_TOP;
			else if( nVS == 5 ) eFE = presentation::FadeEffect_MOVE_FROM_TOP;
			else if( nVS == 6 ) eFE = presentation::FadeEffect_ROLL_FROM_TOP;
			else if( nVS == 7 ) eFE = presentation::FadeEffect_DISSOLVE;
			else if( nVS == 8 ) eFE = presentation::FadeEffect_FADE_FROM_CENTER;
			else if( nVS == 9 ) eFE = presentation::FadeEffect_CLOCKWISE;
		}
		break;


		// Ueberblenden
		case 1:
		{
			if( nVS == 4 ) eFE = presentation::FadeEffect_FADE_FROM_LEFT;
			else if( nVS == 2 ) eFE = presentation::FadeEffect_FADE_FROM_TOP;
			else if( nVS == 6 ) eFE = presentation::FadeEffect_FADE_FROM_RIGHT;
			else if( nVS == 8 ) eFE = presentation::FadeEffect_FADE_FROM_BOTTOM;
			else if( nVS == 1 ) eFE = presentation::FadeEffect_FADE_FROM_UPPERLEFT;
			else if( nVS == 3 ) eFE = presentation::FadeEffect_FADE_FROM_UPPERRIGHT;
			else if( nVS == 7 ) eFE = presentation::FadeEffect_FADE_FROM_LOWERLEFT;
			else if( nVS == 9 ) eFE = presentation::FadeEffect_FADE_FROM_LOWERRIGHT;
		}
		break;

		// Aufdecken
		case 2:
		{
			if( nVS == 4 ) eFE = presentation::FadeEffect_MOVE_FROM_LEFT;
			else if( nVS == 2 ) eFE = presentation::FadeEffect_MOVE_FROM_TOP;
			else if( nVS == 6 ) eFE = presentation::FadeEffect_MOVE_FROM_RIGHT;
			else if( nVS == 8 ) eFE = presentation::FadeEffect_MOVE_FROM_BOTTOM;
			else if( nVS == 1 ) eFE = presentation::FadeEffect_MOVE_FROM_UPPERLEFT;
			else if( nVS == 3 ) eFE = presentation::FadeEffect_MOVE_FROM_UPPERRIGHT;
			else if( nVS == 7 ) eFE = presentation::FadeEffect_MOVE_FROM_LOWERLEFT;
			else if( nVS == 9 ) eFE = presentation::FadeEffect_MOVE_FROM_LOWERRIGHT;
		}
		break;

		// Move
		case 3:
		{
			if( nVS == 4 ) eFE = presentation::FadeEffect_UNCOVER_TO_LEFT;
			else if( nVS == 2 ) eFE = presentation::FadeEffect_UNCOVER_TO_TOP;
			else if( nVS == 6 ) eFE = presentation::FadeEffect_UNCOVER_TO_RIGHT;
			else if( nVS == 8 ) eFE = presentation::FadeEffect_UNCOVER_TO_BOTTOM;
			else if( nVS == 1 ) eFE = presentation::FadeEffect_UNCOVER_TO_UPPERLEFT;
			else if( nVS == 3 ) eFE = presentation::FadeEffect_UNCOVER_TO_UPPERRIGHT;
			else if( nVS == 7 ) eFE = presentation::FadeEffect_UNCOVER_TO_LOWERLEFT;
			else if( nVS == 9 ) eFE = presentation::FadeEffect_UNCOVER_TO_LOWERRIGHT;
		}
		break;

		// Blenden
		case 4:
		{
			if( nVS == 1 ) eFE = presentation::FadeEffect_FADE_TO_CENTER;
			else if( nVS == 2 ) eFE = presentation::FadeEffect_FADE_FROM_CENTER;
			else if( nVS == 4 ) eFE = presentation::FadeEffect_VERTICAL_STRIPES;
			else if( nVS == 5 ) eFE = presentation::FadeEffect_HORIZONTAL_STRIPES;
			else if( nVS == 7 ) eFE = presentation::FadeEffect_CLOCKWISE;
			else if( nVS == 8 ) eFE = presentation::FadeEffect_COUNTERCLOCKWISE;
		}
		break;

		// Oeffnen / Schliessen
		case 5:
		{
			if( nVS == 1 ) eFE = presentation::FadeEffect_OPEN_VERTICAL;
			else if( nVS == 2 ) eFE = presentation::FadeEffect_OPEN_HORIZONTAL;
			else if( nVS == 4 ) eFE = presentation::FadeEffect_CLOSE_VERTICAL;
			else if( nVS == 5 ) eFE = presentation::FadeEffect_CLOSE_HORIZONTAL;
		}
		break;

		// Schlangenlinien
		case 6:
		{
			if( nVS == 4 ) eFE = presentation::FadeEffect_WAVYLINE_FROM_LEFT;
			else if( nVS == 6 ) eFE = presentation::FadeEffect_WAVYLINE_FROM_RIGHT;
			else if( nVS == 2 ) eFE = presentation::FadeEffect_WAVYLINE_FROM_TOP;
			else if( nVS == 8 ) eFE = presentation::FadeEffect_WAVYLINE_FROM_BOTTOM;
		}
		break;

		// Spirale
		case 7:
		{
			if( nVS == 1 ) eFE = presentation::FadeEffect_SPIRALIN_LEFT;
			else if( nVS == 3 ) eFE = presentation::FadeEffect_SPIRALIN_RIGHT;
			else if( nVS == 4 ) eFE = presentation::FadeEffect_SPIRALOUT_LEFT;
			else if( nVS == 6 ) eFE = presentation::FadeEffect_SPIRALOUT_RIGHT;
		}
		break;

		// Rollen
		case 8:
		{
			if( nVS == 4 ) eFE = presentation::FadeEffect_ROLL_FROM_LEFT;
			else if( nVS == 2 ) eFE = presentation::FadeEffect_ROLL_FROM_TOP;
			else if( nVS == 6 ) eFE = presentation::FadeEffect_ROLL_FROM_RIGHT;
			else if( nVS == 8 ) eFE = presentation::FadeEffect_ROLL_FROM_BOTTOM;
		}
		break;

		// Tropfen
		case 9:
		{
			if( nVS == 4 ) eFE = presentation::FadeEffect_STRETCH_FROM_LEFT;
			else if( nVS == 2 ) eFE = presentation::FadeEffect_STRETCH_FROM_TOP;
			else if( nVS == 6 ) eFE = presentation::FadeEffect_STRETCH_FROM_RIGHT;
			else if( nVS == 8 ) eFE = presentation::FadeEffect_STRETCH_FROM_BOTTOM;
		}
		break;

		// Sonstige
		case 10:
		{
			if( nVS == 1 ) eFE = presentation::FadeEffect_VERTICAL_LINES;
			else if( nVS == 2 ) eFE = presentation::FadeEffect_HORIZONTAL_LINES;
			else if( nVS == 3 ) eFE = presentation::FadeEffect_DISSOLVE;
			else if( nVS == 7 ) eFE = presentation::FadeEffect_VERTICAL_CHECKERBOARD;
			else if( nVS == 8 ) eFE = presentation::FadeEffect_HORIZONTAL_CHECKERBOARD;
			else if( nVS == 9 ) eFE = presentation::FadeEffect_RANDOM;
		}
		break;
	}
	return( eFE );
}

// -----------------------------------------------------------------------

void SdSlideChangeWin::FillValueSet()
{
	USHORT nFirstItem = 0;
	USHORT nPos = aLbEffect.GetSelectEntryPos();

	aCtlEffect.SetUpdateMode( FALSE );
	aCtlEffect.Clear();

	if( nPos != LISTBOX_ENTRY_NOTFOUND )
	{
		for( int i = 1; i <= 10; i++ )
		{
			USHORT nStrId = GetStringId( i, nPos );
			USHORT nBmpId = GetBitmapId( i, nPos );
			if( nStrId != 0 && nBmpId != 0 )
			{
				aCtlEffect.InsertItem( i,
						Bitmap( SdResId( nBmpId ) ),
						String( SdResId( nStrId ) ) );
				if( nFirstItem == 0 )
					nFirstItem = i;
			}
			else
				aCtlEffect.InsertSpace( i );
		}
		if( !aCtlEffect.IsVisible() && aLbEffect.IsVisible() )
			aCtlEffect.Show();

		if( nFirstItem > 0 )
			aCtlEffect.SelectItem( nFirstItem );
	}
	else
		aCtlEffect.Hide();
	aCtlEffect.SetUpdateMode( TRUE );
}

// -----------------------------------------------------------------------

USHORT SdSlideChangeWin::GetBitmapId( USHORT i, USHORT nPos )
{
	const bool bHighContrast = GetDisplayBackground().GetColor().IsDark() != 0;
	
	List* pList;
	if( bHighContrast )
		pList = (List*) ppHCBitmapIdList->GetObject( nPos );
	else
		pList = (List*) ppBitmapIdList->GetObject( nPos );
	
	ULONG nId = (ULONG) pList->GetObject( i );
	return( (USHORT) nId );
}

// -----------------------------------------------------------------------

USHORT SdSlideChangeWin::GetStringId( USHORT i, USHORT nPos )
{
	List* pList = (List*) ppStringIdList->GetObject( nPos );
	ULONG nId = (ULONG) pList->GetObject( i );
	return( (USHORT) nId );
}

// -----------------------------------------------------------------------

USHORT SdSlideChangeWin::GetViewTypeResId( ViewTypeSlCh eVT, BOOL bImage )
{
	switch( eVT )
	{
		case VIEWTYPE_SC_EFFECT:
				return( bImage ? IMG_EFFECT : STR_VIEWTYPE_EFFECT );
		case VIEWTYPE_SC_EXTRAS:
				return( bImage ? IMG_EXTRAS : STR_VIEWTYPE_EXTRAS );
		default: DBG_ERROR( "Keine Resource fuer ViewType vorhanden!" );
	}
	return( 0 );
}

// -----------------------------------------------------------------------

void SdSlideChangeWin::OpenFileDialog()
{
	SdOpenSoundFileDialog	aFileDialog;

	String aFile;
	USHORT nPos = aLbSound.GetSelectEntryPos();
	if( nPos != LISTBOX_ENTRY_NOTFOUND )
		aFile = *(String*)pSoundList->GetObject( (long)nPos );
	else
		aFile = SvtPathOptions().GetGraphicPath();

	aFileDialog.SetPath( aFile );

	BOOL bValidSoundFile(TRUE);
	BOOL bQuitLoop(FALSE);	

	while( bQuitLoop == FALSE &&
		   aFileDialog.Execute() == ERRCODE_NONE )
	{
		aFile = aFileDialog.GetPath();
		//aLbSound.SelectEntry( aFile );
		// Ist jetzt nicht mehr so einfach, da Gallery, die Liste und
		// die ListBox auf den neusten Stand gebracht werden muessen
		long nPos = GetSoundObject( aFile );

		if( nPos < 0 ) // not in Soundliste
		{
			// try to insert in Gallery
			if( GalleryExplorer::InsertURL( GALLERY_THEME_USERSOUNDS, aFile, SGA_FORMAT_SOUND ) )
			{
				ClearSoundList();
				aLbSound.Clear();
			
				FillSoundListAndBox();
				nPos = GetSoundObject( aFile );
				DBG_ASSERT( nPos >= 0, "Sound nicht in Liste!" );

				bValidSoundFile=TRUE;
				bQuitLoop=TRUE;
			}
			else
			{
				String aStrWarning(SdResId(STR_WARNING_NOSOUNDFILE));
				String aStr; aStr += sal_Unicode('%');
				aStrWarning.SearchAndReplace( aStr , aFile );
				WarningBox aWarningBox( NULL, WB_3DLOOK | WB_RETRY_CANCEL, aStrWarning );
				aWarningBox.SetModalInputMode (TRUE);
				bQuitLoop = aWarningBox.Execute()==RET_RETRY ? FALSE : TRUE;
				
				bValidSoundFile=FALSE;
			}
		}
		else
		{
			bValidSoundFile=TRUE;
			bQuitLoop=TRUE;
		}		  
		
		if( bValidSoundFile )
			aLbSound.SelectEntryPos( (USHORT) nPos );
	}
}

// -----------------------------------------------------------------------

void SdSlideChangeWin::FillSoundListAndBox()
{
	GalleryExplorer::FillObjList( GALLERY_THEME_SOUNDS, *pSoundList );
	GalleryExplorer::FillObjList( GALLERY_THEME_USERSOUNDS, *pSoundList );

	for( ULONG i = 0; i < pSoundList->Count(); i++ )
	{
		INetURLObject aURL( *(String*)pSoundList->GetObject( i ) );
		aLbSound.InsertEntry( aURL.GetBase() );
	}
}

// -----------------------------------------------------------------------

void SdSlideChangeWin::ClearSoundList()
{
	ULONG nCount = pSoundList->Count();
	for( ULONG i = 0; i < nCount; i++ )
		delete (String*)pSoundList->GetObject( i );
	pSoundList->Clear();
}

// -----------------------------------------------------------------------

long SdSlideChangeWin::GetSoundObject( const String& rStr )
{
	String aStrIn( rStr );

	aStrIn.ToLowerAscii();

	for( ULONG i = 0, nCount = pSoundList->Count(); i < nCount; i++ )
	{
		String aTmpStr( *(String*)pSoundList->GetObject( i ) );

		aTmpStr.ToLowerAscii();

		if( aTmpStr == aStrIn )
			return( i );
	}

	return( -1L );
}

// -----------------------------------------------------------------------

String SdSlideChangeWin::GetSoundById( USHORT nId )
{
	String aStr;
	switch( nId )
	{
		case 2: aStr = UniString::CreateFromAscii( RTL_CONSTASCII_STRINGPARAM( "space2" ) ); break;
		case 3: aStr = UniString::CreateFromAscii( RTL_CONSTASCII_STRINGPARAM( "space3" ) ); break;
		case 4: aStr = UniString::CreateFromAscii( RTL_CONSTASCII_STRINGPARAM( "soft" ) );   break;
		case 5: aStr = UniString::CreateFromAscii( RTL_CONSTASCII_STRINGPARAM( "space" ) );  break;
		case 6: aStr = UniString::CreateFromAscii( RTL_CONSTASCII_STRINGPARAM( "beam" ) );   break;
		case 7: aStr = UniString::CreateFromAscii( RTL_CONSTASCII_STRINGPARAM( "untie" ) );  break;
		case 8: aStr = UniString::CreateFromAscii( RTL_CONSTASCII_STRINGPARAM( "romans" ) ); break;
		case 9: aStr = UniString::CreateFromAscii( RTL_CONSTASCII_STRINGPARAM( "roll" ) );   break;
	}
	return( aStr );
}

// -----------------------------------------------------------------------

USHORT SdSlideChangeWin::GetIdBySound( const String& rStr )
{
	USHORT nId = 1;
	String aStr( rStr );
	aStr.ToLowerAscii();

	if( aStr.EqualsAscii( "space2" ) )
		nId = 2;
	else if( aStr.EqualsAscii( "space3" ) )
		nId = 3;
	else if( aStr.EqualsAscii( "soft" ) )
		nId = 4;
	else if( aStr.EqualsAscii( "space" ) )
		nId = 5;
	else if( aStr.EqualsAscii( "beam" ) )
		nId = 6;
	else if( aStr.EqualsAscii( "untie" ) )
		nId = 7;
	else if( aStr.EqualsAscii( "romans" ) )
		nId = 8;
	else if( aStr.EqualsAscii( "roll" ) )
		nId = 9;

	return( nId );
}


void SdSlideChangeWin::DataChanged( const DataChangedEvent& rDCEvt )
{
	if ( (rDCEvt.GetType() == DATACHANGED_SETTINGS) && (rDCEvt.GetFlags() & SETTINGS_STYLE) )
	{
		FillValueSet();
	}

    SfxDockingWindow::DataChanged( rDCEvt );
}
