/*************************************************************************
 *
 *  $RCSfile: loader.cxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: dv $ $Date: 2002/12/12 12:36:38 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

// defines ---------------------------------------------------------------

#define INCL_DOSSESMGR
#define INCL_DOSMODULEMGR
#define INCL_DOSQUEUES
#define INCL_DOSPROCESS
#define INCL_DOSFILEMGR
#define INCL_WIN
#define INCL_GPI
#define INCL_DOSERRORS
#define INCL_DOS

#define _MT 1
#define MINTEMPSIZE 18000000L

// include ----------------------------------------------------------------

#include <os2.h>

#include <io.h>
#include <stdio.h>
#include <stdlib.h>
#include <direct.h>
#include <string.h>
#include <process.h>
#include <ctype.h>
#include <sys\stat.h>
#include <fcntl.h>
#include <svunzip.h>

#include "loader.h"
#define _LOADER_CXX
#include "arch.hxx"

// #55281#: Absturtz wenn 'Neustart' nach SETUP
#pragma optimize ("", off )

#ifdef CSET
#define strncmpi(s1,s2,n) strnicmp(s1,s2,n)
#endif

#ifdef WTC
#include <dos.h>
ULONG _chdrive(ULONG nDrive)
{
	unsigned nReturn;

	 _dos_setdrive(nDrive,0L);
	 _dos_getdrive(&nReturn);

	 if(nReturn != nDrive)
		return -1;

	return 0;
}

#endif
// prototypes ------------------------------------------------------------

#define MAX_COMMANDLINE_LEN	400

HAB 	hab;				// Anchor block Handle
HWND	hWndFrame;			// Handle des AppWindows
int 	nArgs;				// Anzahl der Kommandoparameter
char*	pArg0;				// Kommandoparameter 1
char*	pArg1;				// Kommandoparameter 2
char*	pArg2;				// Kommandoparameter 3
char	cError[ERROR_LEN];	// globaler Fehlerstring
char    pCommandLine[MAX_COMMANDLINE_LEN];


BOOL 	bShutDownSystem = FALSE;
ULONG	nSetupSize = 0;
ULONG 	nMinTempSize = 0;
static const char strExePatch[] = "BIGFILE:patchpatchpatch";

void ShutDown(HMQ hmq);

// -----------------------------------------------------------------------

char* GetBootDrive( char* pDrive )
{
	UCHAR Databuf[5];
	APIRET rc;

	rc = DosQuerySysInfo( QSV_BOOT_DRIVE, QSV_BOOT_DRIVE, Databuf, sizeof(Databuf) );

	if (rc == 0)
	{
		pDrive[0] = Databuf[0] + 'A' - 1;
		pDrive[1] = '\0';
		strcat( pDrive, ":\\" );        // unsupported os #100211# - checked
		return pDrive;
	}

	return NULL;
}

/*************************************************************************
|*
|*	  IsPointInLibpath()
|*
|*	  Beschreibung		Abfrage, ob der Punkt im Libpath ist
|*	  Ersterstellung	PB	05.05.95
|*	  Letzte Aenderung	PB	05.05.95
|*
*************************************************************************/

void Trim(char *p)
{
	int i=0;

	while(isspace(p[i]))
		i++;

	if (i > 0)
		strcpy(p,p+i);      // unsupported os #100211# - checked
}

int IsDotInLibpath()
{
	// read config.sys
	int	 bFound		= 0;
	char szFile[20] = "";

	if (GetBootDrive(szFile) == NULL)
		return 0;

	strcat(szFile, "config.sys");       // unsupported os #100211# - checked

	FILE *pFile = fopen(szFile, "r");

	if (pFile == 0)
		return 0;

	char* szLine = new char[2048];

	while (fgets(szLine, 2048, pFile) != NULL
		&& !bFound)
	{
		strlwr(szLine);
		Trim(szLine);

		char *p = szLine;

		if (strncmp(p,"set ", 4) == 0)
		{
			p += 4;
			Trim(p);
		}

		if (strncmp(p,"libpath", 7) == 0)
		{
			p += 7;
			Trim(p);

			if (*p == '=')
			{
				p++;
				Trim(p);

				// jetzt kann die Suche losgehen
				int nState = 0;

				// 0 = Suche beginnt
				// 1 = ein Punkt gelesen (gefunden, wenn letztes Zeichen)
				// 2 = mehr als nur ein Punkt (auf ; warten)
				// 3 = gefunden
				//
				// 0 -(.)-> 1 -(bel)-> 2 -(;)-> 0
				//   -(bel)-+-------->
				//          |---(;)--> 3
				//
				int n = strlen(p);
				for (int i=0; i<n && nState != 3; i++)
				{
					if (!isspace(p[i])) // white spaces ignorieren
					{
						switch(nState)
						{
							case 0: nState = p[i] == '.' ? 1 : 2; break;
							case 1: nState = p[i] == ';' ? 3 : 2; break;
							case 2: nState = p[i] == ';' ? 0 : 2; break;
						}
					}
				}

				bFound =  nState == 3
					   || nState == 1; // wenn Punkt letztes Zeichen ist
			}
		}
	}

	fclose(pFile);
	delete szLine;
	return bFound;
}

int AddDotToLibpath()
{
	// read config.sys
	int	 bFound		= 0;
	char szFile[20] = "";
	char szOld[20]  = "";

	if (GetBootDrive(szFile) == NULL)
		return 0;

	strcpy(szOld,szFile);               // unsupported os #100211# - checked
	strcat(szFile, "config.sys");       // unsupported os #100211# - checked
	strcat(szOld,  "config.pre");       // unsupported os #100211# - checked
	DosCopy(szFile, szOld, DCPY_EXISTING);

	FILE *pOld  = fopen(szOld, "r");
	FILE *pFile = fopen(szFile,"w");

	if (pFile == 0
	||  pOld  == 0)
		return 0;

	char* szLine = new char[2048];
	char* szOrg  = new char[2048];

	while (fgets(szOrg, 2048, pOld) != NULL)
	{
		strcpy(szLine,szOrg);           // unsupported os #100211# - checked
		strlwr(szLine);
		Trim(szLine);

		char *p = szLine;

		if (strncmp(p,"set ", 4) == 0)
		{
			p += 4;
			Trim(p);
		}

		if (strncmp(p,"libpath", 7) == 0)
		{
			p += 7;
			Trim(p);

			if (*p == '=')
			{
				p++;
				Trim(p);
				bFound = 1;

				fputs("LIBPATH=.;",pFile);
				fputs(p,pFile);
			}
		}
		else
			fputs(szOrg, pFile);
	}

	// "Libpath =" wurde gar nicht gefunden
	if (!bFound)
		fputs("LIBPATH=.\n", pFile);

	fclose(pFile);
	fclose(pOld);
	delete szLine;
	delete szOrg;
	return 1;
}

int IsProgramAutostart()
{
	char* pVar = getenv("AUTOSTART");

	if (pVar == NULL)
		return 0;

	return strstr(pVar,"programs") != NULL
		|| strstr(pVar,"PROGRAMS") != NULL;
}

/*************************************************************************
 *
 *	  InfoBox(), ErrorBox(), QueryYesNoBox()
 *
 *************************************************************************/

void InfoBox( PSZ pInfo )
{
	WinMessageBox( HWND_DESKTOP, HWND_DESKTOP, pInfo, (PSZ)"Setup", 0,
		MB_MOVEABLE | MB_INFORMATION | MB_OK );
}

void ErrorBox( PSZ pError )
{
	WinMessageBox( HWND_DESKTOP, HWND_DESKTOP, pError, (PSZ)"Setup", 0,
		MB_MOVEABLE | MB_ERROR | MB_OK );
}

int QueryYesNoBox( PSZ pError )
{
	return WinMessageBox(HWND_DESKTOP, HWND_DESKTOP, pError, (PSZ)"Setup", 0,
								MB_MOVEABLE | MB_QUERY | MB_YESNO )
		   == MBID_YES;
}

/*************************************************************************
|*
|*	  WhereAmI()
|*
|*	  Beschreibung		Liefert den Pfad dieses Programms
|*	  Ersterstellung	CL 23.11.93
|*	  Letzte Aenderung	CL 23.11.93
|*
*************************************************************************/

void WhereAmI( const char* pFileName, char* pBuffer, ULONG nBufLen )
{
	// Kompletten Pfad auf Application holen
	HMODULE hModule = 0;
	DosQueryModuleHandle( (PSZ)pFileName, &hModule );
	DosQueryModuleName( hModule, nBufLen, (PCHAR)pBuffer );

	// Dateinamen abhacken, irgendein Backslash muss ja drin sein
	char* pBS = strrchr( pBuffer, '\\' );

	if ( pBS )
		*pBS = 0;
}

/*************************************************************************
|*
|*	  HasFreeSpace()
|*
|*	  Beschreibung
|*	  Ersterstellung	CL 24.11.93
|*	  Letzte Aenderung	CL 24.11.93
|*
*************************************************************************/

BOOL HasFreeSpace( ULONG nBytesWanted )
{
	// Den Platz auf dem aktuellen Laufwerk holen
	char pBuffer[40];
	DosQueryFSInfo( 0, FSIL_ALLOC, pBuffer, 40 );

	ULONG nBytes = *((USHORT*)(pBuffer+16));   // Bytes per Sektor
	nBytes *= *((ULONG*)(pBuffer+4));		   // Sektors per Unit
	nBytes *= *((ULONG*)(pBuffer+12));		   // Free units

	if ( nBytes < nBytesWanted )
		return FALSE;
	else
		return TRUE;
}

/*************************************************************************
|*
|*	  FileExists()
|*
|*	  Beschreibung		Prueft, ob das File existiert
|*	  Ersterstellung	PB 18.02.94
|*	  Letzte Aenderung	PB 18.02.94
|*
*************************************************************************/

BOOL FileExists( const char* pFileName )
{
	// open file
	unsigned long nAction = FILE_EXISTED;
	APIRET nRet;
	HFILE hFile;

	ULONG nFlags = OPEN_FLAGS_WRITE_THROUGH |
				   OPEN_FLAGS_FAIL_ON_ERROR |
				   OPEN_FLAGS_NO_CACHE		|
				   OPEN_FLAGS_RANDOM		|
				   OPEN_FLAGS_NOINHERIT 	|
				   OPEN_SHARE_DENYNONE		|
				   OPEN_ACCESS_READONLY;

	nRet = DosOpen( (PSZ)pFileName, &hFile, (PULONG)&nAction,
					/*size*/ 0, FILE_READONLY,
					OPEN_ACTION_FAIL_IF_NEW | OPEN_ACTION_OPEN_IF_EXISTS,
					nFlags, /*ea*/0 );

	if ( nRet == NO_ERROR )
	{
		DosClose( hFile );
		return TRUE;
	}
	return FALSE;
}

/*************************************************************************
|*
|*	  GetTempPath()
|*
|*	  Beschreibung		Liefert den Pfad auf eine temporaeres Verzeichnis
|*	  Ersterstellung	CL 10.11.93
|*	  Letzte Aenderung	PB 11.07.94
|*
*************************************************************************/

void GetTempPath( char* pPathBuffer, int nBufferLen )
{
	/* Erstmal sehen, ob TEMP oder TMP gesetzt sind */
	char* pVar;

	pVar = getenv("TEMP");
	if (pVar == NULL) pVar = getenv("temp");
	if (pVar == NULL) pVar = getenv("TMP");
	if (pVar == NULL) pVar = getenv("tmp");

	if (pVar
	&&  strlen(pVar) >= 2)
	{
		char szTempDir[256];

		strcpy(szTempDir,pVar);         // unsupported os #100211# - checked

		// Ins Zielverzeichnis wechseln und freien Speicher abfragen
		_chdrive(toupper( szTempDir[0] ) - 'A' + 1 );

		if (chdir(szTempDir) != 0)
		{
			strcpy(szTempDir+1,":\\"); // "c:\tralala" -> "c:\"     // unsupported os #100211# - checked
			chdir(szTempDir);
		}

		if (strlen(szTempDir) == 1 )
			pVar = 0;
	}

	if (!pVar)
	{
		// Keine temp-Variable gefunden, dann gehen wir mal auf die Suche
		// nach dem System-Laufwerk
		//
		pVar = getenv( "USER_INI" );
		if( pVar )
		{
			// Dateinamen abhacken
			char* pBS = strrchr( pVar, '\\' );
			if( pBS )
				*pBS = 0;

			// Ins Zielverzeichnis wechseln und freien Speicher abfragen
			_chdrive( toupper( pVar[0] ) - 'A' + 1 );
			chdir( pVar );
		}
	}

	if ( !pVar )
	{
		pVar = getenv( "SYSTEM_INI" );
		if( pVar )
		{
			// Dateinamen abhacken
			char* pBS = strrchr( pVar, '\\' );
			if( pBS )
				*pBS = 0;

			// Ins Zielverzeichnis wechseln und freien Speicher abfragen
			_chdrive( toupper( pVar[0] ) - 'A' + 1 );
			chdir( pVar );
		}
	}

	// Wenn das immer noch nicht reicht nehmen wir eben die Root von C:
	//
	if (!pVar)
	{
		pVar = "C:\\";

		// Ins Zielverzeichnis wechseln und freien Speicher abfragen
		_chdrive( toupper( pVar[0] ) - 'A' + 1 );
		chdir( pVar );
	}

	if ( pVar )
	{
		strncpy( pPathBuffer, pVar, nBufferLen );
		pPathBuffer[ nBufferLen-1 ] = 0;

		if ( pPathBuffer[ strlen( pPathBuffer )-1 ] == '\\' )
			pPathBuffer[ strlen( pPathBuffer )-1 ] = 0;
	}
	else
		pPathBuffer[0] = 0;
}

/*************************************************************************
|*
|*	  GetTempFile
|*
|*	  Beschreibung
|*	  Ersterstellung	PB 06.05.94
|*	  Letzte Aenderung	PB 06.05.94
|*
*************************************************************************/

void GetTempFile( char* cpTemp )
{
	// source stammt aus FSYS
	char*		ret_val;
	size_t		i;

	// dertermine Directory, Prefix and Extension
	char		pfx[6];
	char		ext[5];
	strcpy( pfx, "sv" );            // unsupported os #100211# - checked
	strcpy( ext, ".tmp" );          // unsupported os #100211# - checked

	char sBuf[_MAX_PATH];
	GetTempPath( sBuf, _MAX_PATH );

	if ( sBuf[0] == 0 )
	{
		cpTemp = 0;
		return;
	}

	// ab hier leicht modifizierter Code von VB
	i = strlen(sBuf);
	ret_val = new char[i+2 /* '\0' & '\\' */ + 8 /*root*/ + 4 /*.ext*/];

	if (ret_val)
	{
		unsigned u;
		strcpy(ret_val,sBuf);       // unsupported os #100211# - checked
		/* Make sure directory ends with a separator */
		if ( i > 0 && ret_val[i-1] != '\\' )
			ret_val[i++] = '\\';
		strncpy(ret_val + i, pfx, 5);
		ret_val[i + 5] = '\0';      /* strncpy doesn't put a 0 if more  */
		i = strlen(ret_val);		/* than 'n' chars.          */

		/* Prefix can have 5 chars, leaving 3 for numbers.
		   26 ** 3 == 17576
		 */
		for (u = 1; u < 26*26*26; u++)
		{
			itoa(u,ret_val + i,26);
			strcat(ret_val,ext);        // unsupported os #100211# - checked
			FILESTATUS3 filestat;
			memset( &filestat, 0, sizeof( filestat ) );
			if ( DosQueryPathInfo( (PSZ)ret_val, 1, &filestat, sizeof(filestat) ) )
			{
				strcpy( cpTemp, ret_val );  // unsupported os #100211# - checked
				break;
			}
		}
		delete ret_val;
		ret_val = 0;
	}
}

/*************************************************************************
|*
|*	  CopyZipFile()
|*
|*	  Beschreibung
|*	  Ersterstellung	CL 24.11.93
|*	  Letzte Aenderung	CL 24.11.93
|*
*************************************************************************/
BOOL CopyZipFile( const char* pFrom, const char* pTo )
{
	if ( !DosCopy( (PSZ)pFrom, (PSZ)pTo, DCPY_EXISTING ) )
		return TRUE;
	else
		return FALSE;
}

/*************************************************************************
|*
|*	  ExecSetup()
|*
|*	  Beschreibung		Startet das Setup Programm und wartet
|*	  Ersterstellung	CL 23.11.93
|*	  Letzte Aenderung	PB 12.07.94
|*
*************************************************************************/
void ExecSetup( const char* pSetupPath )
{
	HQUEUE hQueue = 0;
	DosCreateQueue( &hQueue, 0, (PSZ)"\\QUEUES\\SVSETUP.QUE" );

	STARTDATA aStartData;
	memset( &aStartData, 0, sizeof( STARTDATA ) );
	aStartData.Length	   = sizeof( STARTDATA );
	aStartData.Related	   = SSF_RELATED_CHILD;
	aStartData.FgBg 	   = SSF_FGBG_BACK;
	aStartData.TraceOpt    = SSF_TRACEOPT_NONE;
	aStartData.PgmName	   = (PSZ)(const char*)pSetupPath;
	aStartData.PgmInputs   = pCommandLine;
	aStartData.TermQ	   = "\\QUEUES\\SVSETUP.QUE";
	aStartData.InheritOpt  = SSF_INHERTOPT_PARENT;
	aStartData.SessionType = SSF_TYPE_PM;
	aStartData.PgmControl  = SSF_CONTROL_VISIBLE;

	ULONG nSessionID;
	PID   nPID;
	APIRET nRet = DosStartSession( &aStartData, &nSessionID, &nPID );

	if ( nRet != NO_ERROR )
	{
/*		char cErrNo[10];
		WinLoadByteString( hab, 0, IDS_SESSIONERR, ERROR_LEN, cError );
		strcat( cError, ltoa( (long)nRet, cErrNo, 10 ) );   // unsupported os #100211# - checked
		ErrorBox( cError );
		DosCloseQueue( hQueue );
*/		return;
	}

	// App-Fenster beim Starten des SV-Setups hidden
	WinShowWindow( hWndFrame, FALSE );

	// Warten bis das Setup Programm beendet ist
	PTIB pTib;
	PPIB pPib;
	DosGetInfoBlocks( &pTib, &pPib );

	REQUESTDATA aRequest;
	ULONG nDataLen;
	VOID* pElement;
	BYTE  nPriority;

	if ( pPib )
		aRequest.pid = pPib->pib_ulpid;

	DosReadQueue( hQueue, &aRequest, &nDataLen,
				  &pElement, 0, 0, &nPriority, 0 );
}

/*************************************************************************
|*
|*	  KillSetupPath()
|*
|*	  Beschreibung
|*	  Ersterstellung	CL 24.11.93
|*	  Letzte Aenderung	CL 24.11.93
|*
*************************************************************************/
void KillSetupPath( const char* pPath )
{
	char* pPattern = new char[256];
	strcpy( pPattern, pPath );          // unsupported os #100211# - checked
	strcat( pPattern, "\\*.*" );        // unsupported os #100211# - checked

	HDIR		 hDir = HDIR_SYSTEM;
	FILEFINDBUF3 aBuffer;
	ULONG		 nCount = 1;
	int 		 bFiles = 1;

	if ( DosFindFirst( (PSZ)pPattern, &hDir, 0, (PVOID)&aBuffer,
					   sizeof( aBuffer ), &nCount, FIL_STANDARD ) )
			bFiles = 0;

	if ( bFiles )
	{
		remove( aBuffer.achName );

		while ( !DosFindNext( hDir, (PVOID)&aBuffer,
							  sizeof( aBuffer ), &nCount ) )
			 remove( aBuffer.achName );
	}

	// Nach dem Inhalt ist die directory selbst faellig
	// voerher fluechten wir aber in die root, sonst ist nix mit loeschen
	char aRootPath[4];
	strncpy( aRootPath, pPath, 3 );
	aRootPath[3] = 0;
	chdir( aRootPath );
	rmdir( (char*)pPath );
	delete pPattern;
}

/*************************************************************************
|*
|*	  InstallThread
|*
|*	  Beschreibung
|*	  Ersterstellung	CL 03.12.93
|*	  Letzte Aenderung	PB 08.01.96
|*
*************************************************************************/

void __EnumFilesCallBack(char *pFile, ULONG nSize, void *pObject)
{ nMinTempSize += nSize; }

#ifdef ICC
void _System InstallThread( void* )
#else
void InstallThread( void* )
#endif
{
	// Wir muessen uns leider zum MessageQueueThread machen, sonst
	// is nix mit MessageBoxen
	HMQ  hmq = WinCreateMsgQueue( hab, 0 );

	// Pfad auf dieses Programm holen
	char* pModuleName = new char[256];
	char* pMyPath = new char[256];
	char* pMyName = new char[256];

	strcpy( pModuleName, pArg0 );       // unsupported os #100211# - checked
	strcpy( pMyName, pArg0 );           // unsupported os #100211# - checked

	nSetupSize = atol(&(strExePatch[8]));
	ArchDirectory* pBigDir = NULL;
	if( nSetupSize != 0 )
	{
		pBigDir = new ArchDirectory;
		if( !pBigDir->SetArchFile(pMyName) )
		{
			WinLoadByteString( hab, 0, IDS_NOCOPYFILE, ERROR_LEN, cError );
			ErrorBox( cError );
			WinPostMsg( hWndFrame, WM_QUIT, (MPARAM)0,(MPARAM)0 );
			WinDestroyMsgQueue( hmq );
			return;
		}
	}

	if ( ( strlen(pMyName) < 4 ) ||
		 ( pMyName[ strlen(pMyName) - 4 ] != '.' ) )
		strcat( pMyName, ".exe" );          // unsupported os #100211# - checked

	pMyPath[0] = 0;
	WhereAmI( pMyName, pMyPath, 256 );

	// temporaeres Verzeichnis zum Zwischenlagern der DLLs und
	// des Setup Programms suchen, vorher altes Verzeichnis sichern
	char cpOldDir[256];
	int nOldDrive = _getdrive();
	getcwd( cpOldDir, 256 );

	char* pTempPath = new char[256];
	pTempPath[0] = 0;
	GetTempFile( pTempPath );

	if ( pTempPath[0] == 0 )
	{
		WinLoadByteString( hab, 0, IDS_NOTEMPSPACE, ERROR_LEN, cError );
		ErrorBox( cError );
		WinPostMsg( hWndFrame, WM_QUIT, (MPARAM)0,(MPARAM)0 );
		WinDestroyMsgQueue( hmq );
		if( pBigDir )
			delete pBigDir;
		return;
	}

	if ( mkdir(pTempPath) == -1 )
	{
		if( pBigDir )
			delete pBigDir;
		return;
	}

	// Ins Zielverzeichnis wechseln
	if ( _chdrive( toupper( pTempPath[0] ) - 'A' + 1 ) == -1 ||
		 chdir( pTempPath ) == -1 )
	{
		if( pBigDir )
			delete pBigDir;
		return;
	}

	// Kopieren der Zip-Datei und Auspacken
	char* pOrgZipPath = new char[256];
	char* pZipPath	  = new char[256];
	strcpy( pOrgZipPath, pMyPath );         // unsupported os #100211# - checked
	strcat( pOrgZipPath, "\\f_0000" );      // unsupported os #100211# - checked
	strcpy( pZipPath, pTempPath );          // unsupported os #100211# - checked
	strcat( pZipPath, "\\f_0000" );         // unsupported os #100211# - checked

	if( pBigDir )
		if( !pBigDir->GetFile( "f_0000", pTempPath ) )
		{
			WinLoadByteString( hab, 0, IDS_NOCOPYFILE, ERROR_LEN, cError );
			ErrorBox( cError );
			KillSetupPath( pTempPath );
			WinPostMsg( hWndFrame, WM_QUIT, (MPARAM)0,(MPARAM)0 );
			WinDestroyMsgQueue( hmq );
			delete pBigDir;
			return;
		}

	::SVUnzipEnumFiles( pBigDir? pZipPath : pOrgZipPath, "*",
					 (UnzipEnumFilesCallBack*)__EnumFilesCallBack, NULL );
	nMinTempSize += 512000; // ein Halbes geht noch.

	// Haben wir 2,2MB auf dem aktuellen Laufwerk ?
	if( !HasFreeSpace(nMinTempSize) )
	{
		WinLoadByteString( hab, 0, IDS_NOTEMPSPACE, ERROR_LEN, cError );
		ErrorBox( cError );
		KillSetupPath( pTempPath );
		WinPostMsg( hWndFrame, WM_QUIT, (MPARAM)0,(MPARAM)0 );
		WinDestroyMsgQueue( hmq );
		if( pBigDir )
			delete pBigDir;
		return;
	}

	int nErr = SVUnzip( pBigDir? pZipPath : pOrgZipPath, "*.*", (const char*)"qq", 0 );

	// Fehler beim Auspacken?
	if( nErr )
	{
		char cErrNo[10];
		WinLoadByteString( hab, 0, IDS_NOUNZIP, ERROR_LEN, cError );
		strcat( cError, ltoa( (long)nErr, cErrNo, 10 ) );           // unsupported os #100211# - checked
		ErrorBox( cError );
		KillSetupPath( pTempPath );
		WinPostMsg( hWndFrame, WM_QUIT, (MPARAM)0,(MPARAM)0 );
		WinDestroyMsgQueue( hmq );
		if( pBigDir )
			delete pBigDir;
		return;
	}

	// Konfigurationsdatei fuer Setup Programm erstellen
	// Enthaelt den Pfad auf die Installationsdateien
	char* pIniPath = new char[256];
	strcpy( pIniPath, pTempPath );                  // unsupported os #100211# - checked
	strcat( pIniPath, "\\setup.ini" );              // unsupported os #100211# - checked
	FILE* pFile = fopen( pIniPath, "w+" );

	if ( pFile )
	{
		fprintf( pFile, "[source]\n" );

		if( pBigDir )
		{
			fprintf( pFile, "path=%s\n", pModuleName );
			fprintf( pFile, "big=1\n" );
			fprintf( pFile, "offset=%ld\n", nSetupSize );

		}
		else
			fprintf( pFile, "path=%s\n", pMyPath );

		fprintf( pFile, "[extra]\n" );

		if ( ( pArg1 && ( stricmp( pArg1, "/NET" ) == 0  )  ) ||
			 ( pArg2 && ( stricmp( pArg2, "/NET" ) == 0 ) ) )
		{
			fprintf( pFile, "network=1\n" );
		}

		if ( ( pArg1 && ( stricmp( pArg1, "/REMOVE" ) == 0  )  ) ||
			 ( pArg2 && ( stricmp( pArg2, "/REMOVE" ) == 0 ) ) )
			fprintf( pFile, "removeable=1\n" );
		fclose( pFile );
	}

	// Das eigentliche Setup Programm starten
	char* pSetupPath = new char[256];
	strcpy( pSetupPath, pTempPath );            // unsupported os #100211# - checked
	strcat( pSetupPath, "\\SETUP.EXE" );        // unsupported os #100211# - checked

	// Fehler beim Auspacken?
	if ( !FileExists( pSetupPath ) )
	{
/*		WinLoadByteString( hab, 0, IDS_NOSETUPEXE, ERROR_LEN, cError );
		strcat( cError, pSetupPath );           // unsupported os #100211# - checked
		ErrorBox( cError );
		KillSetupPath( pTempPath );
		WinPostMsg( hWndFrame, WM_QUIT, (MPARAM)0,(MPARAM)0 );
		WinDestroyMsgQueue( hmq );
*/		if( pBigDir )
				delete pBigDir;
		return;
	}
	ExecSetup( pSetupPath );

	FILE* pShutDownFile = fopen( "shutdown.me", "r" );
	if( pShutDownFile )
	{
		bShutDownSystem = TRUE;
		fclose( pShutDownFile );
	}

	// das eigentliche Setup loescht die setup.ini, wenn die Installation
	// erfolgreich abgeschlossen werden konnte
	// pFile = fopen( pIniPath, "r" );
	delete pIniPath;


	// Alle Dateien aus dem temporaeren Verzeichnis loeschen und
	// Verzeichnis zerlegen
	if( (nArgs <= 1) || strcmp( pArg0, "-nodelete" ) )
		KillSetupPath( pTempPath );

	// Vorheriges Arbeitsverzeichnis wiederherstellen
	chdir( cpOldDir );
	_chdrive( nOldDrive );

	// Aufraeumen und tschuess
	delete pSetupPath;
	delete pZipPath;
	delete pOrgZipPath;
	delete pModuleName;
	delete pMyPath;
	delete pMyName;
	delete pTempPath;
	if( pBigDir )
		delete pBigDir;

	WinPostMsg( hWndFrame, WM_QUIT, (MPARAM)0,(MPARAM)0 );
	WinDestroyMsgQueue( hmq );

	return;
}

void ShutDown(HMQ  hmq)
{
//	WinLoadByteString(hab, 0, IDS_SHUTDOWN, ERROR_LEN, cError);
//	InfoBox( cError );

	if (IsProgramAutostart())
	{
		char cTmp[20] = "";
		GetBootDrive(cTmp);
		strcat(cTmp, "_sdset2.tmp" );       // unsupported os #100211# - checked
		FILE* pFile= fopen(cTmp, "a");

		if (pFile)
		{
			fprintf( pFile, "123" );
			fclose( pFile );
		}
	}
	WinShutdownSystem( hab, hmq );
	WinPostMsg( hWndFrame, WM_QUIT, (MPARAM)0,(MPARAM)0 );
	WinDestroyMsgQueue( hmq );
}

/*************************************************************************
|*
|*	  LoaderProc
|*
|*	  Beschreibung
|*	  Ersterstellung	CL 03.12.93
|*	  Letzte Aenderung	PB 08.01.96
|*
*************************************************************************/

MRESULT EXPENTRY LoaderProc( HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2 )
{
  switch( msg )
  {
	case WM_PAINT:
	{
		char cTmp[20] = "";
		GetBootDrive( cTmp );
		strcat( cTmp, "_sdset2.tmp" );      // unsupported os #100211# - checked
		FILE* pFile = fopen( cTmp, "r" );

		if ( pFile )
		{
			fclose( pFile );
			// Datei, die durch ein Shutdown erzeugt wurde, gefunden
			// also l"oschen und beenden
			remove( cTmp );
			WinPostMsg( hWndFrame, WM_QUIT, (MPARAM)0,(MPARAM)0 );
			break;
		}

		char* 	pData;
		APIRET 	rc = DosGetResource( 0L, RT_BITMAP, ID_LOGO, (void**)&pData );

		if( rc == NO_ERROR )
		{
			RECTL	aRect;
			HPS		hPS = WinBeginPaint( hwnd, 0L, &aRect );

			if( hPS )
			{
				BYTE*				pDIB = (BYTE*) pData + 14;
				ULONG 				nWidth = 300, nHeight = 80;
				POINTL				pts[ 4 ];
				BITMAPINFO2*		pBI = (BITMAPINFO2*) pDIB;
				BITMAPINFOHEADER2*	pBIH = (BITMAPINFOHEADER2*) pBI;
				const long			nColors	= 0;
				long				nInfoSize = *(ULONG*) pBI + nColors * sizeof( RGB2 );
				BYTE*				pBits = (BYTE*) pBI + nInfoSize;

				// Src-Rect
				pts[0].x = 0;
				pts[0].y = 0;
				pts[1].x = nWidth - 1;
				pts[1].y = nHeight - 1;

				// Dst-Rect
				pts[2].x = 0;
				pts[2].y = 0;
				pts[3].x = pBIH->cx;
				pts[3].y = pBIH->cy;

				GpiDrawBits( hPS, pDIB + nInfoSize, pBI, 4L, pts, ROP_SRCCOPY, BBO_IGNORE );
				WinEndPaint( hPS );
			}

			DosFreeResource( (void*) pData );
		}
		break;
	}

	case WM_CLOSE:
	  WinPostMsg( hwnd, WM_QUIT, (MPARAM)0,(MPARAM)0 );
	  break;

	default:

	  return WinDefWindowProc( hwnd, msg, mp1, mp2 );
  }
  return (MRESULT)FALSE;
}

/*************************************************************************
|*
|*	  main()
|*
|*	  Beschreibung
|*	  Ersterstellung	CL 10.11.93
|*	  Letzte Aenderung	PB 12.07.94
|*
*************************************************************************/

int main( int argc, char* argv[] )
{
	HMQ  hmq;
	QMSG qmsg;

	nArgs = argc;
	pArg0 = argv[0];
	pArg1 = argv[1];
	if(nArgs == 3)
		pArg2 = argv[2];
	else
		pArg2 = NULL;

	memset( pCommandLine, 0, MAX_COMMANDLINE_LEN );
	for( unsigned short i = 1; i < argc; ++i )
	{
		strcat( pCommandLine, argv[i] );        // unsupported os #100211# - checked
		if( i < argc-1 )
			strcat( pCommandLine, " " );        // unsupported os #100211# - checked
	}

	// PM initialisieren
	hab = WinInitialize( 0 );

	if ( !hab )
		return 0;

	// Fehler-ByteString laden
	// WinLoadByteString( hab, 0, IDS_INITERR, ERROR_LEN, cError );

	// gubed

	// Messagequeue erzeugen
	hmq = WinCreateMsgQueue( hab, 0 );

	if ( !hmq )
	{
		ErrorBox( "Error while initialize." );
		return 0;
	}

	// debug
	char szBuffer[10];

	if (GetBootDrive(szBuffer) == 0)
		ErrorBox("could not determine boot drive");

	if (!IsDotInLibpath())
	{
		WinLoadByteString(hab, 0, IDS_NODOT1, ERROR_LEN/2, cError);
		WinLoadByteString(hab, 0, IDS_NODOT2, ERROR_LEN/2, cError+strlen(cError));

		if (QueryYesNoBox(cError))
		{
			AddDotToLibpath();
			ShutDown(hmq);
		}
		else
		{
			WinPostMsg( hWndFrame, WM_QUIT, (MPARAM)0,(MPARAM)0 );
		}
		WinDestroyMsgQueue(hmq);

		return 0;
	}

	// Windowclass registrieren
	//
	if ( !WinRegisterClass( hab, (PSZ)"LoaderWnd",
							(PFNWP)LoaderProc, CS_SIZEREDRAW, 0 ) )
	{
		ErrorBox( cError );
		WinDestroyMsgQueue( hmq );
		WinTerminate( hab );
		return 0;
	}

	// Main Window erzeugen
	HWND  hWndClient;
//!	ULONG nFlags = FCF_TITLEBAR | FCF_SYSMENU | FCF_DLGBORDER | FCF_ICON;
	ULONG nFlags = FCF_DLGBORDER;
	hWndFrame = WinCreateStdWindow( HWND_DESKTOP, 0, &nFlags,
									(PSZ)"LoaderWnd",
									(PSZ)"Setup",
									0, (HMODULE)0L,
									ID_WINDOW,&hWndClient );
	if ( !hWndFrame )
	{
		ErrorBox( cError );
		WinDestroyMsgQueue( hmq );
		WinTerminate( hab );
		return 0;
	}

	// Main Window Groesse setzen und anzeigen
	long nX, nY;
	nX = WinQuerySysValue( HWND_DESKTOP, SV_CXSCREEN ) / 2;
	nY = WinQuerySysValue( HWND_DESKTOP, SV_CYSCREEN ) / 2;
	WinSetWindowPos( hWndFrame, HWND_TOP, nX - 150, nY - 40, 300, 80,
					 SWP_MOVE | SWP_SIZE | SWP_ACTIVATE | SWP_SHOW );

	// DosError disablen ("A: nicht bereit")
	DosError( FERR_DISABLEHARDERR );

	// Install Thread aufsetzen und dumm rumstehen
	TID nThread;
	DosCreateThread( &nThread, (PFNTHREAD)InstallThread, 0L, 0L, 16000 );

	// Messages dispatchen
	while ( WinGetMsg( hab, &qmsg, 0L, 0, 0 ) )
		WinDispatchMsg( hab, &qmsg );

	if( bShutDownSystem )
	{
		WinShutdownSystem( hab, hmq );
		WinPostMsg( hWndFrame, WM_QUIT, (MPARAM)0,(MPARAM)0 );
		WinDestroyMsgQueue( hmq );
		return 0;
	}

	WinDestroyWindow(hWndFrame);
	WinDestroyMsgQueue( hmq );
	WinTerminate( hab );
	return 0;
}


