/*************************************************************************
 *
 *  $RCSfile: svdr_min.cxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 17:01:29 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#include <sv.hxx>
#include <editdll.hxx>
#include <svdraw.hxx>
#pragma hdrstop

#ifdef JOEDEBUG // Weil ich SvDraw.Lib zur APP linke:
String aSdrEmptyStr;
class String& rImplEmptyStr=aSdrEmptyStr;
#endif

///////////////////////////////////////////////////////////////////////////////

class MyApp: public Application {
public:
	void Main(int, char*[]);
};

///////////////////////////////////////////////////////////////////////////////

class MyWin: public WorkWindow {
	SdrModel*  pSdrModel;
	SdrView*   pSdrView;
public:
	MyWin();
	virtual ~MyWin();
	virtual void Paint(const Rectangle& rRect);
	virtual void KeyInput(const KeyEvent& rKEvt);
	virtual void MouseButtonDown(const MouseEvent& rMEvt);
	virtual void MouseButtonUp(const MouseEvent& rMEvt);
	virtual void MouseMove(const MouseEvent& rMEvt);
	virtual void Command(const CommandEvent& rCEvt);
	virtual BOOL QueryDrop(DropEvent& rDEvt);
	virtual BOOL Drop(const DropEvent& rDEvt);
};

// MyApp //////////////////////////////////////////////////////////////////////

void __EXPORT MyApp::Main(int nParamCount, char* cParamStr[])
{
	EditDLL aEditDLL;
	EnableSVLook();
	SetAppFont(System::GetStandardFont(STDFONT_APP));
	SdrEngineDefaults::SetFontHeight(2258); // 64Pt
	SdrEngineDefaults::SetFontColor(Color(COL_CYAN));
	MyWin aMainWin;
	aMainWin.Show();
	Execute();
	aMainWin.Hide();
}

// MyWin //////////////////////////////////////////////////////////////////////

MyWin::MyWin():
	WorkWindow(NULL,WinBits(WB_APP | WB_STDWORK | WB_CLIPCHILDREN))
{
	SetText("SV-DrawingEngine minimal (Joe M.)");
	SetBackgroundBrush(Brush(Color(COL_LIGHTGRAY)));
	SetPalette(OutputDevice::GetDitherPalette());
	EnableDrop();

	pSdrModel=new SdrModel;
	SetMapMode(MapMode(pSdrModel->GetScaleUnit(),Point(0,0),Fraction(1,4),Fraction(1,4)));

	SdrPage* pSdrPage=new SdrPage(*pSdrModel);
	pSdrPage->SetSize(Size(21000,30000));
	pSdrPage->SetBorder(2000,2000,2000,2000);
	pSdrModel->InsertPage(pSdrPage);

	pSdrView=new SdrView(pSdrModel,this);
	pSdrView->ShowPage(pSdrPage,Point());
	pSdrView->SetCurrentObj(OBJ_RECT);
	pSdrView->SetCreateMode();

	pSdrView->SetTextEditAfterCreate(TRUE); // noch an der View auf TRUE defaulten
	pSdrView->SetMarkHdlWhenTextEdit(TRUE); // noch an der View auf TRUE defaulten
}

MyWin::~MyWin()
{
	delete pSdrView;
	delete pSdrModel;
}

void __EXPORT MyWin::KeyInput(const KeyEvent& rKEvt)
{
	WorkWindow::KeyInput(rKEvt);
	if (!pSdrView->KeyInput(rKEvt,this)) {
		switch (rKEvt.GetKeyCode().GetFullCode()) {
			case KEY_E: pSdrView->SetEditMode(); pSdrView->SetDragMode(SDRDRAG_MOVE); break;
			case KEY_G: pSdrView->SetGluePointEditMode(); pSdrView->SetDragMode(SDRDRAG_MOVE); break;
			case KEY_F: pSdrView->SetFrameHandles(!pSdrView->IsFrameHandles()); break;
			case KEY_R: pSdrView->SetCurrentObj(OBJ_RECT);     pSdrView->SetCreateMode(); pSdrView->UnmarkAllObj(); pSdrView->SetDragMode(SDRDRAG_MOVE); break;
			case KEY_T: pSdrView->SetCurrentObj(OBJ_TEXT);     pSdrView->SetCreateMode(); pSdrView->UnmarkAllObj(); pSdrView->SetDragMode(SDRDRAG_MOVE); break;
			case KEY_K: pSdrView->SetCurrentObj(OBJ_CIRC);     pSdrView->SetCreateMode(); pSdrView->UnmarkAllObj(); pSdrView->SetDragMode(SDRDRAG_MOVE); break;
			case KEY_P: pSdrView->SetCurrentObj(OBJ_POLY);     pSdrView->SetCreateMode(); pSdrView->UnmarkAllObj(); pSdrView->SetDragMode(SDRDRAG_MOVE); break;
			case KEY_H: pSdrView->SetCurrentObj(OBJ_FREELINE); pSdrView->SetCreateMode(); pSdrView->UnmarkAllObj(); pSdrView->SetDragMode(SDRDRAG_MOVE); break;
			case KEY_V: pSdrView->SetCurrentObj(OBJ_EDGE);     pSdrView->SetCreateMode(); pSdrView->UnmarkAllObj(); pSdrView->SetDragMode(SDRDRAG_MOVE); break;
			case KEY_B: pSdrView->SetCurrentObj(OBJ_MEASURE);  pSdrView->SetCreateMode(); pSdrView->UnmarkAllObj(); pSdrView->SetDragMode(SDRDRAG_MOVE); break;
			case KEY_I: if (pSdrView->IsGluePointEditMode()) {
							pSdrView->SetInsGluePointMode(!pSdrView->IsInsGluePointMode());
						} else {
							pSdrView->SetInsObjPointMode(!pSdrView->IsInsObjPointMode());
						}
						break;
			case KEY_D: pSdrView->SetDragMode(SDRDRAG_ROTATE);  break;
			case KEY_S: pSdrView->SetDragMode(SDRDRAG_MIRROR);  break;
			case KEY_Z: pSdrView->SetDragMode(SDRDRAG_SHEAR);   break;
			case KEY_A: pSdrView->SetDragMode(SDRDRAG_CROOK);   break;
		} // switch
		if (pSdrView->IsInsGluePointMode() && !pSdrView->IsGluePointEditMode()) pSdrView->SetInsGluePointMode(FALSE);
		if (pSdrView->IsInsObjPointMode() && !pSdrView->IsInsObjPointPossible()) pSdrView->SetInsObjPointMode(FALSE);
		// InsPoint,InsPoints
	}
}

void __EXPORT MyWin::MouseButtonDown(const MouseEvent& rMEvt)
{
	pSdrView->MouseButtonDown(rMEvt,this);
}

void __EXPORT MyWin::MouseButtonUp(const MouseEvent& rMEvt)
{
	pSdrView->MouseButtonUp(rMEvt,this);
}

void __EXPORT MyWin::MouseMove(const MouseEvent& rMEvt)
{
	pSdrView->MouseMove(rMEvt,this);
}

void __EXPORT MyWin::Command(const CommandEvent& rCEvt)
{
//    pSdrView->Command(rCEvt,this);
}

BOOL __EXPORT MyWin::QueryDrop(DropEvent& rDEvt)
{
	return pSdrView->QueryDrop(rDEvt,this);
}

BOOL __EXPORT MyWin::Drop(const DropEvent& rDEvt)
{
	return pSdrView->Drop(rDEvt,this);
}

void __EXPORT MyWin::Paint(const Rectangle& rRect)
{
	pSdrView->InitRedraw(this,rRect);
	Point aPos(0,GetOutputSize().Height()-GetTextSize("X").Height());
	DrawText(aPos,"E)dit  G)lue  F)rameHandles    D)rehen  S)piegeln  A)uf Kreis  VerZ)erren    R)ect  T)ext  K)reis  P)oly  FreiH)and  V)erbinder  B)emassung    I)nsPt");
}

///////////////////////////////////////////////////////////////////////////////
MyApp aMyApp;
