/*************************************************************************
 *
 *  $RCSfile: wizgo.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: jp $ $Date: 2001/02/14 16:13:29 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _WIZGO_HXX
#define _WIZGO_HXX


#ifndef _PRINT_HXX //autogen
#include <vcl/print.hxx>
#endif
#include "wizenum.hxx"

class SwWrtShell;
class SwNewDBMgr;
class WizardDokuDlg;
class WizardPage;
class WizardKopz;
class WizardFusz;
class WizardFrame;
class WizardLogo;
class SwTabCols;

#define NODATE 0xFFFF
#define NOTIME 0xFFFF

class WizardGo
{
public:
	SwWrtShell* pShell;
	SwNewDBMgr* pDBas;

	WizardGo();
	~WizardGo();

	long Twip( long mmEinheit ) { return mmEinheit*14400/254/EINHEIT; }

	BOOL NewVorlage( const String& rVorlage );
	BOOL SaveVorNewDoc( const WizardDokuDlg& rDoku );
	void FillDocInfo( const WizardDokuDlg& rDoku );
	void AssignDBas( const String& rDBName, const String& rDBTable );

	void InsertBookmark( const sal_Char* pName );
	BOOL GotoBookmark( const sal_Char* pName, const sal_Char cAdd = 0 );

	BOOL AssignMacro( String& rMacStr, String& rMacNam,
						const String& rLibNam, const String& rModulNam,
						USHORT nEvent, String *pCode = NULL );
	BOOL SetCreateMacro( WizardDokuDlg& rDoku,
						ULONG nDateFmt = NODATE,
						ULONG nTimeFmt = NOTIME,
						USHORT nDateAnz = 1,
						BOOL bDelUmbr = FALSE );

	BOOL SetSaveMacro( WizardDokuDlg& rDoku,
						BOOL bMarker1GoDown = FALSE,
						BOOL bMarker2GoDown = FALSE );

	String GetDocInfoMacroStr( const String& aStr, BOOL bFeld, BOOL bGoDown );

	void SetMarg( const WizardPage& rPage,
					WizardKopz* pKopz = 0,
					WizardFusz* pFusz = 0 );
	void SetTray( USHORT nTray );
	void SetPrinter( Printer *pPrt );
	void SetFusz( WizardFusz& rFusz,
					const sal_Char* pFusMark,
					const sal_Char* pNumMark );

	void DelFrame();
	void MovFrame( WizardFrame& rFrm,
					BOOL bPreventHgt = FALSE,
					BOOL bPutBack = FALSE );
	void MovFrame( long X, long Y, long W, long H,
					BOOL bPreventHgt = FALSE, BOOL bPutBack = FALSE );
	void SizFrame( long W, long H,
					BOOL bPreventHgt = FALSE, BOOL bPutBack = FALSE );
	void JstFrame( PageAlign eJst, BOOL bPutBack = FALSE );
	void PrnFrame( BOOL bPrn = TRUE );

	void InsString( const String& rStr );
	void InsDBasFldStr( const String& rStr );
	void InsDBasFld( const String& rStr );

	void InsLogoObj( WizardLogo& rLogo,
					BOOL bKopz = FALSE,
					BOOL bPrintGraf = TRUE );

	void MarkText();
	void DelText();

	void SetTabColWidth( SwTabCols& rCols, USHORT nNum, long nNewWidth );

/*  void InsAbsn()
	void InsLogo()
	void InsEmpf()
	void InsFusz(WizardFusz& rFusz, const String& rFusMark, const String& rNumMark)
	void InsKopF()*/
};

#endif  //_WIZGO_HXX


