/*************************************************************************
 *
 *	$RCSfile: rmevents.cxx,v $
 *
 *	$Revision: 1.3 $
 *
 *	last change: $Author: obr $ $Date: 2001/07/13 07:05:36 $
 *
 *	The Contents of this file are made available subject to the terms of
 *	either of the following licenses
 *
 *		   - GNU Lesser General Public License Version 2.1
 *		   - Sun Industry Standards Source License Version 1.1
 *
 *	Sun Microsystems Inc., October, 2000
 *
 *	GNU Lesser General Public License Version 2.1
 *	=============================================
 *	Copyright 2000 by Sun Microsystems, Inc.
 *	901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *	This library is free software; you can redistribute it and/or
 *	modify it under the terms of the GNU Lesser General Public
 *	License version 2.1, as published by the Free Software Foundation.
 *
 *	This library is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *	Lesser General Public License for more details.
 *
 *	You should have received a copy of the GNU Lesser General Public
 *	License along with this library; if not, write to the Free Software
 *	Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *	MA	02111-1307	USA
 *
 *
 *	Sun Industry Standards Source License Version 1.1
 *	=================================================
 *	The contents of this file are subject to the Sun Industry Standards
 *	Source License Version 1.1 (the "License"); You may not use this file
 *	except in compliance with the License. You may obtain a copy of the
 *	License at http://www.openoffice.org/license.html.
 *
 *	Software provided under this License is provided on an "AS IS" basis,
 *	WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *	WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *	MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *	See the License for the specific provisions governing your rights and
 *	obligations concerning the Software.
 *
 *	The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *	Copyright: 2000 by Sun Microsystems, Inc.
 *
 *	All Rights Reserved.
 *
 *	Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#define _SV_RMEVENTS_CXX

#ifdef REMOTE_APPSERVER

#include <rmevents.hxx>
#include <vos/diagnose.hxx>
#include <vos/thread.hxx>
#include <vos/semaphor.hxx>
#include <window.hxx>
#include <svdata.hxx>
#include <windata.hxx>
#include <tools/debug.hxx>
#include <rmwindow.hxx>

#include <rmdrgsrc.hxx>

#pragma hdrstop

RmEventSubQueue::RmEventSubQueue()
{
	mpHead = NULL;
	mpTail = NULL;
}

RmEventSubQueue::~RmEventSubQueue()
{
	while( mpHead )
	{
		RmEvent* pKill = mpHead;
		mpHead = mpHead->mpNext;
		delete pKill;
	}
}

void RmEventSubQueue::Push( RmEvent* pElement )
{
	if( mpTail )
		mpTail->mpNext = pElement;
	else
		mpHead = pElement;

	pElement->mpNext= NULL;
	mpTail = pElement;
}

RmEvent* RmEventSubQueue::RemoveHead()
{
	RmEvent* pElement = mpHead;
	if( mpHead )
	{
		mpHead= mpHead->mpNext;

		if( !mpHead )
			mpTail = 0;
	}
	return pElement;
}

RmEvent* RmEventSubQueue::GetFirst()
{
	mpCursor = mpHead;
	return mpCursor;
}

RmEvent* RmEventSubQueue::GetNext()
{
	if( mpCursor )
		mpCursor = mpCursor->mpNext;
	return mpCursor;
}

void RmEventSubQueue::RemoveCurrent()
{
	if( mpCursor )
	{
		if( mpCursor == mpHead )
		{
			mpHead = mpCursor->mpNext;

			if( !mpHead )
				mpTail = NULL;

			mpCursor = NULL;
		}
		else
		{
			RmEvent* pPrev= mpHead;

			while( pPrev && ( pPrev->mpNext != mpCursor ) )
				pPrev = pPrev->mpNext;

			if( mpCursor == mpTail )
				mpTail= pPrev;

			pPrev->mpNext = mpCursor->mpNext;
			mpCursor = NULL;
		}
	}
}

RmEventQueue::RmEventQueue() :
	mnMouseEvtCount ( 0UL ),
	mnKeyEvtCount	( 0UL ),
	mnPaintEvtCount ( 0UL ),
	mnTimerEvtCount ( 0UL ),
	mnOtherEvtCount ( 0UL ),
	m_pLastKeyInputEvent( NULL ),
	m_nLastRepeatedInputTime( 0L )
{
}

RmEventQueue::~RmEventQueue()
{
	vos::OGuard LockQueue(&m_Lock);
}

void RmEventQueue::RemoveWindowEvents( Window* pWindow )
{
  vos::OGuard LockQueue(&m_Lock);
  ExtRmEvent* pRemoveEvent;
  do
	{
	  pRemoveEvent = (ExtRmEvent*)maSubQueue.GetFirst();
	  while ( pRemoveEvent && ( pRemoveEvent->GetWindow() != pWindow ) )
		pRemoveEvent = (ExtRmEvent*)maSubQueue.GetNext();
	  if( pRemoveEvent )
	RemoveEvent( pRemoveEvent );
	} while( pRemoveEvent );
}

void RmEventQueue::ImplRemoveFromWindow( ExtRmEvent* pEvent )
{
	// Abfrage ob GetWindow() != NULL muss vorher geschehen sein,
	// hier wird sofort der Guard aktiv.
	if( pEvent->IsValid() )
	{
		ImplSVData* pSVData = ImplGetSVData();
		vos::OGuard aGuard( pSVData->mpWindowObjectMutex );
		ExtRmEvent* pPrev = NULL;
		ExtRmEvent* pTempEvt = pEvent->GetWindow()->GetRmEvents();

		while ( pTempEvt && ( pTempEvt != pEvent ) )
		{
			pPrev		= pTempEvt;
			pTempEvt	= pTempEvt->GetNextWindowEvent();
		}
		if ( pTempEvt )
		{
			if ( pPrev )
				pPrev->SetNextWindowEvent( pTempEvt->GetNextWindowEvent() );
			else
				pEvent->GetWindow()->SetRmEvents( pTempEvt->GetNextWindowEvent() );
		}
	}
}

void RmEventQueue::SetMaxGeneratedRepeats()
{
	m_nMaxGeneratedEvents = 2;

	RmKeyEventData* pData = (RmKeyEventData*)m_pLastKeyInputEvent->GetData();
	KeyCode aCode( pData->nKeyCode );
	if( ( aCode.GetModifier() == 0	 ||
		  aCode.GetModifier() == KEY_SHIFT )
		&&
		( aCode.GetCode() == KEY_LEFT	||
		  aCode.GetCode() == KEY_RIGHT )
		)
		m_nMaxGeneratedEvents = 4;

	if( m_nLastRepeatedInputTime )
	{
		USHORT nMax = ( Time::GetSystemTicks() - m_nLastRepeatedInputTime ) / 40;
		m_nMaxGeneratedEvents = nMax < m_nMaxGeneratedEvents ? nMax : m_nMaxGeneratedEvents;
	}
	m_nMaxGeneratedEvents = m_nMaxGeneratedEvents > pData->nCount+1 ? pData->nCount+1 : m_nMaxGeneratedEvents;
}

void RmEventQueue::AddEvent( ExtRmEvent* pEvent )
{
	vos::OGuard LockQueue(&m_Lock);

	switch( pEvent->GetId() )
	{
		case( RMEVENT_MOUSEBUTTONDOWN ):
		case( RMEVENT_MOUSEBUTTONUP ):
		case( RMEVENT_MOUSEMOVE ): mnMouseEvtCount++; break;
		case( RMEVENT_KEYINPUT ):
		{
			mnKeyEvtCount++;
			RmKeyEventData* pKeyData = (RmKeyEventData*)pEvent->GetData();
			m_nGeneratedEvents = 0;
			if( m_pLastKeyInputEvent )
			{
				RmKeyEventData* pLastData = (RmKeyEventData*)m_pLastKeyInputEvent->GetData();
				if( pKeyData->nChar == pLastData->nChar &&
					pKeyData->nKeyCode == pLastData->nKeyCode &&
					m_pLastKeyInputEvent->GetWindow() == pEvent->GetWindow()
					)
				{
					if( pKeyData->nCount > m_nMaxGeneratedEvents )
						pKeyData->nCount = m_nMaxGeneratedEvents;
					m_nKeyInputRepeated++;
				}
				else
					delete m_pLastKeyInputEvent, m_pLastKeyInputEvent =  NULL;
			}
			if( ! m_pLastKeyInputEvent )
			{
				m_nKeyInputRepeated = 0;
				m_pLastKeyInputEvent = new ExtRmEvent( RMEVENT_KEYINPUT, pEvent->GetWindow(), new RmKeyEventData( *pKeyData ) );
				SetMaxGeneratedRepeats();
			}
			m_nLastRepeatedInputTime = Time::GetSystemTicks();
			break;
		}
		case( RMEVENT_KEYUP ):
//			mnKeyEvtCount++;
			if( m_pLastKeyInputEvent )
				delete m_pLastKeyInputEvent, m_pLastKeyInputEvent = NULL;
			break;
		case( RMEVENT_PAINT ): mnPaintEvtCount++; break;
		default: mnOtherEvtCount++; break;
	}

	maSubQueue.Push( pEvent );

	if ( pEvent->GetWindow() )
	{
		ImplSVData* pSVData = ImplGetSVData();
		vos::OGuard aGuard( pSVData->mpWindowObjectMutex );

		pEvent->SetNextWindowEvent( pEvent->GetWindow()->GetRmEvents() );
		pEvent->GetWindow()->SetRmEvents( pEvent );
	}

	m_notEmpty.set();
}

void RmEventQueue::RemoveEvent( ExtRmEvent* pDelEvent )
{
	vos::OGuard LockQueue(&m_Lock);
	ExtRmEvent* pEvent = (ExtRmEvent*)maSubQueue.GetFirst();
	while ( pEvent && ( pEvent != pDelEvent ) )
		pEvent = (ExtRmEvent*)maSubQueue.GetNext();

	if ( pEvent )
	{
		switch( pEvent->GetId() )
		{
			case( RMEVENT_MOUSEBUTTONDOWN ):
			case( RMEVENT_MOUSEBUTTONUP ):
			case( RMEVENT_MOUSEMOVE ): mnMouseEvtCount--; break;
			case( RMEVENT_KEYINPUT ):
				mnKeyEvtCount--;
				if( ! mnKeyEvtCount )
					pEvent->GetWindow()->ImplGetFrame()->KeyInputProcessed();
				break;
// KeyEvents are interpreted by writer as KeyInputEvents
//			case( RMEVENT_KEYUP ): mnKeyEvtCount--; break;
			case( RMEVENT_PAINT ): mnPaintEvtCount--; break;
			default: mnOtherEvtCount--; break;
		}

		maSubQueue.RemoveCurrent();

		// Nur wenn der Event noch in der Queue war ist er noch existent
		// ggf. aus der Event-Liste des Fensters entfernen
		if ( pEvent->GetWindow() )
			ImplRemoveFromWindow( pEvent );

		delete pEvent;
	}
	if( maSubQueue.IsEmpty() )
		m_notEmpty.reset();
}

RmEvent* RmEventQueue::GetNextEvent( BOOL bWaitForEvent )
{

retry:

	// if there are no more events and we have a repeated KeyInput
	// genrate new KeyInputs
	if( ! m_notEmpty.check() && m_pLastKeyInputEvent && m_nKeyInputRepeated && m_nGeneratedEvents <= m_nKeyInputRepeated && m_nGeneratedEvents <= m_nMaxGeneratedEvents )
	{
		vos::OGuard LockQueue(&m_Lock);
		if( ! m_notEmpty.check() && m_pLastKeyInputEvent && m_nKeyInputRepeated && m_nGeneratedEvents <= m_nKeyInputRepeated && m_nGeneratedEvents <= m_nMaxGeneratedEvents )
		{
			RmKeyEventData* pLastData = (RmKeyEventData*)m_pLastKeyInputEvent->GetData();
			RmKeyEventData* pData = new RmKeyEventData( pLastData->nChar, pLastData->nKeyCode, 0 );
			ExtRmEvent* pEvent =
				new ExtRmEvent( RMEVENT_KEYINPUT,
								m_pLastKeyInputEvent->GetWindow(),
								pData
					);
			m_nGeneratedEvents++;
			return pEvent;
		}
	}
	else
	{
		if ( bWaitForEvent )
			m_notEmpty.wait();
		else if ( !m_notEmpty.check() )
			return NULL;
	}

    ExtRmEvent* pEvent;
    {
	    vos::OGuard LockQueue(m_Lock);

	    pEvent = (ExtRmEvent*)maSubQueue.RemoveHead();

	    if( maSubQueue.IsEmpty() )
		    m_notEmpty.reset();

		if( pEvent && pEvent->GetWindow() )
			ImplRemoveFromWindow( pEvent );
    }

	if( pEvent )
	{
        // server side drag and drop runnning ?
        RmDragSource * pDragSource = static_cast < RmDragSource * > ( ImplGetSVData()->mxServerDragSource.get() );
        if( pDragSource && pDragSource->handleRemoteEvent( pEvent ) )
            goto retry;

		switch( pEvent->GetId() )
		{
			case( RMEVENT_MOUSEBUTTONDOWN ):
			case( RMEVENT_MOUSEBUTTONUP ):
			case( RMEVENT_MOUSEMOVE ): mnMouseEvtCount--; break;
			case( RMEVENT_KEYINPUT ):
				mnKeyEvtCount--;
				if( ! mnKeyEvtCount )
					pEvent->GetWindow()->ImplGetFrame()->KeyInputProcessed();
				// set key repeat from client to 0 else
				// key repeats on server and client are added up !
				((RmKeyEventData*)pEvent->GetData())->nCount = 0;
				break;
// KeyEvents are interpreted by writer as KeyInputEvents
//			case( RMEVENT_KEYUP ): mnKeyEvtCount--; break;
			case( RMEVENT_PAINT ): mnPaintEvtCount--; break;
			default: mnOtherEvtCount--; break;
		}
	}

	return pEvent;
}


BOOL RmEventQueue::HasEvent()
{
	vos::OGuard LockQueue(&m_Lock);
	return !maSubQueue.IsEmpty();
}


ExtRmEvent::ExtRmEvent( ULONG nEvtId, Window* pWindow, void* pData )
{
	mnId				= nEvtId;
	mpData				= pData;
	mpWindow			= pWindow;
	mpNextWindowEvent	= NULL;
	mbValid 			= TRUE;
}

ExtRmEvent::~ExtRmEvent()
{
	// Daten zerstoeren, wenn SV-Event
	if ( mnId && ( mnId != RMEVENT_USEREVENT ) )
		delete mpData;
}

void ImplPostEvent( ExtRmEvent* pEvent )
{
	ImplSVData* pSVData = ImplGetSVData();
   	pSVData->mpRmEventQueue->AddEvent( pEvent );
}

void ImplRemoveEvent( ULONG nEventId )
{
	ImplSVData* pSVData = ImplGetSVData();
	ExtRmEvent* pEvent = (ExtRmEvent*)nEventId;
	pSVData->mpRmEventQueue->RemoveEvent( pEvent );
}

void ImplDispatchEvent( ExtRmEvent* pEvent )
{
	if ( pEvent->IsValid() )
		ImplRemoteWindowFrameProc( pEvent );

	delete pEvent;
}

#endif	// REMOTE_APPSERVER
