/*************************************************************************
 *
 *  $RCSfile: cntpool.cxx,v $
 *
 *  $Revision: 1.8 $
 *
 *  last change: $Author: vg $ $Date: 2003/06/12 11:09:59 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

//=========================================================================

#if 0  /* @@@ Pool for 'mbx.cxx' usage only @@@ */

WID_MSG_START,    WID_MSG_END, [WID_MAIL_REPLY, WID_RECIPIENT_LIST]
WID_DATE_CREATED, WID_DATE_CREATED

SfxVoidItem                -> <svtools/poolitem.hxx>
SfxDateTimeItem            -> <svtools/dateitem.hxx>
CntBoolItem                -> <svtools/cenumitm.hxx>

CntSeenStatusItem          -> cntsitem.hxx + cxx
CntStringItem              -> cstritem.hxx + cxx
CntNameItem                -> cntvwitm.hxx + cxx
CntPriorityItem            ->   - "" -
CntMessageBodyItem         -> cntmbitm.hxx + cxx
CntItemListItem            -> ilstitem.hxx + cxx
CntOutMsgInternalStateItem -> outitems.hxx + cxx
CntRecipientListItem       -> rcptitem.hxx + cxx

cntpool:  CntResId
cntvwitm: CntResId
          CntWIDSetItem         -> widsitem.hxx
ilstitem: CntCrossReferenceItem -> cntxref.hxx
mbxformt: CntCrossReferenceItem ->   - "" -
          CntRangesItem         -> cntrange.hxx

//=========================================================================
// svtools/inc/cntwids.hrc: WID-definitions for CHAOS
//=========================================================================

#define WID_CHAOS_START 500

//FUNC MSG
#define WID_MSG_START                       (WID_CHAOS_START +  6)
#define WID_MAIL_REPLY                      (WID_CHAOS_START +  6)
#define WID_POST_REPLY                      (WID_CHAOS_START +  7)
#define WID_FORWARD                         (WID_CHAOS_START +  8)
#define WID_MARK_THREAD_READ                (WID_CHAOS_START +  9)
#define WID_HIDE_THREAD                     (WID_CHAOS_START + 10)
#define WID_HIDE_AUTHOR                     (WID_CHAOS_START + 11)
#define WID_HIDE_SUBJECT                    (WID_CHAOS_START + 12)
#define WID_RESEND_MSG                      (WID_CHAOS_START + 13)
#define WID_MARK_THREAD_UNREAD              (WID_CHAOS_START + 14)

//PROP MSG
#define WID_PRIORITY                        (WID_CHAOS_START + 15)
#define WID_RULE_APPLIED                    (WID_CHAOS_START + 16)
#define WID_MSG_LOCK                        (WID_CHAOS_START + 17)
#define WID_SEEN_STATUS                     (WID_CHAOS_START + 18)
#define WID_REPLY_TO                        (WID_CHAOS_START + 19)
#define WID_IN_REPLY_TO                     (WID_CHAOS_START + 20)

#define WID_MESSAGE_ID                      (WID_CHAOS_START + 21)
#define WID_BCC                             (WID_CHAOS_START + 22)
#define WID_CC                              (WID_CHAOS_START + 23)
#define WID_TO                              (WID_CHAOS_START + 24)
#define WID_FROM                            (WID_CHAOS_START + 25)
#define WID_TITLE                           (WID_CHAOS_START + 26)
#define WID_SUBJECT WID_TITLE // only here to prevent panic, should be removed
#define WID_MESSAGEBODY                     (WID_CHAOS_START + 27)

#define WID_REFERENCES                      (WID_CHAOS_START + 28)
#define WID_NEWSGROUPS                      (WID_CHAOS_START + 29)
#define WID_NEWS_XREFLIST                   (WID_CHAOS_START + 30)

#define WID_OUTMSGINTERNALSTATE             (WID_CHAOS_START + 31)
#define WID_RECIPIENTLIST                   (WID_CHAOS_START + 32)
#define WID_MSG_END                         (WID_CHAOS_START + 32)

//PROP ALL
#define WID_DATE_CREATED                    (WID_CHAOS_START + 55)

#endif /* @@@ */

//=========================================================================

#include "cntpool.hxx"

#ifndef _RTL_MEMORY_H_
#include <rtl/memory.h>
#endif

#ifndef _CNTWIDS_HRC
#include <svtools/cntwids.hrc>
#endif
#ifndef _SVTOOLS_CINTITEM_HXX
#include <svtools/cintitem.hxx>
#endif
#ifndef _DATETIMEITEM_HXX
#include <svtools/dateitem.hxx>
#endif

#ifndef _CNTBASE_HXX
#include <cntbase.hxx>
#endif
#ifndef _CNTRIDS_HRC
#include <cntrids.hrc>
#endif

#ifndef _CNTMBITM_HXX
#include <cntmbitm.hxx>
#endif
#ifndef _CNTSIITEM_HXX
#include <cntsitem.hxx>
#endif
#ifndef _CNTVWITM_HXX
#include <cntvwitm.hxx>
#endif
#ifndef _CSTRITEM_HXX
#include <cstritem.hxx>
#endif
#ifndef _ILSTITEM_HXX
#include <ilstitem.hxx>
#endif
#ifndef _OUTITEMS_HXX
#include <outitems.hxx>
#endif
#ifndef _RCPNITEM_HXX
#include <rcpnitem.hxx>
#endif

using namespace chaos;

//=========================================================================

static String aEmpty;

//=========================================================================
//
// class CntStaticPoolDefaults_Impl
//
//=========================================================================

namespace chaos {

class CntStaticPoolDefaults_Impl
{
	ULONG		  m_nItems;
	SfxPoolItem** m_ppDefaults;
	SfxItemInfo*  m_pItemInfos;

private:
	// Forbidden and not implemented...
	CntStaticPoolDefaults_Impl( const CntStaticPoolDefaults_Impl& );
    CntStaticPoolDefaults_Impl&	operator=( const CntStaticPoolDefaults_Impl& );

	inline void Insert( SfxPoolItem* pItem, USHORT nSID, USHORT nFlags );

public:
	CntStaticPoolDefaults_Impl( CntItemPool* pPool );
	~CntStaticPoolDefaults_Impl();

	SfxPoolItem** 	   GetDefaults() const  { return m_ppDefaults; }
	const SfxItemInfo* GetItemInfos() const { return m_pItemInfos; }
};

}

//=========================================================================
//
// CntStaticPoolDefaults_Impl implementation.
//
//=========================================================================

inline void CntStaticPoolDefaults_Impl::Insert(
	 	SfxPoolItem* pItem, 		/* Static Pool Default Item */
     	USHORT nSID, USHORT nFlags  /* Item Info */	)
{
	DBG_ASSERT( ( pItem->Which() >= WID_CHAOS_START ) &&
				( pItem->Which() <= WID_CHAOS_END ),
				"CntStaticPoolDefaults_Impl::Insert - Id out of range!" );

	USHORT nPos = pItem->Which() - WID_CHAOS_START;

	DBG_ASSERT( !m_ppDefaults[ nPos ],
				"CntStaticPoolDefaults_Impl::Insert - Already inserted!" );

	m_ppDefaults[ nPos ]         = pItem;
	m_pItemInfos[ nPos ]._nSID   = nSID;
	m_pItemInfos[ nPos ]._nFlags = nFlags;
}

//-------------------------------------------------------------------------
CntStaticPoolDefaults_Impl::~CntStaticPoolDefaults_Impl()
{
	for ( ULONG n = 0; n < m_nItems; ++n )
		delete m_ppDefaults[ n ];

	delete [] m_ppDefaults;
	delete [] m_pItemInfos;
}

//-------------------------------------------------------------------------
CntStaticPoolDefaults_Impl::CntStaticPoolDefaults_Impl( CntItemPool* pPool )
: m_nItems( WID_CHAOS_END - WID_CHAOS_START + 1 ),
  m_ppDefaults( new SfxPoolItem* [ m_nItems ] ),
  m_pItemInfos( new SfxItemInfo  [ m_nItems ] )
{
	rtl_zeroMemory( m_ppDefaults, sizeof( m_ppDefaults ) * m_nItems );
	rtl_zeroMemory( m_pItemInfos, sizeof( m_pItemInfos ) * m_nItems );

	//====================================================================
	//
	//	Notes on item flags:
	//
	//	SFX_ITEM_POOLABLE:
	//		- Items are shareable and poolable.
	//	SFX_ITEM_NOT_POOLABLE
	//		- Items are not shareable and not poolable.
	//	0
	//		- Items are not shareable, but poolable. Should not be of
	//        interest for our items.
	//
	//====================================================================

	USHORT nWhich;

	for (nWhich = WID_CHAOS_START; nWhich < WID_MSG_START; nWhich++)
		Insert (
			new SfxVoidItem (nWhich),
			0,
			SFX_ITEM_NOT_POOLABLE);
	for (nWhich = WID_MSG_END + 1; nWhich < WID_DATE_CREATED; nWhich++)
		Insert (
			new SfxVoidItem (nWhich),
			0,
			SFX_ITEM_NOT_POOLABLE);
	for (nWhich = WID_DATE_CREATED + 1; nWhich <= WID_CHAOS_END; nWhich++)
		Insert (
			new SfxVoidItem (nWhich),
			0,
			SFX_ITEM_NOT_POOLABLE);


	Insert(
		new SfxVoidItem( WID_MAIL_REPLY ),
		0,
		SFX_ITEM_NOT_POOLABLE );

	Insert(
		new SfxVoidItem( WID_POST_REPLY ),
		0,
		SFX_ITEM_NOT_POOLABLE );

	Insert(
		new SfxVoidItem( WID_FORWARD ),
		0,
		SFX_ITEM_NOT_POOLABLE );

	Insert(
		new SfxVoidItem( WID_MARK_THREAD_READ ),
		0,
		SFX_ITEM_NOT_POOLABLE | CNT_ITEM_MULTISELECTION );

	Insert(
		new SfxVoidItem( WID_HIDE_THREAD ),
		0,
		SFX_ITEM_NOT_POOLABLE );

	Insert(
		new SfxVoidItem( WID_HIDE_AUTHOR ),
		0,
		SFX_ITEM_NOT_POOLABLE | CNT_ITEM_MULTISELECTION );

	Insert(
		new SfxVoidItem( WID_HIDE_SUBJECT ),
		0,
		SFX_ITEM_NOT_POOLABLE | CNT_ITEM_MULTISELECTION );

	Insert(
		new SfxVoidItem( WID_RESEND_MSG ),
		0,
		SFX_ITEM_NOT_POOLABLE | CNT_ITEM_MULTISELECTION | CNT_ITEM_UI_CANCELABLE );

	Insert(
		new SfxVoidItem( WID_MARK_THREAD_UNREAD ),
		0,
		SFX_ITEM_NOT_POOLABLE | CNT_ITEM_MULTISELECTION );

	Insert(
		new CntPriorityItem( WID_PRIORITY, CNT_PRIO_NORMAL ),
		SID_PRIORITY,
		SFX_ITEM_POOLABLE | CNT_ITEM_MULTISELECTION | CNT_ITEM_AUTO_OWNPROP | CNT_ITEM_RULES_RELEVANT );

	Insert(
		new CntBoolItem( WID_RULE_APPLIED, FALSE ),
		0,
		SFX_ITEM_POOLABLE | CNT_ITEM_AUTO_USERPROP );

	Insert(
		new CntBoolItem( WID_MSG_LOCK, FALSE ),
		0,
		SFX_ITEM_POOLABLE );

	Insert(
		new CntSeenStatusItem( WID_SEEN_STATUS, CNT_NONE_SEEN ),
		0,
		SFX_ITEM_POOLABLE );

	Insert(
		new CntStringItem( WID_REPLY_TO, aEmpty ),
		0,
		SFX_ITEM_POOLABLE | CNT_ITEM_RULES_RELEVANT );

	Insert(
		new CntStringItem( WID_IN_REPLY_TO, aEmpty ),
		SID_IN_REPLY_TO,
		SFX_ITEM_NOT_POOLABLE | CNT_ITEM_RULES_RELEVANT );

	Insert(
		new CntStringItem( WID_MESSAGE_ID, aEmpty ),
		SID_MESSAGE_ID,
		SFX_ITEM_NOT_POOLABLE | CNT_ITEM_RULES_RELEVANT );

	Insert(
		new CntStringItem( WID_BCC, aEmpty ),
		SID_BCC,
		SFX_ITEM_POOLABLE | CNT_ITEM_RULES_RELEVANT );

	Insert(
		new CntStringItem( WID_CC, aEmpty ),
		SID_CC,
		SFX_ITEM_POOLABLE | CNT_ITEM_RULES_RELEVANT );

	Insert(
		new CntStringItem( WID_TO, aEmpty ),
		SID_TO,
		SFX_ITEM_POOLABLE | CNT_ITEM_AUTO_GARBLE | CNT_ITEM_RULES_RELEVANT );

	Insert(
		new CntNameItem( WID_FROM, aEmpty ),
		0,
		SFX_ITEM_POOLABLE | CNT_ITEM_RULES_RELEVANT );

	Insert(
		new CntStringItem( WID_TITLE, aEmpty ),
		SID_TITLE,
		SFX_ITEM_NOT_POOLABLE | CNT_ITEM_AUTO_VIEWPROP | CNT_ITEM_SYNCHRON | CNT_ITEM_RULES_RELEVANT | CNT_ITEM_UI_CANCELABLE );

	Insert(
		new CntMessageBodyItem( WID_MESSAGEBODY, aEmpty ),
		SID_MESSAGEBODY,
		SFX_ITEM_NOT_POOLABLE );

	Insert(
		new CntStringItem( WID_REFERENCES, aEmpty ),
		0,
		SFX_ITEM_NOT_POOLABLE | CNT_ITEM_RULES_RELEVANT );

	Insert(
		new CntStringItem( WID_NEWSGROUPS, aEmpty ),
		SID_NEWSGROUPS,
		SFX_ITEM_NOT_POOLABLE );

	Insert(
		new CntItemListItem( WID_NEWS_XREFLIST, pPool ),
		0,
		SFX_ITEM_NOT_POOLABLE );

	Insert(
		new CntOutMsgInternalStateItem(	WID_OUTMSGINTERNALSTATE ),
		0,
		SFX_ITEM_POOLABLE );

	Insert(
		new CntRecipientListItem( WID_RECIPIENTLIST ),
		SID_RECIPIENTLIST,
		SFX_ITEM_NOT_POOLABLE | CNT_ITEM_RULES_RELEVANT );

	Insert(
		new SfxDateTimeItem( WID_DATE_CREATED, DateTime( 0, 0 ) ),
		SID_DATE_CREATED,
		SFX_ITEM_NOT_POOLABLE | CNT_ITEM_RULES_RELEVANT );

	//////////////////////////////////////////////////////////////////////

#ifdef DBG_UTIL
	for ( ULONG n = 0; n < m_nItems; ++n )
	{
		SfxPoolItem* pCurr = m_ppDefaults[ n ];
		if ( !pCurr )
		{
			DBG_ERROR( "Static default items list incomplete!" );
			break;
		}
	}
#endif
}

//=========================================================================
//
//	CntItemPool implementation
//
//=========================================================================

static CntStaticPoolDefaults_Impl* pPoolDefs_Impl = NULL;

// static member!
CntItemPool* CntItemPool::_pThePool = NULL;

//-------------------------------------------------------------------------
CntItemPool::CntItemPool()
: SfxItemPool(
	UniString::CreateFromAscii(	RTL_CONSTASCII_STRINGPARAM( "chaos" ) ),
	WID_CHAOS_START, WID_CHAOS_END, NULL ),
  _nRefs( 0 )
{
    SetFileFormatVersion( SOFFICE_FILEFORMAT_50 );

	FreezeIdRanges();

	// Create static defaults.
	pPoolDefs_Impl = new CntStaticPoolDefaults_Impl( this );

	// Set item infos.
	SetItemInfos( pPoolDefs_Impl->GetItemInfos() );

	// Set static pool default items.
	SetDefaults( pPoolDefs_Impl->GetDefaults() );
}

//-------------------------------------------------------------------------
//virtual
CntItemPool::~CntItemPool()
{
	// Release static pool default items.
	ReleaseDefaults( FALSE );
}

//-------------------------------------------------------------------------
// static
CntItemPool* CntItemPool::Acquire()
{
	if ( !_pThePool )
		_pThePool = new CntItemPool;

	_pThePool->_nRefs++;

	return _pThePool;
}

//-------------------------------------------------------------------------
// static
USHORT CntItemPool::Release()
{
	if ( !_pThePool )
		return 0;

	USHORT& nRefs = _pThePool->_nRefs;

	if ( nRefs )
		--nRefs;

	if ( !nRefs )
	{
		DELETEZ( _pThePool );
		DELETEZ( pPoolDefs_Impl );
		return 0;
	}

	return nRefs;
}

//-------------------------------------------------------------------------
SfxItemPresentation CntItemPool::GetPresentation(
	const SfxPoolItem&	rItem,
	SfxItemPresentation ePresentation,
	SfxMapUnit			ePresentationMetric,
	XubString&			rText,
    const IntlWrapper * ) const
{
	USHORT nWhich = rItem.Which();

	DBG_ASSERT( ( nWhich >= GetFirstWhich() ) && ( nWhich <= GetLastWhich() ),
		        "Bad which in GetPresentation" );

	if ( nWhich == WID_CREATE_NEW )
	{
		const CntItemListItem *pCreateItem =
									PTR_CAST( CntItemListItem, &rItem );
		if ( pCreateItem )
		{
			const CntStringItem *pNameItem =
				(const CntStringItem*)pCreateItem->Get( WID_FACTORY_NAME );
			rText = pNameItem->GetValue();
			return SFX_ITEM_PRESENTATION_NAMELESS;
		}
	}

	USHORT nResId = nWhich - GetFirstWhich() + RID_CNT_POOL_PRES_NAME_START;
	rText = String();
	return SFX_ITEM_PRESENTATION_NAMEONLY;
}

//-------------------------------------------------------------------------
const SfxPoolItem& CntItemPool::Put( const SfxPoolItem& rItem, USHORT nWhich )
{
	// Da wir nur einen Pool haben, muss ein Item, dass einen RefCount hat,
	// schon in diesem Pool sein!
	if ( /* rItem.GetRef() */ IsPooledItem( &rItem ) )
	{
		AddRef( rItem );
		return rItem;
	}
	else
		return SfxItemPool::Put( rItem, nWhich );
}

//-------------------------------------------------------------------------
