/*************************************************************************
 *
 *  $RCSfile: Busiphon.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: hr $ $Date: 2003/03/25 16:01:43 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include "sections.hrc"
#include "adrresid.hxx"
#include "busiphon.hxx"
#include "datman.hxx"


/*
	Telephone(0-n,Private/Company/Preferred/Fax/Car/Mobile/Pager/Telex/Modem/Main/Assistant);
	URL(0-n,Private/Company/Preferred);
	EMail(0-n,Private/Company/Preferred/OnlyAsciiMail);
	Calendarurl(0-n,Private/Company/Preferred);
*/

#define LSTR_PHONE		L"Telephone"
#define LSTR_HOMEPAGE	L"URL"
#define LSTR_EMAIL		L"EMail"

#define LSTR_MOBIL		L"Mobile"
#define LSTR_FAX		L"Fax"
#define LSTR_PAGER		L"Pager"	

#define LSTR_PRIVAT		L"Private"
#define LSTR_BUSINESS	L"Business"


AdrPhonePage::AdrPhonePage( Window * pParent,AdrDataManagerHdl pDM, const UString& aGroup)
    : AdrBasePage( pParent, pDM, AdrResId(RID_TP_BUSIPHONE )),
    aFtPhone   ( this, ResId( FT_PHONE ) ),
    aEdPhone   ( this, ResId( ED_PHONE ) ),
    aFtMobil   ( this, ResId( FT_MOBIL ) ),
    aEdMobil   ( this, ResId( ED_MOBIL ) ),
    aFtEmail   ( this, ResId( FT_EMAIL ) ),
    aEdEmail   ( this, ResId( ED_EMAIL ) ),
    aIBEmail   ( this, ResId( BTN_EMAIL ) ),
	aFtFax     ( this, ResId( FT_FAX ) ),
    aEdFax     ( this, ResId( ED_FAX ) ),
    aFtPager   ( this, ResId( FT_PAGER ) ),
    aEdPager   ( this, ResId( ED_PAGER ) ),
    aFtHomepage( this, ResId( FT_HOMEPAGE ) ),
    aEdHomepage( this, ResId( ED_HOMEPAGE ) ),
	aIBHomepage( this, ResId( BTN_HOMEPAGE ) ),
	aBusinessTitle( ResId( STR_BUSIPHON) ),
	aPrivateTitle ( ResId( STR_PRIVPHON) ),
	aGroupName(aGroup)
{
    FreeResource();

	if(aGroup == LSTR_BUSINESS)
	{
		SetText(aBusinessTitle);
	}
	else if(aGroup == LSTR_PRIVAT)
	{
		SetText(aPrivateTitle);
	}

	Sequence<UString> aGroupSeq;

	INT32 nLen=aGroup.len();
	if( nLen >0)
	{
		Sequence<UString> aGroupSeq1(&aGroup,1);
		aGroupSeq = aGroupSeq1;
	}

	InsertToFieldList(&aEdEmail,	LSTR_EMAIL,	aGroupSeq);
	InsertToFieldList(&aEdHomepage,	LSTR_HOMEPAGE,	aGroupSeq);
	InsertToFieldList(&aEdPhone,	LSTR_PHONE,	aGroupSeq);

	aGroupSeq.realloc(nLen+1);

	UString* pStr = aGroupSeq.getArray();

	pStr[nLen]= LSTR_MOBIL;
	InsertToFieldList(&aEdMobil,	LSTR_PHONE,	aGroupSeq);
	pStr[nLen]= LSTR_FAX;
	InsertToFieldList(&aEdFax,		LSTR_PHONE,	aGroupSeq);
	pStr[nLen]= LSTR_PAGER;
	InsertToFieldList(&aEdPager,	LSTR_PHONE,	aGroupSeq);
}

void AdrPhonePage::GenerateFields()
{
	AdrDataManagerHdl ppDM = GetDataManager();

	if(*ppDM != NULL)
	{
		AdrDataManagerPtr pDM= *ppDM;
		
		Sequence<UString> aGroupSeq;
		if(aGroupName.len()>0)
		{
			Sequence<UString> aGroupSeq1(&aGroupName,1);
			aGroupSeq = aGroupSeq1;
		}

		UsrAny aAny =pDM -> getAvailableField(LSTR_PHONE,aGroupSeq);
		aAny =pDM -> getAvailableField(LSTR_EMAIL,aGroupSeq);			//ED_EMAIL
		aAny =pDM -> getAvailableField(LSTR_HOMEPAGE,aGroupSeq);		//ED_HOMEPAGE		
		USHORT nDummy=5;
	}
}

AdrPhonePage* CreatePhonePage( Window * pParent, AdrDataManagerHdl ppDM,const UString& aGroup)
{
	AdrPhonePage* pAdrPhonePage=NULL;

	if(*ppDM != NULL)
	{
		AdrDataManagerPtr pDM= *ppDM;

		Sequence<UString> aGroupSeq;
		if(aGroup.len()>0)
		{
			Sequence<UString> aGroupSeq1(&aGroup,1);
			aGroupSeq = aGroupSeq1;
		}

		if(	pDM -> GetMaxFieldCount(LSTR_PHONE,aGroupSeq)	>0 ||	//ED_PHONE
			pDM -> GetMaxFieldCount(LSTR_EMAIL,aGroupSeq)	>0 ||	//ED_EMAIL
			pDM -> GetMaxFieldCount(LSTR_HOMEPAGE,aGroupSeq)>0 )	//ED_HOMEPAGE		
		{
			pAdrPhonePage = new AdrPhonePage(pParent,ppDM,aGroup);
		}
	}
	return pAdrPhonePage;
}



