/*************************************************************************
 *
 *  $RCSfile: adrcont.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: hr $ $Date: 2003/03/25 16:01:47 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include <vos/mutex.hxx>
#include <tools/urlobj.hxx>
#include <usr/weak.hxx>
#include <usr/reflserv.hxx>
#include <usr/factoryhlp.hxx>
#include <usr/services.hxx>
#include <usr/smart2uno.hxx>
#include <toolkit/unoiface.hxx>
#ifndef _SMART_COM_SUN_STAR_FRAME_XCONTROLLER_HXX_
#include <smart/com/sun/star/frame/XController.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_FRAME_XFRAMEACTIONLISTENER_HXX_
#include <smart/com/sun/star/frame/XFrameActionListener.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_FRAME_XCOMPONENTLOADER_HXX_
#include <smart/com/sun/star/frame/XComponentLoader.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_FRAME_XFRAME_HXX_
#include <smart/com/sun/star/frame/XFrame.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_FRAME_FRAMEACTIONEVENT_HXX_
#include <smart/com/sun/star/frame/FrameActionEvent.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_FRAME_FRAMEACTION_HXX_
#include <smart/com/sun/star/frame/FrameAction.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_FRAME_XFRAMELOADER_HXX_
#include <smart/com/sun/star/frame/XFrameLoader.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_FRAME_XLOADEVENTLISTENER_HXX_
#include <smart/com/sun/star/frame/XLoadEventListener.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_FRAME_XFILTERDETECT_HXX_
#include <smart/com/sun/star/frame/XFilterDetect.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_LANG_XSERVICENAME_HXX_
#include <smart/com/sun/star/lang/XServiceName.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_LANG_XSERVICEINFO_HXX_
#include <smart/com/sun/star/lang/XServiceInfo.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_LANG_XMULTISERVICEFACTORY_HXX_
#include <smart/com/sun/star/lang/XMultiServiceFactory.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_LANG_XSINGLESERVICEFACTORY_HXX_
#include <smart/com/sun/star/lang/XSingleServiceFactory.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_BEANS_PROPERTYVALUES_HXX_
#include <smart/com/sun/star/beans/PropertyValues.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_BEANS_XPROPERTYSET_HXX_
#include <smart/com/sun/star/beans/XPropertySet.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_BEANS_PROPERTYVALUE_HXX_
#include <smart/com/sun/star/beans/PropertyValue.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_BEANS_PROPERTYSTATE_HXX_
#include <smart/com/sun/star/beans/PropertyState.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_BEANS_XPROPERTYSETINFO_HXX_
#include <smart/com/sun/star/beans/XPropertySetInfo.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_BEANS_XMULTIPROPERTYSET_HXX_
#include <smart/com/sun/star/beans/XMultiPropertySet.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_BEANS_XFASTPROPERTYSET_HXX_
#include <smart/com/sun/star/beans/XFastPropertySet.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_BEANS_XVETOABLECHANGELISTENER_HXX_
#include <smart/com/sun/star/beans/XVetoableChangeListener.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_BEANS_XPROPERTYSTATE_HXX_
#include <smart/com/sun/star/beans/XPropertyState.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_BEANS_XPROPERTYSTATECHANGELISTENER_HXX_
#include <smart/com/sun/star/beans/XPropertyStateChangeListener.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_BEANS_PROPERTYATTRIBUTE_HXX_
#include <smart/com/sun/star/beans/PropertyAttribute.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_BEANS_XPROPERTIESCHANGELISTENER_HXX_
#include <smart/com/sun/star/beans/XPropertiesChangeListener.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_BEANS_XPROPERTYCHANGELISTENER_HXX_
#include <smart/com/sun/star/beans/XPropertyChangeListener.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_BEANS_XPROPERTYACCESS_HXX_
#include <smart/com/sun/star/beans/XPropertyAccess.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_BEANS_XPROPERTYCONTAINER_HXX_
#include <smart/com/sun/star/beans/XPropertyContainer.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_BEANS_PROPERTYSTATECHANGEEVENT_HXX_
#include <smart/com/sun/star/beans/PropertyStateChangeEvent.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_BEANS_PROPERTYCHANGEEVENT_HXX_
#include <smart/com/sun/star/beans/PropertyChangeEvent.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_CONTAINER_XCONTAINER_HXX_
#include <smart/com/sun/star/container/XContainer.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_CONTAINER_XINDEXCONTAINER_HXX_
#include <smart/com/sun/star/container/XIndexContainer.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_CONTAINER_XNAMEREPLACE_HXX_
#include <smart/com/sun/star/container/XNameReplace.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_CONTAINER_XCONTAINERLISTENER_HXX_
#include <smart/com/sun/star/container/XContainerListener.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_CONTAINER_XSET_HXX_
#include <smart/com/sun/star/container/XSet.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_CONTAINER_CONTAINEREVENT_HXX_
#include <smart/com/sun/star/container/ContainerEvent.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_CONTAINER_XINDEXREPLACE_HXX_
#include <smart/com/sun/star/container/XIndexReplace.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_CONTAINER_XNAMECONTAINER_HXX_
#include <smart/com/sun/star/container/XNameContainer.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_REGISTRY_MERGECONFLICTEXCEPTION_HXX_
#include <smart/com/sun/star/registry/MergeConflictException.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_REGISTRY_XSIMPLEREGISTRY_HXX_
#include <smart/com/sun/star/registry/XSimpleRegistry.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_REGISTRY_INVALIDVALUEEXCEPTION_HXX_
#include <smart/com/sun/star/registry/InvalidValueException.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_REGISTRY_REGISTRYKEYTYPE_HXX_
#include <smart/com/sun/star/registry/RegistryKeyType.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_REGISTRY_XREGISTRYKEY_HXX_
#include <smart/com/sun/star/registry/XRegistryKey.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_REGISTRY_REGISTRYVALUETYPE_HXX_
#include <smart/com/sun/star/registry/RegistryValueType.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_REGISTRY_INVALIDREGISTRYEXCEPTION_HXX_
#include <smart/com/sun/star/registry/InvalidRegistryException.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_LOADER_XIMPLEMENTATIONLOADER_HXX_
#include <smart/com/sun/star/loader/XImplementationLoader.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_LOADER_CANNOTACTIVATEFACTORYEXCEPTION_HXX_
#include <smart/com/sun/star/loader/CannotActivateFactoryException.hxx>
#endif

#include <svtools/iniprop.hxx>
#include <svtools/iniman.hxx>

#include "adrcont.hxx"

#ifdef _USE_NAMESPACE
using namespace usr;
using namespace vos;
#endif

#define PROPERTY_FRAME						1


AdrWindowContainer::AdrWindowContainer( Window* pParent,WinBits nStyle):
		DockingWindow(pParent,nStyle),
		pChild(NULL)
{
//	SetBackground();
//	SetPaintTransparent(TRUE);
}

AdrWindowContainer::AdrWindowContainer( Window* pParent,Window* pWin, WinBits nStyle):
		DockingWindow(pParent,nStyle),
		pChild(pWin)
{
//	SetBackground();
//	SetPaintTransparent(TRUE);
	if(pChild!=NULL)
	{
		pChild->SetParent(this);
		pChild->Show();
		pChild->SetPosPixel(Point(0,0));
	}
}

AdrWindowContainer::~AdrWindowContainer()
{
	if(pChild!=NULL) delete pChild;
}

void AdrWindowContainer::Resize()
{
	Size aSize=GetOutputSizePixel();
	if(pChild!=NULL) pChild->SetSizePixel(aSize);
	//Invalidate(INVALIDATE_NOCHILDREN);
}

void AdrWindowContainer::SetChild(Window* pWin)
{
	pChild=pWin;
	if(pChild!=NULL)
	{
		pChild->SetParent(this);
		pChild->Show();
		pChild->SetPosPixel(Point(0,0));
	}
}

AdrBookContainer::AdrBookContainer(Window* pParent,AdrDataManagerHdl pDtMn, WinBits nStyle):
	SplitWindow(pParent,nStyle),
	ppDatMan(pDtMn),
	pTopWin(NULL),
	pBottomWin(NULL),
	bFirstTime(TRUE)
{
	aTimer.SetTimeoutHdl(LINK( this, AdrBookContainer, SplitHdl));
	aTimer.SetTimeout(400);
}

void AdrBookContainer::SetPosSizePixel( long nX, long nY,
										long nWidth, long nHeight,
										USHORT nFlags)
{
	SplitWindow::SetPosSizePixel(nX,nY,nWidth,nHeight,nFlags);
}

AdrBookContainer::~AdrBookContainer()
{
	if ( xTopFrameRef.is() ) xTopFrameRef->dispose();
	if ( xBottomFrameRef.is() ) xBottomFrameRef->dispose();

	if(pTopWin) delete pTopWin;
	if(pBottomWin) delete pBottomWin;
}

void AdrBookContainer::Split()
{
	aTimer.Start();
}

IMPL_LINK( AdrBookContainer, SplitHdl, Timer*,pT)
{
	if(*ppDatMan!=NULL)
	{
		AdrDataManagerPtr pDatMan=*ppDatMan;
		long nSize=	GetItemSize( TOP_WINDOW);
		pDatMan->setBeamerSize(nSize);
		nSize=	GetItemSize( BOTTOM_WINDOW);
		pDatMan->setViewSize(nSize);
	}
	return 0;
}


XWindowPeer* AdrBookContainer::GetTopComponentInterface( BOOL bCreate)
{
	return pTopWin->GetComponentInterface(bCreate);
}
void AdrBookContainer::SetTopComponentInterface( XWindowPeer* pIFace )
{
	pTopWin->SetComponentInterface(pIFace);
}

XWindowPeer* AdrBookContainer::GetBottomComponentInterface( BOOL bCreate)
{
	return pBottomWin->GetComponentInterface(bCreate);
}
void AdrBookContainer::SetBottomComponentInterface( XWindowPeer* pIFace )
{
	pBottomWin->SetComponentInterface(pIFace);
}

VCLXWindow*	AdrBookContainer::GetTopWindowPeer()
{
	return pTopWin->GetWindowPeer();
}
void AdrBookContainer::SetTopWindowPeer( VCLXWindow* pPeer )
{
	pTopWin->SetWindowPeer(pPeer );
}

VCLXWindow* AdrBookContainer::GetBottomWindowPeer()
{
	return pBottomWin->GetWindowPeer();
}
void AdrBookContainer::SetBottomWindowPeer( VCLXWindow* pPeer )
{
	pBottomWin->SetWindowPeer(pPeer );
}


void AdrBookContainer::CreateTopWin()
{
	if ( xTopFrameRef.is() ) xTopFrameRef->dispose();
	
	if(pTopWin) 
	{
		RemoveItem(TOP_WINDOW);
		delete pTopWin;
	}


	if(*ppDatMan!=NULL)
	{
		pTopWin= new DockingWindow(this,0);
		AdrDataManagerPtr pDatMan=*ppDatMan;
		long nSize=pDatMan->getBeamerSize();
		InsertItem(TOP_WINDOW, pTopWin, nSize, 0, 0, SWIB_PERCENTSIZE );
	}

}

void AdrBookContainer::CreateBottomWin()
{

	if ( xBottomFrameRef.is() ) xBottomFrameRef->dispose();
	
	if(pBottomWin) 
	{
		RemoveItem(BOTTOM_WINDOW);
		delete pBottomWin;
	}

	if(*ppDatMan!=NULL)
	{
		AdrDataManagerPtr pDatMan=*ppDatMan;
		pBottomWin= new DockingWindow(this,0);
		long nSize=pDatMan->getViewSize();
		InsertItem(BOTTOM_WINDOW, pBottomWin, nSize, 1, 0, SWIB_PERCENTSIZE );
	}

}

void AdrBookContainer::createTopFrame(const UString & rURL )
{
	XFrameRef	xNewFrame;

	CreateTopWin();
	
	xTopPeerRef=XWindowRef(GetTopComponentInterface(), USR_QUERY );

	XMultiServiceFactoryRef xMgr( NAMESPACE_USR( getProcessServiceManager )() );
	
	xNewFrame = XFrameRef( xMgr->createInstance( L"com.sun.star.frame.Frame" ), USR_QUERY );
	XDispatchProviderRef xDSP( xNewFrame, USR_QUERY );
	if( xDSP.is() )
	{
		xNewFrame->initialize( xTopPeerRef);

		// optional:
		//xFrame->setName( L"WhatYouWant" );

		XURLTransformerRef xTrans ( xMgr->createInstance( L"com.sun.star.util.URLTransformer" ), USR_QUERY );
		if( xTrans.is() )
		{
			// Datei laden
			URL aURL;
			aURL.Complete = rURL;

			xTrans->parseStrict( aURL );

			XDispatchRef xDisp = xDSP->queryDispatch( aURL, L"_self", FrameSearchFlag_SELF );
			if ( xDisp.Is() )
				xDisp->dispatch( aURL, Sequence<PropertyValue>() );
		}
	}

	// set the frame
	{
	OGuard aGuard(OMutex::getGlobalMutex());
	xTopFrameRef = xNewFrame;
	}

}

void AdrBookContainer::createBottomFrame(const UString & rURL )
{
	XFrameRef	xNewFrame;

	CreateBottomWin();

	xBottomPeerRef=XWindowRef(GetBottomComponentInterface(), USR_QUERY );

	XMultiServiceFactoryRef xMgr( NAMESPACE_USR( getProcessServiceManager )() );

	xNewFrame = XFrameRef( xMgr->createInstance( L"com.sun.star.frame.Frame" ), USR_QUERY );
	XDispatchProviderRef xDSP( xNewFrame, USR_QUERY );
	if( xDSP.is() )
	{
		xNewFrame->initialize( xBottomPeerRef);

		// optional:
		//xFrame->setName( L"WhatYouWant" );

		XURLTransformerRef xTrans ( xMgr->createInstance( L"com.sun.star.util.URLTransformer" ), USR_QUERY );
		if( xTrans.is() )
		{
			// Datei laden
			URL aURL;
			aURL.Complete = rURL;

			xTrans->parseStrict( aURL );

			XDispatchRef xDisp = xDSP->queryDispatch( aURL, UString(), FrameSearchFlag_SELF );
			if ( xDisp.Is() )
				xDisp->dispatch( aURL, Sequence<PropertyValue>() );
		}
	}

	// set the frame
	{
	OGuard aGuard(OMutex::getGlobalMutex());
	xBottomFrameRef = xNewFrame;
	}

}

void AdrBookContainer::createTopFrame(Window* pWin)
{
	if ( xTopFrameRef.is() ) xTopFrameRef->dispose();
	
	if(pTopWin) 
	{
		RemoveItem(TOP_WINDOW);
		delete pTopWin;
	}
	
	if(*ppDatMan!=NULL)
	{
		AdrDataManagerPtr pDatMan=*ppDatMan;			
		pTopWin=new AdrWindowContainer(this,pWin,WB_CLIPCHILDREN);

		long nSize=pDatMan->getBeamerSize();
		InsertItem(TOP_WINDOW, pTopWin, nSize, 1, 0, SWIB_PERCENTSIZE  );
	}
}

void AdrBookContainer::createBottomFrame(Window* pWin)
{
	if ( xBottomFrameRef.is() ) xBottomFrameRef->dispose();

	if(pBottomWin)
	{
		RemoveItem(BOTTOM_WINDOW);
		delete pBottomWin;
	}

	if(*ppDatMan!=NULL)
	{
		AdrDataManagerPtr pDatMan=*ppDatMan;
		pBottomWin=new AdrWindowContainer(this,pWin,WB_CLIPCHILDREN);
		pBottomWin->SetBackground();          
		pBottomWin->SetPaintTransparent(TRUE);
		long nSize=pDatMan->getViewSize();
		InsertItem(BOTTOM_WINDOW, pBottomWin, nSize, 1, 0, SWIB_PERCENTSIZE  );
	}
}

