/*************************************************************************
 *
 *  $RCSfile: basepage.hxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: hr $ $Date: 2003/03/25 16:01:57 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _ADR_BASEPAGE_HXX
#define _ADR_BASEPAGE_HXX

#ifndef _USR_USTRING_HXX
#include <usr/ustring.hxx>
#endif

#ifndef _SV_TABPAGE_HXX //autogen
#include <sv/tabpage.hxx>
#endif

#ifndef _SMART_COM_SUN_STAR_REGISTRY_MERGECONFLICTEXCEPTION_HXX_
#include <smart/com/sun/star/registry/MergeConflictException.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_REGISTRY_XSIMPLEREGISTRY_HXX_
#include <smart/com/sun/star/registry/XSimpleRegistry.hxx>
#endif

#ifndef _SVARRAY_HXX
#include <svtools/svarray.hxx>
#endif

#ifndef _ADR_FIELDDSC_HXX
#include "fielddsc.hxx"
#endif

#ifndef _ADR_DATMAN_HXX
#include "datman.hxx"
#endif

#ifndef _ADR_FRAMESET_HXX
#include "frameset.hxx"
#endif

class AdrBasePage: public TabPage
{
private:

	AdrDataManagerHdl		ppDatMan;
	AdrFieldList			aFieldList;
	AdrFrameSet				aFrameSet;

	USHORT					nCols;
	long					nFixedTextWidth;
	
	Point					FindPos(Window *pField);

protected:
	
	Size					aOriginalSize;
	virtual	void			Resize();


	BOOL					MakeField();

	AdrDataManagerHdl		GetDataManager() {return ppDatMan;}
	
public:
							AdrBasePage( Window* pParent,AdrDataManagerHdl ppDatMan, 
									WinBits nWinStyle = 0 );
							AdrBasePage( Window* pParent,AdrDataManagerHdl ppDatMan, 
									const ResId& rResId);

							~AdrBasePage();
	
	virtual void			InitPage();

	virtual void			UpdateData();
	virtual void			GenerateFields();
	virtual void			RefreshFields();
	virtual void			SaveFields();

	AdrFieldDescriptionPtr	InsertToFieldList(Edit* pField, const UString& aClassName, 
										const Sequence<UString>& seqParas);
	void					RemoveFromFieldList(AdrFieldDescriptionPtr* pField);

	long					GetMaxFixTextWidth();
	void					SetFixTextWidth(long nWidth);
};



#endif


