/*************************************************************************
 *
 *  $RCSfile: servicemanager.cxx,v $
 *
 *  $Revision: 1.8 $
 *
 *  last change: $Author: jbu $ $Date: 2002/10/01 09:24:37 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

//_________________________________________________________________________________________________________________
//	my own includes
//_________________________________________________________________________________________________________________

#ifndef __FRAMEWORK_SERVICEMANAGER_HXX_
#include <classes/servicemanager.hxx>
#endif

#ifndef __FRAMEWORK_THREADHELP_THREADHELPBASE_HXX_
#include <threadhelp/threadhelpbase.hxx>
#endif

#ifndef __FRAMEWORK_THREADHELP_RESETABLEGUARD_HXX_
#include <threadhelp/resetableguard.hxx>
#endif

#ifndef __FRAMEWORK_SERVICES_H_
#include <services.h>
#endif

//_________________________________________________________________________________________________________________
//	interface includes
//_________________________________________________________________________________________________________________

#ifndef _COM_SUN_STAR_LANG_XINITIALIZATION_HPP_
#include <com/sun/star/lang/XInitialization.hpp>
#endif

#ifndef _COM_SUN_STAR_REGISTRY_XSIMPLEREGISTRY_HPP_
#include <com/sun/star/registry/XSimpleRegistry.hpp>
#endif

//_________________________________________________________________________________________________________________
//	includes of other projects
//_________________________________________________________________________________________________________________

#ifndef _COMPHELPER_PROCESSFACTORY_HXX_
#include <comphelper/regpathhelper.hxx>
#endif

#ifndef _CPPUHELPER_SERVICEFACTORY_HXX_
#include <cppuhelper/servicefactory.hxx>
#endif
#ifndef _CPPUHELPER_BOOTSTRAP_HXX_
#include <cppuhelper/bootstrap.hxx>
#endif

#ifndef _VOS_PROCESS_HXX_
#include <vos/process.hxx>
#endif

#ifndef _VOS_PROFILE_HXX_
#include <vos/profile.hxx>
#endif

#ifndef _OSL_FILE_HXX_
#include <osl/file.hxx>
#endif

//_________________________________________________________________________________________________________________
//	includes of my own project
//_________________________________________________________________________________________________________________

//_________________________________________________________________________________________________________________
//	namespace
//_________________________________________________________________________________________________________________

namespace framework{

using namespace ::osl									;
using namespace ::rtl									;
using namespace	::comphelper							;
using namespace	::cppu									;
using namespace ::com::sun::star                        ;
using namespace ::com::sun::star::uno					;
using namespace ::com::sun::star::lang					;
using namespace ::com::sun::star::registry				;

//_________________________________________________________________________________________________________________
//	non exported const
//_________________________________________________________________________________________________________________

//_________________________________________________________________________________________________________________
//	non exported definitions
//_________________________________________________________________________________________________________________

//_________________________________________________________________________________________________________________
//	declarations
//_________________________________________________________________________________________________________________

sal_Int32							ServiceManager::m_nRefCount						=	0		;
Reference< XMultiServiceFactory >*	ServiceManager::m_pGlobalServiceManager			=	NULL	;
Reference< XMultiServiceFactory >*	ServiceManager::m_pSimpleGlobalServiceManager	=	NULL	;
Reference< XMultiServiceFactory >*	ServiceManager::m_pSharedServiceManager			=	NULL	;
Reference< XMultiServiceFactory >*	ServiceManager::m_pPrivateServiceManager		=	NULL	;

//*****************************************************************************************************************
//	constructor
//*****************************************************************************************************************
ServiceManager::ServiceManager()
{
	// Global access, must be guarded (multithreading!).
    ResetableGuard aGuard( LockHelper::getGlobalLock() );
	++m_nRefCount;
}

//*****************************************************************************************************************
//	destructor
//*****************************************************************************************************************
ServiceManager::~ServiceManager()
{
	// Global access, must be guarded (multithreading!).
    ResetableGuard aGuard( LockHelper::getGlobalLock() );

	if( m_nRefCount == 1 )
	{
		if( m_pGlobalServiceManager != NULL )
		{
			*m_pGlobalServiceManager	=	Reference< XMultiServiceFactory >()	;
			m_pGlobalServiceManager		=	NULL								;
		}
		if( m_pSimpleGlobalServiceManager != NULL )
		{
			*m_pSimpleGlobalServiceManager	=	Reference< XMultiServiceFactory >()	;
			m_pSimpleGlobalServiceManager	=	NULL								;
		}
		if( m_pSharedServiceManager != NULL )
		{
			*m_pSharedServiceManager	=	Reference< XMultiServiceFactory >()	;
			m_pSharedServiceManager		=	NULL								;
		}
		if( m_pPrivateServiceManager != NULL )
		{
			*m_pPrivateServiceManager	=	Reference< XMultiServiceFactory >()	;
			m_pPrivateServiceManager	=	NULL								;
		}
	}

	--m_nRefCount;
}

//*****************************************************************************************************************
//	public method
//*****************************************************************************************************************
Reference< XMultiServiceFactory > ServiceManager::getGlobalUNOServiceManager()
{
    // jbu: function is obsolete and should be removed by as in near future
    // switched to default bootstrapping mechanism as fallback
    Reference< XComponentContext > rCtx = 
        defaultBootstrap_InitialComponentContext();
    return Reference< XMultiServiceFactory > ( rCtx->getServiceManager() , UNO_QUERY );

	// Algorithm: (create global manager one times only!)
	//		a)	get paths to user.rdb and applicat.rdb
	//		b)	open rdb files (if user.rdb not exist - create it)
	//		c)	initialize component context
	//		d)	set service manager of component context as static member
// 	if( m_pGlobalServiceManager == NULL )
// 	{
// 		// Global access, must be guarded (multithreading!).
//         ResetableGuard aGuard( LockHelper::getGlobalLock() );

// 		try
// 		{
//             // a) (getPath... comes from comphelper)
//             OUString sNameUserRegistry		= getPathToUserRegistry()	;
//             OUString sNameSystemRegistry	= getPathToSystemRegistry()	;

//             // b)
//             Reference< XSimpleRegistry > xUserRegistry	( ::cppu::createSimpleRegistry() );
//             Reference< XSimpleRegistry > xSystemRegistry( ::cppu::createSimpleRegistry() );

//             if	(
//                 ( xUserRegistry.is()			==	sal_True	)	&&
//                 ( sNameUserRegistry.getLength()	>	0			)
//                 )
//             {
//                 xUserRegistry->open( sNameUserRegistry, sal_False, sal_True ); // try to open/create it writable ... (second param = sal_False)
//                 if( xUserRegistry->isValid() == sal_False )
//                 {
//                     xUserRegistry->open( sNameUserRegistry, sal_True, sal_True ); // try to open/create it readonly ... (second param = sal_True)
//                 }
//             }

//             if	(
//                 ( xSystemRegistry.is()				==	sal_True	)	&&
//                 ( sNameSystemRegistry.getLength()	>	0			)
//                 )
//             {
//                 xSystemRegistry->open( sNameSystemRegistry, sal_True, sal_False );
//             }

//             if	(
//                 ( xSystemRegistry.is()			==	sal_True	)	&&
//                 ( xSystemRegistry->isValid()	==	sal_True	)
//                 )
//             {
//                 Sequence< Any > lNestedParameters(1);
//                 lNestedParameters[0] <<= xSystemRegistry;
//                 if	(
//                     ( xUserRegistry.is()			==	sal_True	)	&&
//                     ( xUserRegistry->isValid()		==	sal_True	)
//                     )
//                 {
//                     lNestedParameters.realloc(2);
//                     lNestedParameters[1] <<= xUserRegistry;
//                 }

//                 Reference < XSimpleRegistry > xNestedRegistry( ::cppu::createNestedRegistry() );
//                 Reference< XInitialization > xInit( xNestedRegistry, UNO_QUERY );
//                 xInit->initialize( lNestedParameters );

//                 // c)
//                 Reference< XComponentContext > xContext( ::cppu::bootstrap_InitialComponentContext( xNestedRegistry ) );
//                 // d)
//                 static Reference< XMultiServiceFactory > xManager( xContext->getServiceManager(), UNO_QUERY );
//                 m_pGlobalServiceManager = &xManager;
//             }
// 		}
// 		catch(...)
// 		{
// 			// If an exception is thrown - we set the return value to NULL!
// 			// Its neccessary, because it can be, that we have overwrite the default from beginning of this method with an "HALF-VALID" value!
// 			LOG_ASSERT( sal_False, "ServiceManager::getGlobalUNOServiceManager()\nException detected!\n" )
// 			m_pGlobalServiceManager = NULL;
// 		}
// 	}

// 	return *m_pGlobalServiceManager;
}

//*****************************************************************************************************************
//	public method
//*****************************************************************************************************************
Reference< XMultiServiceFactory > ServiceManager::getSimpleGlobalUNOServiceManager()
{
	LOG_ASSERT( sal_False, "ServiceManager::getSimpleGlobalUNOServiceManager()\nPlease don't use it yet! cppu don't support these feature!\n" )
	return Reference< XMultiServiceFactory >();
/*
	// Algorithm: (create global manager one times only!)
	//		a)	get uninitialized manager from cppu helper method
	//		b)	get path to applicat.rdb
	//		c)	open rdb file (don't create it if it not exist)
	//		d)	initialize manager
	//		e)	if created manager valid set it on static member

	if( m_pSimpleGlobalServiceManager == NULL )
	{
		// Global access, must be guarded (multithreading!).
		ResetableGuard aGuard( m_aLock );;

		try
		{
			// a)
			static Reference< XMultiServiceFactory > xManager = createServiceFactory();
			if( xManager.is() == sal_True )
			{
				// b) (getPath... comes from comphelper)
				OUString sNameSystemRegistry = getPathToSystemRegistry();

				// c)
				Reference< XSimpleRegistry > xSystemRegistry( xManager->createInstance( SERVICENAME_SIMPLEREGISTRY ), UNO_QUERY );
				if	(
						( xSystemRegistry.is()				==	sal_True	)	&&
						( sNameSystemRegistry.getLength()	>	0			)
					)
				{
					xSystemRegistry->open( sNameSystemRegistry, sal_True, sal_False );
				}

				// d)
				if	(
			 			( xSystemRegistry.is()			==	sal_True	)	&&
						( xSystemRegistry->isValid()	==	sal_True	)
					)
				{
					Sequence< Any > lNestedParameters(1);
					lNestedParameters[0] <<= xSystemRegistry;

					Reference< XSimpleRegistry > xNestedRegistry( xManager->createInstanceWithArguments( SERVICENAME_NESTEDREGISTRY, lNestedParameters ), UNO_QUERY );
					if( xNestedRegistry.is() == sal_True )
					{
						Sequence< Any > lInitParameter(1);
						lInitParameter[0] <<= xNestedRegistry;

						Reference< XInitialization > xInit( xManager, UNO_QUERY );
						if( xInit.is() == sal_True )
						{
							xInit->initialize( lInitParameter );
							m_pSimpleGlobalServiceManager = &xManager;
						}
					}
				}
			}
		}
		catch(...)
		{
			// If an exception is thrown - we set the return value to NULL!
			// Its neccessary, because it can be, that we have overwrite the default from beginning of this method with an "HALF-VALID" value!
			LOG_ASSERT( sal_False, "ServiceManager::getSimpleGlobalUNOServiceManager()\nException detected!\n" )
			m_pSimpleGlobalServiceManager = NULL;
		}
	}

	return *m_pSimpleGlobalServiceManager;
*/
}

//*****************************************************************************************************************
//	public method
//*****************************************************************************************************************
Reference< XMultiServiceFactory > ServiceManager::getSharedUNOServiceManager( const OUSTRING& sUserRegistryFile )
{
	// Algorithm: (create global manager one times only!)
	//		a)	get path to applicat.rdb (user.rdb is given by user)
	//		b)	open rdb files (if user.rdb not exist - create it)
	//		c)	initialize component context
	//		d)	set component context's service manager as static  member

	if( m_pSharedServiceManager == NULL )
	{
    	// Global access, must be guarded (multithreading!).
        ResetableGuard aGuard( LockHelper::getGlobalLock() );

		try
		{
            // a) (getPath... comes from comphelper)
            OUString sNameUserRegistry		= sUserRegistryFile			;
            OUString sNameSystemRegistry	= getPathToSystemRegistry()	;

            // b)
            Reference< XSimpleRegistry > xUserRegistry	( ::cppu::createSimpleRegistry() );
            Reference< XSimpleRegistry > xSystemRegistry( ::cppu::createSimpleRegistry() );

            if	(
                ( xUserRegistry.is()			==	sal_True	)	&&
                ( sNameUserRegistry.getLength()	>	0			)
                )
            {
                xUserRegistry->open( sNameUserRegistry, sal_False, sal_True ); // try to open/create it writable ... (second param = sal_False)
                if( xUserRegistry->isValid() == sal_False )
                {
                    xUserRegistry->open( sNameUserRegistry, sal_True, sal_True ); // try to open/create it readonly ... (second param = sal_True)
                }
            }

            if	(
                ( xSystemRegistry.is()				==	sal_True	)	&&
                ( sNameSystemRegistry.getLength()	>	0			)
                )
            {
                xSystemRegistry->open( sNameSystemRegistry, sal_True, sal_False );
            }

            if	(
                ( xSystemRegistry.is()			==	sal_True	)	&&
                ( xSystemRegistry->isValid()	==	sal_True	)
                )
            {
                Sequence< Any > lNestedParameters(1);
                lNestedParameters[0] <<= xSystemRegistry;
                if	(
                    ( xUserRegistry.is()			==	sal_True	)	&&
                    ( xUserRegistry->isValid()		==	sal_True	)
                    )
                {
                    lNestedParameters.realloc(2);
                    lNestedParameters[1] <<= xUserRegistry;
                }

                Reference < XSimpleRegistry > xNestedRegistry( ::cppu::createNestedRegistry() );
                Reference< XInitialization > xInit( xNestedRegistry, UNO_QUERY );
                xInit->initialize( lNestedParameters );

                // c)
                Reference< XComponentContext > xContext( ::cppu::bootstrap_InitialComponentContext( xNestedRegistry ) );
                // d)
                static Reference< XMultiServiceFactory > xManager( xContext->getServiceManager(), UNO_QUERY );
                m_pSharedServiceManager = &xManager;
			}
		}
		catch(...)
		{
			// If an exception is thrown - we set the return value to NULL!
			// Its neccessary, because it can be, that we have overwrite the default from beginning of this method with an "HALF-VALID" value!
			LOG_ASSERT( sal_False, "ServiceManager::getSharedUNOServiceManager()\nException detected!\n" )
			m_pSharedServiceManager = NULL;
		}
	}

	return *m_pSharedServiceManager;
}

//*****************************************************************************************************************
//	public method
//*****************************************************************************************************************
Reference< XMultiServiceFactory > ServiceManager::getPrivateUNOServiceManager( const OUSTRING& sUserRegistryFile )
{
	// Algorithm: (create global manager one times only!)
	//		a)	open rdb file (if it not exist - create it)
	//		b)	initialize component context
	//		c)	set component context's service manager as static member

	if( m_pPrivateServiceManager == NULL )
	{
    	// Global access, must be guarded (multithreading!).
        ResetableGuard aGuard( LockHelper::getGlobalLock() );

		try
		{
            // a)
            Reference< XSimpleRegistry > xUserRegistry( ::cppu::createSimpleRegistry() );

            if	(
                ( xUserRegistry.is()			==	sal_True	)	&&
                ( sUserRegistryFile.getLength()	>	0			)
                )
            {
                xUserRegistry->open( sUserRegistryFile, sal_False, sal_True ); // try to open/create it writable ... (second param = sal_False)
                if( xUserRegistry->isValid() == sal_False )
                {
                    xUserRegistry->open( sUserRegistryFile, sal_True, sal_True ); // try to open/create it readonly ... (second param = sal_True)
                }
            }

            if	(
                ( xUserRegistry.is()		==	sal_True	)	&&
                ( xUserRegistry->isValid()	==	sal_True	)
                )
            {
                Sequence< Any > lNestedParameters(1);
                lNestedParameters[0] <<= xUserRegistry;

                Reference < XSimpleRegistry > xNestedRegistry( ::cppu::createNestedRegistry() );
                Reference< XInitialization > xInit( xNestedRegistry, UNO_QUERY );
                xInit->initialize( lNestedParameters );

                // b)
                Reference< XComponentContext > xContext( ::cppu::bootstrap_InitialComponentContext( xNestedRegistry ) );
                // c)
                static Reference< XMultiServiceFactory > xManager( xContext->getServiceManager(), UNO_QUERY );
                m_pPrivateServiceManager = &xManager;
			}
		}
		catch(...)
		{
			// If an exception is thrown - we set the return value to NULL!
			// Its neccessary, because it can be, that we have overwrite the default from beginning of this method with an "HALF-VALID" value!
			LOG_ASSERT( sal_False, "ServiceManager::getPrivateUNOServiceManager()\nException detected!\n" )
			m_pPrivateServiceManager = NULL;
		}
	}

	return *m_pPrivateServiceManager;
}

}	//	namespace framework
