/*************************************************************************
 *
 *  $RCSfile: mailsrv.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: hr $ $Date: 2000/12/07 14:20:45 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#ifndef _MAILSRV_HXX
#define _MAILSRV_HXX

// include ---------------------------------------------------------------

#ifdef OS2
#include <tools/solar.h>
#if _SOLAR__PRIVATE
#ifndef _DLL_
#define _DLL_ 1			// landet in der SFX-DLL
#endif
#endif
#endif

#ifndef _APP_HXX //autogen
#include <vcl/svapp.hxx>
#endif
#ifndef _SFXHINT_HXX //autogen
#include <svtools/hint.hxx>
#endif
#include "mailenum.hxx"
#include "mailbook.hxx"

// define ----------------------------------------------------------------

#define MAIL_LIBRARY()	pImpl->pLibrary
#define MAIL_RES(nId)	ResId( nId, GetSystem().GetResMgr() )

// forward ---------------------------------------------------------------

class Link;
class DirEntry;
class Window;
class ResMgr;
class MailServer;
class Mail;
class IncomingMail;
class OutgoingMail;
class MessageRefList;
class MailFolderManager;
class SvStringsDtor;
class INetCoreMIMEMessage;
class INetCoreMailer;

struct MailServer_Impl;
struct MessageRef;

// prototypes ------------------------------------------------------------

void ExtractMailFromMessage( const INetCoreMIMEMessage&, INetCoreMailer*,
							 FASTBOOL, OutgoingMail&, FASTBOOL& );

// callback function -----------------------------------------------------

typedef BOOL (*GetEmailNames)( SvStringsDtor& rList );
typedef MailFolderManager* (*GetFolderManager)( const String& rName );

// structs ---------------------------------------------------------------

struct MailReceiver {
	String      		aUserName;
	MailReceiverRole  	eRole;
};

struct MailAttachFile {
	String      		aFile;
	String      		aName;
};

// class MailHint --------------------------------------------------------

class MailHint : public SfxHint
{
	MailServer*	_pServer;
	const Mail*	_pMail;
	MailAction	_eAction;

public:
				TYPEINFO();

				MailHint( MailServer* pServer, MailAction eAction,
						  const Mail* pMail = 0 )
				:	_pServer( pServer ),
					_eAction( eAction ),
					_pMail( pMail )
				{}

	MailServer*	GetServer() const { return _pServer; }
	const Mail*	GetMail() const	{ return _pMail; }
	MailAction	GetAction() const { return _eAction; }
};

// class MailServer ------------------------------------------------------

class MailServer
{
friend class MailSystem;

private:
	const MailSystem&	rSystem;

	// nicht implementiert
	MailServer( const MailServer& );
	MailServer& operator=( const MailServer& );

#if _SOLAR__PRIVATE
	void				PrepareMailList();
#endif

protected:
	FASTBOOL			bLogin;
	FASTBOOL			bLoadMails;
	MailState			eState;
	MailDriver			eDriver;
	MailServer_Impl*	pImpl;
	MessageRefList* 	pRefList;
	MailFolderManager*	pFolderManager;
	String				sUser;
	GetEmailNames		fnGetEmailNames;
	GetFolderManager	fnGetFolderManager;

	MailServer( const MailSystem& rSys );

	void				LoadLocalMails();
	const MailSystem& 	GetSystem() const { return rSystem; }
	void 				SetStatusText( const String& rTxt )
							{ GetpApp()->ShowStatusText( rTxt ); }
	void 				HideStatusText()
							{ GetpApp()->HideStatusText(); }
	void 				SetProgress( ULONG nCur, ULONG nMax,
									 USHORT nResId, BOOL bHide );

public:
	virtual 					~MailServer();
	virtual MailState			Send( OutgoingMail& rMail );

	virtual String				GetAddresses( Window* pParent,
											  const String& rOldAddr );

	virtual MailAddressBook		GetDirectory();
	virtual MailAddressBook		GetMailList();
	virtual MailAddressBook		GetPrivateList();

	virtual void				LoadMailList( MessageRefList& rList,
											  BOOL bAll );
	virtual void				LoadMailAttributes(
									MessageRef* pRef, MessageRef* pNew,
									OutgoingMail& rMail, BOOL bAttach );
	virtual BOOL				MarkMailAsRead( MessageRef* pRef );
	virtual BOOL				RemoveMail( MessageRef* pRef );
	virtual BOOL				DeleteFromServer( SvStringsDtor* pIdList );
	virtual void				ClearMailReference( MessageRef* );
	virtual BOOL				HasNewMail();

	USHORT				GetMailCount();
	void				UpdateMailList( BOOL bAll = FALSE );
	IncomingMail*		GetMail( USHORT nIndex,
								 BOOL bAttach = TRUE, BOOL bLast = FALSE );
	IncomingMail*		NextMail( const IncomingMail* pCurMail );
	IncomingMail*		PrevMail( const IncomingMail* pCurMail );
	BOOL				HasNextMail( const IncomingMail* pCurMail );
	BOOL				HasPrevMail( const IncomingMail* pCurMail );
	ULONG				GetPos( const IncomingMail& rMail ) const;
	void 				ReadMail( USHORT nIndex, BOOL bLast );
	const String&		GetLastId() const;
	void				SetLastId( const String& rId );

	ResMgr*				GetResMgr();
	MailState			GetState() 	{ return eState; }
	MailDriver			GetDriver() { return eDriver; }
	const String&		GetUser()	{ return sUser; }
	BOOL				IsEqual( MailDriver eCmpDriver,
								 const String& rCmpName,
								 const String& rCmpPath ) const;

	void				SetEmailNamesFunc( GetEmailNames pFunc )
							{ fnGetEmailNames = pFunc; }
	void				SetFolderFunc( GetFolderManager pFunc )
							{ fnGetFolderManager = pFunc; }
	BOOL				GetEmailAddresses( SvStringsDtor& rNameList );

	void				SetHintLink( const Link &rLink );
	void 				Hint( MailAction eAction, const Mail *pMail = 0 );

	static IncomingMail*	CreateMail( Mail* pCopy = 0 );
	static String			GetContentType4Ext( const String& rExt );
	static String			GetExt4ContentType( const String& rType );
	static FASTBOOL			GetTempFile( DirEntry& rFile,
										 const String& rMask );
};



#endif

