/*************************************************************************
 *
 *  $RCSfile: actmeta.cxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 16:30:13 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include <main.hxx>
#include <outact.hxx>
#include <vcl/virdev.hxx>
#include <vcl/bitmapex.hxx>

// ---------------------------------------------------------------

CGMMetaOutAct::CGMMetaOutAct( CGM& rCGM ) :
	CGMOutAct ( rCGM )
{

};

// ---------------------------------------------------------------

void CGMMetaOutAct::DrawBitmap( CGMBitmapDescriptor* pBmpDesc )
{
	if ( pBmpDesc->mbStatus && pBmpDesc->mpBitmap )
	{
		if ( mpCGM->mpGraphic && mpCGM->mpVirDev )
		{
			FloatPoint aOrigin = pBmpDesc->mnOrigin;
			double fdx = pBmpDesc->mndx;
			double fdy = pBmpDesc->mndy;

			mpCGM->ImplMapPoint( aOrigin );
			mpCGM->ImplMapX( fdx );
			mpCGM->ImplMapY( fdy );

			BitmapEx aBmpEx( *(pBmpDesc->mpBitmap) );
			long nRotation = -(long)( (double)pBmpDesc->mnOrientation * 10 ) ;
			if ( !nRotation )
			{
				Color aColor( COL_TRANSPARENT );
				aBmpEx.Rotate( nRotation , aColor );
				double fSin = sin( (-pBmpDesc->mnOrientation ) * (double)57.29577951308 );
				double fCos = cos( (-pBmpDesc->mnOrientation ) * (double)57.29577951308 );
				double fx = -( fdx / 2 );
				double fy = -( fdy / 2 );
				double fxdiff = fCos * fx + fSin * fy;
				double fydiff = -fSin * fx - fCos * fy;
				aOrigin.X -= fxdiff;
				aOrigin.Y -= fydiff;
			}
			mpCGM->mpVirDev->DrawBitmapEx( Point( (long)aOrigin.X, (long)aOrigin.Y ),
				Size( (long)fdx, (long)fdy ), aBmpEx );
		}
	}
};

// ---------------------------------------------------------------

void CGMMetaOutAct::DrawRectangle( FloatRect& rRect )
{
	Polygon aPolygon( 4 );
	aPolygon.SetPoint( Point( (long)rRect.Left, (long)rRect.Top ), 0 );
	aPolygon.SetPoint( Point( (long)rRect.Right, (long)rRect.Top ), 1 );
	aPolygon.SetPoint( Point( (long)rRect.Right, (long)rRect.Bottom ), 2 );
	aPolygon.SetPoint( Point( (long)rRect.Left, (long)rRect.Bottom ), 3 );
	DrawPolygon( aPolygon );
}

// ---------------------------------------------------------------

void CGMMetaOutAct::DrawPolygon( Polygon& rPolygon )
{
	sal_uInt32			nColor;

	if ( mpCGM->pElement->nAspectSourceFlags & ASF_LINETYPE )
		nColor = mpCGM->pElement->pLineBundle->GetColor();
	else
		nColor = mpCGM->pElement->aLineBundle.GetColor();

	mpCGM->mpVirDev->SetLineColor( BMCOL( nColor ) );

	FillInteriorStyle eFillStyle;
	if ( mpCGM->pElement->nAspectSourceFlags & ASF_FILLINTERIORSTYLE )
	{
		nColor = mpCGM->pElement->pFillBundle->GetColor();
		eFillStyle = mpCGM->pElement->pFillBundle->eFillInteriorStyle;
	}
	else
	{
		nColor = mpCGM->pElement->aFillBundle.GetColor();
		eFillStyle = mpCGM->pElement->aFillBundle.eFillInteriorStyle;
	}

	mpCGM->mpVirDev->SetFillColor( BMCOL( nColor ) );

	switch ( eFillStyle )
	{
		case FIS_EMPTY :
			mpCGM->mpVirDev->SetDrawMode( DRAWMODE_NOFILL );
			break;
		default:
			mpCGM->mpVirDev->SetDrawMode( DRAWMODE_DEFAULT );
	}
	mpCGM->mpVirDev->DrawPolygon( rPolygon );
};

// ---------------------------------------------------------------

void CGMMetaOutAct::DrawPolyLine( Polygon& rPolygon )
{
	sal_uInt32			nColor;

	if ( mpCGM->pElement->nAspectSourceFlags & ASF_LINETYPE )
		nColor = mpCGM->pElement->pLineBundle->GetColor();
	else
		nColor = mpCGM->pElement->aLineBundle.GetColor();

	mpCGM->mpVirDev->SetLineColor( BMCOL( nColor ) );

	FillInteriorStyle eFillStyle;
	if ( mpCGM->pElement->nAspectSourceFlags & ASF_FILLINTERIORSTYLE )
	{
		nColor = mpCGM->pElement->pFillBundle->GetColor();
		eFillStyle = mpCGM->pElement->pFillBundle->eFillInteriorStyle;
	}
	else
	{
		nColor = mpCGM->pElement->aFillBundle.GetColor();
		eFillStyle = mpCGM->pElement->aFillBundle.eFillInteriorStyle;
	}

	mpCGM->mpVirDev->SetFillColor( BMCOL( nColor ) );
	switch ( eFillStyle )
	{
		case FIS_EMPTY :
			mpCGM->mpVirDev->SetDrawMode( DRAWMODE_NOFILL );
			break;
		default:
			mpCGM->mpVirDev->SetDrawMode( DRAWMODE_DEFAULT );
	}
	mpCGM->mpVirDev->DrawPolyLine( rPolygon );
};

// ---------------------------------------------------------------

void CGMMetaOutAct::DrawPolybezier( Polygon& rPolygon )
{
	DrawPolyLine( rPolygon );
};
