
package org.netbeans.modules.openoffice.wizard.actions.idl;

import java.util.ResourceBundle;
import org.netbeans.modules.openoffice.wizard.util.Create;
import org.netbeans.modules.openoffice.wizard.util.ServiceCreator;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.actions.NodeAction;

public class CreateServiceAction extends NodeAction implements Create
{
       
    private static final ResourceBundle bundle = ResourceBundle.getBundle("org/netbeans/modules/openoffice/wizard/actions/idl/Bundle");    
    
    public CreateServiceAction()
    {
    }

    protected void performAction(Node anode[])
    {
        if(enable(anode))
            ((ServiceCreator)anode[0].getCookie(ServiceCreator.class)).createService();
    }

    protected boolean enable(Node anode[])
    {
        if(anode.length != 1)
            return false;
        if(anode[0].getCookie(ServiceCreator.class)!= null)
        {
            return true;
        }
        else
        {
            org.openide.nodes.Node.Cookie cookie = anode[0].getCookie(ServiceCreator.class);
            return false;
        }
    }

    public String getName()
    {
        return bundle.getString("TXT_CreateService");
    }

    public String toString()
    {
        return bundle.getString("TXT_Service");
    }

    public HelpCtx getHelpCtx()
    {
        return HelpCtx.DEFAULT_HELP;
    }

    public boolean isEnabled(Node anode[])
    {
        return enable(anode);
    }

    
    
}
