
package org.netbeans.modules.openoffice.wizard.actions.idl;

import java.util.ResourceBundle;
import org.netbeans.modules.openoffice.wizard.util.Create;
import org.netbeans.modules.openoffice.wizard.util.StructMemberCreator;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.actions.NodeAction;

public class CreateStructMemberAction extends NodeAction
    implements Create
{

    public CreateStructMemberAction()
    {
    }

    protected void performAction(Node anode[])
    {
        if(enable(anode))
            ((StructMemberCreator)anode[0].getCookie(StructMemberCreator.class)).createStructMember();
    }

    protected boolean enable(Node anode[])
    {
        return anode.length == 1 && anode[0].getCookie(StructMemberCreator.class) != null;
    }

    public String getName()
    {
        return ResourceBundle.getBundle("org/netbeans/modules/openoffice/wizard/actions/idl/Bundle").getString("TXT_CreateMember");
    }

    public String toString()
    {
        return ResourceBundle.getBundle("org/netbeans/modules/openoffice/wizard/actions/idl/Bundle").getString("TXT_StructMember");
    }

    public HelpCtx getHelpCtx()
    {
        return HelpCtx.DEFAULT_HELP;
    }

    public boolean isEnabled(Node anode[])
    {
        return enable(anode);
    }


 }
