

package org.netbeans.modules.openoffice.wizard.nodes;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.FeatureDescriptor;
import java.util.ResourceBundle;
import org.netbeans.modules.openoffice.wizard.panels.idl.*;
import org.netbeans.modules.openoffice.wizard.keys.*;
import org.netbeans.modules.openoffice.wizard.util.*;
import org.netbeans.modules.openoffice.wizard.actions.idl.*;
import org.openide.TopManager;
import org.openide.nodes.*;
import org.openide.util.actions.SystemAction;
import org.openide.DialogDescriptor;
import org.netbeans.modules.openoffice.*;
import java.util.Vector;
import org.openide.nodes.Node;
import java.util.StringTokenizer;



public class InterfaceNode extends MovableNode
    implements org.openide.nodes.Node.Cookie, OperationCreator, AttributeCreator
{

    public InterfaceNode(NameKey namedkey)
    {
        super(namedkey);
        getCookieSet().add(this);
        setName(namedkey.getName());
        setIconBase("org/netbeans/modules/openoffice/wizard/ui/interface");
    }

    public String generateSelf(int i)
    {
        String s = new String();
        String s1 = new String();
        for(int j = 0; j < i; j++)
              s1 = s1 + "    ";

        s = s1;
        s = s + "interface " + getName() + " ";
        if(((InterfaceKey)key).getbaseInterfaces().length() > 0)
            s = s + ": " + ((InterfaceKey)key).getbaseInterfaces() + " ";
        s = s + "{\n";
        Node anode[] = getChildren().getNodes();
        for(int k = 0; k < anode.length; k++)
            s = s + ((BaseNode)anode[k]).generateSelf(i + 1);

        s = s + s1 + "};\n";
        return s;
    }

    public SystemAction[] createActions()
    {
        return (new SystemAction[] {
//            SystemAction.get(CreateAttributeAction.class),
            SystemAction.get(CreateOperationAction.class), 
            SystemAction.get(DestroyAction.class), 
            SystemAction.get(EditAction.class)
        });
    }

    public void createOperation()
    {
        TopManager topmanager = TopManager.getDefault();
        final OperationPanel operationpanel = new OperationPanel();
        DialogDescriptor exdialogdescriptor = new DialogDescriptor(operationpanel, ResourceBundle.getBundle("org/netbeans/modules/openoffice/wizard/nodes/Bundle").getString("TXT_CreateOperation"));
        exdialogdescriptor.setButtonListener( new ActionListener() {

            public void actionPerformed(ActionEvent actionevent)
            {
                if(actionevent.getActionCommand().equals("OK"))
                { 
                        String s = operationpanel.getName();
                        String s1 = operationpanel.getReturnType();
                        String s2 = operationpanel.getParameters();
                        String s3 = operationpanel.getExceptions();
                   
                        boolean flag = operationpanel.isOneway();
                        OperationKey operationkey = new OperationKey(3, s, s1, s2, s3,  flag);
                        ((IDLBaseChildren)getChildren()).addKey(operationkey);                
                        }
                dialog.setVisible(false);
                dialog.dispose();
            }

        });
        dialog = topmanager.createDialog(exdialogdescriptor);
        dialog.setVisible(true);
        

    }

    public void createAttribute()
    {
        TopManager topmanager = TopManager.getDefault();
        final AttributePanel attributepanel = new AttributePanel();
        DialogDescriptor exdialogdescriptor = new DialogDescriptor(attributepanel, ResourceBundle.getBundle("org/netbeans/modules/openoffice/wizard/nodes/Bundle").getString("TXT_CreateAttribute"));
        exdialogdescriptor.setButtonListener( new ActionListener() {

            public void actionPerformed(ActionEvent actionevent)
            {
                if(actionevent.getActionCommand().equals("OK"))
                { 
                        String s = attributepanel.getName();
                        String s1 = attributepanel.getType();
                        boolean flag = attributepanel.isReadOnly();
                        AttributeKey attributekey = new AttributeKey(4, s, s1, flag);
                        ((IDLBaseChildren)getChildren()).addKey(attributekey);
                }
                dialog.setVisible(false);
                dialog.dispose();
            }

        });
        dialog = topmanager.createDialog(exdialogdescriptor);
        dialog.setVisible(true);
         
    }

    public BasePanel getEditPanel()
    {
        InterfacePanel interfacepanel = new InterfacePanel();
        interfacepanel.setName(getName());
        interfacepanel.setBase(((InterfaceKey)key).getbaseInterfaces());
       return interfacepanel;
    }

    public void reInit(BasePanel expanel)
    {
        if(expanel instanceof InterfacePanel)
        {
            String s = ((InterfacePanel)expanel).getName();
            String s1 = ((InterfacePanel)expanel).getBase();
            InterfaceKey interfacekey = (InterfaceKey)key;
            if(!s.equals(interfacekey.getName()))
            {
                setName(s);
                interfacekey.setName(s);
            }
            if(!s1.equals(interfacekey.getbaseInterfaces()))
                interfacekey.setBaseInterfaces(s1);
        } 
    }

   public void generateImports(Vector Imports1)
    {   
        StringTokenizer st = new StringTokenizer(((InterfaceKey)key).getbaseInterfaces(),","); 
        while (st.hasMoreTokens())
        {    
                String Import = OOTools.replaceSubStrings(st.nextToken().trim(),"::", "/");
                if((Import.length() > 0) && (!Imports1.contains(Import)))
                 { 
                   Imports1.add(Import);
                 }  
        }
        
        Node anode[] = getChildren().getNodes();
        for(int l = 0; l < anode.length; l++)
        {
            ((BaseNode)anode[l]).generateImports(Imports1);
            
        }  
    }    
    private static final String ICON_BASE = "org/netbeans/modules/openoffice/wizard/ui/interface";
    private Dialog dialog;
    

}
