/*************************************************************************
 *
 *  $RCSfile: process.c,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: vg $ $Date: 2003/04/15 17:41:37 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include "system.h"

#include <osl/process.h>


oslProcessError SAL_CALL osl_executeProcess(rtl_uString *ustrImageName,
											rtl_uString *ustrArguments[],
                                            sal_uInt32   nArguments,
											oslProcessOption Options,
											oslSecurity Security,
											rtl_uString *ustrWorkDir,
											rtl_uString *ustrEnvironment[],
                                            sal_uInt32   nEnvironmentVars,
											oslIOResource* pResources,
											oslProcess *pProcess)
{
	return osl_Process_E_Unknown;
}


oslProcessError SAL_CALL osl_terminateProcess(oslProcess Process)
{
	return osl_Process_E_Unknown;
}


oslProcess SAL_CALL osl_getProcess(oslProcessIdentifier Ident)
{
	return NULL;
}


void SAL_CALL osl_freeProcessHandle(oslProcess Process)
{
}


oslProcessError SAL_CALL osl_getProcessInfo(oslProcess Process, oslProcessData Fields, oslProcessInfo* pInfo)
{
	return osl_Process_E_Unknown;
}


oslProcessError SAL_CALL osl_joinProcess(oslProcess Process)
{
	return osl_Process_E_None;
}


oslProcessError SAL_CALL osl_getExecutableFile(rtl_uString **ustrFile)
{
    sal_Char  Buffer[PATH_MAX] = "";

#if OSL_DEBUG_LEVEL > 1
        fprintf(stderr,"In  osl_getExecutableFile\n");
#endif

    if ( ustrFile == NULL )
    {
#if OSL_DEBUG_LEVEL > 1
        fprintf(stderr,"Out  osl_getExecutableFile, invalid argument\n");
#endif
        return osl_Process_E_InvalidError;   /* this error code is inexact */
					     /* may need a new error code */
    }

    strcpy( Buffer, "test");
    rtl_uString_newFromAscii(ustrFile,Buffer);

    return osl_Process_E_Unknown;
}



sal_uInt32 SAL_CALL osl_getCommandArgCount()
{
	return 0;
}


oslProcessError SAL_CALL osl_getCommandArg( sal_uInt32 nArg, rtl_uString **strCommandArg)
{
    sal_Char  Buffer[PATH_MAX] = "";

#if OSL_DEBUG_LEVEL > 1
        fprintf(stderr,"In  osl_getCommandArg\n");
#endif

    if ( strCommandArg == NULL )
    {
#if OSL_DEBUG_LEVEL > 1
        fprintf(stderr,"Out  osl_getCommandArg, invalid argument\n");
#endif
        return osl_Process_E_InvalidError;   /* this error code is inexact */
					     /* may need a new error code */
    }

    strcpy( Buffer, "test");
    rtl_uString_newFromAscii(strCommandArg,Buffer);

    return osl_Process_E_Unknown;
}


oslProcessError SAL_CALL osl_getEnvironment(rtl_uString *ustrVar, rtl_uString **ustrValue)
{
    sal_Char  Buffer[PATH_MAX] = "";

#if OSL_DEBUG_LEVEL > 1
        fprintf(stderr,"In  osl_getEnvironment\n");
#endif

    if ( ustrValue == NULL )
    {
#if OSL_DEBUG_LEVEL > 1
        fprintf(stderr,"Out  osl_getEnvironment, invalid argument\n");
#endif
        return osl_Process_E_InvalidError;   /* this error code is inexact */
					     /* may need a new error code */
    }

    strcpy( Buffer, "test");
    rtl_uString_newFromAscii(ustrValue,Buffer);

    return osl_Process_E_Unknown;
}


oslProcessError SAL_CALL osl_getIOResources(oslIOResource Resources[], sal_uInt32 Max)
{
	return osl_Process_E_NotFound;
}


