/*************************************************************************
 *
 *  $RCSfile: asciiopt.hxx,v $
 *
 *  $Revision: 1.7 $
 *
 *  last change: $Author: dr $ $Date: 2002/08/15 09:29:09 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

// ============================================================================

#ifndef SC_ASCIIOPT_HXX
#define SC_ASCIIOPT_HXX

#ifndef _STRING_HXX //autogen
#include <tools/string.hxx>
#endif
#ifndef _DIALOG_HXX //autogen
#include <vcl/dialog.hxx>
#endif
#ifndef _BUTTON_HXX //autogen
#include <vcl/button.hxx>
#endif
#ifndef _FIXED_HXX //autogen
#include <vcl/fixed.hxx>
#endif
#ifndef _LSTBOX_HXX //autogen
#include <vcl/lstbox.hxx>
#endif
#ifndef _COMBOBOX_HXX //autogen
#include <vcl/combobox.hxx>
#endif
#ifndef _FIELD_HXX //autogen
#include <vcl/field.hxx>
#endif
#ifndef _STREAM_HXX //autogen
#include <tools/stream.hxx>
#endif
#ifndef _SVX_TXENCBOX_HXX
#include <svx/txencbox.hxx>
#endif

#ifndef _SC_CSVTABLEBOX_HXX
#include "csvtablebox.hxx"
#endif


// ============================================================================

class ScAsciiOptions
{
private:
	BOOL		bFixedLen;
	String		aFieldSeps;
	BOOL		bMergeFieldSeps;
	sal_Unicode	cTextSep;
	CharSet		eCharSet;
	BOOL		bCharSetSystem;
	long		nStartRow;
	USHORT		nInfoCount;
    xub_StrLen* pColStart;  //! TODO replace with vector
    BYTE*       pColFormat; //! TODO replace with vector

public:
					ScAsciiOptions();
					ScAsciiOptions(const ScAsciiOptions& rOpt);
					~ScAsciiOptions();

	ScAsciiOptions&	operator=( const ScAsciiOptions& rCpy );

	BOOL			operator==( const ScAsciiOptions& rCmp ) const;

	void			ReadFromString( const String& rString );
	String			WriteToString() const;

	void			InterpretColumnList( const String& rString );

	CharSet				GetCharSet() const		{ return eCharSet; }
	BOOL				GetCharSetSystem() const	{ return bCharSetSystem; }
	const String&		GetFieldSeps() const	{ return aFieldSeps; }
	BOOL				IsMergeSeps() const		{ return bMergeFieldSeps; }
	sal_Unicode			GetTextSep() const		{ return cTextSep; }
	BOOL				IsFixedLen() const		{ return bFixedLen; }
	USHORT				GetInfoCount() const	{ return nInfoCount; }
	const xub_StrLen*	GetColStart() const		{ return pColStart; }
	const BYTE*			GetColFormat() const	{ return pColFormat; }
	long				GetStartRow() const		{ return nStartRow; }

	void	SetCharSet( CharSet eNew )			{ eCharSet = eNew; }
	void	SetCharSetSystem( BOOL bSet )		{ bCharSetSystem = bSet; }
	void	SetFixedLen( BOOL bSet )			{ bFixedLen = bSet; }
	void	SetFieldSeps( const String& rStr )	{ aFieldSeps = rStr; }
	void	SetMergeSeps( BOOL bSet )			{ bMergeFieldSeps = bSet; }
	void	SetTextSep( sal_Unicode c )			{ cTextSep = c; }
	void	SetStartRow( long nRow)				{ nStartRow= nRow; }

	void	SetColInfo( USHORT nCount, const xub_StrLen* pStart, const BYTE* pFormat );
    void    SetColumnInfo( const ScCsvExpDataVec& rDataVec );
};


// ============================================================================

class ScImportAsciiDlg : public ModalDialog
{
    SvStream*                   pDatStream;
    ULONG*                      pRowPosArray;
    ULONG*                      pRowPosArrayUnicode;
    USHORT                      nArrayEndPos;
    USHORT                      nArrayEndPosUnicode;
    ULONG                       nStreamPos;
    ULONG                       nStreamPosUnicode;
    BOOL                        bVFlag;

    FixedLine                   aFlFieldOpt;
    FixedText                   aFtCharSet;
    SvxTextEncodingBox          aLbCharSet;

    FixedText                   aFtRow;
    NumericField                aNfRow;

    FixedLine                   aFlSepOpt;
    RadioButton                 aRbFixed;
    RadioButton                 aRbSeparated;

    CheckBox                    aCkbTab;
    CheckBox                    aCkbSemicolon;
    CheckBox                    aCkbComma;
    CheckBox                    aCkbSpace;
    CheckBox                    aCkbOther;
    Edit                        aEdOther;
    CheckBox                    aCkbAsOnce;
    FixedText                   aFtTextSep;
    ComboBox                    aCbTextSep;

    FixedLine                   aFlWidth;
    FixedText                   aFtType;
    ListBox                     aLbType;

    ScCsvTableBox               maTableBox;

    OKButton                    aBtnOk;
    CancelButton                aBtnCancel;
    HelpButton                  aBtnHelp;

    String                      aCharSetUser;
    String                      aColumnUser;
    String                      aFldSepList;
    String                      aTextSepList;

	// aPreviewLine contains the byte string as read from the file
    ByteString                  aPreviewLine[ CSV_PREVIEW_LINES ];
	// same for Unicode
    String                      aPreviewLineUnicode[ CSV_PREVIEW_LINES ];

    CharSet                     meCharSet;          /// Selected char set.
    bool                        mbCharSetSystem;    /// Is System char set selected?

public:
                                ScImportAsciiDlg(
                                    Window* pParent, String aDatName,
									SvStream* pInStream, sal_Unicode cSep = '\t' );
                                ~ScImportAsciiDlg();

    void                        GetOptions( ScAsciiOptions& rOpt );

private:
    /** Sets the selected char set data to meCharSet and mbCharSetSystem. */
    void                        SetSelectedCharSet();
    /** Returns all separator characters in a string. */
    String                      GetSeparators() const;

    /** Enables or disables all separator checkboxes and edit fields. */
    void                        SetupSeparatorCtrls();

    void                        UpdateVertical( bool bSwitchToFromUnicode = false );

                                DECL_LINK( CharSetHdl, SvxTextEncodingBox* );
                                DECL_LINK( FirstRowHdl, NumericField* );
                                DECL_LINK( RbSepFixHdl, RadioButton* );
                                DECL_LINK( SeparatorHdl, Control* );
                                DECL_LINK( LbColTypeHdl, ListBox* );
                                DECL_LINK( UpdateTextHdl, ScCsvTableBox* );
                                DECL_LINK( ColTypeHdl, ScCsvTableBox* );
};


// ============================================================================

#endif

