/*************************************************************************
 *
 *  $RCSfile: parameterhelper.cxx,v $
 *
 *  $Revision: 1.12 $
 *
 *  last change: $Author: hr $ $Date: 2003/03/27 10:22:20 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifdef UNX
#include <stdlib.h>
#include <stdio.h>
#endif


#ifndef INCLUDED_UTILITY
#include <utility> /* std::pair */
#endif

#include "parameterhelper.hxx"

#ifndef _RTL_USTRING_HXX_
#include <rtl/ustring.hxx>
#endif
#ifndef _RTL_USTRBUF_HXX_
#include <rtl/ustrbuf.hxx>
#endif

#ifndef _RTL_STRBUF_HXX_
#include <rtl/strbuf.hxx>
#endif

#ifndef _OSL_THREAD_H_
#include <osl/thread.h>
#endif

#include <tools/string.hxx>
#include <ctype.h>

namespace ParameterHelper
{
	
Association::Association() {}
	
// Dictionary globalDictionary;

// check if only ascii chars are inside
sal_Bool Association::checkString( rtl::OUString const& _suString )
{
	sal_Int32 nIndex;
	sal_Unicode* pBuffer = (sal_Unicode*)(_suString.getStr());
	for ( nIndex = 0 ; nIndex < _suString.getLength() ; nIndex++,pBuffer++ )
	{
		if ( (*pBuffer) >= 128 )
			return sal_False;
	}
	return sal_True;
}

    
Assoc Association::makeAssoc(rtl::OUString const& _sKeyEqualValue)
{
// PRE: String which contain "X=Y"
// POST: cut down this string and offer an Assoc

	sal_Int32 nEqualPos = _sKeyEqualValue.indexOf(sal_Unicode(L'='));
	if (nEqualPos > 0)
	{
		rtl::OUString pre = _sKeyEqualValue.copy(0, nEqualPos);
		rtl::OUString post = _sKeyEqualValue.copy(nEqualPos + 1);
		
		return std::make_pair(pre.trim(), post.trim());
	}
	return std::make_pair(rtl::OUString(), rtl::OUString());
}
// -----------------------------------------------------------------------------
void Association::insertAnAssoc(Assoc const& _aAssoc, sal_Int16 _nOverrideType)
{
	if (_aAssoc.first.getLength() > 0) // insert only, if there is a key
	{
		if ( checkString( _aAssoc.first ) && checkString( _aAssoc.second ) )
		{
			if (existKey(_aAssoc.first))
			{
				// value already exist
				::rtl::OString aOne( rtl::OUStringToOString(_aAssoc.first, osl_getThreadTextEncoding()) );
				if (_nOverrideType == DO_NOT_OVERRIDE_EXISTING_VALUES)
				{
					fprintf(stderr, "warning: Key: %s already exist, do not replace.", aOne.getStr());
					return;
				}
				else
				{
					removeKey(_aAssoc.first);
					fprintf(stderr, "warning: override existing Key: %s.", aOne.getStr());
				}
			}
			m_aDictionary.push_back(_aAssoc);
		}
		else
		{
			::rtl::OString aOne( rtl::OUStringToOString(_aAssoc.first + rtl::OUString::createFromAscii("=") + _aAssoc.second, osl_getThreadTextEncoding()) );
			fprintf(stderr, "error: Non ASCII characters in %s.\nerror: No replacement for this variable will be performed.\n", aOne.getStr() );
		}
	}
}
	
// -----------------------------------------------------------------------------
void Association::feedDictionary(rtl::OString const& _sKey, rtl::OString const& _sValue, sal_Int16 _nOverrideType )
{
	rtl::OUString suKey(rtl::OStringToOUString(_sKey, osl_getThreadTextEncoding()));
	rtl::OUString suValue(rtl::OStringToOUString(_sValue, osl_getThreadTextEncoding()));
	
	Assoc aAssoc(std::make_pair(suKey.trim(), suValue.trim()));
	insertAnAssoc(aAssoc, _nOverrideType);
}

// -----------------------------------------------------------------------------
void Association::feedDictionary(rtl::OUString const& _sKeyEqualValue, sal_Int16 _nOverrideType)
{
	Assoc aAssoc = makeAssoc(_sKeyEqualValue);
	// rtl::OUString pre = aAssoc.first;
	// rtl::OUString post = aAssoc.second;
	insertAnAssoc(aAssoc, _nOverrideType);
}

sal_Int32 Association::getCount()
{
	return m_aDictionary.size();
}

// -----------------------------------------------------------------------------
bool Association::existKey(rtl::OUString const& _sKey)
{
	// BACK: true, if key found
	// not thread save
	for (Dictionary::const_iterator it = m_aDictionary.begin();
		 it != m_aDictionary.end();
		 ++it)
	{
		Assoc const& aAssocRef = *it;
		if (aAssocRef.first == _sKey)
		{
			return true;
		}
	}
	return false;
}
// -----------------------------------------------------------------------------
void Association::removeKey(rtl::OUString const& _sKey)
{
	// BACK: true, if key found
	// not thread save
	for (Dictionary::iterator it = m_aDictionary.begin();
		 it != m_aDictionary.end();
		 ++it)
	{
		Assoc const& aAssocRef = *it;
		if (aAssocRef.first == _sKey)
		{
			m_aDictionary.erase(it);
		}
	}
}
// -----------------------------------------------------------------------------
rtl::OUString Association::findSecond(Dictionary const& _aDictionary, rtl::OUString const& _sKey)
{
	for (Dictionary::const_iterator it = _aDictionary.begin();
		 it != _aDictionary.end();
		 ++it)
	{
		Assoc const& aAssocRef = *it;
		if (aAssocRef.first == _sKey)
		{
			return aAssocRef.second;
		}
	}
	return rtl::OUString();
}

// -----------------------------------------------------------------------------
// ------------------------------ Name Based Acces ------------------------------
// -----------------------------------------------------------------------------
rtl::OUString Association::getSecond(rtl::OUString const& _suKey)
{
	return findSecond(m_aDictionary, _suKey);
}
// -----------------------------------------------------------------------------
rtl::OUString Association::getSecond(rtl::OString const& _sKey)
{
	rtl::OUString suKey(rtl::OStringToOUString(_sKey, osl_getThreadTextEncoding()));
	return getSecond(suKey);
}


// -----------------------------------------------------------------------------
// ---------------------------- Indexed Based Access ----------------------------
// -----------------------------------------------------------------------------
rtl::OUString Association::getOne(sal_Int32 _nIdx)
{
	Assoc aAssoc(m_aDictionary[_nIdx]);
	rtl::OUStringBuffer sAll;
	sAll = aAssoc.first + rtl::OUString::createFromAscii("=") + aAssoc.second;
	return (rtl::OUString) sAll;
}
// -----------------------------------------------------------------------------
rtl::OUString Association::getFirst(sal_Int32 _nIdx)
{
	Assoc aAssoc(m_aDictionary[_nIdx]);
	rtl::OUString sAll(aAssoc.first);
	return sAll;
}
// -----------------------------------------------------------------------------
rtl::OUString Association::getSecond(sal_Int32 _nIdx)
{
	Assoc aAssoc(m_aDictionary[_nIdx]);
	rtl::OUString sAll(aAssoc.second);
	return sAll;
}

// -----------------------------------------------------------------------------
// ------------------------------ Helper for Quote -----------------------------
// -----------------------------------------------------------------------------
bool alreadyQuoted(ByteString const& _sStr)
{
        if ( _sStr.Len() == 0 ) return false;
	sal_Char cFirstChar = _sStr.GetChar(0);
	sal_Char cLastChar =  _sStr.GetChar(_sStr.Len() - 1);
	if (cFirstChar == '\"' && cLastChar == '\"')
	{
		return true;
	}
	if (cFirstChar == '\'' && cLastChar == '\'')
	{
		return true;
	}
	return false;
}

bool containWhiteSpace(ByteString const& _sStr)
{
	bool bContainWhiteSpace = false;
	sal_Int32 nLen = _sStr.Len();
	while(--nLen >= 0)
	{
		sal_Char cChar = _sStr.GetChar(nLen);
		if (isspace(cChar))
		{
			bContainWhiteSpace = true;
			break;								 // we found one white space, one is enough
		}
	}
	return bContainWhiteSpace;
}


ByteString QuoteIfNeed(ByteString const& _sStr)
{
        if ( _sStr.Len() == 0 ) return _sStr;
	if (!alreadyQuoted(_sStr) && containWhiteSpace(_sStr))
	{
		ByteString aStr('\"');
		aStr += _sStr;
		aStr += '\"';
		return aStr;
	}
	return _sStr;
}

} // namespace ParameterHelper

// -----------------------------------------------------------------------------

namespace StringHelper 
{
// -----------------------------------------------------------------------------
	
	typedef std::vector<rtl::OUString> StringList;

	sal_Int32 const NO_MORE_TOKENS = -1;

	struct OTokenizeBySeparator
	{
		rtl::OUString const sSeparator;
		OTokenizeBySeparator(rtl::OUString const& _sSeparator) 
			: sSeparator(_sSeparator)
		{
			OSL_PRECOND(sSeparator.trim().getLength() > 0, "Invalid empty separator string");
		}

		sal_Int32 findFirstTokenStart(rtl::OUString const& sText) const 
		{
			return 0;
		}
		sal_Int32 findNextTokenStart(rtl::OUString const& sText, sal_Int32 nPrevTokenEnd) const
		{
			sal_Int32 const nEnd = sText.getLength();
			sal_Int32 nPos = nPrevTokenEnd;
			OSL_PRECOND( nPos == nEnd || (0 <= nPos && nPos < nEnd && sText.indexOf(sSeparator, nPos) == nPos),
						 "Invalid nPrevTokenEnd");

			if (nPos < nEnd)
				return nPos + sSeparator.getLength();
			else
				return NO_MORE_TOKENS;
		}
		sal_Int32 findTokenEnd(rtl::OUString const& sText, sal_Int32 nTokenStart) const 
		{
			sal_Int32 const nEnd = sText.getLength();
			OSL_PRECOND( 0 <= nTokenStart && nTokenStart <= nEnd ,
						 "Invalid nTokenStart");

			sal_Int32 nPos = sText.indexOf(sSeparator,nTokenStart);

			if (nPos >= 0)
				return nPos;
			else
				return nEnd;
		}
	};
// -----------------------------------------------------------------------------
	template <class Tokenizer>
	void tokenizeListData(Tokenizer const& aTokenizer, rtl::OUString const& aContent, StringList& rContentList)
			
	{
		sal_Int32 nTokenPos = aTokenizer.findFirstTokenStart(aContent);

		while(nTokenPos != NO_MORE_TOKENS)
		{
			sal_Int32 nTokenEnd = aTokenizer.findTokenEnd(aContent, nTokenPos);
			
			// this is what the tokenizer must provide
			OSL_ASSERT(0 <= nTokenPos && nTokenPos <= nTokenEnd && nTokenEnd <= aContent.getLength());

			rContentList.push_back( aContent.copy(nTokenPos, nTokenEnd-nTokenPos) );

			nTokenPos= aTokenizer.findNextTokenStart(aContent, nTokenEnd);
		}
	}

	StringList tokenizeByComma(rtl::OUString const& _sCSVList)
	{
		StringList aList;
		tokenizeListData(OTokenizeBySeparator(rtl::OUString::createFromAscii( "," )),
						 _sCSVList,
						 aList);
		return aList;
	}
}
