/*************************************************************************
 *
 *  $RCSfile: arch.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: hr $ $Date: 2003/04/04 15:06:08 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#ifndef _ARCH_HXX
#define _ARCH_HXX

#ifndef _LOADER_CXX
#include <tools/solar.h>
#else
#undef BOOL
#define BOOL unsigned char
#ifndef ULONG
#define ULONG unsigned long
#endif
#ifndef USHORT
#define USHORT unsigned short
#endif
#endif

#include <stdio.h>

#define MAX_ENTRYS				10000
#define MAX_ARCH_PATH			255
#define BUF_SZ					32000
#define ARCH_ACTUAL_VERSION		1

#ifndef WIN
#ifndef WNT
#define CALLTYPE
#else
#define CALLTYPE			__cdecl
#endif
#else
#define PASCAL				_pascal
#define FAR					_far
#define CALLTYPE			FAR PASCAL
#endif

extern "C" {
	typedef const char* (*FncFindArch)(const char* pDefSource, const char* pDefName);
};
///////////////////////////////////////////////////////////////////////////////
// Archive Directory Entry

struct ArchEntry
{
	ULONG	nOffset;
	ULONG	nSize;
	char*	pName;
};

///////////////////////////////////////////////////////////////////////////////
// Archive Directory

class ArchDirectory
{
	FILE*		pArch;
	ULONG		nArchSize;
	FncFindArch	fncFindArch;

	char		cDelim;
	char		pSourceDir[MAX_ARCH_PATH];
	char		pMasterArch[MAX_ARCH_PATH];
	char		pErrorMsg[1000];
	BOOL		bNoJunk;

	ULONG		nArchVersion;
	ULONG		nDirOffset;
	ULONG 		nDataOffset;

	ULONG 		nDirCount;
	ArchEntry* 	pDirectory[MAX_ENTRYS];

	void				GetArchFileName( USHORT nSegment, char* pBuffer, long nBufSize );
	BOOL				ReadDirectory();
public:
		ArchDirectory();
		~ArchDirectory();

	void 				SetFindArchHdl(FncFindArch fncNew) { fncFindArch = fncNew; }
	char*				GetErrorMsg() { return pErrorMsg; }

	BOOL				SetArchFile(const char* pBigFile);
	const ArchEntry*	ExistsFile(const char* pFileName);
	BOOL				GetFile(const char* pFileName, const char* pDestDir);

	ULONG 				GetCount() const { return nDirCount; }
	ArchEntry** 		GetRawList() const { return (ArchEntry**)pDirectory; }

	void				ExtractAll( const char* pDirname );
};

#ifdef _LOADER_CXX
#undef BOOL
#endif

#endif //_ARCH_HXX

