/*************************************************************************
 *
 *  $RCSfile: webaction.cxx,v $
 *
 *  $Revision: 1.7 $
 *
 *  last change: $Author: ok $ $Date: 2001/09/07 12:02:39 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include "webaction.hxx"

SiWebDownloadAction::SiWebDownloadAction( SiAgenda* pAgenda, const UniString& aFilename ) :
	SiWebAction( pAgenda, ActionType_DOWNLOAD )
{
	bProcess		= FALSE;
	eType			= ActionType_DOWNLOAD;
	bDone 			= FALSE;
	strFilename		= aFilename;
	nSizeKB			= 0;
}

DownloadAction& SiWebDownloadAction::GetWebAction()
{
	return *this;
}

///////////////////////////////////////////////////////////////////////////////

SiWebMakeDirAction::SiWebMakeDirAction( SiAgenda* pAgenda, const UniString& name, sal_Int32 rights ) :
	SiWebAction( pAgenda, ActionType_MAKEDIR )
{
	bProcess		= FALSE;
	eType			= ActionType_MAKEDIR;
	strDirname		= name;
	nRights			= rights;
}

MakeDirAction& SiWebMakeDirAction::GetWebAction()
{
	return *this;
}

BOOL SiWebMakeDirAction::operator < (const SiWebMakeDirAction& rObj)
{
	UniString a( strDirname );
	UniString b( rObj.GetDirname() );
	return a < b;
}

BOOL SiWebMakeDirAction::operator == (const SiWebMakeDirAction& rObj)
{
	UniString a( strDirname );
	UniString b( rObj.GetDirname() );
	return a == b;
}

///////////////////////////////////////////////////////////////////////////////

SiWebUnzipAction::SiWebUnzipAction( SiAgenda* pAgenda,
		const UniString& source, const UniString& destination, const UniString& pattern,
		com::sun::star::util::DateTime& datetime, sal_Int32 rights, BOOL unocomponent, BOOL activex ) :
	SiWebAction( pAgenda, ActionType_UNZIPFILE )
{
	bProcess				= FALSE;
	eType					= ActionType_UNZIPFILE;

	strSourceFilename		= source;
	strDestinationPath		= destination;
	strPattern				= pattern;

	aDateTime				= datetime;
    nRights					= rights;
	bUnoComponent			= unocomponent;
	bActiveX				= activex;
}

UnzipAction& SiWebUnzipAction::GetWebAction()
{
	return *this;
}

void SiWebUnzipAction::AddSubFile( const UniString& rFilename )
{
	sal_Int32 nIdx = seqSubFiles.getLength();
	seqSubFiles.realloc( nIdx + 1 );
	seqSubFiles[nIdx] = rFilename;
}

///////////////////////////////////////////////////////////////////////////////

SiWebCopyFileAction::SiWebCopyFileAction( SiAgenda* pAgenda,
		const UniString& source, const UniString& destination,
		com::sun::star::util::DateTime& datetime, sal_Int32 rights,
		BOOL unocomponent, BOOL activex ) :
	SiWebAction( pAgenda, ActionType_COPYFILE )
{
	bProcess				= FALSE;
	eType					= ActionType_COPYFILE;

	strSourceFilename		= source;
	strDestinationFilename	= destination;

	aDateTime				= datetime;
    nRights					= rights;
	bUnoComponent			= unocomponent;
	bActiveX				= activex;
}

CopyFileAction& SiWebCopyFileAction::GetWebAction()
{
	return *this;
}

///////////////////////////////////////////////////////////////////////////////

SiWebProfileItemAction::SiWebProfileItemAction( SiAgenda* pAgenda,
		const UniString& filename, const UniString& section,
		const UniString& key, const UniString& value, USHORT order, BOOL create ) :
	SiWebAction( pAgenda, ActionType_PROFILEITEM )
{
	bProcess				= FALSE;
	eType					= ActionType_PROFILEITEM;
	nOrder 					= order;    // agenda sort order

    strProfilename			= filename;
    strSection				= section;
    strKey					= key;
    strValue				= value;
    bCreate					= create;
}

ProfileItemAction& SiWebProfileItemAction::GetWebAction()
{
	return *this;
}

///////////////////////////////////////////////////////////////////////////////

SiWebFontAction::SiWebFontAction( SiAgenda* pAgenda,
		const UniString& fontfilename,
		const UniString& fontname, BOOL create ) :
	SiWebAction( pAgenda, ActionType_FONT )
{
	bProcess				= FALSE;
	eType					= ActionType_FONT;

	strFontFilename			= fontfilename;
	strFontname				= fontname;

	bCreate					= create;
}

FontAction& SiWebFontAction::GetWebAction()
{
	return *this;
}

///////////////////////////////////////////////////////////////////////////////

SiWebWindowsRegistryAction::SiWebWindowsRegistryAction( SiAgenda* pAgenda,
		const UniString& key,
		const UniString& subkey,
		const UniString& name,
		const UniString& value,
		BOOL create,
		BOOL hex,
		BOOL deleteall ) :
	SiWebAction( pAgenda, ActionType_WINREGISTRY )
{
	bProcess				= FALSE;
	eType					= ActionType_WINREGISTRY;

	strKey					= key;
	strSubkey				= subkey;
    strName					= name;
    strValue				= value;

	bCreate					= create;
    bHexValue				= hex;
    bDeleteAll				= deleteall;
}

WindowsRegistryAction& SiWebWindowsRegistryAction::GetWebAction()
{
	return *this;
}

///////////////////////////////////////////////////////////////////////////////

SiWebMakeFolderAction::SiWebMakeFolderAction( SiAgenda* pAgenda,
		const UniString& name, BOOL user ) :
	SiWebAction( pAgenda, ActionType_MAKEFOLDER )
{
	bProcess				= FALSE;
	eType					= ActionType_MAKEFOLDER;

	strFoldername			= name;
    bUserFolder				= user;
}

MakeFolderAction& SiWebMakeFolderAction::GetWebAction()
{
	return *this;
}

///////////////////////////////////////////////////////////////////////////////

SiWebMakeFolderItemAction::SiWebMakeFolderItemAction( SiAgenda* pAgenda,
		const UniString& foldername,
		const UniString& itemname,
		const UniString& destinationpath,
		const UniString& destinationexecutable,
		const UniString& parameter ) :
	SiWebAction( pAgenda, ActionType_MAKEFOLDERITEM )
{
	bProcess				= FALSE;
	eType					= ActionType_MAKEFOLDERITEM;

	strFoldername			= foldername;
	strItemname				= itemname;
	strDestinationPath		= destinationpath;
	strDestinationExecutable = destinationexecutable;
	strParameter			= parameter;
}

MakeFolderItemAction& SiWebMakeFolderItemAction::GetWebAction()
{
	return *this;
}

///////////////////////////////////////////////////////////////////////////////

SiWebDeleteFileAction::SiWebDeleteFileAction( SiAgenda* pAgenda,
		const UniString& path,
		const UniString& pattern,
		BOOL unocomponent,
		BOOL activex,
		BOOL testdate,
		com::sun::star::util::DateTime& datetime ) :
	SiWebAction( pAgenda, ActionType_DELETEFILE )
{
	bProcess				= FALSE;
	eType					= ActionType_DELETEFILE;

    strDestinationPath		= path;
    strPattern				= pattern;
    bUnoComponent			= unocomponent;
	bActiveX				= activex;
	bTestDate				= bTestDate;
	aDateTime				= datetime;
}

DeleteFileAction& SiWebDeleteFileAction::GetWebAction()
{
	return *this;
}

///////////////////////////////////////////////////////////////////////////////

SiWebDeleteDirAction::SiWebDeleteDirAction( SiAgenda* pAgenda,
		const UniString& path ) :
	SiWebAction( pAgenda, ActionType_DELETEDIR )
{
	bProcess				= FALSE;
	eType					= ActionType_DELETEDIR;

    strDirname				= path;
}

DeleteDirAction& SiWebDeleteDirAction::GetWebAction()
{
	return *this;
}

///////////////////////////////////////////////////////////////////////////////

SiWebMakeShortcutAction::SiWebMakeShortcutAction( SiAgenda* pAgenda,
		const UniString& source,
		const UniString& destination,
		const UniString& path,
		const UniString& description ) :
	SiWebAction( pAgenda, ActionType_CREATESHORTCUT )
{
	bProcess		= FALSE;
	eType			= ActionType_CREATESHORTCUT;

	strSource		= source;
	strDestination	= destination;
	strPath			= path;
	strDescription	= description;
}

MakeShortcutAction& SiWebMakeShortcutAction::GetWebAction()
{
	return *this;
}

///////////////////////////////////////////////////////////////////////////////

SiWebDeleteFolderAction::SiWebDeleteFolderAction( SiAgenda* pAgenda,
		const UniString& foldername ) :
	SiWebAction( pAgenda, ActionType_DELETEFOLDER )
{
	bProcess				= FALSE;
	eType					= ActionType_DELETEFOLDER;

	strFoldername			= foldername;
}

DeleteFolderAction& SiWebDeleteFolderAction::GetWebAction()
{
	return *this;
}

///////////////////////////////////////////////////////////////////////////////

SiWebDeleteFolderItemAction::SiWebDeleteFolderItemAction( SiAgenda* pAgenda,
		const UniString& foldername,
		const UniString& itemname ) :
	SiWebAction( pAgenda, ActionType_DELETEFOLDERITEM )
{
	bProcess				= FALSE;
	eType					= ActionType_DELETEFOLDERITEM;

    strFoldername			= foldername;
    strItemname				= itemname;
}

DeleteFolderItemAction& SiWebDeleteFolderItemAction::GetWebAction()
{
	return *this;
}
