#!/bin/sh
#*************************************************************************
#
#   $RCSfile: jvmsetup.sh,v $
#
#   $Revision: 1.6.52.1 $
#
#   last change: $Author: vg $ $Date: 2004/05/03 16:30:21 $
#
#   The Contents of this file are made available subject to the terms of
#   either of the following licenses
#
#          - GNU Lesser General Public License Version 2.1
#          - Sun Industry Standards Source License Version 1.1
#
#   Sun Microsystems Inc., October, 2000
#
#   GNU Lesser General Public License Version 2.1
#   =============================================
#   Copyright 2000 by Sun Microsystems, Inc.
#   901 San Antonio Road, Palo Alto, CA 94303, USA
#
#   This library is free software; you can redistribute it and/or
#   modify it under the terms of the GNU Lesser General Public
#   License version 2.1, as published by the Free Software Foundation.
#
#   This library is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#   Lesser General Public License for more details.
#
#   You should have received a copy of the GNU Lesser General Public
#   License along with this library; if not, write to the Free Software
#   Foundation, Inc., 59 Temple Place, Suite 330, Boston,
#   MA  02111-1307  USA
#
#
#   Sun Industry Standards Source License Version 1.1
#   =================================================
#   The contents of this file are subject to the Sun Industry Standards
#   Source License Version 1.1 (the "License"); You may not use this file
#   except in compliance with the License. You may obtain a copy of the
#   License at http://www.openoffice.org/license.html.
#
#   Software provided under this License is provided on an "AS IS" basis,
#   WITHOUT WARRUNTY OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING,
#   WITHOUT LIMITATION, WARRUNTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
#   MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
#   See the License for the specific provisions governing your rights and
#   obligations concerning the Software.
#
#   The Initial Developer of the Original Code is: Sun Microsystems, Inc..
#
#   Copyright: 2000 by Sun Microsystems, Inc.
#
#   All Rights Reserved.
#
#   Contributor(s): _______________________________________
#
#
#
#*************************************************************************

# resolve installation directory
sd_platform=`uname -s`

case $sd_platform in
	SCO_SV) test=/bin/test     ;;
	FreeBSD) test=/bin/test    ;;
	*)      test=/usr/bin/test ;;
esac

sd_cwd="`pwd`"
if [ -h "$0" ] ; then
	sd_basename=`basename "$0"`
	sd_script=`ls -l "$0" | sed "s/.*${sd_basename} -> //g"`
else
	sd_script="$0"
fi

cd "`dirname "$sd_script"`/.."
sd_binary=`basename "$sd_script"`".bin"
sd_inst="`pwd`"

# change back directory
cd "$sd_cwd"

sd_fonts=$sd_inst/fonts
sd_platform=`uname -s`
# set search path for shared libraries
case $sd_platform in
  SunOS)
	LD_LIBRARY_PATH=$sd_inst/program/local:$sd_inst/program/service:$sd_inst/program:/usr/openwin/lib:/usr/dt/lib:$LD_LIBRARY_PATH
    export LD_LIBRARY_PATH
    ;;

  AIX)
    LIBPATH=$sd_inst/program:$LIBPATH
    export LIBPATH
    ;;

  HP-UX)
    SHLIB_PATH=$sd_inst/program/local:$sd_inst/program:/usr/openwin/lib:$SHLIB_PATH
    export SHLIB_PATH
    ;;

  IRIX*)
    LD_LIBRARYN32_PATH=:$sd_inst/program/local:$sd_inst/program:$LD_LIBRARYN32_PATH
    export LD_LIBRARYN32_PATH
    ;;

  Darwin)
    DYLD_LIBRARY_PATH=$sd_inst/program/local:$sd_inst/program:$DYLD_LIBRARY_PATH
    export DYLD_LIBRARY_PATH
    ;;

  *)
    LD_LIBRARY_PATH=$sd_inst/program/local:$sd_inst/program:$LD_LIBRARY_PATH
    export LD_LIBRARY_PATH
    ;;
esac

# extend the ld_library_path for java: javaldx checks the sofficerc for us
java_ld_library_path=`"$sd_inst/program/javaldx" "$@"`
if [ "$java_ld_library_path" != "" ] ; then
    case $sd_platform in
        AIX)
            LIBPATH=${java_ld_library_path}:${LIBPATH}
            ;;
        HP-UX)
            SHLIB_PATH=${java_ld_library_path}:${SHLIB_PATH}
            ;;
        IRIX*)
            LD_LIBRARYN32_PATH=${java_ld_library_path}:${LD_LIBRARYN32_PATH}
            ;;
        Darwin)
            DYLD_LIBRARY_PATH=${java_ld_library_path}:${DYLD_LIBRARY_PATH}
            ;;
        *)
            LD_LIBRARY_PATH=${java_ld_library_path}:${LD_LIBRARY_PATH}
            ;;
    esac
fi


# misc. environment variables
SAL_FONTPATH=$sd_fonts/type1:$sd_fonts/75dpi

unset XENVIRONMENT

export SAL_FONTPATH

# execute soffice binary
exec "$sd_inst/program/$sd_binary" "$@"
