/*************************************************************************
 *
 *  $RCSfile: mailchildwin.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: mba $ $Date: 2000/12/20 20:54:23 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

// includes --------------------------------------------------------------

#include "mailchildwin.hxx"
#include "mailwindow.hxx"
#include "sfxresid.hxx"

#include "sfxsids.hrc"
#include "dialog.hrc"

#include <vcl/msgbox.hxx>	// QueryBox

#ifndef _SFXAPP_HXX
#include <app.hxx>
#endif

#define RET_SENDMAIL	200
#define RET_CLOSEMAIL	201

// class SfxMailChildWinWrapper_Impl -------------------------------------

SFX_IMPL_CHILDWINDOW( SfxMailChildWinWrapper_Impl, SID_MAIL_CHILDWIN )

SfxMailChildWinWrapper_Impl::SfxMailChildWinWrapper_Impl( Window* pParent, sal_uInt16 nId,
														  SfxBindings* pBindings,
														  SfxChildWinInfo* pInfo ) :

	SfxChildWindow( pParent, nId )

{
	// Window erzeugen
	pWindow = new SfxMailChildWindow_Impl(
		pBindings, this, pParent,
		WB_STDDOCKWIN | WB_CLIPCHILDREN | WB_SIZEABLE | WB_3DLOOK | WB_DOCKBORDER );
	eChildAlignment = SFX_ALIGN_TOP;
	pWindow->SetSizePixel( Size( 240, 240 ) );
	( (SfxDockingWindow*)pWindow )->Initialize( pInfo );
}

// -----------------------------------------------------------------------

sal_Bool SfxMailChildWinWrapper_Impl::QueryClose()
{
	return ( (SfxMailChildWindow_Impl*)pWindow )->QueryClose();
}

// -----------------------------------------------------------------------

SfxChildWinInfo SfxMailChildWinWrapper_Impl::GetInfo() const
{
	SfxChildWinInfo aInfo = SfxChildWindow::GetInfo();
	( (SfxDockingWindow*)GetWindow() )->FillInfo( aInfo );
	aInfo.bVisible = sal_False;
	return aInfo;
}

// class SfxMailChildWindow_Impl -----------------------------------------

SfxMailChildWindow_Impl::SfxMailChildWindow_Impl( SfxBindings* pBindings, SfxChildWindow* pChildWin,
												  Window* pParent, WinBits nBits ) :

	SfxDockingWindow( pBindings, pChildWin, pParent, nBits ),

	mpWindow( NULL )

{
	mpWindow = new MailWindow_Impl( this, pBindings, SfxResId( RID_MAIL_WINDOW ) );
	mpWindow->Show();
}

// -----------------------------------------------------------------------

SfxMailChildWindow_Impl::~SfxMailChildWindow_Impl()
{
	delete mpWindow;
}

// -----------------------------------------------------------------------

void SfxMailChildWindow_Impl::Resize()
{
	SfxDockingWindow::Resize();
	mpWindow->SetSizePixel( GetSizePixel() );
}

// -----------------------------------------------------------------------

sal_Bool SfxMailChildWindow_Impl::QueryClose()
{
    if( SfxApplication::IsPlugin() )
        return sal_True;

	sal_Bool bCanClose = mpWindow->HasSend();
	if ( !bCanClose )
	{
		MessBox aBox( this, 0,
					  String( SfxResId( RID_STR_CLOSE_TITLE ) ),
					  String( SfxResId( RID_STR_CLOSE_MESSAGE ) ) );
		aBox.SetImage( InfoBox::GetStandardImage() );
		USHORT nBtnFlags = ( BUTTONDIALOG_DEFBUTTON | BUTTONDIALOG_OKBUTTON | BUTTONDIALOG_FOCUSBUTTON );

		if ( mpWindow->CanSend() )
		{
			aBox.AddButton( String( SfxResId( RID_STR_CLOSE_BTN_SEND ) ), RET_SENDMAIL, nBtnFlags );
			nBtnFlags = 0;
		}
		aBox.AddButton( String( SfxResId( RID_STR_CLOSE_BTN_REJECT ) ), RET_CLOSEMAIL, nBtnFlags );
		aBox.AddButton( String( SfxResId( RID_STR_CLOSE_BTN_BACKTOMSG ) ), RET_CANCEL,
						BUTTONDIALOG_CANCELBUTTON );
		short nRet = aBox.Execute();
		bCanClose = (  RET_CLOSEMAIL == nRet );

		if ( RET_SENDMAIL == nRet )
			mpWindow->Send();
	}
	return bCanClose;
}


