/*************************************************************************
 *
 *  $RCSfile: AccessibleBrowseBoxTableCell.cxx,v $
 *
 *  $Revision: 1.13 $
 *
 *  last change: $Author: vg $ $Date: 2003/05/22 13:36:02 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the License); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an AS IS basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include "AccessibleBrowseBoxTableCell.hxx"

#ifndef _SVTOOLS_ACCESSIBLETABLEPROVIDER_HXX
#include "accessibletableprovider.hxx"
#endif
#ifndef _SVTOOLS_ACCESSIBLEBROWSEBOX_HXX
#include "AccessibleBrowseBox.hxx"
#endif
#ifndef _SV_GEN_HXX
#include <vcl/gen.hxx>
#endif
#ifndef _TOOLKIT_HELPER_VCLUNOHELPER_HXX_
#include <toolkit/helper/vclunohelper.hxx>
#endif

namespace svt
{
	namespace
	{
		void checkIndex_Impl( sal_Int32 _nIndex, const ::rtl::OUString& _sText ) throw (::com::sun::star::lang::IndexOutOfBoundsException)
		{
			if ( _nIndex >= _sText.getLength() )
				throw ::com::sun::star::lang::IndexOutOfBoundsException();
		}

		sal_Int32 getIndex_Impl( sal_Int32 _nRow, sal_uInt16 _nColumn, sal_uInt16 _nColumnCount )
		{
			return _nRow * _nColumnCount + _nColumn;
		}
	}
	using namespace ::com::sun::star::lang;
	using namespace utl;
	using namespace comphelper;
	using ::rtl::OUString;
	using ::svt::AccessibleBrowseBox;
	using namespace ::com::sun::star::uno;
	using ::com::sun::star::accessibility::XAccessible;
	using namespace ::com::sun::star::accessibility;


	// implementation of a table cell
	::rtl::OUString AccessibleBrowseBoxTableCell::implGetText()
	{
		ensureIsAlive();
		return mpBrowseBox->GetAccessibleCellText( getRowPos(), getColumnPos() );
	}

	::com::sun::star::lang::Locale AccessibleBrowseBoxTableCell::implGetLocale()
	{
		ensureIsAlive();
		return mpBrowseBox->GetAccessible()->getAccessibleContext()->getLocale();
	}

	void AccessibleBrowseBoxTableCell::implGetSelection( sal_Int32& nStartIndex, sal_Int32& nEndIndex )
	{
		nStartIndex = 0;
		nEndIndex = 0;
	}

	AccessibleBrowseBoxTableCell::AccessibleBrowseBoxTableCell(const Reference<XAccessible >& _rxParent,
								IAccessibleTableProvider& _rBrowseBox,
								const ::com::sun::star::uno::Reference< ::com::sun::star::awt::XWindow >& _xFocusWindow,
								sal_Int32 _nRowPos,
								sal_uInt16 _nColPos)
		:AccessibleBrowseBoxCell( _rxParent, _rBrowseBox, _xFocusWindow, _nRowPos, _nColPos )
	{
		sal_Int32 nIndex = getIndex_Impl( _nRowPos, _nColPos, _rBrowseBox.GetColumnCount() );
		setAccessibleName( _rBrowseBox.GetAccessibleName( BBTYPE_TABLECELL, nIndex ) );
		setAccessibleDescription( _rBrowseBox.GetAccessibleDescription( BBTYPE_TABLECELL, nIndex ) );
	}

	// XInterface -------------------------------------------------------------

	/** Queries for a new interface. */
	::com::sun::star::uno::Any SAL_CALL AccessibleBrowseBoxTableCell::queryInterface(
			const ::com::sun::star::uno::Type& rType )
		throw ( ::com::sun::star::uno::RuntimeException )
	{
		Any aRet = AccessibleBrowseBoxCell::queryInterface(rType);
		if ( !aRet.hasValue() )
			aRet = AccessibleTextHelper_BASE::queryInterface(rType);
		return aRet;
	}

	/** Aquires the object (calls acquire() on base class). */
	void SAL_CALL AccessibleBrowseBoxTableCell::acquire() throw ()
	{
		AccessibleBrowseBoxCell::acquire();
	}

	/** Releases the object (calls release() on base class). */
	void SAL_CALL AccessibleBrowseBoxTableCell::release() throw ()
	{
		AccessibleBrowseBoxCell::release();
	}

	::com::sun::star::awt::Rectangle SAL_CALL AccessibleBrowseBoxTableCell::getCharacterBounds( sal_Int32 nIndex ) throw (IndexOutOfBoundsException, RuntimeException)
	{
		BBSolarGuard aSolarGuard;
		::osl::MutexGuard aGuard( getOslMutex() );

		ensureIsAlive();
		if ( !implIsValidIndex( nIndex, implGetText().getLength() ) )
			throw IndexOutOfBoundsException();

		::com::sun::star::awt::Rectangle aRect;

		if ( mpBrowseBox )
		{
			aRect = AWTRectangle( mpBrowseBox->GetFieldCharacterBounds( getRowPos(), getColumnPos(), nIndex ) );
		}

		return aRect;
	}

	sal_Int32 SAL_CALL AccessibleBrowseBoxTableCell::getIndexAtPoint( const ::com::sun::star::awt::Point& _aPoint ) throw (RuntimeException)
	{
		//! TODO CTL bidi
		// DBG_ASSERT(0,"Need to be done by base class!");
		BBSolarGuard aSolarGuard;
		::osl::MutexGuard aGuard( getOslMutex() );
		ensureIsAlive();

		return mpBrowseBox->GetFieldIndexAtPoint( getRowPos(), getColumnPos(), VCLPoint( _aPoint ) );
	}

	/** @return
			The name of this class.
	*/
	::rtl::OUString SAL_CALL AccessibleBrowseBoxTableCell::getImplementationName()
		throw ( ::com::sun::star::uno::RuntimeException )
	{
		return ::rtl::OUString( RTL_CONSTASCII_USTRINGPARAM( "com.sun.star.comp.svtools.AccessibleBrowseBoxTableCell" ) );
	}

	/** @return  The count of visible children. */
	sal_Int32 SAL_CALL AccessibleBrowseBoxTableCell::getAccessibleChildCount()
		throw ( ::com::sun::star::uno::RuntimeException )
	{
		return 0;
	}

	/** @return  The XAccessible interface of the specified child. */
	::com::sun::star::uno::Reference<
		::com::sun::star::accessibility::XAccessible > SAL_CALL
		AccessibleBrowseBoxTableCell::getAccessibleChild( sal_Int32 nChildIndex )
			throw ( ::com::sun::star::lang::IndexOutOfBoundsException,
					::com::sun::star::uno::RuntimeException )
	{
		throw ::com::sun::star::lang::IndexOutOfBoundsException();
	}

	/** Creates a new AccessibleStateSetHelper and fills it with states of the
		current object.
		@return
			A filled AccessibleStateSetHelper.
	*/
	::utl::AccessibleStateSetHelper* AccessibleBrowseBoxTableCell::implCreateStateSetHelper()
	{
		BBSolarGuard aSolarGuard;
		::osl::MutexGuard aGuard( getOslMutex() );

		::utl::AccessibleStateSetHelper* pStateSetHelper = new ::utl::AccessibleStateSetHelper;

		if( isAlive() )
		{
			// SHOWING done with mxParent
			if( implIsShowing() )
				pStateSetHelper->AddState( AccessibleStateType::SHOWING );

			mpBrowseBox->FillAccessibleStateSetForCell( *pStateSetHelper, getRowPos(), getColumnPos() );
		}
		else
			pStateSetHelper->AddState( AccessibleStateType::DEFUNC );

		return pStateSetHelper;
	}


	// XAccessible ------------------------------------------------------------

	/** @return  The XAccessibleContext interface of this object. */
	Reference< XAccessibleContext > SAL_CALL AccessibleBrowseBoxTableCell::getAccessibleContext() throw ( RuntimeException )
	{
		ensureIsAlive();
		return this;
	}

	// XAccessibleContext -----------------------------------------------------

	sal_Int32 SAL_CALL AccessibleBrowseBoxTableCell::getAccessibleIndexInParent()
			throw ( ::com::sun::star::uno::RuntimeException )
	{
		BBSolarGuard aSolarGuard;
		::osl::MutexGuard aGuard( getOslMutex() );
		ensureIsAlive();

		return BBINDEX_FIRSTCONTROL + ( getRowPos() * mpBrowseBox->GetColumnCount() ) + getColumnPos();
	}

	sal_Int32 SAL_CALL AccessibleBrowseBoxTableCell::getCaretPosition(  ) throw (::com::sun::star::uno::RuntimeException)
	{
		return -1;
	}
	sal_Bool SAL_CALL AccessibleBrowseBoxTableCell::setCaretPosition ( sal_Int32 nIndex ) throw (::com::sun::star::lang::IndexOutOfBoundsException, ::com::sun::star::uno::RuntimeException)
	{
		BBSolarGuard aSolarGuard;
		::osl::MutexGuard aGuard( getOslMutex() );

		if ( !implIsValidRange( nIndex, nIndex, implGetText().getLength() ) )
			throw IndexOutOfBoundsException();

		return sal_False;
	}
	sal_Unicode SAL_CALL AccessibleBrowseBoxTableCell::getCharacter( sal_Int32 nIndex ) throw (::com::sun::star::lang::IndexOutOfBoundsException, ::com::sun::star::uno::RuntimeException)
	{
		BBSolarGuard aSolarGuard;
		::osl::MutexGuard aGuard( getOslMutex() );
		return OCommonAccessibleText::getCharacter( nIndex );
	}
	::com::sun::star::uno::Sequence< ::com::sun::star::beans::PropertyValue > SAL_CALL AccessibleBrowseBoxTableCell::getCharacterAttributes( sal_Int32 nIndex, const ::com::sun::star::uno::Sequence< ::rtl::OUString >& aRequestedAttributes ) throw (::com::sun::star::lang::IndexOutOfBoundsException, ::com::sun::star::uno::RuntimeException)
	{
		BBSolarGuard aSolarGuard;
		::osl::MutexGuard aGuard( getOslMutex() );

		::rtl::OUString sText( implGetText() );

		if ( !implIsValidIndex( nIndex, sText.getLength() ) )
			throw IndexOutOfBoundsException();

		return ::com::sun::star::uno::Sequence< ::com::sun::star::beans::PropertyValue >();
	}
	sal_Int32 SAL_CALL AccessibleBrowseBoxTableCell::getCharacterCount(  ) throw (::com::sun::star::uno::RuntimeException)
	{
		BBSolarGuard aSolarGuard;
		::osl::MutexGuard aGuard( getOslMutex() );
		return OCommonAccessibleText::getCharacterCount(  );
	}

	::rtl::OUString SAL_CALL AccessibleBrowseBoxTableCell::getSelectedText(  ) throw (::com::sun::star::uno::RuntimeException)
	{
		BBSolarGuard aSolarGuard;
		::osl::MutexGuard aGuard( getOslMutex() );
		return OCommonAccessibleText::getSelectedText(  );
	}
	sal_Int32 SAL_CALL AccessibleBrowseBoxTableCell::getSelectionStart(  ) throw (::com::sun::star::uno::RuntimeException)
	{
		BBSolarGuard aSolarGuard;
		::osl::MutexGuard aGuard( getOslMutex() );
		return OCommonAccessibleText::getSelectionStart(  );
	}
	sal_Int32 SAL_CALL AccessibleBrowseBoxTableCell::getSelectionEnd(  ) throw (::com::sun::star::uno::RuntimeException)
	{
		BBSolarGuard aSolarGuard;
		::osl::MutexGuard aGuard( getOslMutex() );
		return OCommonAccessibleText::getSelectionEnd(  );
	}
	sal_Bool SAL_CALL AccessibleBrowseBoxTableCell::setSelection( sal_Int32 nStartIndex, sal_Int32 nEndIndex ) throw (::com::sun::star::lang::IndexOutOfBoundsException, ::com::sun::star::uno::RuntimeException)
	{
		BBSolarGuard aSolarGuard;
		::osl::MutexGuard aGuard( getOslMutex() );
		if ( !implIsValidRange( nStartIndex, nEndIndex, implGetText().getLength() ) )
			throw IndexOutOfBoundsException();

		return sal_False;
	}
	::rtl::OUString SAL_CALL AccessibleBrowseBoxTableCell::getText(  ) throw (::com::sun::star::uno::RuntimeException)
	{
		BBSolarGuard aSolarGuard;
		::osl::MutexGuard aGuard( getOslMutex() );
		return OCommonAccessibleText::getText(  );
	}
	::rtl::OUString SAL_CALL AccessibleBrowseBoxTableCell::getTextRange( sal_Int32 nStartIndex, sal_Int32 nEndIndex ) throw (::com::sun::star::lang::IndexOutOfBoundsException, ::com::sun::star::uno::RuntimeException)
	{
		BBSolarGuard aSolarGuard;
		::osl::MutexGuard aGuard( getOslMutex() );
		return OCommonAccessibleText::getTextRange( nStartIndex, nEndIndex );
	}
    ::com::sun::star::accessibility::TextSegment SAL_CALL AccessibleBrowseBoxTableCell::getTextAtIndex( sal_Int32 nIndex, sal_Int16 aTextType ) throw (::com::sun::star::lang::IndexOutOfBoundsException, ::com::sun::star::lang::IllegalArgumentException, ::com::sun::star::uno::RuntimeException)
	{
		BBSolarGuard aSolarGuard;
		::osl::MutexGuard aGuard( getOslMutex() );
		return OCommonAccessibleText::getTextAtIndex( nIndex ,aTextType);
	}
    ::com::sun::star::accessibility::TextSegment SAL_CALL AccessibleBrowseBoxTableCell::getTextBeforeIndex( sal_Int32 nIndex, sal_Int16 aTextType ) throw (::com::sun::star::lang::IndexOutOfBoundsException, ::com::sun::star::lang::IllegalArgumentException, ::com::sun::star::uno::RuntimeException)
	{
		BBSolarGuard aSolarGuard;
		::osl::MutexGuard aGuard( getOslMutex() );
		return OCommonAccessibleText::getTextBeforeIndex( nIndex ,aTextType);
	}
    ::com::sun::star::accessibility::TextSegment SAL_CALL AccessibleBrowseBoxTableCell::getTextBehindIndex( sal_Int32 nIndex, sal_Int16 aTextType ) throw (::com::sun::star::lang::IndexOutOfBoundsException, ::com::sun::star::lang::IllegalArgumentException, ::com::sun::star::uno::RuntimeException)
	{
		BBSolarGuard aSolarGuard;
		::osl::MutexGuard aGuard( getOslMutex() );
		return OCommonAccessibleText::getTextBehindIndex( nIndex ,aTextType);
	}
	sal_Bool SAL_CALL AccessibleBrowseBoxTableCell::copyText( sal_Int32 nStartIndex, sal_Int32 nEndIndex ) throw (::com::sun::star::lang::IndexOutOfBoundsException, ::com::sun::star::uno::RuntimeException)
	{
		BBSolarGuard aSolarGuard;
		::osl::MutexGuard aGuard( getOslMutex() );
		::rtl::OUString sText = implGetText();
		checkIndex_Impl( nStartIndex, sText );
		checkIndex_Impl( nEndIndex, sText );

		//!!! don't know how to put a string into the clipboard
		return sal_False;
	}
	void AccessibleBrowseBoxTableCell::disposing( const EventObject& _rSource ) throw (RuntimeException)
	{
        	if ( _rSource.Source == mxParent )
        	{
                	dispose();
        	}
	}

}
