/*************************************************************************
 *
 *  $RCSfile: hashcont.cxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 16:59:01 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include "hashcont.hxx"

#ifndef _DEBUG_HXX //autogen
#include <tools/debug.hxx>
#endif

DECL_SV_STRING_MAP(StringTest,String*);
DECL_SV_STRING_MAP_CONTAINER(StringTest1,String*);

//------------------------------------------------------------------
void SvStringMap::SetAt(const String& rKey, void* _pObj)
{
	StringHashTab::AddPtrSym((void *const)&rKey, _pObj);
}

//------------------------------------------------------------------
void* SvStringMap::RemoveAt(const String& rKey)
{
	HASHSYMPTR pElem = FindSym((void*const)&rKey);
	if (pElem)
	{
		void* pObj = StringHashTab::Derefer(pElem);
		DelSym(pElem);
		return pObj;
	}
	return NULL;
}

//------------------------------------------------------------------
void* SvStringMap::Remove(void* _pObj)
{
	HASHSYMPTR pElem = Find(_pObj);
	if (pElem)
	{
		DelSym(pElem);
		return _pObj;
	}
	return NULL;
}

//------------------------------------------------------------------
String SvStringMap::GetKey(void* _pObj) const
{
	HASHSYMPTR pElem = Find(_pObj);
	const void* pKey = StringHashTab::GetName(pElem);
	return pKey ? String(*(const String*)pKey) : String();
}

//------------------------------------------------------------------
void* SvStringMap::Lookup(const String& rKey) const
{
	return ((SvStringMap*)this)->FindPtrSym((void *const)&rKey);
}

//------------------------------------------------------------------
HASHSYMPTR SvStringMap::Find(void* _pObj) const
{
	if (!_pObj)
		return NULL;

	SvStringMap* THIS = (SvStringMap*) this;	// kleiner const cast
	HASHSYMPTR pElem = THIS->StringHashTab::First();
	while (pElem)
	{
		if (Derefer(pElem) == _pObj)
			break;
		else
			pElem =  THIS->StringHashTab::Next();
	}
	return pElem;
}

//------------------------------------------------------------------
ULONG SvStringMap::Count() const
{
	return (ULONG) ((SvStringMap*)this)->StringHashTab::Count();
}

//------------------------------------------------------------------
void SvStringMap::Clear()
{
	HASHSYMPTR pElem;
	while ((pElem = StringHashTab::First()) != NULL)
		DelSym(pElem);
}



//------------------------------------------------------------------
void SvStringMapContainer::InsertAt(const String& _rKey,
									void* _pObj,
									ULONG _nIndex)
{
	DBG_ASSERTWARNING(GetPos(_pObj) == CONTAINER_ENTRY_NOTFOUND && Lookup(_rKey) == NULL,
		"SvStringMapContainer::Insert -> Object already in List");

	Container::Insert(_pObj, _nIndex);
	aMap.SetAt(_rKey, _pObj);
}

//------------------------------------------------------------------
void* SvStringMapContainer::ReplaceAt(const String& _rOldKey,
									  const String& _rKey,
									  void* _pObj)
{
	void* pOldObj = Lookup(_rOldKey);
	DBG_ASSERT(pOldObj, "SvStringMapContainer::Replace -> Objekt not found");

	ULONG nIndex  = Container::GetPos(pOldObj);
	pOldObj = Remove(pOldObj);
	if (pOldObj)
		InsertAt(_rKey, _pObj, nIndex);
	return pOldObj;
}

//------------------------------------------------------------------
void* SvStringMapContainer::ReplaceAt(ULONG _nIndex, const String& _rKey, void* _pObj)
{
	void* pOldObj = RemoveAt((ULONG)_nIndex);
	if (pOldObj)
		InsertAt(_rKey, _pObj, _nIndex);
	return pOldObj;
}

//------------------------------------------------------------------
void* SvStringMapContainer::Replace(void* _pOldObj, const String& _rKey, void* _pObj)
{
	ULONG nIndex  = Container::GetPos((void*)_pOldObj);
	void* pOldObj = RemoveAt(nIndex);
	if (pOldObj)
		InsertAt(_rKey, _pObj, nIndex);
	return pOldObj;
}

//------------------------------------------------------------------
void* SvStringMapContainer::RemoveAt(const String& _rKey)
{
	void* pOldObj	= Lookup(_rKey);
	DBG_ASSERT(pOldObj, "SvStringMapContainer::RemoveAt -> Objekt not found");
	if (pOldObj)
	{
		aMap.Remove(pOldObj);
		Container::Remove((void*)pOldObj);
	}
	return pOldObj;
}

//------------------------------------------------------------------
void* SvStringMapContainer::RemoveAt(ULONG _nIndex)
{
	void* pOldObj = Container::Remove(_nIndex);
	DBG_ASSERT(pOldObj, "SvStringMapContainer::RemoveAt -> Objekt not found");
	if (pOldObj)
		aMap.Remove(pOldObj);
	return pOldObj;
}

//------------------------------------------------------------------
void* SvStringMapContainer::Remove(void* _pObj)
{
	void* pOldObj = Container::Remove((void*)_pObj);
	DBG_ASSERT(pOldObj, "SvStringMapContainer::Remove -> Objekt not found");
	if (pOldObj)
		aMap.Remove(_pObj);

	return pOldObj;
}


