/*************************************************************************
 *
 *  $RCSfile: wpclient.cxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 17:03:05 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/


#define INCL_DOSPROCESS
#define INCL_DOSERRORS
#include <svpm.h>
#include <solar.h>

#include <string.h>
#include <wpclient.hxx>

static const char cBackSlash = '\\';

/*****************************************************************************
 *
 * WPSBaseImpl Implementation
 *
 *****************************************************************************
 */

inline Boolean IsPipeError(APIRET rc)
{
    return rc == ERROR_BROKEN_PIPE
        || rc == ERROR_BAD_PIPE
        || rc == ERROR_PIPE_NOT_CONNECTED
        || rc == ERROR_PIPE_BUSY;
}

/*------------------------------------------------------------------------------------
 * Constructor()
 *------------------------------------------------------------------------------------
 */

WPSBaseImpl::WPSBaseImpl() : ODynamicLoader<wps_api>("wps", "wps_init", TRUE)
{
    char buffer[256];
    OStartupInfo aInfo;

    // find out if PMSHELL is default shell
    m_bPMShell = (OStartupInfo::E_None == aInfo.getEnvironment("RUNWORKPLACE", buffer, 256)
                  && 0 == strcmp(buffer + 3, "OS2\\PMSHELL.EXE"));

    // create global mutex
    m_pMutex = new OMutex;

    m_hPipe  = 0;
    m_pAPI   = NULL;

    if(m_bPMShell && isLoaded())
    {
        // query wps api
        m_pAPI = getApi();

        if(m_pAPI)
        {
            
            // launch wps agent
            m_hPipe = m_pAPI->wps_connect();
        }
    }
}

/*------------------------------------------------------------------------------------
 * Destructor()
 *------------------------------------------------------------------------------------
 */

WPSBaseImpl::~WPSBaseImpl()
{
    if (m_hPipe)
        m_pAPI->wps_disconnect(m_hPipe);

    if (m_pMutex != 0)
        delete m_pMutex;
}

/*------------------------------------------------------------------------------------
 * isAvailable()
 *------------------------------------------------------------------------------------
 */

Boolean WPSBaseImpl::isAvailable()
{
    // if m_pAPI <> NULL, m_bPMShell must be true
    if(m_pAPI && !m_hPipe)
        m_hPipe = m_pAPI->wps_connect();

    return m_hPipe;
}

/*------------------------------------------------------------------------------------
 * sendRequest()
 *------------------------------------------------------------------------------------
 */

Boolean WPSBaseImpl::sendRequest(PSZ szDir, BYTE aType, PVOID pBuf, ULONG ulSize)
{
    // aquire pipe mutex
    NAMESPACE_VOS(OGuard) aGuard(m_pMutex);

    APIRET rc = 1;;
    UCHAR  n  = 2;

    OSL_ASSERT(m_pAPI);

    // loop counter - only 1 reconnect allowed
    while(m_hPipe && n--)
    {
        ULONG  ulActual = ulSize;

        // find first non-filesystem wps-object in specified folder
        rc = m_pAPI->wps_request(m_hPipe, szDir, aType, pBuf, &ulActual);

        // try to reconnect when connection lost
        if(rc && IsPipeError(rc))
        {
            m_hPipe = m_pAPI->wps_reconnect(m_hPipe);
            continue;
        }

        break;
    }

    return rc == NO_ERROR;
}

/*------------------------------------------------------------------------------------
 * queryHandle()
 *------------------------------------------------------------------------------------
 */

Boolean WPSBaseImpl::queryHandle(PSZ szDir, PVOID pBuf, ULONG ulSize)
{
    OSL_ASSERT(m_pAPI);

    if(ulSize >= sizeof(HOBJECT))
    {
        HOBJECT hObject = ((PFN_HQUERY) m_pAPI->wps_queryHandle)(szDir);

        if(!hObject)
        {
            char szBuffer[13];

            if(sendRequest(szDir, GET_OBJECT_HANDLE, &szBuffer, 13))
                hObject = m_pAPI->wps_queryHandle(szBuffer);
        }

        if(hObject)
        {
            *((HOBJECT *) pBuf) = hObject;
            return TRUE;
        }
    }

    return FALSE;
}
