/*************************************************************************
 *
 *  $RCSfile: i_struct.hxx,v $
 *
 *  $Revision: 1.1 $
 *
 *  last change: $Author: np $ $Date: 2002/05/14 08:29:33 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef UDM_I_STRUCT_HXX
#define UDM_I_STRUCT_HXX



// USED SERVICES
	// BASE CLASSES
#include <udm/struct.hxx>
	// COMPONENTS
#include <udm/object.hxx>
	// PARAMETERS
#include <vector>


namespace udm
{

template <class> class struct_traits;

template <class SRC>
class TStruct : public Struct
{
  public:
    typedef SRC     source_type;

    // LIFECYCLE
                        TStruct(
                            member_id           i_nCountMembers );
    virtual             ~TStruct();

    // OPERATIONS
    void                connect_to(
                           const source_type &  i_rObj );

  private:
    typedef std::vector<Object> MemberList;

    // Interface Data:
    virtual void        do_Dispose();

    // Interface Struct:
    virtual Object      inq_Member(
                            member_id           i_m ) const;
    virtual Object      inq_SearchByKey(
                            int                 i_nKey ) const;
    virtual member_id   size() const;

    // Locals
    const struct_traits<SRC> &
                        my_traits() const;

    // DATA
    mutable MemberList  aMembers;
    const source_type * pObj;
};



// Begin IMPLEMENTATION
//   further implementation can be found in udm/impl_struct.hxx

template <class SRC>
TStruct<SRC>::TStruct( member_id    i_nCountMembers )
    :   aMembers( i_nCountMembers ),
        pObj(0)
{
    // Until now we prefer lazy evaluation,
    //   so this commented out:
    //   pScheme->create_members(aMembers);

}

template <class SRC>
TStruct<SRC>::~TStruct()
{
}

template <class SRC>
inline void
TStruct<SRC>::connect_to( const source_type & i_rObj )
{
    pObj = &i_rObj;
}



}   // namespace udm

#endif


