/*************************************************************************
 *
 *  $RCSfile: outdev.h,v $
 *
 *  $Revision: 1.13 $
 *
 *  last change: $Author: hr $ $Date: 2003/03/27 17:57:25 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _SV_OUTDEV_H
#define _SV_OUTDEV_H

#ifndef _SV_SV_H
#include <sv.h>
#endif
#ifndef _SV_OUTFONT_HXX
#include <outfont.hxx>
#endif

class Size;
class Font;
class VirtualDevice;
class ImplServerGraphics;

// -----------------------------------------------------------------------

void ImplGetEnglishSearchFontName( String& rName );

// -----------------------------------------------------------------------

// C0 Controls and Basic Latin
#define IMPL_CACHE_A1_BIT       ((ULONG)0x00000001)
#define IMPL_CACHE_A1_FIRST     0x0020
#define IMPL_CACHE_A1_LAST      0x007E
#define IMPL_CACHE_A1_INDEX     0

// C1 Controls and Latin-1
#define IMPL_CACHE_A2_BIT       ((ULONG)0x00000002)
#define IMPL_CACHE_A2_FIRST     0x00A0
#define IMPL_CACHE_A2_LAST      0x00FF
#define IMPL_CACHE_A2_INDEX     (IMPL_CACHE_A1_INDEX+IMPL_CACHE_A1_LAST-IMPL_CACHE_A1_FIRST+1)

// Greek and Coptic
#define IMPL_CACHE_A3_BIT       ((ULONG)0x00000004)
#define IMPL_CACHE_A3_FIRST     0x0384
#define IMPL_CACHE_A3_LAST      0x03F3
#define IMPL_CACHE_A3_INDEX     (IMPL_CACHE_A2_INDEX+IMPL_CACHE_A2_LAST-IMPL_CACHE_A2_FIRST+1)

// Cyrillic
#define IMPL_CACHE_A4_BIT       ((ULONG)0x00000008)
#define IMPL_CACHE_A4_FIRST     0x0400
#define IMPL_CACHE_A4_LAST      0x045F
#define IMPL_CACHE_A4_INDEX     (IMPL_CACHE_A3_INDEX+IMPL_CACHE_A3_LAST-IMPL_CACHE_A3_FIRST+1)

// -----------------------------------------------------------------------

#define IMPL_WIDTH_CACHE_MAX    IMPL_CACHE_A4_LAST
#define IMPL_WIDTH_CACHE_COUNT  (IMPL_CACHE_A4_INDEX+IMPL_CACHE_A4_LAST-IMPL_CACHE_A4_FIRST+1)
#define IMPL_WIDTH_ARY_INIT     256
#define IMPL_WIDTH_ARY_RESIZE   256

// Could by any value not equal 0 (is only a hint)
#define IMPL_FACTOR_NOTINIT     ((long)1111111111)

// -----------------------------------------------------------------------

// -----------------------
// - ImplDevFontListData -
// -----------------------

#define IMPL_DEVFONT_SCALABLE       ((ULONG)0x00000001)
#define IMPL_DEVFONT_SYMBOL         ((ULONG)0x00000002)
#define IMPL_DEVFONT_NONESYMBOL     ((ULONG)0x00000004)
#define IMPL_DEVFONT_LIGHT          ((ULONG)0x00000010)
#define IMPL_DEVFONT_BOLD           ((ULONG)0x00000020)
#define IMPL_DEVFONT_NORMAL         ((ULONG)0x00000040)
#define IMPL_DEVFONT_NONEITALIC     ((ULONG)0x00000100)
#define IMPL_DEVFONT_ITALIC         ((ULONG)0x00000200)

struct ImplDevFontListData
{
    ImplFontData*       mpFirst;            // First FontData
    XubString           maName;             // Fontname (original FamilyName)
    XubString           maSearchName;       // Fontname in english and lowercase ascii without symbols
    XubString           maMapNames;         // Aliase
    FontFamily          meFamily;           // Family vom Font
    FontPitch           mePitch;            // Pitch vom Font
    ULONG               mnTypeFaces;        // Typeface Flags
    XubString           maMatchFamilyName;  // MATCH - FamilyName
    FontWeight          meMatchWeight;      // MATCH - Weight
    FontWidth           meMatchWidth;       // MATCH - Width
    ULONG               mnMatchType;        // MATCH - Type
};


// ---------------------
// - ImplWidthInfoData -
// ---------------------

struct ImplWidthInfoData
{
    USHORT              mnChar;
    long                mnWidth;
};

// ---------------
// - ImplCvtChar -
// ---------------

struct ImplCvtChar
{
    const sal_Unicode*  mpCvtTab;
    const char*         mpSubsFontName;
    sal_Unicode         (*mpCvtFunc)( sal_Unicode );
};

sal_Unicode ImplRecodeChar( const ImplCvtChar* pCvtData, sal_Unicode c );
void ImplRecodeString( const ImplCvtChar* pCvtData, String& rStr,
                       xub_StrLen nIndex, xub_StrLen nLen );
const ImplCvtChar* ImplGetRecodeData( const String& rOrgFontName,
                                      const String& rMapFontName );


// -----------------
// - ImplFontEntry -
// ------------------

struct ImplFontEntry
{
    ImplFontEntry*      mpNext;                     // Naechster FontEntry
    ImplFontSelectData  maFontSelData;              // FontSelectionData
    ImplFontMetricData  maMetric;                   // Font-Metric
    const ImplCvtChar*  mpConversion;               // used e.g. for StarBats->StarSymbol
    long                mnLineHeight;               // FontHoehe
    ULONG               mnWidthInit;                // BitField, which sizes are init
    ImplKernPairData*   mpKernPairs;                // Kerning-Paare
    ULONG               mnKernPairs;                // Anzahl Kerning-Paare
    USHORT              mnRefCount;                 // Anzahl-Referenzen
    USHORT              mnSetFontFlags;             // Flags von SetFont()
    short               mnOwnOrientation;           // Drehung, falls System nicht dreht
    short               mnOrientation;              // Drehung vom Text
    BOOL                mbInit;                     // Wurden Daten initalisiert
    BOOL                mbInitKernPairs;            // Wurden Kerning-Daten initialisiert
    BOOL                mbFixedFont;                // Ist der Font ein FixedFont

                        ~ImplFontEntry();
};

// ----------------------
// - ImplGetDevFontList -
// ----------------------

class ImplGetDevFontList : private List
{
public:
                            ImplGetDevFontList() :
                                List( 4096, 512, 64 )
                            {}

    void                    Add( ImplFontData* pData )
                                { List::Insert( (void*)pData, LIST_APPEND ); }
    ImplFontData*           Get( ULONG i ) const
                                { return (ImplFontData*)List::GetObject( i ); }
    ULONG                   Count() const { return List::Count(); }
};

// ----------------------
// - ImplGetDevSizeList -
// ----------------------

class ImplGetDevSizeList : public List
{
private:
    XubString           maFontName;     // Name des Fonts, zu dem die Groessen gehoeren

public:
                        ImplGetDevSizeList( const XubString& rName ) :
                            List( 1024, 16, 16 ),
                            maFontName( rName )
                        {}

    void                Add( long nNewHeight );
    long                Get( ULONG nIndex ) const
                            { return (long)List::GetObject( nIndex ); }

    void                SetFontName( const XubString& rName ) { maFontName = rName; }
    const XubString&    GetFontName() const { return maFontName; }
};

// ----------------------
// - ImplFontSubstEntry -
// ----------------------

struct ImplFontSubstEntry
{
    String                  maName;
    String                  maReplaceName;
    String                  maSearchName;
    String                  maSearchReplaceName;
    USHORT                  mnFlags;
    ImplFontSubstEntry*     mpNext;
};

// -----------------
// - ImplFontCache -
// -----------------

class ImplFontCache
{
private:
    ImplFontEntry*      mpFirstEntry;
    USHORT              mnRef0Count;
    BOOL                mbPrinter;
    BOOL                mbDummy;

public:
                        ImplFontCache( BOOL bPrinter );
                        ~ImplFontCache();

    ImplFontEntry*      Get( ImplDevFontList* pFontList,
                             const Font& rFont, const Size& rSize, ImplFontSubstEntry* pDevSpecific );
    ImplFontEntry*      GetFallback( ImplDevFontList* pFontList,
                                     const Font& rFont, const Size& rSize,
                                     int nLevel,
                                     ImplFontSubstEntry* pDevSpecific
                                     );
    void                Release( ImplFontEntry* pEntry );
    void                Clear();
};

// ------------------
// - ImplOutDevData -
// ------------------

namespace vcl { struct ControlLayoutData; }

struct ImplOutDevData
{
    VirtualDevice*				mpRotateDev;
    vcl::ControlLayoutData*		mpRecordLayout;
	Rectangle					maRecordRect;
    ImplFontSubstEntry*			mpFirstFontSubstEntry;
};

void ImplFreeOutDevFontData();

#endif // _SV_OUTDEV_H
