/*************************************************************************
 *
 *  $RCSfile: salgdi.cxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: thb $ $Date: 2002/06/19 11:39:42 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include <string.h>
#include <svmac.h>

#define _SV_SALGDI_CXX

#ifndef _DEBUG_HXX
#include <tools/debug.hxx>
#endif
#ifndef _OSL_THREAD_H_
#include <osl/thread.h>
#endif
#ifndef _SV_SALDATA_HXX
#include <saldata.hxx>
#endif
#ifndef _SV_SALGDI_HXX
#include <salgdi.hxx>
#endif

// =======================================================================

// =======================================================================

inline void InlineSetCPixel( long nX, long nY, MacColor& rRGB )
{
	// ... evt. Abfrage auf RasterOp mit aufnehmen
	SetCPixel( nX, nY, rRGB );
	DBG_ASSERT((nX<=SHRT_MAX && nY<=SHRT_MAX),"SalGraphics::DrawPixel out of range!" );
	DBG_ASSERT((nX>=SHRT_MIN && nY>=SHRT_MIN),"SalGraphics::DrawPixel negativ!" );
}

// -----------------------------------------------------------------------
// last changed:	dv	26.09.97

static void Mac_DrawClosedPolygon( ULONG nPoints, const SalPoint* pPtAry )
{
	short	x, y;
	short	x1, y1;
	ULONG	i = nPoints - 1;

	DBG_ASSERT( ( nPoints > 2 ), "Polygone brauchen mindestens 3 Punkte" );

	x1 = (short) pPtAry->mnX;
	y1 = (short) pPtAry->mnY;

	pPtAry++;

	MoveTo ( x1, y1 );

	while( i-- != 0L )
	{
		x = (short) pPtAry->mnX;
		y = (short) pPtAry->mnY;
		pPtAry++;
		LineTo ( x, y );
	}

	LineTo ( x1, y1 );
}

// -----------------------------------------------------------------------
// last changed:	dv	26.09.97

static RgnHandle Mac_CreatePolygonRgn( ULONG nPoints, const SalPoint* pPtAry )
{
	RgnHandle hRegion = NewRgn ();

	OpenRgn();
	Mac_DrawClosedPolygon( nPoints, pPtAry );
	CloseRgn( hRegion );

	if ( QDError() != noErr )
	{
		DisposeRgn( hRegion );
		hRegion = 0L;
	}

	return hRegion;
}

// -----------------------------------------------------------------------
// last changed:	dv	26.09.97

static RgnHandle Mac_CreatePolyPolygonRgn( ULONG nPoly, const ULONG* pPoints,
										   PCONSTSALPOINT* ppPtAry )
{
	DBG_ASSERT( ( nPoly > 1 ), "PolyPolygone benoetigen mindesten ZWEI Polygone" );

	RgnHandle	hTmpRgn1 = NewRgn();
	RgnHandle	hTmpRgn2 = NewRgn();
	USHORT		ii;
	USHORT		nPoints;

	for ( ii = 0; ii < nPoly; ii++ )
	{
		const SalPoint* pPtAry = ppPtAry[ii];
		nPoints = pPoints[ii];

		OpenRgn();
		Mac_DrawClosedPolygon( nPoints, pPtAry );
		CloseRgn( hTmpRgn2 );

		if ( QDError() == noErr )
		{
			if ( ii == 0 )
				CopyRgn( hTmpRgn2, hTmpRgn1 );
			else
				XorRgn( hTmpRgn1, hTmpRgn2, hTmpRgn1 );
		}
	}

	DisposeRgn( hTmpRgn2 );

	if ( QDError() != noErr )
	{
		DisposeRgn( hTmpRgn1 );
		hTmpRgn1 = 0L;
	}

	return hTmpRgn1;
}

// -----------------------------------------------------------------------

static SalColor ImplGetROPSalColor( SalROPColor nROPColor )
{
	SalColor nSalColor;

	switch( nROPColor )
	{
		case( SAL_ROP_0 ):
			nSalColor = MAKE_SALCOLOR( 255, 255, 255 );
		break;

		case( SAL_ROP_1 ):
		case( SAL_ROP_INVERT ):
			nSalColor = MAKE_SALCOLOR( 0, 0, 0 );
		break;
	}

	return nSalColor;
}

// =======================================================================

void ImplInitSalGDI()
{}

// -----------------------------------------------------------------------

void ImplFreeSalGDI()
{}

// =======================================================================
// last changed:	dv	31.10.97

void ImplSalInitGraphics( SalGraphicsData* pData )
{
	DBG_ASSERT( pData->mpGrafPort , "ImplSalInitGraphics mpGrafPort == 0" );
	pData->meLastDrawMode = DRAW_NONE;
	pData->mnStatus |= CHANGED_CLIP;
}

// -----------------------------------------------------------------------

void ImplSalDeInitGraphics( SalGraphicsData* mpData )
{}

// =======================================================================
// last changed:	dv	02.12.97

SalGraphicsData::SalGraphicsData()
{
	memset( this, 0, sizeof( SalGraphicsData ) );
	mnStatus |= CHANGED_CLIP;
	mnPenMode = patCopy;
	mnXRes = MyIntToFixed( 96 );		// eigentlich 72
	mnYRes = MyIntToFixed( 96 );		// eigentlich 72
}

// -----------------------------------------------------------------------
// last changed:	dv	26.09.97

SalGraphicsData::~SalGraphicsData()
{
	// Objekte zerstoeren
	ReplaceFillBrush( (PixPatHandle)0L );

	// Clip-Region freigeben; ACHTUNG: die Grow-Rgn gehoert dem Frame !!!
	if ( mhClipRgn )
	{
		DisposeRgn( mhClipRgn );
		mhClipRgn = 0L;
	}
}

// -----------------------------------------------------------------------
// last changed:	dv	26.09.97

void SalGraphicsData::ReplaceFillBrush( PixPatHandle hPPat )
{
	// Altes PixPat entsorgen
	if ( mhDefBrush && hPPat != mhDefBrush )
		DisposePixPat( mhDefBrush );

	mhDefBrush = hPPat;
}

// -----------------------------------------------------------------------
// last changed:	dv	19.01.98

BOOL SalGraphicsData::CombineClipRgn( RgnHandle hRegion )
{
	// CombineClipRgn muss/soll hRegion entsorgen, es sei denn, hRegion wird
	// zu mhRegion!

	BOOL bRet = TRUE;

	DBG_ASSERT( hRegion, "CombineClipRgn ohne Rgn !" );

	if ( mhClipRgn )
	{
		UnionRgn(mhClipRgn, hRegion, mhClipRgn);
		DisposeRgn( hRegion );
	}
	else
	{
		mhClipRgn = hRegion;
	}

	return bRet;
}

// -----------------------------------------------------------------------
// last changed:	dv	12.11.97

BOOL SalGraphicsData::CheckDrawMode( DrawMode eNewMode )
{
	GrafPtr	pCurPort;
	BOOL	bRet = TRUE;

	osl_yieldThread();

	if ( ( eNewMode == DRAW_FILL ) && mbTransparentBrush )
		return FALSE;
	else if ( ( eNewMode == DRAW_LINE ) && mbTransparentPen )
		return FALSE;

	GetPort( &pCurPort );
	if ( pCurPort != (GrafPtr) mpGrafPort )
		SetGWorld( mpGrafPort, mhDevice );

	if ( eNewMode == DRAW_SETPORT )
		return TRUE;

	if ( mnStatus & CHANGED_CLIP )
	{
		if ( mhClipRgn )
			SetClip( mhClipRgn );
		else
			ClipRect( &( mpGrafPort->portRect ) );
		mnStatus &= ~CHANGED_CLIP;
	}

	// Wenn sich der Zeichenmodus nicht geaendert hat, dann ist hier Schluss
	if ( meLastDrawMode == eNewMode )
	{
		return TRUE;
	}

	if ( eNewMode == DRAW_TEXT )
	{
		RGBForeColor( maTextColor );
		TextFont( mnFontNum );
		TextFace( mnFontFace );
		TextSize( mnFontSize );
	}
	else if ( eNewMode == DRAW_LINE )
	{
		PenNormal();
		PenMode( mnPenMode );
		RGBForeColor( maPenColor );
	}
	else if ( eNewMode == DRAW_FILL )
	{
		PenNormal();
		PenMode( mnPenMode );
		RGBForeColor( maBrushColor );
	}
	else if (eNewMode == DRAW_BITS )
	{
		PenNormal();
		ForeColor( blackColor );
		BackColor( whiteColor );
	}

	meLastDrawMode = eNewMode;

	return TRUE;
}

// =======================================================================

SalGraphics::SalGraphics()
{
	MAC_SAL_TRACE("SalGraphics::__ct");
}

// -----------------------------------------------------------------------

SalGraphics::~SalGraphics()
{
	MAC_SAL_TRACE("SalGraphics::__dt");
}

// -----------------------------------------------------------------------

void SalGraphics::GetResolution( long& rDPIX, long& rDPIY )
{
	MAC_SAL_TRACE("SalGraphics::GetResolution");

	rDPIX = MyFixedToInt( maGraphicsData.mnXRes );
	rDPIY = MyFixedToInt( maGraphicsData.mnYRes );
}

// -----------------------------------------------------------------------

void SalGraphics::GetScreenFontResolution( long& rDPIX, long& rDPIY )
{
	MAC_SAL_TRACE("SalGraphics::GetResolution");

/*
	rDPIX = 108;		// 8 Point Font auf 12 Point hochskalieren ( 72 / 8 * 12 )
	rDPIY = 108;
*/
	rDPIX = 108;
	rDPIY = 108;
}

// -----------------------------------------------------------------------
// last changed:	dv	26.09.97

USHORT SalGraphics::GetBitCount()
{
	MAC_SAL_TRACE("SalGraphics::GetBitCount");

	USHORT nBitCount = 1;	// bw

	if ( maGraphicsData.mpGrafPort )
	{
		PixMapHandle hPixmap = maGraphicsData.mpGrafPort->portPixMap;
		nBitCount = (**hPixmap).pixelSize;
	}
	else
	{
		DBG_ERROR( "SalGraphics::GetBitCount bit count falsch !");
	}

	return nBitCount;
}

// -----------------------------------------------------------------------
// last changed:	dv	11.12.97

void SalGraphics::ResetClipRegion()
{
	if ( ! maGraphicsData.mbWindow )
	{
		if ( maGraphicsData.mhClipRgn )
		{
			DisposeRgn( maGraphicsData.mhClipRgn );
			maGraphicsData.mhClipRgn = NULL;
		}
	}
	else
	{
		if ( ! maGraphicsData.mhClipRgn )
			maGraphicsData.mhClipRgn = NewRgn();
	
		Rect clip = maGraphicsData.mpGrafPort->portRect;
		SetRectRgn( maGraphicsData.mhClipRgn, 0, 0,
					clip.right - clip.left,
					clip.bottom - clip.top );
	
		if ( maGraphicsData.mhGrowRgn )
			DiffRgn( maGraphicsData.mhClipRgn, maGraphicsData.mhGrowRgn,
					 maGraphicsData.mhClipRgn );
	}
	maGraphicsData.mnStatus |= CHANGED_CLIP;
}

// -----------------------------------------------------------------------
// last changed:	hro	15.01.98

void SalGraphics::BeginSetClipRegion( ULONG )
{
	if ( maGraphicsData.mhClipRgn )
	{
		DisposeRgn( maGraphicsData.mhClipRgn );
		maGraphicsData.mhClipRgn = NULL;
	}
}

// -----------------------------------------------------------------------
// last changed:	hro	16.01.98

BOOL SalGraphics::UnionClipRegion( long nX, long nY, long nWidth, long nHeight )
{
	RgnHandle hRegion = NewRgn();

	SetRectRgn( hRegion, nX, nY, nX+nWidth, nY+nHeight);
	if (maGraphicsData.mhClipRgn)
	{
		UnionRgn(maGraphicsData.mhClipRgn, hRegion, maGraphicsData.mhClipRgn);
		DisposeRgn(hRegion);
	}
	else
		maGraphicsData.mhClipRgn = hRegion;
		
	return TRUE;
}

// -----------------------------------------------------------------------

void SalGraphics::EndSetClipRegion()
{
	if ( maGraphicsData.mhClipRgn )
	{
		if ( maGraphicsData.mhGrowRgn )
			DiffRgn( maGraphicsData.mhClipRgn, maGraphicsData.mhGrowRgn,
					 maGraphicsData.mhClipRgn );
	}
	else
		ResetClipRegion();

	maGraphicsData.mnStatus |= CHANGED_CLIP;
}

// -----------------------------------------------------------------------

void SalGraphics::SetLineColor()
{
	maGraphicsData.mbTransparentPen = TRUE;
}

// -----------------------------------------------------------------------

void SalGraphics::SetLineColor( SalColor nSalColor )
{
	MacColor aRGB( SALCOLOR_RED  ( nSalColor ),
				   SALCOLOR_GREEN( nSalColor ),
				   SALCOLOR_BLUE ( nSalColor ) );

	maGraphicsData.mbTransparentPen = FALSE;
	maGraphicsData.maPenColor = aRGB;
	maGraphicsData.meLastDrawMode = DRAW_NONE;
}

// -----------------------------------------------------------------------

void SalGraphics::SetFillColor()
{
	maGraphicsData.mbTransparentBrush = TRUE;
}

// -----------------------------------------------------------------------

void SalGraphics::SetFillColor( SalColor nSalColor )
{
	SalData	*pSalData = GetSalData();

	MacColor aRGB( SALCOLOR_RED  ( nSalColor ),
				   SALCOLOR_GREEN( nSalColor ),
				   SALCOLOR_BLUE ( nSalColor ) );

	maGraphicsData.maBrushColor = aRGB;
	maGraphicsData.mbTransparentBrush = FALSE;
	maGraphicsData.meLastDrawMode = DRAW_NONE;

	PixPatHandle hPattern = NULL;

	// !!! die 16 Grundfarben duerfen nicht gedithered werden !!!

	if (   nSalColor != MAKE_SALCOLOR( 0x00, 0x00, 0x00 )   // black
		&& nSalColor != MAKE_SALCOLOR( 0x00, 0x00, 0x80 ) // blue
		&& nSalColor != MAKE_SALCOLOR( 0x00, 0x80, 0x00 ) // green
		&& nSalColor != MAKE_SALCOLOR( 0x00, 0x80, 0x80 ) // cyan
		&& nSalColor != MAKE_SALCOLOR( 0x80, 0x00, 0x00 ) // red
		&& nSalColor != MAKE_SALCOLOR( 0x80, 0x00, 0x80 ) // magenta
		&& nSalColor != MAKE_SALCOLOR( 0x80, 0x80, 0x00 ) // brown
		&& nSalColor != MAKE_SALCOLOR( 0x80, 0x80, 0x80 ) // gray
		&& nSalColor != MAKE_SALCOLOR( 0xC0, 0xC0, 0xC0 ) // light gray
		&& nSalColor != MAKE_SALCOLOR( 0x00, 0x00, 0xFF ) // light blue
		&& nSalColor != MAKE_SALCOLOR( 0x00, 0xFF, 0x00 ) // light green
		&& nSalColor != MAKE_SALCOLOR( 0x00, 0xFF, 0xFF ) // light cyan
		&& nSalColor != MAKE_SALCOLOR( 0xFF, 0x00, 0x00 ) // light red
		&& nSalColor != MAKE_SALCOLOR( 0xFF, 0x00, 0xFF ) // light magenta
		&& nSalColor != MAKE_SALCOLOR( 0xFF, 0xFF, 0x00 ) // light brown
		&& nSalColor != MAKE_SALCOLOR( 0xFF, 0xFF, 0xFF ) ) // white
	{
		hPattern = NewPixPat();
		MakeRGBPat( hPattern, aRGB );
	}

	maGraphicsData.ReplaceFillBrush( hPattern );
}

// -----------------------------------------------------------------------

void SalGraphics::SetROPLineColor( SalROPColor nROPColor )
{
	SetLineColor( ImplGetROPSalColor( nROPColor ) );
}

// -----------------------------------------------------------------------

void SalGraphics::SetROPFillColor( SalROPColor nROPColor )
{
	SetFillColor( ImplGetROPSalColor( nROPColor ) );
}

// -----------------------------------------------------------------------

void SalGraphics::SetXORMode( BOOL bSet )
{
	maGraphicsData.meLastDrawMode = DRAW_NONE;

	if ( bSet )
		maGraphicsData.mnPenMode = patXor;
	else
		maGraphicsData.mnPenMode = patCopy;
}

// -----------------------------------------------------------------------

void SalGraphics::DrawPixel( long nX, long nY )
{
	InlineSetCPixel( nX, nY, maGraphicsData.maPenColor );
}

// -----------------------------------------------------------------------

void SalGraphics::DrawPixel( long nX, long nY, SalColor nSalColor )
{
	if ( maGraphicsData.CheckDrawMode( DRAW_BITS ) )
	{
		MacColor aRGB( SALCOLOR_RED  ( nSalColor ),
					   SALCOLOR_GREEN( nSalColor ),
					   SALCOLOR_BLUE ( nSalColor ) );
		InlineSetCPixel( nX, nY, aRGB );
	}
}

// -----------------------------------------------------------------------

void SalGraphics::DrawLine( long nX1, long nY1, long nX2, long nY2 )
{
	if ( maGraphicsData.CheckDrawMode( DRAW_LINE ) )
	{
		MoveTo( (INT16)nX1, (INT16)nY1 );
		// we must paint the endpoint
		LineTo( (INT16)nX2, (INT16)nY2 );
	}
}

// -----------------------------------------------------------------------

void SalGraphics::DrawRect( long nX, long nY, long nDX, long nDY )
{
	MacRect aMRect( nY, nX, nY + nDY, nX + nDX );

	if ( maGraphicsData.CheckDrawMode( DRAW_FILL ) )
	{
		if ( maGraphicsData.mhDefBrush )
			FillCRect( aMRect, maGraphicsData.mhDefBrush );
		else
			PaintRect( aMRect );
	}
	if ( maGraphicsData.CheckDrawMode( DRAW_LINE ) )
	{
		FrameRect( aMRect );
	}
}

// -----------------------------------------------------------------------
// last changed:	dv	12.11.97

void SalGraphics::DrawPolyLine( ULONG nPoints, const SalPoint* pPtAry )
{
	DBG_ASSERT( maGraphicsData.mpGrafPort, "No Grafport ?" );

	if ( maGraphicsData.CheckDrawMode( DRAW_LINE ) )
	{
		ULONG	i;
		short	x, y;

		x = (short) pPtAry->mnX;
		y = (short) pPtAry->mnY;
		pPtAry++;
		MoveTo ( x, y );

		for( i=1 ; i < nPoints ; i++ )
		{
			x = (short) pPtAry->mnX;
			y = (short) pPtAry->mnY;
			pPtAry++;
			LineTo ( x, y );
		}
	}
}

// -----------------------------------------------------------------------
// last changed:	dv	12.11.97

void SalGraphics::DrawPolygon( ULONG nPoints, const SalPoint* pPtAry )
{
	DBG_ASSERT( maGraphicsData.mpGrafPort, "No Grafport ?" );

	ULONG	nMaxPoint = ((ULONG)SHRT_MAX - sizeof(MAC_Polygon)) / sizeof(MAC_Point);
	if ( nPoints > nMaxPoint )
	{	nPoints = nMaxPoint -1;
	}

	// Zuerst mit checkDrawMode den richtigen Port setzen
	maGraphicsData.CheckDrawMode( DRAW_SETPORT );

	// Polygon erzeugen
	PolyHandle hMyPoly = OpenPoly();
	Mac_DrawClosedPolygon( nPoints, pPtAry );
	ClosePoly();

	// Inhalt des Polygons mit dem Muster malen
	if ( QDError()==noErr)
	{
		if ( maGraphicsData.CheckDrawMode( DRAW_FILL ) )
		{
			if ( maGraphicsData.mhDefBrush )
				FillCPoly( hMyPoly, maGraphicsData.mhDefBrush );
			else
				PaintPoly( hMyPoly );
		}
		if ( maGraphicsData.CheckDrawMode( DRAW_LINE ) )
		{	// Rahmen zeicnen
			FramePoly( hMyPoly );
		}
	}

	// Das Polygon nach Gebrauch entsorgen
	KillPoly( hMyPoly );
}

// -----------------------------------------------------------------------

void SalGraphics::DrawPolyPolygon( ULONG nPoly, const ULONG* pPoints,
								   PCONSTSALPOINT* ppPtAry )
{
	if ( !maGraphicsData.mpGrafPort )
		return;

	DBG_ASSERT( (nPoly>1), " DrawPolyPolygon mit weniger als zwei Polygonen!!");

	maGraphicsData.CheckDrawMode( DRAW_SETPORT );

	RgnHandle hTmpRgn = Mac_CreatePolyPolygonRgn( nPoly, pPoints, ppPtAry );

	if ( hTmpRgn )
	{
		// Polygon (QD) malen
		if ( maGraphicsData.CheckDrawMode( DRAW_FILL ) )
		{
			if ( maGraphicsData.mhDefBrush )
				FillCRgn( hTmpRgn, maGraphicsData.mhDefBrush );
			else
				PaintRgn( hTmpRgn );
		}
		if ( maGraphicsData.CheckDrawMode( DRAW_LINE ) )
		{	// Rahmen zeicnen
			FrameRgn( hTmpRgn );
		}
	}

	DisposeRgn( hTmpRgn );
}

// -----------------------------------------------------------------------

sal_Bool SalGraphics::DrawPolyLineBezier( ULONG nPoints, const SalPoint* pPtAry, const BYTE* pFlgAry )
{
    return sal_False;
}

// -----------------------------------------------------------------------

sal_Bool SalGraphics::DrawPolygonBezier( ULONG nPoints, const SalPoint* pPtAry, const BYTE* pFlgAry )
{
    return sal_False;
}

// -----------------------------------------------------------------------

sal_Bool SalGraphics::DrawPolyPolygonBezier( ULONG nPoly, const ULONG* pPoints,
                                             const SalPoint* const* pPtAry, const BYTE* const* pFlgAry )
{
    return sal_False;
}

// -----------------------------------------------------------------------
// last changed:	hro	15.01.98
// Die Flags muessen noch breuecksichtigt werden !!! Kommt noch !

void SalGraphics::Invert( ULONG nPoints, const SalPoint* pPtAry, SalInvert nFlags )
{
	ULONG	i;
	short	x, y;

	DBG_ASSERT( maGraphicsData.mpGrafPort, "No Grafport ?" );

	x = (short) pPtAry->mnX;
	y = (short) pPtAry->mnY;
	pPtAry++;
	MoveTo ( x, y );
	maGraphicsData.CheckDrawMode( DRAW_BITS );
	PenPat( (ConstPatternParam)&qd.gray );
	PenMode( patXor );

	for( i=1 ; i < nPoints ; i++ )
	{
		x = (short) pPtAry->mnX;
		y = (short) pPtAry->mnY;
		pPtAry++;
		LineTo ( x, y );
	}

	PenMode( patCopy );
}
void SalGraphics::CopyArea( long nDestX, long nDestY,
							long nSrcX, long nSrcY,
							long nSrcWidth, long nSrcHeight,
							USHORT nFlags )
{
	SalTwoRect	aTwoRect;
	
	aTwoRect.mnSrcX = nSrcX;
	aTwoRect.mnSrcY = nSrcY;
	aTwoRect.mnSrcWidth = nSrcWidth;
	aTwoRect.mnSrcHeight = nSrcHeight;
	aTwoRect.mnDestX = nDestX;
	aTwoRect.mnDestY = nDestY;
	aTwoRect.mnDestWidth = nSrcWidth;
	aTwoRect.mnDestHeight = nSrcHeight;
	
	CopyBits(&aTwoRect, this);
}

	
// -----------------------------------------------------------------------

BOOL SalGraphics::DrawEPS( long nX, long nY, long nWidth, long nHeight, void* pPtr, ULONG nSize )
{
	return FALSE;
}

