/*************************************************************************
 *
 *  $RCSfile: fibersrv.hxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 15:18:12 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/


#ifndef _VOS_FIBERSRV_HXX_
#define _VOS_FIBERSRV_HXX_

#ifndef _VOS_TYPES_HXX_
#	include <vos/types.hxx>
#endif
#ifndef _VOS_EXECABL_HXX_
#	include <vos/execabl.hxx>
#endif
#ifndef _VOS_THREAD_HXX_
#	include <vos/thread.hxx>
#endif
#ifndef _VOS_MUTEX_HXX_
#	include <vos/mutex.hxx>
#endif
#ifndef _VOS_REF_HXX_
#	include <vos/ref.hxx>
#endif
#ifndef _VOS_QUEUE_HXX_
#	include <vos/queue.hxx>
#endif

#ifdef _USE_NAMESPACE
namespace vos
{     
#endif


/////////////////////////////////////////////////////////////////////////////
//
//  class OFiberingServer
//
//      Depends on cooperative executing IExecutable-Objects.
//      The OFiberingServer creates one thread where each IExecutables execute()
//      method is called in turn. When an execute() returns False, the FiberServer
//      assumes it is finished and stops calling it.
//      As the FiberServer depends on the cooperative nature of the IExecutables,
//      their execute()-methods should neither contain blocking functions nor 
//      should they be used to do very time-consuming task.
//      If you need preemtive multitasking or want to use blocking calls, use   
//      a OThreadServer instead.
//
//
//      <BHO> Further ideas:
//      - Include a sleep() operation (in IExecutable?) to tell the
//      OFiberingServer not to call the IExecutable for some time.
//      - Assign an delay/call-intervall attribute to the IExecutable,
//      which tells the OFiberingServer/OThreadingServer to let the
//      specified time pass doing something else before calling the executable 
//      again.
//

class OFiberingServer : public NAMESPACE_VOS(OReference),
						public NAMESPACE_VOS(OThread) 
{
	VOS_DECLARE_CLASSINFO(NAMESPACE_VOS(OFiberingServer));
public:

	/**
		Creates an empty fiberserver.
	*/
	OFiberingServer();

	/**
		By destroying the OFiberServer, you also delete all its IExecutable-Objects.
	*/
	~OFiberingServer();

	/** 
		Adds an IExecutable to the server and starts calling its execute() method.
	*/
	void SAL_CALL add(const ORef<IExecutable>& ref);		

	/** 
		Stops calling the the IExecutable and removes it from the server.
	*/
	void SAL_CALL remove(const ORef<IExecutable>& ref);

	/** Wait till all excutables are finished.
	*/
	void SAL_CALL complete();

	/** Block until the next executable has finished and return a reference to it.
	*/
	ORef<IExecutable> SAL_CALL getNextCompleted();


protected:

	virtual void SAL_CALL run();

	typedef ORef<IExecutable> TRefExecutable;

	// queue of running executables
	NAMESPACE_VOS(OQueue<TRefExecutable>) m_RunningQueue;

	// queue of finished executables
	NAMESPACE_VOS(OQueue<TRefExecutable>) m_CompletedQueue;
	
	NAMESPACE_VOS(OMutex) m_Lock;

};

#ifdef _USE_NAMESPACE
}
#endif

#endif // _VOS_FIBERSRV_HXX_

