/*************************************************************************
 *
 *  $RCSfile: componentloader.hxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: as $ $Date: 2002/08/12 11:41:24 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef __FRAMEWORK_HELPER_COMPONENTLOADER_HXX_
#define __FRAMEWORK_HELPER_COMPONENTLOADER_HXX_

//_________________________________________________________________________________________________________________
//	my own includes
//_________________________________________________________________________________________________________________

#ifndef __FRAMEWORK_CLASSES_ARGUMENTANALYZER_HXX_
#include <classes/argumentanalyzer.hxx>
#endif

#ifndef __FRAMEWORK_THREADHELP_THREADHELPBASE_HXX_
#include <threadhelp/threadhelpbase.hxx>
#endif

#ifndef __FRAMEWORK_THREADHELP_READGUARD_HXX_
#include <threadhelp/readguard.hxx>
#endif

#ifndef __FRAMEWORK_THREADHELP_WRITEGUARD_HXX_
#include <threadhelp/writeguard.hxx>
#endif

#ifndef __FRAMEWORK_MACROS_XINTERFACE_HXX_
#include <macros/xinterface.hxx>
#endif

#ifndef __FRAMEWORK_MACROS_XTYPEPROVIDER_HXX_
#include <macros/xtypeprovider.hxx>
#endif

#ifndef __FRAMEWORK_MACROS_GENERIC_HXX_
#include <macros/generic.hxx>
#endif

#ifndef __FRAMEWORK_MACROS_DEBUG_HXX_
#include <macros/debug.hxx>
#endif

#ifndef __FRAMEWORK_GENERAL_H_
#include <general.h>
#endif

//_________________________________________________________________________________________________________________
//	interface includes
//_________________________________________________________________________________________________________________

#ifndef _COM_SUN_STAR_FRAME_XCOMPONENTLOADER_HPP_
#include <com/sun/star/frame/XComponentLoader.hpp>
#endif

#ifndef _COM_SUN_STAR_FRAME_XFRAME_HPP_
#include <com/sun/star/frame/XFrame.hpp>
#endif

#ifndef _COM_SUN_STAR_FRAME_XFRAMELOADER_HPP_
#include <com/sun/star/frame/XFrameLoader.hpp>
#endif

#ifndef _COM_SUN_STAR_FRAME_XLOADEVENTLISTENER_HPP_
#include <com/sun/star/frame/XLoadEventListener.hpp>
#endif

#ifndef _COM_SUN_STAR_LANG_XMULTISERVICEFACTORY_HPP_
#include <com/sun/star/lang/XMultiServiceFactory.hpp>
#endif

#ifndef _COM_SUN_STAR_BEANS_PROPERTYVALUE_HPP_
#include <com/sun/star/beans/PropertyValue.hpp>
#endif

#ifndef _COM_SUN_STAR_UTIL_URL_HPP_
#include <com/sun/star/util/URL.hpp>
#endif

#ifndef _COM_SUN_STAR_TASK_XINTERACTIONHANDLER_HPP_
#include <com/sun/star/task/XInteractionHandler.hpp>
#endif

#ifndef _COM_SUN_STAR_TASK_XINTERACTIONREQUEST_HPP_
#include <com/sun/star/task/XInteractionRequest.hpp>
#endif

#ifndef _COM_SUN_STAR_TASK_XINTERACTIONABORT_HPP_
#include <com/sun/star/task/XInteractionAbort.hpp>
#endif

#ifndef _COM_SUN_STAR_DOCUMENT_XINTERACTIONFILTERSELECT_HPP_
#include <com/sun/star/document/XInteractionFilterSelect.hpp>
#endif

#ifndef _COM_SUN_STAR_DOCUMENT_AMBIGOUSFILTERREQUEST_HPP_
#include <com/sun/star/document/AmbigousFilterRequest.hpp>
#endif

//_________________________________________________________________________________________________________________
//	other includes
//_________________________________________________________________________________________________________________

#ifndef _CPPUHELPER_WEAK_HXX_
#include <cppuhelper/weak.hxx>
#endif

#ifndef _THREAD_HXX_
#include <osl/thread.hxx>
#endif

#ifndef _SV_SVAPP_HXX
#include <vcl/svapp.hxx>
#endif

//_________________________________________________________________________________________________________________
//	namespace
//_________________________________________________________________________________________________________________

namespace framework{

//_________________________________________________________________________________________________________________
//	exported const
//_________________________________________________________________________________________________________________

//_________________________________________________________________________________________________________________
//	exported definitions
//_________________________________________________________________________________________________________________

/*-************************************************************************************************************//**
    @short      implements a helper for loading documents in any target frame
    @descr      This helper support the functionality of the interface XComponentComponentLoader.
                It combines all neccessary services for TypeDetection, ExtendedTypeDetection, FrameComponentLoader, Filter,
                Frame to reach this goal. So it can be used at any node inside the frame tree to provide
                such loading of documents. Of course targeting (means findFrame()) is supported too here.

    @base       ThreadHelpBase
                    help to guarantee correct initialized lock member at startup

    @base       OWeakObject
                    provides the refcount and XInterface, XWeak

	@devstatus	ready to use
	@threadsafe	yes
    @modified   01.07.2002 09:39, as96863
*//*-*************************************************************************************************************/
class ComponentLoader : public  css::lang::XTypeProvider
                      , public  css::frame::XComponentLoader
                      , private ThreadHelpBase
                      , public  ::cppu::OWeakObject
{
    //_____________________________________
    // structs
//    struct LoadInfo
//    {
        /// uno factory, which can created services inside this context
        css::uno::Reference< css::lang::XMultiServiceFactory > m_xFactory;
        /// our owner frame which use our functionality (wee need to start findFrame() there!)
        css::uno::Reference< css::frame::XFrame > m_xOwner;
//        /// the target frame of the load request
//        css::uno::Reference< css::frame::XFrame > m_xTarget;
//        /// the "MediaDescriptor"
//        ArgumentAnalyzer m_aDescriptor;
//    }

    //_____________________________________
    // interface
	public:

        //_________________________________
        // ctor/dtor
                 ComponentLoader( const css::uno::Reference< css::lang::XMultiServiceFactory >& xFactory ,
                                  const css::uno::Reference< css::frame::XFrame >&              xFrame   );
        virtual ~ComponentLoader(                                                                        );

        //_________________________________
        // XInterface, XTypeProvider
		DECLARE_XINTERFACE
		DECLARE_XTYPEPROVIDER

        //_________________________________
        // XComponentLoader
        virtual css::uno::Reference< css::lang::XComponent > SAL_CALL loadComponentFromURL( const ::rtl::OUString&                                 sURL         ,
                                                                                            const ::rtl::OUString&                                 sTargetName  ,
                                                                                                  sal_Int32                                        nSearchFlags ,
                                                                                            const css::uno::Sequence< css::beans::PropertyValue >& lDescriptor  ) throw (css::io::IOException               ,
                                                                                                                                                                         css::lang::IllegalArgumentException,
                                                                                                                                                                         css::uno::RuntimeException         );

        //_________________________________
        // static public helper !

        static sal_Bool                                     detectTypeAndFilter             ( const css::uno::Reference< css::lang::XMultiServiceFactory >& xFactory    ,
                                                                                              const css::util::URL&                                         aURL        ,
                                                                                                    ArgumentAnalyzer&                                       rDescriptor ,
                                                                                                    sal_Bool                                                bDeep       );
        static sal_Bool                                     isContent                       ( const css::uno::Reference< css::lang::XMultiServiceFactory >& xFactory    ,
                                                                                              const ::rtl::OUString&                                        sURL        );
        static sal_Bool                                     isComponent                     ( const css::uno::Reference< css::lang::XMultiServiceFactory >& xFactory    ,
                                                                                              const ::rtl::OUString&                                        sURL        ,
                                                                                                    ArgumentAnalyzer&                                       rDescriptor );
        static ::rtl::OUString                              specifyDocServiceByURL          ( const css::uno::Reference< css::lang::XMultiServiceFactory >  xFactory    ,
                                                                                              const css::util::URL&                                         aURL        ,
                                                                                                    ArgumentAnalyzer&                                       rDescriptor );
        static ::rtl::OUString                              specifyDocServiceByDocument     ( const css::uno::Reference< css::lang::XMultiServiceFactory >  xFactory  ,
                                                                                              const css::uno::Reference< css::frame::XController >&         xDocument );
        static css::uno::Reference< css::frame::XFrame >    findAndActivateAlreadyLoadedTask( const css::uno::Reference< css::lang::XMultiServiceFactory >  xFactory    ,
                                                                                              const css::util::URL&                                         aURL        ,
                                                                                                    ArgumentAnalyzer&                                       rDescriptor );
        static css::uno::Reference< css::frame::XFrame >    findAndLockRecycleTask          ( const css::uno::Reference< css::lang::XMultiServiceFactory >  xFactory    ,
                                                                                              const css::util::URL&                                         aURL        ,
                                                                                                    ArgumentAnalyzer&                                       rDescriptor );
        static css::uno::Reference< css::lang::XComponent > loadItIntoFrame                 ( const css::uno::Reference< css::lang::XMultiServiceFactory >& xFactory    ,
                                                                                              const css::util::URL&                                         aURL        ,
                                                                                                    ArgumentAnalyzer&                                       rDescriptor ,
                                                                                              const css::uno::Reference< css::frame::XFrame >&              xTarget     ) throw(css::io::IOException);
        static css::uno::Reference< css::lang::XComponent > getFrameComponent               ( const css::uno::Reference< css::frame::XFrame >&              xFrame      );
        static void                                         updateFrameAfterLoading         ( const css::uno::Reference< css::lang::XMultiServiceFactory >& xFactory    ,
                                                                                              const css::uno::Reference< css::frame::XFrame >&              xFrame      ,
                                                                                                    ArgumentAnalyzer&                                       rDescriptor );

    //_____________________________________
    // private helper
	public:

        void impl_checkLoadParameters(
                                       const ::rtl::OUString&  sURL         ,
                                       const ::rtl::OUString&  sTargetName  ,
                                             sal_Int32         nSearchFlags ,
                                       const ArgumentAnalyzer& rDescriptor  ) throw (css::lang::IllegalArgumentException);

}; // class ComponentLoader

} // namespace framework

#endif // #ifndef __FRAMEWORK_HELPER_COMPONENTLOADER_HXX_
