/*************************************************************************
 *
 *  $RCSfile: LoginContext.java,v $
 *
 *  $Revision: 1.1 $
 *
 *  last change: $Author: dbo $ $Date: 2000/12/21 13:34:22 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
package com.sun.star.comp.security.auth.login;

import com.sun.star.uno.UnoRuntime;
import com.sun.star.registry.XRegistryKey;
import com.sun.star.lang.XServiceInfo;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.lang.XSingleServiceFactory;

import com.sun.star.comp.security.ServiceFactory;

import com.sun.star.comp.security.AccessController;
import com.sun.star.comp.security.AccessControlContext;
import com.sun.star.comp.security.PrivilegedExceptionAction;

import com.sun.star.security.XPrivilegedAction;
import com.sun.star.security.XAccessControlContext;
import com.sun.star.security.auth.XSubject;
import com.sun.star.security.auth.login.XLoginContext;
import com.sun.star.security.auth.login.LoginException;
import com.sun.star.security.auth.callback.XCallbackHandler;


//==================================================================================================
class Subject implements XSubject
{
	private static final boolean DEBUG = true;
	private javax.security.auth.Subject _subject;

	//----------------------------------------------------------------------------------------------
	public Subject( javax.security.auth.Subject subject )
	{
		_subject = subject;
	}
	
	// XSubject
	//______________________________________________________________________________________________
    public void/*Object*/ doAs( XPrivilegedAction action )
		throws com.sun.star.uno.Exception, com.sun.star.uno.RuntimeException
	{
		try
		{
			/*return*/ javax.security.auth.Subject.doAs(
				_subject, new PrivilegedExceptionAction( action ) );
		}
		catch (java.security.PrivilegedActionException exc)
		{
			AccessController.rethrowException( exc );
//  			return null; // for dummy
		}
	}
	//______________________________________________________________________________________________
    public Object doAsPrivileged( XPrivilegedAction action, XAccessControlContext restriction )
		throws com.sun.star.uno.Exception, com.sun.star.uno.RuntimeException
	{
		try
		{
			if (restriction == null)
			{
				return javax.security.auth.Subject.doAsPrivileged(
					_subject, new PrivilegedExceptionAction( action ), null );
			}
			else
			{
				return javax.security.auth.Subject.doAsPrivileged(
					_subject, new PrivilegedExceptionAction( action ),
					AccessControlContext.getContext( restriction ) );
			}
		}
		catch (java.security.PrivilegedActionException exc)
		{
			AccessController.rethrowException( exc );
			return null; // for dummy
		}
	}
	//______________________________________________________________________________________________
    public void logout()
		throws com.sun.star.uno.RuntimeException
	{
	}
}

//==================================================================================================
public class LoginContext implements XLoginContext,
									 XServiceInfo
{
    private static final boolean DEBUG = true;
	private static final String SERVICE_NAME = "com.sun.star.security.auth.login.LoginContext";

	// XLoginContext
	//______________________________________________________________________________________________
    public XSubject login( String applicationName, XCallbackHandler handler )
		throws LoginException, com.sun.star.uno.RuntimeException
	{
		return null;
	}
	
	// XServiceInfo
    //______________________________________________________________________________________________
    public String getImplementationName() 
		throws com.sun.star.uno.RuntimeException
    {
        return LoginContext.class.getName();
    }
    //______________________________________________________________________________________________
    public boolean supportsService( String serviceName ) 
		throws com.sun.star.uno.RuntimeException
    {
		return serviceName.equals( SERVICE_NAME );
    }
    //______________________________________________________________________________________________
    public String [] getSupportedServiceNames() 
		throws com.sun.star.uno.RuntimeException
	{
        return new String [] { SERVICE_NAME };
	}
	
	/**
	 * Returns the service factory for the <code>ServiceManager</code>. If the given implementation name 
	 * does not equal to the <code>ServiceManagers</code> class name null will be returned.
	 * <p>
	 * @return     the factory for the <code>ServiceManager</code>.
	 * @param      implName		the implementation name of the of the service. 
	 *                          Must be equal to <code>com.sun.star.comp.servicemanager.ServicManager</code>
	 * @param	   multiFactory	refernce of the <code>MultiServiceFactory</code>. This parameter will be ignored.
	 * @param	   regKey		the root key of the registry. This parameter will be ignored. 	
	 */
  	public static XSingleServiceFactory getServiceFactory(
		String implName, 
		XMultiServiceFactory multiFactory, 
		XRegistryKey regKey )
	{
	    if (implName.equals( LoginContext.class.getName() ))
		{
			return new ServiceFactory(
				LoginContext.class,
				new String [] { SERVICE_NAME } );
		}
		return null;
	}
}
