/*************************************************************************
 *
 *  $RCSfile: section.cxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 16:59:05 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _SV_SV_H
#include <vcl/sv.h>
#endif
#ifndef _SV_CTRL_HXX
#include <vcl/ctrl.hxx>
#endif
#ifndef _SV_DOCKWIN_HXX
#include <vcl/dockwin.hxx>
#endif

#ifndef	_SV_SECTCTR_HXX
#include "sectctr.hxx"
#endif

#include "section.hxx"

#define SPLIT_HEIGHT	4

SvSection::SvSection(const XubString& rName, SvSectionControl* pParent,WinBits nStyle):
		DockingWindow(pParent,nStyle | WB_CLIPCHILDREN),
		aExpander(this,WB_TABSTOP),
		aChildWinContainer(this,WB_DIALOGCONTROL|WB_NOBORDER|WB_CLIPCHILDREN),
		aPrivatSplit(this,PRIVSPLIT_VERT,WB_NOBORDER),
		aName(rName),
		pSectionControl(pParent),
		pChildWin(NULL),
		nSectionID(0),
		nHeight(0),
		nOldHeight(-1),
		nMinHeight(0),
		nMinWidth(0)
{
	aExpander.SetText(rName);
	aExpander.SetPosPixel(Point());
	aExpander.SetToggleHdl(LINK( this, SvSection, ToggleHdl ) );
	aExpander.Show();
	aPrivatSplit.SetBackground(pSectionControl->GetBackground());
	aPrivatSplit.Show();
	aPrivatSplit.SetCtrModifiedHdl(LINK( this, SvSection, SplitHdl));

	Size aSize(aExpander.GetMinSize());
	long nImageWidth=aSize.Width();
	long nNewSize=aSize.Height();
	aChildWinContainer.SetPosPixel(Point(nImageWidth,nNewSize));
	aChildWinContainer.SetBackground();
	aChildWinContainer.SetPaintTransparent(TRUE);
	aChildWinContainer.Show();

	nMinHeight=aExpander.GetMinSize().Height();
	nMinWidth=0;
	SetBackground();          
	SetPaintTransparent(TRUE);
}		
		
		
SvSection::SvSection(const XubString& rName, SvSectionControl* pParent, Window* pWin, WinBits nStyle):
		DockingWindow(pParent,nStyle| WB_CLIPCHILDREN),
		aExpander(this,WB_TABSTOP),
		aChildWinContainer(this,WB_DIALOGCONTROL|WB_NOBORDER|WB_CLIPCHILDREN),
		aPrivatSplit(this,PRIVSPLIT_VERT,WB_NOBORDER),
		aName(rName),
		pSectionControl(pParent),
		pChildWin(pWin),
		nSectionID(0),
		nHeight(0),
		nOldHeight(-1),
		nMinHeight(0),
		nMinWidth(0)
{
	aExpander.SetText(rName);
	aExpander.SetPosPixel(Point());
	aExpander.SetToggleHdl(LINK( this, SvSection, ToggleHdl ) );
	aExpander.Show();
	aPrivatSplit.SetBackground(pSectionControl->GetBackground());
	aPrivatSplit.Show();
	aPrivatSplit.SetCtrModifiedHdl(LINK( this, SvSection, SplitHdl));
	
	Size aSize(aExpander.GetMinSize());
	long nImageWidth=aSize.Width();
	long nNewSize=aSize.Height();
	aChildWinContainer.SetPosPixel(Point(nImageWidth,nNewSize));
	aChildWinContainer.SetBackground();
	aChildWinContainer.SetPaintTransparent(TRUE);
	aChildWinContainer.Show();

	if(pChildWin!=NULL) 
	{
		pChildWin->SetParent(&aChildWinContainer);
		pChildWin->SetPosPixel(Point(0,0));
		pChildWin->SetStyle(WB_CLIPCHILDREN | pChildWin->GetStyle());
		if(!pChildWin->IsBackground())
		{
			pChildWin->SetBackground(pSectionControl->GetBackground());
			pChildWin->SetPaintTransparent(FALSE);
		}

		pChildWin->Show();
	}
	nMinHeight=aExpander.GetMinSize().Height();
	nMinWidth=0;
	SetBackground();          
	SetPaintTransparent(TRUE);
}		

const SvSectionControl*	SvSection::GetSectionControl()const
{
	return pSectionControl;
}
		
void SvSection::Resize()
{
	Size aSize=GetOutputSizePixel();
	Size a2Size(aExpander.GetMinSize());
	long nImageWidth=a2Size.Width();
	long nWidth=aSize.Width()-2*nImageWidth;
		
	a2Size.Width()=aSize.Width();
	aExpander.SetSizePixel(a2Size);

	ULONG nSpltPos=aSize.Height()-SPLIT_HEIGHT;

   	if(aPrivatSplit.IsVisible())
	{
		aPrivatSplit.SetPosSizePixel(Point(nImageWidth,nSpltPos),
						Size(nWidth,SPLIT_HEIGHT));
		aSize.Height()-=SPLIT_HEIGHT;
	}

	if(aChildWinContainer.IsVisible())
	{
		aSize.Height()-=aExpander.GetMinSize().Height();
		aSize.Width()=nWidth;
		aChildWinContainer.SetSizePixel(aSize);
		if(pChildWin!=NULL)
		{
			aSize=pChildWin->GetSizePixel();
			
			if(nWidth <= nMinWidth)
				nWidth  = nMinWidth;

			if(aSize.Width() != nWidth )
			{
				pChildWin->SetSizePixel(aSize);
			}
			else
				aChildWinContainer.Invalidate(INVALIDATE_NOCHILDREN);
		}
	}
}

void SvSection::Paint( const Rectangle& rRect )
{
	DrawWallpaper(rRect,pSectionControl->GetBackground());
}
		

long SvSection::Notify( NotifyEvent& rNEvt )
{
	long nRes = FALSE;

	if(rNEvt.GetType() == EVENT_KEYINPUT)
	{
		const KeyEvent* pKEvt = rNEvt.GetKeyEvent();
		
		KeyCode aKeyCode = pKEvt->GetKeyCode();
		USHORT	nKeyCode = aKeyCode.GetCode();

		if ( aKeyCode.IsMod1() )
		{
			switch (nKeyCode)
			{
				case KEY_ADD:
					if(!IsExpanded()) 
						aExpander.SetExpanderImage(EST_PLUS_DOWN);
					nRes = TRUE;
					break;
				case KEY_SUBTRACT:
					if(IsExpanded()) 
						aExpander.SetExpanderImage(EST_MIN_DOWN);
					nRes = TRUE;
					break;
			}
		}

	}
	else if(rNEvt.GetType() == EVENT_KEYUP)
	{
		const KeyEvent* pKEvt = rNEvt.GetKeyEvent();
		
		KeyCode aKeyCode = pKEvt->GetKeyCode();
		USHORT	nKeyCode = aKeyCode.GetCode();

		if ( aKeyCode.IsMod1() )
		{
			switch (nKeyCode)
			{
				case KEY_ADD:
					nRes = TRUE;
					ExpandSection();
					break;
				case KEY_SUBTRACT:
					nRes = TRUE;
					ShrinkSection();
					aExpander.GrabFocus();
					break;
			}
		}
	}
	
	if(!nRes)
	{
		nRes = DockingWindow::Notify(rNEvt );
	}
	return nRes;
}

void SvSection::SetSectionControl(SvSectionControl* pParent)
{
	pSectionControl=pParent;
	SetParent(pParent);
}

void SvSection::SetSectionText( const XubString& rString)
{
	aExpander.SetText(rString);
	aName=rString;
}

void SvSection::SetChildWin(Window* pWin)
{
	pChildWin=pWin;
	if(pChildWin!=NULL) 
	{
		pChildWin->SetParent(&aChildWinContainer);
		pChildWin->SetPosPixel(Point(0,0));
		pChildWin->SetStyle(WB_CLIPCHILDREN | pChildWin->GetStyle());
		if(!pChildWin->IsBackground())
		{
			pChildWin->SetBackground(pSectionControl->GetBackground());
			pChildWin->SetPaintTransparent(FALSE);
		}

		if(aChildWinContainer.IsVisible())
			pChildWin->Show();
	}
}

void SvSection::ExpandSection()
{
	if(!IsExpanded())
	{
		aExpander.SetToExpanded(TRUE);
		ImplExpandSection();	
	}
}

void SvSection::ShrinkSection()
{
	if(IsExpanded())
	{
		aExpander.SetToExpanded(FALSE);
		ImplShrinkSection();
	}
}

void SvSection::ImplExpandSection()
{
	USHORT nId=GetSectionID();
	long nNewSize=aExpander.GetMinSize().Height();
	//if(pChildWin!=NULL) nNewSize+=pChildWin->GetSizePixel().Height();
	//if(pChildWin!=NULL) pChildWin->Show();
	aChildWinContainer.Show();
	aPrivatSplit.Show();
	
	if(nOldHeight<0)
		nOldHeight=pSectionControl->GetSectionSize( nId);
	
	pSectionControl->SetSectionSize( nId,nOldHeight);
}

void SvSection::ImplShrinkSection()
{
	USHORT nId=GetSectionID();
	nOldHeight=pSectionControl->GetSectionSize( nId);
	aChildWinContainer.Hide();
	aPrivatSplit.Hide();
	long nNewSize=aExpander.GetMinSize().Height();
	pSectionControl->SetSectionSize( nId,nNewSize );
}

BOOL SvSection::IsExpanded()
{
	return aExpander.IsExpanded();
}

void SvSection::SetMaxHeight(long nSize)
{
	nHeight=nSize;
	nSize-=SPLIT_HEIGHT;
	Range aYRange(aExpander.GetMinSize().Height(),nSize);

	aPrivatSplit.SetYRange(aYRange);
}

long SvSection::GetMaxHeight()
{
	return nHeight;
}

void SvSection::SetMinHeight(long nSize)
{
	if(nSize>aExpander.GetMinSize().Height())
	{
		nMinHeight=nSize;
	}
	else
	{
		nMinHeight=aExpander.GetMinSize().Height();
	}

	Range aYRange(nMinHeight,nHeight);
	aPrivatSplit.SetYRange(aYRange);
}

long SvSection::GetMinHeight()
{
	return nMinHeight;
}

void SvSection::SetMinWidth(long nWidth)
{
	if(nMinWidth!=nWidth)
	{
		nMinWidth=nWidth;
		pSectionControl->SetSectionWidth(GetSectionID(),nMinWidth);
	}
}

long SvSection::GetMinWidth()
{
	Size a2Size(aExpander.GetMinSize());
	long nImageWidth=a2Size.Width();
	long nWidth=nMinWidth+2*nImageWidth;
	return nWidth;
}

void SvSection::SetScrollPos(long nPos)
{
	if(pChildWin!=NULL)
	{
		Point aPos(pChildWin->GetPosPixel());
		aChildWinContainer.Scroll(nPos-aPos.X(),0,SCROLL_CHILDREN);
		aPos.X() = nPos;
		pChildWin->SetPosPixel(aPos);
	}
}

void SvSection::SetChildPos(long nPos)
{
	if(pChildWin!=NULL)
	{
		Point aPos(pChildWin->GetPosPixel());
		aPos.X() = nPos;
		pChildWin->SetPosPixel(aPos);
	}
}

IMPL_LINK( SvSection, ToggleHdl, SvExpander*, pPtr )
{
	if(pPtr==&aExpander)
	{
		if(!IsExpanded())
		{
			ImplExpandSection();
		}
		else
		{
			ImplShrinkSection();
		}
		
	}
	return 0;
}

IMPL_LINK( SvSection, SplitHdl,SvPrivatSplit*, pCtrl )
{
	if (pCtrl == &aPrivatSplit)
	{
		long nTmpHeight=aPrivatSplit.GetPosPixel().Y();
		nTmpHeight+=SPLIT_HEIGHT;
		if(nTmpHeight>nHeight) nTmpHeight=nHeight;

		Rectangle aRect(Point(),GetParent()->GetOutputSizePixel());

		aRect.Top() = GetPosPixel().Y() + nTmpHeight - aPrivatSplit.GetDeltaY();
		long nOldHeight = GetSizePixel().Height();

		GetParent()->Scroll(0,nTmpHeight-nOldHeight,aRect,SCROLL_CHILDREN);
		pSectionControl->SetSectionSize( GetSectionID(),nTmpHeight);
	}

	return 0;
}


