/*************************************************************************
 *
 *  $RCSfile: e3dundo.hxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 17:00:55 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _E3D_UNDO_HXX
#define _E3D_UNDO_HXX

#ifndef _SVDUNDO_HXX
#include "svdundo.hxx"
#endif
class E3DObject;
#ifndef _E3D_SCENE3D_HXX
#include "scene3d.hxx"
#endif

class E3dView;

/************************************************************************\
|*
|* Basisklasse fuer alle 3D-Undo-Aktionen.
|*
\************************************************************************/
class E3dUndoAction : public SdrUndoAction
{

	protected :
		E3dObject *pMy3DObj;

	public:
		TYPEINFO();
		E3dUndoAction (SdrModel  *pModel,
					   E3dObject *p3DObj) :
			SdrUndoAction (*pModel),
			pMy3DObj (p3DObj)
			{
			}

		virtual ~E3dUndoAction ();

		virtual BOOL CanRepeat(SfxRepeatTarget&) const;
};

/************************************************************************\
|*
|* Undo fuer 3D-Rotation ueber die Rotationsmatrizen (ob das wohl klappt ?)
|*
\************************************************************************/
class E3dRotateUndoAction : public E3dUndoAction
{
		Matrix4D aMyOldRotation;
		Matrix4D aMyNewRotation;

	public:
		TYPEINFO();
		E3dRotateUndoAction (SdrModel       *pModel,
							 E3dObject      *p3DObj,
							 const Matrix4D &aOldRotation,
							 const Matrix4D &aNewRotation) :
			E3dUndoAction (pModel, p3DObj),
			aMyOldRotation (aOldRotation),
			aMyNewRotation (aNewRotation)
			{
			}

		virtual ~E3dRotateUndoAction ();

		virtual void Undo();
		virtual void Redo();

};

/************************************************************************\
|*
|* Undo fuer 3D-Attribute (Implementiert ueber Set3DAttributes())
|*
\************************************************************************/
class E3dAttributesUndoAction : public SdrUndoAction
{
	SdrObject*	pObject;
	E3dView*	pView;
	BOOL		bUseSubObjects;

	const SfxItemSet aNewSet;
	const SfxItemSet aOldSet;

 public:
		TYPEINFO();
		E3dAttributesUndoAction( SdrModel &rModel, E3dView*	pView,
			E3dObject* pInObject,
			const SfxItemSet& rNewSet,
			const SfxItemSet& rOldSet,
			BOOL bUseSubObj);

		virtual ~E3dAttributesUndoAction();

		virtual BOOL CanRepeat(SfxRepeatTarget& rView) const;
		virtual void Undo();
		virtual void Redo();
		virtual void Repeat();
};


#endif			// _E3D_CUBE3D_HXX
