/*************************************************************************
 *
 *  $RCSfile: frmdirlbox.hxx,v $
 *
 *  $Revision: 1.1 $
 *
 *  last change: $Author: dr $ $Date: 2002/09/12 09:51:55 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _SVX_FRMDIRLBOX_HXX
#define _SVX_FRMDIRLBOX_HXX

#ifndef _LSTBOX_HXX
#include <vcl/lstbox.hxx>
#endif
#ifndef _SVX_FRMDIR_HXX
#include "frmdir.hxx"
#endif

namespace svx {

// ----------------------------------------------------------------------------

/** This listbox contains entries to select the horizontal text direction in
    frames (i.e. left-to-right, right-to-left). It supports the
    SvxFrameDirection enumeration, used i.e. in conjunction with the
    SvxFrameDirectionItem. */
class FrameDirectionListBox : public ListBox
{
public:
    explicit                    FrameDirectionListBox( Window* pParent, WinBits nStyle = WB_BORDER );
    explicit                    FrameDirectionListBox( Window* pParent, const ResId& rResId );
    virtual                     ~FrameDirectionListBox();

    /** Inserts a string with corresponding direction enum into the listbox. */
    void                        InsertEntryValue(
                                    const String& rString,
                                    SvxFrameDirection eDirection,
                                    sal_uInt16 nPos = LISTBOX_APPEND );
    /** Removes the entry, that represents the specified frame direction. */
    void                        RemoveEntryValue( SvxFrameDirection eDirection );

    /** Selects the specified frame direction. */
    void                        SelectEntryValue( SvxFrameDirection eDirection );
    /** Returns the currently selected frame direction. */
    SvxFrameDirection           GetSelectEntryValue() const;

    /** Saves the currently selected frame direction. */
    inline void                 SaveValue() { meSaveValue = GetSelectEntryValue(); }
    /** Returns the frame direction saved with SaveValue(). */
    inline SvxFrameDirection    GetSavedValue() const { return meSaveValue; }

private:
    SvxFrameDirection           meSaveValue;        /// Saved value for later comparison.
};

// ----------------------------------------------------------------------------

} // namespace svx

#endif

