/*************************************************************************
 *
 *  $RCSfile: rapofflinecommandprocessor.cxx,v $
 *
 *  $Revision: 1.1 $
 *
 *  last change: $Author: sb $ $Date: 2001/06/07 12:58:11 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef INCLUDED_UCB_RAPOFFLINECOMMANDPROCESSOR_HXX
#include "rapofflinecommandprocessor.hxx"
#endif

#ifndef INCLUDED_UCB_RAPOFFLINECOMMANDMAP_HXX
#include "rapofflinecommandmap.hxx"
#endif
#ifndef INCLUDED_UCB_RAPOFFLINEINTERACTIONREQUEST_HXX
#include "rapofflineinteractionrequest.hxx"
#endif

#ifndef _COM_SUN_STAR_UCB_UNSUPPORTEDCOMMANDEXCEPTION_HPP_
#include "com/sun/star/ucb/UnsupportedCommandException.hpp"
#endif
#ifndef _OSL_DIAGNOSE_H_
#include "osl/diagnose.h"
#endif

using namespace com::sun;
using ucprmt::offline::CommandProcessor;
using ucprmt::offline::CommandMapSupplier;

CommandProcessor::CommandProcessor(CommandMapSupplier & rCommandMapSupplier,
                                   void * pContent):
    m_rCommandMapSupplier(rCommandMapSupplier),
    m_pContent(pContent)
{}

CommandProcessor::~CommandProcessor()
{}

sal_Int32 SAL_CALL CommandProcessor::createCommandIdentifier()
    throw (star::uno::RuntimeException)
{
    return 0;
}

star::uno::Any SAL_CALL
CommandProcessor::execute(
    star::ucb::Command const & rCommand,
    sal_Int32,
    star::uno::Reference< star::ucb::XCommandEnvironment > const &
        rEnvironment)
    throw (star::uno::Exception)
{
    //TODO! Multi thread safe access to m_xCommandMap?
    if (!m_xCommandMap.is())
        m_xCommandMap = m_rCommandMapSupplier.getCommandMap();
    OSL_ASSERT(m_xCommandMap.is());
    CommandMap::iterator aIt(m_xCommandMap->find(rCommand.Name));
    if (aIt == m_xCommandMap->end())
        handleInteractionRequest(
            star::uno::makeAny(
                star::ucb::UnsupportedCommandException(
                    rtl::OUString(
                            RTL_CONSTASCII_USTRINGPARAM(
                               "ucprmt::offline::CommandProcessor::execute "))
                        + rCommand.Name,
                    star::uno::Reference< star::uno::XInterface >(
                        this, star::uno::UNO_QUERY))),
            rEnvironment);
    return
        aIt->second.m_pFunction(m_pContent, rCommand.Argument, rEnvironment);
}

void SAL_CALL CommandProcessor::abort(sal_Int32)
    throw (star::uno::RuntimeException)
{}
