
/**
 * Title:        Help Content Provider<p>
 * Description:  <p>
 * Copyright:    Copyright (c) Andreas Bille ( abi )<p>
 * Company:      Sun Microsystems. Inc<p>
 * @author Andreas Bille ( abi )
 * @version 1.0
 */
package com.sun.star.help;

import java.io.*;
import com.sleepycat.db.*;

public class CreateDb {

	public CreateDb()
 	{
  	}



   	void iterate( String dbName )
    {
    	System.out.println( dbName );
    	Db table = null;
		try
		{
			table = new Db( null,0 );
		}
		catch( DbException e )
		{
			System.out.println( "Error initializing database" );
		}

		table.set_error_stream( System.err );
		table.set_errpfx( "HelpAccess" );
		try
		{
			table.open( dbName,null,Db.DB_BTREE,Db.DB_RDONLY,0644 );
			Dbc cursor = table.cursor( null,0 );

			StringDbt key = new StringDbt();
			StringDbt data = new StringDbt();
			//
			boolean first = true;
  			key.set_flags( Db.DB_DBT_MALLOC );      // The cursor must allocate the necessary memory
     		data.set_flags( Db.DB_DBT_MALLOC );
		    String filePrefix = System.getProperty( "com.sun.star.help.Directory" );
		    File outFile = new File( "e:/helpdata/test1/filelist" );
			try
			{
			    outFile.createNewFile();
			}
			catch( IOException e )
			{
			    e.printStackTrace();
			}

			FileWriter outStream = null;
			try
			{
			    outStream = new FileWriter( outFile );
			}
			catch( IOException e )
			{
				e.printStackTrace();
			}

			while( Db.DB_NOTFOUND != cursor.get( key,data,Db.DB_NEXT ) )
			{
   				// String keyStr = new String( key.get_data(),0,key.get_size() );
       			// String dataStr = new String( data.get_data(),0,data.get_size() );

				String keyStr = key.getString();
				String dataStr = data.getString();
				String testStr1 = data.getFile();
				String testStr2 = data.getDatabase();
				String testStr3 = data.getTitle();
				if( ! testStr3.equals("") )
					System.out.println( keyStr + " " + testStr1 + " " + testStr2 + " " + testStr3 );

                String fileStr = filePrefix + "49/" + dataStr;
                File aFile = new File( fileStr );
                if( aFile.exists() )
				{
                	System.out.println( keyStr + " " + dataStr );
				    outStream.write( keyStr + " " + dataStr );
				}
       			if( first )
          		{
					key.set_flags( Db.DB_DBT_REALLOC );
     				data.set_flags( Db.DB_DBT_REALLOC );
         			first = false;
            	}
            }
		}
		catch( DbRunRecoveryException e )
		{
			System.out.println( "Not able to create cursor: " + e.getMessage() );
		}
		catch (DbException dbe)
		{
			System.err.println("HelpAccess: " + dbe.toString());
			System.exit(1);
		}
		catch (FileNotFoundException fnfe)
		{
			System.err.println("HelpAccess: " + fnfe.toString());
			System.exit(1);
		}
		catch( IOException e )
		{
		    e.printStackTrace();
		}
	}



  	public static void CreateDatabase()
  	{
    	String key1 = "1234";
    	String data1 = "dumm/start.xml";
    	String key2 = "4321";
    	String data2 = "blub/embedded.xml";
    	String key3 = "1235";
    	String data3 = "dumm/testpage.xml";

    	try
    	{
      		Db table = new Db(null, 0);
      		table.set_error_stream(System.err);
      		table.set_errpfx("AccessExample");
      		table.open("e:/rvp603b/help/helpaccess.db", null, Db.DB_HASH, Db.DB_CREATE, 0644);
      		StringDbt key = new StringDbt(key1);
      		StringDbt data = new StringDbt(data1);
      		try
      		{
        		int err;
        		if ((err = table.put(null, key, data, 0)) == Db.DB_KEYEXIST)
        		{
          			System.out.println("Key " + " already exists.");
        		}
      		}
      		catch (DbException dbe)
      		{
        		System.out.println(dbe.toString());
			}
      		System.out.println(" inserted first key ");


      		key = new StringDbt(key2);
      		data = new StringDbt(data2);
      		try
      		{
        		int err;
        		if ((err = table.put(null, key, data, 0)) == Db.DB_KEYEXIST)
        		{
          			System.out.println("Key " + " already exists.");
        		}
      		}
      		catch (DbException dbe)
      		{
        		System.out.println(dbe.toString());
      		}
      		System.out.println(" inserted second key ");


      		key = new StringDbt(key3);
      		data = new StringDbt(data3);
      		try
      		{
        		int err;
        		if ((err = table.put(null, key, data, 0)) == Db.DB_KEYEXIST)
        		{
          			System.out.println("Key " + " already exists.");
        		}
      		}
      		catch (DbException dbe)
      		{
        		System.out.println(dbe.toString());
      		}
      		System.out.println(" inserted third key ");


      		table.close(0);
		}
    	catch (DbException dbe)
    	{
      		System.err.println("AccessExample: " + dbe.toString());
      		System.exit(1);
    	}
    	catch (FileNotFoundException fnfe)
    	{
      		System.err.println("AccessExample: " + fnfe.toString());
      		System.exit(1);
    	}
  	}
}
