(*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: main.applescript,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: obo $ $Date: 2005/10/13 09:46:35 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 *************************************************************************)

--
-- the default handlers: run, open, idle, quit
--

on run
	runFondu()
	openSoffice("-")
end run

on open (theFiles)
	runFondu()
	openFiles( theFiles )
end open

on idle
	-- close icon only if ooo has terminated
	if isOOoRunning() = 0 then
		tell me to quit
	end
	-- check all x seconds if ok to quit
	return 3
end idle

on quit
	if isOOoRunning() = 0 then
		continue quit
	end if
end quit

-------------------------------------------------------------

on isOOoRunning()
	set soffice to getProgramPath() & "/soffice"
	set isRunning to do shell script "_FOUND_=`ps -wx -o command | grep \"" & soffice & "\" | grep -v grep`; echo $_FOUND_"
	if isRunning  "" then
		return 1
	else
		return 0
	end
end isOOoRunning

on openSoffice(aFile)
	set oooProgramPath to getProgramPath()
	set theDisplay to startXServer()
	set theEnv to "DISPLAY=" & theDisplay & " ; export DISPLAY; "
	set theCmd to "sh \"" & oooProgramPath & "/soffice" & "\" "
	do shell script theEnv & thecmd & aFile & " &>/dev/null & echo $!"
end

on startXServer()
	-- First try standard X11 location, then try standard XDarwin location
	set Xserverloc to "/Applications/Utilities/X11.app"
	set whichserver to do shell script "if [ -d " & Xserverloc & "  ]; then echo \"X11\"; else echo \"NOXSERVER\"; fi"
	if whichserver = "NOXSERVER" then
		set Xserverloc to "/Applications/XDarwin.app"
		set whichserver to do shell script "if [ -d " & Xserverloc & " ]; then echo \"XDarwin\"; else echo \"NOXSERVER\"; fi"
	end if
	
	-- if nothing found yet try using locate, first with X11.app and then with XDarwin.app
	if whichserver = "NOXSERVER" then
		set Xserverloc to do shell script "locate X11.app/Contents/MacOS/X11 | sed -e 's-/Contents/MacOS/X11--g'"
		if Xserverloc  "" then
			set whichserver to "X11"
		end if
	end if
	if whichserver = "NOXSERVER" then
		set Xserverloc to do shell script "locate XDarwin.app/Contents/MacOS/XDarwin | sed -e 's-/Contents/MacOS/XDarwin--g'"
		if Xserverloc  "" then
			set whichserver to "XDarwin"
		end if
	end if
	
	set now_running to ""
	set now_running to do shell script "INX=`ps -wcx | grep  \"" & whichserver & "\"`; echo $INX"
	if whichserver = "NOXSERVER" then
		-- display dialog "No XServer Found"
		set now_running to "Skip"
	end if
	
	-- display dialog "now running is " & now_running
	if now_running = "" then
		if whichserver = "X11" then
			-- enable keyboard extension for X11 for proper Alt key handling 
			set x11cmd to Xserverloc & "/Contents/MacOS/X11 +kb &>/dev/null & echo $!"
			do shell script x11cmd
			-- save process id
			set x11pid to the result
			-- wait until the window manager is started which is the second child process of x11
			set numchildrencmd to "ps -x -o ppid | grep " & x11pid & " | wc -l"
			set numchildren to 0
			set d to current date
			set t1 to time of d
			repeat while numchildren  2
				set d to current date
				set t2 to time of d
				-- give up after 30 seconds
				if t2 - t1 > 30 then
					display dialog "Command timed out"
					exit repeat
				end if
				set result to do shell script numchildrencmd
				set numchildren to result as integer
			end repeat
		else -- startup XDarwin
			do shell script "open " & "\"" & Xserverloc & "\"" & " >> /dev/null 2>&1"
			do shell script "sleep 4"
		end if
	end if
	
	
	if whichserver = "X11" then
	-- the DISPLAY variable is different for every user currently logged in
	-- X11 passes the DISPLAY as the last command line parameter to its child process
	-- we can use ps to read the command line and parse the trailing :0, :1, or whatever
		set xdisplay to do shell script "ps -wx -o command | grep X11.app | grep \":.$\" | sed \"s/^.*:/:/g\""
		-- display dialog xdisplay
		return xdisplay
	else
	-- TODO: find out how XDarwin does it
		return ":0"
	end if
end startXServer

on checkPath( aPath )
	set pathFound to do shell script "if [ -d \"" & aPath & "\" ]; then echo \"true\"; else echo \"false\"; fi"
	if( pathFound = "true" )
		return 1
	else
		return 0
	end if
end checkPath

on getInstallPath()
	set myPath to (path to me)
	set oooInstallPath to POSIX path of myPath & "Contents/openoffice.org"
	if checkPath( oooInstallPath ) = 0 then
		display dialog "No valid installation found at: " & oooInstallPath
		return ""
	else
		return oooInstallPath
	end if
end getInstallPath

on getProgramPath()
	return getInstallPath() & "/program"
end getProgramPath

on runFondu()
	set fondu to "/usr/local/bin/fondu"
	set fonduinstalled to do shell script "if [ -x " & fondu & "  ]; then echo \"true\"; else echo \"false\"; fi"
	if fonduinstalled = "false" then
		-- try fink version
		set fondu to "/sw/bin/fondu"
	end if
	set fonduinstalled to do shell script "if [ -x " & fondu & "  ]; then echo \"true\"; else echo \"false\"; fi"
	if fonduinstalled = "true" then
		set fontpath to getInstallPath() & "/share/fonts/truetype"
		set footprint to (fontpath & "/.fondudone")
		
		-- continue only if dir exists	
		set fontpathFound to do shell script "if [ -d \"" & fontpath & "\"  ]; then echo \"true\"; else echo \"false\"; fi"
		if checkPath( fontpath ) = 0 then
			display dialog "Font directory not found: " & fontpath
			return
		end

		-- check footprint to see if font conversion was already run
		set fonduDone to do shell script "if [ -e \"" & footprint & "\" ]; then echo \"true\"; else echo \"false\"; fi"
		if fonduDone = "false" then
			-- try to create footprint
			set result to do shell script "touch \"" & footprint & "\"; if [ -e \"" & footprint & "\" ]; then echo \"true\"; else echo \"false\"; fi" 
			if result = "false" then
				-- user not privileged
				return
			end if

			-- call fondu for each font (i.e. without wildcard), so if it crashes only one font is missing
			set fonduCmd0 to "cd \"" & fontpath & "\""
			set fonduCmd1 to "for i in /System/Library/Fonts/*; do " & fondu & " -force \"$i\" >> /dev/null 2>&1; done"
			set fonduCmd2 to "for i in /Library/Fonts/*; do " & fondu & " -force \"$i\" >> /dev/null 2>&1; done"
			try
				-- ignore errors
				set fonduCmd to "'" & fonduCmd0 & "; " & fonduCmd1 & "; " & fonduCmd2 & "'"
				-- with admin privileges does not work well on panther
				-- do shell script "sh -c " & fonduCmd with administrator privileges
				do shell script "sh -c " & fonduCmd
			end try
		end if
	end if
	
	-- the following sequence would make all installed fonts available to X11:
	-- create a ttf fontdir in home, eg. ~/Library/OpenOffice/fonts/truetype
	-- cd <ttf fontdir>
	-- fondu /Library/Fonts/*
	-- fondu /System/Library/Fonts/*
	-- fondu ~/Library/Fonts/*
	-- mkfontscale
	-- mkfontdir
	-- Note: for the following steps a running X11 is required
	-- xset fp+ <ttf fontdir>
	-- xset fp rehash
	-- start OOo...
	-- end if
end runFondu


on openFiles( fileList )
	if (count of fileList) > 0 then
		repeat with i from 1 to the count of fileList
			set theDocument to (item i of fileList)
			set theFilePath to " \"" & (POSIX path of theDocument) & "\""
			set theFileInfo to (info for theDocument)
			openSoffice(theFilePath)
		end repeat
	end if
end openFiles

