#*************************************************************************
#
#   OpenOffice.org - a multi-platform office productivity suite
#
#   $RCSfile: makefile.mk,v $
#
#   $Revision: 1.2 $
#
#   last change: $Author: obo $ $Date: 2005/10/13 09:46:50 $
#
#   The Contents of this file are made available subject to
#   the terms of GNU Lesser General Public License Version 2.1.
#
#
#     GNU Lesser General Public License Version 2.1
#     =============================================
#     Copyright 2005 by Sun Microsystems, Inc.
#     901 San Antonio Road, Palo Alto, CA 94303, USA
#
#     This library is free software; you can redistribute it and/or
#     modify it under the terms of the GNU Lesser General Public
#     License version 2.1, as published by the Free Software Foundation.
#
#     This library is distributed in the hope that it will be useful,
#     but WITHOUT ANY WARRANTY; without even the implied warranty of
#     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#     Lesser General Public License for more details.
#
#     You should have received a copy of the GNU Lesser General Public
#     License along with this library; if not, write to the Free Software
#     Foundation, Inc., 59 Temple Place, Suite 330, Boston,
#     MA  02111-1307  USA
#
#*************************************************************************

PRJ=..$/..
BUNDLE=OpenOffice.org.app

# --- Settings -------------------------------------------------

.INCLUDE :	settings.mk

# --- Files ----------------------------------------------------

.IF "$(OS)"!="MACOSX"

dummy:
        @echo "Nothing to build for OS $(OS)"

.ELSE           # "$(OS)"!="MACOSX"

scriptfiles = $(MISC)$/$(BUNDLE)$/Contents$/Resources$/Scripts$/main.scpt

plistfiles  = $(MISC)$/$(BUNDLE)$/Contents$/Info.plist \
		$(MISC)$/$(BUNDLE)$/Contents$/Resources$/InfoPlist.strings		

iconfiles = \
	$(MISC)$/$(BUNDLE)$/Contents$/Resources$/oo1-writer-doc.icns		\
	$(MISC)$/$(BUNDLE)$/Contents$/Resources$/oo1-writer-template.icns	\
	$(MISC)$/$(BUNDLE)$/Contents$/Resources$/oo1-master-doc.icns		\
	$(MISC)$/$(BUNDLE)$/Contents$/Resources$/oo1-calc-doc.icns		\
	$(MISC)$/$(BUNDLE)$/Contents$/Resources$/oo1-calc-template.icns		\
	$(MISC)$/$(BUNDLE)$/Contents$/Resources$/oo1-impress-doc.icns		\
	$(MISC)$/$(BUNDLE)$/Contents$/Resources$/oo1-impress-template.icns	\
	$(MISC)$/$(BUNDLE)$/Contents$/Resources$/oo1-draw-doc.icns		\
	$(MISC)$/$(BUNDLE)$/Contents$/Resources$/oo1-draw-template.icns		\
	$(MISC)$/$(BUNDLE)$/Contents$/Resources$/oo1-math-doc.icns		\
	$(MISC)$/$(BUNDLE)$/Contents$/Resources$/oo2-writer-doc.icns		\
	$(MISC)$/$(BUNDLE)$/Contents$/Resources$/oo2-writer-template.icns	\
	$(MISC)$/$(BUNDLE)$/Contents$/Resources$/oo2-master-doc.icns		\
	$(MISC)$/$(BUNDLE)$/Contents$/Resources$/oo2-calc-doc.icns		\
	$(MISC)$/$(BUNDLE)$/Contents$/Resources$/oo2-calc-template.icns		\
	$(MISC)$/$(BUNDLE)$/Contents$/Resources$/oo2-impress-doc.icns		\
	$(MISC)$/$(BUNDLE)$/Contents$/Resources$/oo2-impress-template.icns	\
	$(MISC)$/$(BUNDLE)$/Contents$/Resources$/oo2-draw-doc.icns		\
	$(MISC)$/$(BUNDLE)$/Contents$/Resources$/oo2-draw-template.icns		\
	$(MISC)$/$(BUNDLE)$/Contents$/Resources$/oo2-math-doc.icns		\
	$(MISC)$/$(BUNDLE)$/Contents$/Resources$/oo2-base-doc.icns		\
	$(MISC)$/$(BUNDLE)$/Contents$/Resources$/oo2-chart-doc.icns		\
	$(MISC)$/$(BUNDLE)$/Contents$/Resources$/oo2-main-app.icns

tarfile = $(MISC)$/$(BUNDLE).tar

$(tarfile) : $(scriptfiles) $(plistfiles) $(iconfiles)

$(plistfiles) : $(scriptfiles)

$(iconfiles) : $(scriptfiles)

all : $(tarfile)

# create application bundle from apple script source
# Info.plist will be deleted to trigger copy rule of our own Info.plist  
$(MISC)$/$(BUNDLE)$/Contents$/Resources$/Scripts$/%.scpt : %.applescript
	rm -rf $(MISC)$/$(BUNDLE)
	osacompile -o $(MISC)$/$(BUNDLE) -s $<
	rm -f $(MISC)$/$(BUNDLE)$/Contents$/Info.plist

# Info.plist and icns are just copied into the bundle	
$(MISC)$/$(BUNDLE)$/Contents$/%.plist : %.plist	
	+$(COPY) $< $@
	
$(MISC)$/$(BUNDLE)$/Contents$/Resources$/InfoPlist.strings : InfoPlist.strings	
	+$(COPY) $< $@
	
$(MISC)$/$(BUNDLE)$/Contents$/Resources$/%.icns : icons$/%.icns
	+$(COPY) $< $@

# tar the bundle to simplify deliver
# will be untared by packaging process
$(MISC)$/$(BUNDLE).tar : $(MISC)$/$(BUNDLE)
	tar cf $@ -C $(MISC) $(BUNDLE) 
	
.INCLUDE : target.mk

.ENDIF		# "$(OS)"!="MACOSX"	

